/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.core.fm.AccountCurrencyVerifyUtil;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.util.BusinessProcessUtil;
import com.kingdee.eas.fi.cas.CasDataException;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.cas.RecPayException;
import com.kingdee.eas.fi.cas.SourceTypeEnum;
import com.kingdee.eas.fi.cas.app.service.PayAddNewService;
import com.kingdee.eas.framework.SystemEnum;

public class CasPayAddNewService
extends PayAddNewService {
    private IContextHelper ich;

    public CasPayAddNewService() {
        this.ich = ContextHelperFactory.getLocalInstance((Context)this.ctx);
    }

    @Override
    public void initService(Context ctx, PaymentBillInfo info) throws EASBizException, BOSException {
        super.initService(ctx, info);
        boolean addPast = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("CS103", (IObjectPK)new ObjectUuidPK(info.getCompany().getId()));
        if (!addPast && !SourceTypeEnum.AP.equals((Object)info.getSourceType())) {
            PeriodInfo periodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)info.getCompany());
            if (periodInfo == null) {
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("name"));
                CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(info.getCompany().getId()), sic);
                throw new RecPayException(RecPayException.PAY_PERIODNOTNULL, new Object[]{company.getName()});
            }
            if (EmptyUtil.isEmpty((Object)info.getBizDate())) {
                throw new CasDataException(CasDataException.BIZDATENOTNULL);
            }
            if (info.getBizDate().before(periodInfo.getBeginDate())) {
                throw new RecPayException(RecPayException.CANNOTADDPASTBILL);
            }
        }
    }

    @Override
    public void beforeAddNew() throws EASBizException, BOSException {
        super.beforeAddNew();
        boolean val = this.ich.getBooleanParam("CS064", (IObjectPK)new ObjectUuidPK(this.info.getCompany().getId()));
        if (this.info.getOppAccount() != null && val) {
            AccountCurrencyVerifyUtil.verifyAccountCurrency((Context)this.ctx, (String)this.info.getOppAccount().getId().toString(), (String)this.info.getCurrency().getId().toString());
        }
        if (this.info.isIsCBPay() && this.info.getCbPayInfo() != null && this.info.getCbPayInfo().getPaymentCurrency() == null) {
            throw new CasDataException(CasDataException.NULL_CURRENCY);
        }
        if (!EmptyUtil.isEmpty((String)this.info.getPayeeID())) {
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)this.info.getPayeeID()));
            ev.setFilter(filter);
            ev = this.getSelectorForPerson(ev);
            IObjectValue cmpInfo = null;
            try {
                cmpInfo = (IObjectValue)BusinessProcessUtil.getValueByBosType((Context)this.ctx, (BOSObjectType)BOSObjectType.create((String)"3471EE3F"), (EntityViewInfo)ev);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (cmpInfo != null && EmptyUtil.isEmpty((String)this.info.getPayeeBank()) && EmptyUtil.isEmpty((String)this.info.getPayeeAccountBank())) {
                if (((Boolean)cmpInfo.get("accountOneFlag")).booleanValue()) {
                    this.info.setPayeeBank((String)cmpInfo.get("accountOneName"));
                    this.info.setPayeeAccountBank((String)cmpInfo.get("accountOne"));
                } else if (((Boolean)cmpInfo.get("accountTwoFlag")).booleanValue()) {
                    this.info.setPayeeBank((String)cmpInfo.get("accountTwoName"));
                    this.info.setPayeeAccountBank((String)cmpInfo.get("accountTwo"));
                } else if (((Boolean)cmpInfo.get("accountThreeFlag")).booleanValue()) {
                    this.info.setPayeeBank((String)cmpInfo.get("accountThreeName"));
                    this.info.setPayeeAccountBank((String)cmpInfo.get("accountThree"));
                } else if (((Boolean)cmpInfo.get("accountFourFlag")).booleanValue()) {
                    this.info.setPayeeBank((String)cmpInfo.get("accountFourName"));
                    this.info.setPayeeAccountBank((String)cmpInfo.get("accountFour"));
                }
            }
        }
    }

    private EntityViewInfo getSelectorForPerson(EntityViewInfo ev) {
        SelectorItemCollection selector = ev.getSelector();
        selector.add("accountOneFlag");
        selector.add("accountTwoFlag");
        selector.add("accountThreeFlag");
        selector.add("accountFourFlag");
        selector.add("accountOne");
        selector.add("accountOneName");
        selector.add("accountTwo");
        selector.add("accountTwoName");
        selector.add("accountThree");
        selector.add("accountThreeName");
        selector.add("accountFour");
        selector.add("accountFourName");
        return ev;
    }
}

