/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.DisposerActionEnum;
import com.kingdee.eas.fi.cas.PaymentBillEntryCollection;
import com.kingdee.eas.fi.cas.PaymentBillEntryInfo;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.cas.RecPayException;
import com.kingdee.eas.fi.cas.app.service.PaySubmitService;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.fs.TransUpBillInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import java.math.BigDecimal;

public class CasPaySubmitService
extends PaySubmitService {
    @Override
    public void initService(Context ctx, PaymentBillInfo info) throws EASBizException, BOSException {
        super.initService(ctx, info);
        IContextHelper ich = ContextHelperFactory.getLocalInstance((Context)ctx);
        String sourceBillId = info.getSourceBillId();
        boolean istransup = !EmptyUtil.isEmpty((String)sourceBillId) && !BOSUuid.read((String)sourceBillId).getType().equals((Object)new TransUpBillInfo().getBOSType());
        int tm105 = ich.getIntParam("TM105", (IObjectPK)new ObjectUuidPK(info.getCompany().getId()));
        if (tm105 == 0 && !istransup && info.getPayBillType() != null && info.getPayBillType().isIsFinanceTranUp() && !EmptyUtil.isEmpty((CoreBaseInfo)info.getActRecAccountBank()) && !EmptyUtil.isEmpty((CoreBaseInfo)info.getPayerInAcctID())) {
            if (info.getActRecAccountBank().getCompany() == null) {
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("company.id"));
                sic.add(new SelectorItemInfo("id"));
                AccountBankInfo accountbank = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankInfo((IObjectPK)new ObjectUuidPK(info.getActRecAccountBank().getId()), sic);
                info.getActRecAccountBank().setCompany(accountbank.getCompany());
            }
            String companyid = info.getActRecAccountBank().getCompany().getId().toString();
            String acctid = info.getPayerInAcctID().getId().toString();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("bank.relatedCompany.id"));
            sic.add(new SelectorItemInfo("bank.relatedCompany.name"));
            AccountBankInfo accountbank = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankInfo((IObjectPK)new ObjectUuidPK(acctid), sic);
            String companyid2 = accountbank.getBank().getRelatedCompany().getId().toString();
            if (!companyid.equals(companyid2) || !accountbank.getBank().getRelatedCompany().getName().equals(info.getPayeeName())) {
                throw new RecPayException(RecPayException.ACTPAYERACCTISNOTBANK);
            }
        }
    }

    @Override
    public void beforeSubmit() throws EASBizException, BOSException {
        super.beforeSubmit();
        this.serviceHandler.transAsstAccount(this.ctx, this.info);
        this.serviceHandler.dispose(this.ctx, this.info, DisposerActionEnum.ReqPay_SUBMIT);
    }

    @Override
    protected void verify() throws EASBizException, BOSException {
        super.verify();
        this.checkNumberDup(this.info);
    }

    private void checkNumberDup(PaymentBillInfo info) throws BOSException, EASBizException {
        String number = info.getNumber();
        if (number != null && number.length() > 0) {
            this.serviceHandler.checkNumberDup(this.ctx, (IObjectValue)info);
        }
    }

    @Override
    protected void setDefaultPropertyValue() throws BOSException, EASBizException {
        super.setDefaultPropertyValue();
        PaymentBillEntryInfo entry = null;
        for (int i = this.info.getEntries().size() - 1; i >= 0; --i) {
            entry = this.info.getEntries().get(i);
            if (!FMHelper.isZERO((BigDecimal)entry.getActualAmt())) continue;
            this.info.getEntries().remove(entry);
        }
    }

    @Override
    public void initDeleteEntry(Context ctx, PaymentBillEntryCollection coll) throws EASBizException, BOSException {
        super.initDeleteEntry(ctx, coll);
    }

    @Override
    public void afterSubmit(IObjectPK pk) throws EASBizException, BOSException {
        super.afterSubmit(pk);
    }
}

