/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.bot.IBOTRelation;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.ServiceStateManager;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.AccountCurrencyVerifyUtil;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CityCollection;
import com.kingdee.eas.basedata.assistant.CityFactory;
import com.kingdee.eas.basedata.assistant.ProvinceCollection;
import com.kingdee.eas.basedata.assistant.ProvinceFactory;
import com.kingdee.eas.basedata.assistant.SettlementTypeCollection;
import com.kingdee.eas.basedata.assistant.SettlementTypeFactory;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyBankCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyInfoInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.ICustomer;
import com.kingdee.eas.basedata.master.cssp.ISupplier;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyBankCollection;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyInfoInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.ExpenseTypeSubjectMappingCollection;
import com.kingdee.eas.cp.bc.ExpenseTypeSubjectMappingFactory;
import com.kingdee.eas.fi.cas.FundDispatchTypeEnum;
import com.kingdee.eas.fi.cas.PaymentBillEntryCollection;
import com.kingdee.eas.fi.cas.PaymentBillEntryInfo;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.cas.RecPayException;
import com.kingdee.eas.fi.cas.SettlementStatusEnum;
import com.kingdee.eas.fi.cas.SourceTypeEnum;
import com.kingdee.eas.fi.cas.app.service.IPayAddNewService;
import com.kingdee.eas.fi.cas.app.service.handler.ServiceHandler;
import com.kingdee.eas.fi.cas.utils.PayAdmitUtils;
import com.kingdee.eas.fm.be.BEBankCollection;
import com.kingdee.eas.fm.be.BEBankFactory;
import com.kingdee.eas.fm.be.BEBankInfo;
import com.kingdee.eas.fm.be.ITransDetail;
import com.kingdee.eas.fm.be.TransDetailFactory;
import com.kingdee.eas.fm.be.TransDetailInfo;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.common.FMVerifyHelper;
import com.kingdee.eas.fm.common.H;
import com.kingdee.eas.fm.common.util.BizRelateReceivableBillUtil;
import com.kingdee.eas.fm.fee.FeeBillInfo;
import com.kingdee.eas.fm.fin.app.LoanReverseHelper;
import com.kingdee.eas.fm.nt.AssureAmountFactory;
import com.kingdee.eas.fm.nt.AssureAmountInfo;
import com.kingdee.eas.fm.nt.AssureStateEnum;
import com.kingdee.eas.fm.nt.ChequeFactory;
import com.kingdee.eas.fm.nt.ChequeInfo;
import com.kingdee.eas.fm.nt.NTTypeGroupEnum;
import com.kingdee.eas.fm.nt.ReceivableBillFactory;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import org.apache.log4j.Logger;

public class PayAddNewService
implements IPayAddNewService {
    private static Logger logger = Logger.getLogger((String)PayAddNewService.class.getName());
    protected Context ctx;
    protected PaymentBillInfo info;
    IObjectPK pkOut;
    protected ServiceHandler serviceHandler;

    protected ServiceHandler getServiceHandler() {
        return new ServiceHandler();
    }

    @Override
    public void initService(Context ctx, PaymentBillInfo info) throws EASBizException, BOSException {
        this.ctx = ctx;
        this.info = info;
        this.serviceHandler = this.getServiceHandler();
    }

    @Override
    public void beforeAddNew() throws EASBizException, BOSException {
        PayAdmitUtils.verifyPayadmit(this.ctx, (CoreBaseInfo)this.info, true);
        this.setInfoProps(this.ctx, (IObjectValue)this.info);
        if (!EmptyUtil.isEmpty((CoreBaseInfo)this.info) && !EmptyUtil.isEmpty((String)this.info.getSourceBillId())) {
            this.prcessPriveteAndCity(this.info.getPayeeBank(), this.ctx, this.info);
        }
        this.beforeCAS_RefundPaymentAddNewCheck(this.ctx, (IObjectValue)this.info);
        this.serviceHandler.setCommonPropertyValue(this.ctx, this.info);
        if (!EmptyUtil.isEmpty((String)this.info.getDescription()) && this.info.getDescription().length() > 255) {
            this.info.setDescription(this.info.getDescription().substring(0, 255));
        }
        if (this.info.getSourceSysType() == null && this.info.getSourceBillId() != null) {
            FMVerifyHelper.checkBlank((Context)this.ctx, (IObjectValue)this.info, (String)"sourceSysType");
        }
        this.checkAccountAndAccountBank();
        this.reversePropertyToAssureAmount();
        this.setArApAmount();
        if (this.info.getSourceSysType() == null && this.info.getSourceType() != null) {
            this.info.setSourceSysType(this.info.getSourceType());
        }
        this.serviceHandler.initAndCheckNumber(this.ctx, (IObjectValue)this.info, 1);
        boolean cs122 = ContextHelperFactory.getLocalInstance((Context)this.ctx).getBooleanParam("CS122", (IObjectPK)new ObjectUuidPK(this.info.getCompany().getId()));
        if (this.info.getSourceBillId() != null) {
            this.setEntries_oppAccount(this.ctx, this.info);
            if (cs122) {
                this.checkPayeeInfo(this.ctx, this.info);
            }
        }
    }

    private BEBankInfo getBEBankInfo(String bankName, Context ctx) throws EASBizException, BOSException {
        BEBankInfo bankInfo = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("name", (Object)bankName, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)1, CompareType.EQUALS));
        view.setFilter(filter);
        BEBankCollection coll = BEBankFactory.getLocalInstance((Context)ctx).getBEBankCollection(view);
        if (coll.size() > 0) {
            bankInfo = coll.get(0);
        }
        return bankInfo;
    }

    private void prcessPriveteAndCity(String bankName, Context ctx, PaymentBillInfo paymentBillInfo) throws EASBizException, BOSException {
        AccountBankInfo accountBankInfo;
        if (EmptyUtil.isEmpty((CoreBaseInfo)paymentBillInfo.getPayerBank()) && (accountBankInfo = paymentBillInfo.getPayerAccountBank()) != null) {
            if (EmptyUtil.isEmpty((CoreBaseInfo)accountBankInfo.getBank())) {
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("bank.*"));
                sic.add(new SelectorItemInfo("account.*"));
                accountBankInfo = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankInfo((IObjectPK)new ObjectUuidPK(accountBankInfo.getId()), sic);
            }
            paymentBillInfo.setPayerBank(accountBankInfo.getBank());
            if (!EmptyUtil.isEmpty((CoreBaseInfo)accountBankInfo.getAccount())) {
                AccountViewInfo avInfo = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewInfo((IObjectPK)new ObjectUuidPK(accountBankInfo.getAccount().getId()));
                if (EmptyUtil.isEmpty((CoreBaseInfo)paymentBillInfo.getPayerAccount()) && !EmptyUtil.isEmpty((CoreBaseInfo)avInfo)) {
                    paymentBillInfo.setPayerAccount(avInfo);
                }
            }
        }
        BEBankInfo bankInfo = this.getBEBankInfo(bankName, ctx);
        if (EmptyUtil.isEmpty((String)paymentBillInfo.getBankNumber()) && !EmptyUtil.isEmpty((CoreBaseInfo)bankInfo) && !EmptyUtil.isEmpty((String)bankInfo.getNumber())) {
            paymentBillInfo.setBankNumber(bankInfo.getNumber());
        }
        if (EmptyUtil.isEmpty((String)paymentBillInfo.getRecProvince()) && EmptyUtil.isEmpty((String)paymentBillInfo.getRecCity()) && !EmptyUtil.isEmpty((CoreBaseInfo)bankInfo) && !EmptyUtil.isEmpty((String)bankInfo.getBeProvince()) && !EmptyUtil.isEmpty((String)bankInfo.getBeCity())) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            String beProvince = bankInfo.getBeProvince().replaceAll(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"449_CasPaymentBillUI", (Locale)ctx.getLocale()), "");
            beProvince = beProvince.replaceAll("\u5e02", "");
            filter.getFilterItems().add(new FilterItemInfo("name", (Object)(beProvince + "%"), CompareType.LIKE));
            filter.getFilterItems().add(new FilterItemInfo("deletedStatus", (Object)new Integer(1)));
            view.setFilter(filter);
            ProvinceCollection provinceColl = ProvinceFactory.getLocalInstance((Context)ctx).getProvinceCollection(view);
            view = new EntityViewInfo();
            filter = new FilterInfo();
            String beCity = bankInfo.getBeCity().replaceAll(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"450_CasPaymentBillUI", (Locale)ctx.getLocale()), "");
            filter.getFilterItems().add(new FilterItemInfo("name", (Object)(beCity + "%"), CompareType.LIKE));
            filter.getFilterItems().add(new FilterItemInfo("deletedStatus", (Object)new Integer(1)));
            view.setFilter(filter);
            CityCollection cityColl = CityFactory.getLocalInstance((Context)ctx).getCityCollection(view);
            if (provinceColl.size() > 0) {
                paymentBillInfo.setRecProvince(provinceColl.get(0).getName());
            } else {
                paymentBillInfo.setRecProvince(bankInfo.getBeProvince());
            }
            if (cityColl.size() > 0) {
                paymentBillInfo.setRecCity(cityColl.get(0).getName());
            } else {
                paymentBillInfo.setRecCity(bankInfo.getBeCity());
            }
        }
    }

    @Override
    public void afterAddNew(IObjectPK pkNew) throws EASBizException, BOSException {
        LoanReverseHelper.getInstance().paymentBillSubmited(this.ctx, this.info);
        if (this.info != null && this.info.getSourceBillId() != null && new FeeBillInfo().getBOSType().equals((Object)BOSUuid.read((String)this.info.getSourceBillId()).getType())) {
            String sql = "update T_FE_FeeBill set FIsPayBill=1 where fid='" + this.info.getSourceBillId() + "'";
            DbUtil.execute((Context)this.ctx, (String)sql);
        }
        this.processCAS_RefundPaymentAddNew(this.ctx, (IObjectValue)this.info, pkNew);
        if (EmptyUtil.isEmpty((Object)this.ctx.get((Object)"fromSchedule")) && this.info.getSettlementType() != null && this.info.getSettlementType().getNtType() != null && NTTypeGroupEnum.RECEIVABLE.equals((Object)this.info.getSettlementType().getNtType().getSuperGroup())) {
            ReceivableBillFactory.getLocalInstance((Context)this.ctx).lockReceivanleBill((CoreBaseInfo)this.info, "addNew");
        }
        BizRelateReceivableBillUtil.relateReceivableBill((Context)this.ctx, (CoreBaseInfo)this.info, (IObjectPK)pkNew);
        this.pkOut = LogUtil.beginLog((Context)this.ctx, (String)"addnew", (BOSObjectType)this.info.getBOSType(), null, (String)this.info.getLogInfo(), (String)"cas_paymentBill_addnew");
        LogUtil.afterLog((Context)this.ctx, (IObjectPK)this.pkOut);
    }

    private void setInfoProps(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CompanyOrgUnitInfo companyInfo;
        PaymentBillInfo info;
        Object chequeID = model.get("cheque");
        if (chequeID instanceof BOSUuid) {
            ChequeInfo chequeInfo = new ChequeInfo();
            chequeInfo.setId((BOSUuid)chequeID);
            model.put("cheque", (Object)chequeInfo);
        }
        if ((info = (PaymentBillInfo)model).getCompany() == null) {
            companyInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
            info.setCompany(companyInfo);
        }
        if (EmptyUtil.isEmpty((CoreBaseInfo)info.getCU())) {
            companyInfo = info.getCompany();
            if (EmptyUtil.isEmpty((CoreBaseInfo)companyInfo.getCU())) {
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("CU"));
                companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyInfo.getId()), sic);
            }
            info.setCU(companyInfo.getCU());
        }
        if (info.getSettlementStatus() == null) {
            info.setSettlementStatus(SettlementStatusEnum.UNSUBMIT);
        }
        if (info.getFundDispatchType() == null || info.getFundDispatchType().getValue() == 0) {
            info.setFundDispatchType(FundDispatchTypeEnum.PAYMENT_DEFAULT);
        }
        if (info.getBizDate() != null) {
            info.setBizDate(DateUtil.getDayBegin((Date)info.getBizDate()));
        }
        for (int index = info.getEntries().size() - 1; index >= 0; --index) {
            PaymentBillEntryInfo entry = info.getEntries().get(index);
            if (entry.getActualAmt() != null) continue;
            info.getEntries().remove(entry);
        }
        if (info.getSourceBillId() != null && !SourceTypeEnum.FDC.equals((Object)info.getSourceType())) {
            info.setIsNeedPay(true);
        }
        if (info.getSourceBillId() != null && new ChequeInfo().getBOSType().equals((Object)BOSUuid.read((String)info.getSourceBillId()).getType())) {
            if (info.getSettlementNumber() == null || info.getSettlementType() == null) {
                ChequeInfo chequeInfo = this.getCheque(ctx, info.getSourceBillId());
                info.setSettlementNumber(chequeInfo.getSettleNumber());
                info.setSettlementType(chequeInfo.getSettleType());
                if (info.getCheque() == null) {
                    info.setCheque(chequeInfo);
                }
                if (chequeInfo.getSettleType() == null && chequeInfo.getNtType() != null) {
                    EntityViewInfo view = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("ntType.id", (Object)chequeInfo.getNtType().getId().toString(), CompareType.EQUALS));
                    view.setFilter(filter);
                    SettlementTypeCollection coll = SettlementTypeFactory.getLocalInstance((Context)ctx).getSettlementTypeCollection(view);
                    if (coll != null && coll.size() > 0) {
                        info.setSettlementType(coll.get(0));
                    } else {
                        throw new RecPayException(RecPayException.NULLSETTLETYPE);
                    }
                }
            }
            if (info.getCheque() == null) {
                ChequeInfo chequeInfo = new ChequeInfo();
                chequeInfo.setId(BOSUuid.read((String)info.getSourceBillId()));
                info.setCheque(chequeInfo);
            }
        }
        ServiceStateManager.getInstance().enableNextCallService("PERMISSION_SERVICE");
    }

    private ChequeInfo getCheque(Context ctx, String id) throws BOSException, EASBizException {
        SelectorItemCollection chequeSelector = new SelectorItemCollection();
        chequeSelector.add("settleNumber");
        chequeSelector.add("settleType.id");
        chequeSelector.add("settleType.name");
        chequeSelector.add("settleType.number");
        chequeSelector.add("ntType.id");
        ChequeInfo chequeInfo = ChequeFactory.getLocalInstance((Context)ctx).getChequeInfo((IObjectPK)new ObjectUuidPK(id), chequeSelector);
        return chequeInfo;
    }

    private void processCAS_RefundPaymentAddNew(Context ctx, IObjectValue model, IObjectPK bpk) throws BOSException {
        if (!H.same((Object)model.get("isRefundPay"), (Object)true)) {
            return;
        }
        TransDetailInfo tinfo = (TransDetailInfo)model.get("transDetailInfo");
        PaymentBillInfo ainfo = (PaymentBillInfo)model.get("refundPaymentBillInfo");
        if (H.hasEmpty((Object[])new Object[]{tinfo, ainfo})) {
            return;
        }
        String sql = "UPDATE T_CAS_PaymentBill SET FRefundPayBillId = ?  WHERE FID = ? ";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{H.IDSTR((Object)ainfo), bpk.toString()});
        String sql2 = "UPDATE T_BE_TransDetail SET FhasRefundPay = 1  WHERE FID = ? ";
        DbUtil.execute((Context)ctx, (String)sql2, (Object[])new Object[]{H.IDSTR((Object)tinfo)});
        this.createBotpRelation(ctx, H.IDSTR((Object)tinfo), bpk.toString());
        this.createBotpRelation(ctx, H.IDSTR((Object)ainfo), H.IDSTR((Object)tinfo));
        this.createBotpRelation(ctx, H.IDSTR((Object)ainfo), bpk.toString());
    }

    private void beforeCAS_RefundPaymentAddNewCheck(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PaymentBillInfo ainfo;
        if (!H.same((Object)model.get("isRefundPay"), (Object)true)) {
            return;
        }
        TransDetailInfo tinfo = (TransDetailInfo)model.get("transDetailInfo");
        if (H.hasEmpty((Object[])new Object[]{tinfo, ainfo = (PaymentBillInfo)model.get("refundPaymentBillInfo")})) {
            return;
        }
        if (tinfo != null && tinfo.getId() != null) {
            ITransDetail biz = TransDetailFactory.getLocalInstance((Context)ctx);
            TransDetailInfo transInfo = biz.getTransDetailInfo((IObjectPK)new ObjectUuidPK(tinfo.getId()));
            String sql2 = "UPDATE T_BE_TransDetail SET FhasRefundPay = 1  WHERE FID = ? ";
            DbUtil.execute((Context)ctx, (String)sql2, (Object[])new Object[]{H.IDSTR((Object)tinfo)});
            if (transInfo.isHasRefundPay()) {
                throw new RecPayException(RecPayException.NO_REPEAT_PAY);
            }
        }
    }

    private void createBotpRelation(Context ctx, String srcObjectId, String destObjectId) throws BOSException {
        if (H.hasEmpty((Object[])new Object[]{srcObjectId, destObjectId})) {
            return;
        }
        IBOTRelation iBOTRelation = BOTRelationFactory.getLocalInstance((Context)ctx);
        BOTRelationInfo info = new BOTRelationInfo();
        String srcBosType = BOSUuid.read((String)srcObjectId).getType().toString();
        String destBosType = BOSUuid.read((String)destObjectId).getType().toString();
        info.setSrcEntityID(srcBosType);
        info.setDestEntityID(destBosType);
        info.setSrcObjectID(srcObjectId);
        info.setDestObjectID(destObjectId);
        info.setDate(new Date());
        info.setOperatorID("system");
        info.setIsEffected(true);
        info.setType(0);
        iBOTRelation.addnew(info);
    }

    protected void setArApAmount() {
        PaymentBillEntryInfo paymentBillEntryInfo = null;
        for (int i = 0; i < this.info.getEntries().size(); ++i) {
            paymentBillEntryInfo = this.info.getEntries().get(i);
            if (paymentBillEntryInfo.getAmount() == null || paymentBillEntryInfo.getAmount() != null && paymentBillEntryInfo.getAmount().equals(Constants.ZERO)) {
                paymentBillEntryInfo.setAmount(paymentBillEntryInfo.getActualAmt());
            }
            if (paymentBillEntryInfo.getLocalAmt() != null && (paymentBillEntryInfo.getLocalAmt() == null || !paymentBillEntryInfo.getLocalAmt().equals(Constants.ZERO))) continue;
            paymentBillEntryInfo.setLocalAmt(paymentBillEntryInfo.getActualLocAmt());
        }
    }

    protected void reversePropertyToAssureAmount() throws BOSException, EASBizException {
        BOSUuid bosId;
        String sourcBillId = this.info.getSourceBillId();
        if (sourcBillId != null && sourcBillId.length() > 0 && (bosId = BOSUuid.read((String)sourcBillId)).getType().equals((Object)new AssureAmountInfo().getBOSType())) {
            PaymentBillEntryCollection eColl = this.info.getEntries();
            for (int i = 0; i < eColl.size(); ++i) {
                PaymentBillEntryInfo eInfo = eColl.get(i);
                String eSourcBillId = eInfo.getSourceBillId();
                AssureAmountInfo assureAmountInfo = AssureAmountFactory.getLocalInstance((Context)this.ctx).getAssureAmountInfo((IObjectPK)new ObjectUuidPK(eSourcBillId));
                assureAmountInfo.setIsGenePayBill(true);
                assureAmountInfo.setAssureState(AssureStateEnum.PAIED);
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("isGenePayBill"));
                sic.add(new SelectorItemInfo("assureState"));
                AssureAmountFactory.getLocalInstance((Context)this.ctx).updatePartial((CoreBaseInfo)assureAmountInfo, sic);
            }
        }
    }

    protected void checkAccountAndAccountBank() throws BOSException, EASBizException {
        if (!EmptyUtil.isEmpty((String)this.info.getPayeeAccountBank()) && this.info.getPayeeAccountBankO() == null) {
            this.info.setPayeeAccountBankO(this.serviceHandler.getBankByPayeeAccountBank(this.ctx, this.info.getPayeeAccountBank()));
        }
        if (!EmptyUtil.isEmpty((CoreBaseInfo)this.info.getPayeeAccountBankO())) {
            this.info.setOppInnerAcct(this.info.getPayeeAccountBankO().getInnerAcct());
        }
        if (this.info.getPayerAccount() != null) {
            String acctComId = "";
            if (EmptyUtil.isEmpty((CoreBaseInfo)this.info.getPayerAccount().getCompanyID())) {
                AccountViewInfo avInfo = AccountViewFactory.getLocalInstance((Context)this.ctx).getAccountViewInfo("select id,companyid where id='" + this.info.getPayerAccount().getId().toString() + "'");
                acctComId = avInfo.getCompanyID().getId().toString();
            } else {
                acctComId = this.info.getPayerAccount().getCompanyID().getId().toString();
            }
            if (!this.info.getCompany().getId().toString().equals(acctComId)) {
                throw new FMException(FMException.COMMMONEXCEPTION, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"282_PayAddNewService", (Locale)this.ctx.getLocale())});
            }
            AccountCurrencyVerifyUtil.verifyAccountCurrency((Context)this.ctx, (String)this.info.getPayerAccount().getId().toString(), (String)this.info.getCurrency().getId().toString());
        }
    }

    private void checkPayeeInfo(Context ctx, PaymentBillInfo info) {
        String payeeName = "";
        if (info.getPayeeType() != null && info.getPayeeType().getAsstHGAttribute() != null && info.getPayeeID() != null) {
            try {
                if (info.getPayeeType().getAsstHGAttribute().equalsIgnoreCase("provider")) {
                    ISupplier iSupplier = SupplierFactory.getLocalInstance((Context)ctx);
                    SelectorItemCollection spcSelector = new SelectorItemCollection();
                    spcSelector.add(new SelectorItemInfo("id"));
                    spcSelector.add(new SelectorItemInfo("supplierBank.*"));
                    SupplierCompanyInfoInfo supplierCompany = iSupplier.getCompanyInfo((IObjectPK)new ObjectUuidPK(info.getPayeeID()), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), spcSelector);
                    if (supplierCompany != null && supplierCompany.getSupplierBank() != null && supplierCompany.getSupplierBank().size() > 0) {
                        SupplierCompanyBankCollection coll = supplierCompany.getSupplierBank();
                        for (int i = 0; i < coll.size(); ++i) {
                            if (!supplierCompany.getSupplierBank().get(i).isIsDefault() || coll.get(i).getBeneficiary() == null) continue;
                            payeeName = coll.get(i).getBeneficiary();
                            break;
                        }
                        if (payeeName != null && payeeName.equals("")) {
                            payeeName = coll.get(0).getBeneficiary();
                        }
                    } else {
                        SelectorItemCollection sic = new SelectorItemCollection();
                        sic.add(new SelectorItemInfo("*"));
                        SupplierInfo realSupplier = iSupplier.getSupplierInfo((IObjectPK)new ObjectUuidPK(info.getPayeeID()), sic);
                        payeeName = realSupplier.getName();
                    }
                } else if (info.getPayeeType().getAsstHGAttribute().equalsIgnoreCase("customer")) {
                    ICustomer iCustomer = CustomerFactory.getLocalInstance((Context)ctx);
                    SelectorItemCollection spcSelector = new SelectorItemCollection();
                    spcSelector.add(new SelectorItemInfo("id"));
                    spcSelector.add(new SelectorItemInfo("customerBank.*"));
                    CustomerCompanyInfoInfo custCompany = iCustomer.getCustomerCompanyInfo((IObjectPK)new ObjectUuidPK(info.getPayeeID()), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), spcSelector);
                    if (custCompany != null && custCompany.getCustomerBank() != null && custCompany.getCustomerBank().size() > 0) {
                        CustomerCompanyBankCollection coll = custCompany.getCustomerBank();
                        for (int i = 0; i < coll.size(); ++i) {
                            if (!custCompany.getCustomerBank().get(i).isIsDefault()) continue;
                            payeeName = coll.get(i).getBeneficiary();
                            break;
                        }
                        if (payeeName != null && payeeName.equals("")) {
                            payeeName = coll.get(0).getBeneficiary();
                        }
                    } else {
                        SelectorItemCollection sic = new SelectorItemCollection();
                        sic.add(new SelectorItemInfo("*"));
                        CustomerInfo realCust = iCustomer.getCustomerInfo((IObjectPK)new ObjectUuidPK(info.getPayeeID()), sic);
                        payeeName = realCust.getName();
                    }
                }
            }
            catch (BOSException e) {
                logger.error((Object)e);
            }
            catch (EASBizException e) {
                logger.error((Object)e);
            }
        }
        if (payeeName != null && !payeeName.equals("")) {
            info.setBankAcctName(payeeName);
        }
    }

    private void setEntries_oppAccount(Context ctx, PaymentBillInfo info) {
        PaymentBillEntryCollection entries = info.getEntries();
        Iterator it = entries.iterator();
        while (it.hasNext()) {
            PaymentBillEntryInfo entryInfo = (PaymentBillEntryInfo)it.next();
            if (entryInfo.getOppAccount() != null || entryInfo.getExpenseType() == null) continue;
            try {
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                view.setFilter(filter);
                SelectorItemCollection sic = new SelectorItemCollection();
                view.setSelector(sic);
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("accountId.*"));
                filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)info.getCompany().getId()));
                filter.getFilterItems().add(new FilterItemInfo("expenseTypeId.id", (Object)entryInfo.getExpenseType().getId()));
                ExpenseTypeSubjectMappingCollection colls = ExpenseTypeSubjectMappingFactory.getLocalInstance((Context)ctx).getExpenseTypeSubjectMappingCollection(view);
                if (colls == null || colls.size() <= 0) continue;
                entryInfo.setOppAccount(colls.get(0).getAccountId());
            }
            catch (BOSException e) {
                logger.error((Object)e);
            }
        }
    }
}

