/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BillStatusEnum;
import com.kingdee.eas.fi.cas.CasException;
import com.kingdee.eas.fi.cas.PaymentBill2BankPayBillBuilder;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.cas.RecPayException;
import com.kingdee.eas.fi.cas.RecPayHelper;
import com.kingdee.eas.fi.cas.app.service.IPayCommitToBeService;
import com.kingdee.eas.fi.cas.app.service.handler.ServiceHandler;
import com.kingdee.eas.fm.be.BEException;
import com.kingdee.eas.fm.be.BankPayingBillFactory;
import com.kingdee.eas.fm.be.BankPayingBillStateEnum;
import com.kingdee.eas.fm.be.IBankPayingBill;
import com.kingdee.eas.fm.be.TransDetailInfo;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.common.FMVerifyHelper;
import com.kingdee.eas.fm.common.IContextHelper;
import com.kingdee.eas.fm.fee.FeeBillInfo;
import com.kingdee.eas.fm.fs.SettBizTypeEnum;
import com.kingdee.eas.fm.fs.SettlementBillInfo;
import com.kingdee.eas.fm.fs.TransUpBillInfo;
import com.kingdee.eas.fm.nt.EndorsementBillInfo;
import com.kingdee.eas.fm.nt.PayableTransferBillInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class PayAndTransToBeService
implements IPayCommitToBeService {
    private static Logger logger = Logger.getLogger((String)PayAndTransToBeService.class.getName());
    protected Context ctx;
    protected String id;
    protected boolean isInvokeWF;
    protected PaymentBillInfo info;
    protected boolean isNeedCommitToBank;

    public void beforeTransToBe() throws EASBizException, BOSException {
        String sql = "update t_cas_paymentbill set  FIsCommittoBe = 1,FCommitBeTime= ?,FBankPayState= ?, FConceit = null where fid= ?";
        BankPayingBillStateEnum state = BankPayingBillStateEnum.OP;
        if (this.isNeedCommitToBank) {
            state = BankPayingBillStateEnum.OS;
        }
        Timestamp currTime = new Timestamp(System.currentTimeMillis());
        DbUtil.execute((Context)this.ctx, (String)sql, (Object[])new Object[]{currTime, new Integer(state.getValue()), this.id});
        this.info = PaymentBillFactory.getLocalInstance(this.ctx).getPaymentBillInfo((IObjectPK)new ObjectUuidPK(this.id), this.getSelector());
        this.verifyBillStatus(this.info);
        new ServiceHandler().checkIfByEdited(this.ctx, this.info);
        this.verify(this.ctx, this.info);
    }

    private void verifyBillStatus(PaymentBillInfo info) throws BEException {
        if (info.getBillStatus() != BillStatusEnum.AUDITED) {
            throw new BEException(BEException.NOTAUDITCANNOTBE);
        }
    }

    @Override
    public void initService(Context ctx, String id, boolean isNeedCommitToBank) throws EASBizException, BOSException {
        this.ctx = ctx;
        this.id = id;
        this.isNeedCommitToBank = isNeedCommitToBank;
    }

    @Override
    public IObjectPK doService() throws EASBizException, BOSException {
        this.beforeTransToBe();
        String billId = this.info.getId().toString();
        LinkedHashSet<String> idSet = new LinkedHashSet<String>();
        idSet.add(billId);
        PaymentBillFactory.getLocalInstance(this.ctx).payForBook(idSet, true, false);
        if (!this.isNeedCommitToBank) {
            PaymentBillFactory.getLocalInstance(this.ctx).commitToBE4WF((IObjectPK)new ObjectUuidPK(billId));
        }
        IBankPayingBill iBankPayingBill = BankPayingBillFactory.getLocalInstance((Context)this.ctx);
        String builderName = PaymentBill2BankPayBillBuilder.class.getName();
        IObjectPK bankPayingbillId = iBankPayingBill.commit2BankPayBill(billId, builderName);
        String numbers = this.info.getNumber();
        IObjectPK pkOut = LogUtil.beginLog((Context)this.ctx, (String)ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"215_PayCommitToBeService", (Locale)this.ctx.getLocale()), (BOSObjectType)new PaymentBillInfo().getBOSType(), null, (String)numbers, (String)"cas_paymentBill_commitBe");
        LogUtil.afterLog((Context)this.ctx, (IObjectPK)pkOut);
        return bankPayingbillId;
    }

    private void verify(Context ctx, PaymentBillInfo info) throws EASBizException, BOSException {
        Pattern pattern;
        Matcher matcher;
        boolean isLinkPay;
        BigDecimal actPayAmt = info.getActPayAmt();
        if (Constants.ZERO.compareTo(actPayAmt) >= 0) {
            throw new FMException(FMException.MUSTMORETHANZERO, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"283_PayAndTransToBeService", (Locale)ctx.getLocale())});
        }
        if (info.getBillStatus() != BillStatusEnum.AUDITED) {
            throw new BEException(BEException.NOTAUDITCANNOTBE);
        }
        if (info.getPayerAccountBank() == null) {
            throw new CasException(CasException.NONEACCOUNT);
        }
        String id = info.getSourceBillId();
        if (!EmptyUtil.isEmpty((String)id)) {
            if (new FeeBillInfo().getBOSType().equals((Object)BOSUuid.read((String)id).getType())) {
                throw new BEException(BEException.FROMFEEBILLNOTBE);
            }
            if (new TransDetailInfo().getBOSType().equals((Object)BOSUuid.read((String)id).getType())) {
                throw new RecPayException(RecPayException.CANNOTCOMMITTOBE, new Object[]{info.getNumber()});
            }
            if (new SettlementBillInfo().getBOSType().equals((Object)BOSUuid.read((String)id).getType())) {
                throw new RecPayException(RecPayException.NOTCOMMITTOBE, new Object[]{info.getNumber()});
            }
            if (new TransUpBillInfo().getBOSType().equals((Object)BOSUuid.read((String)id).getType())) {
                throw new RecPayException(RecPayException.CANNOTSETTLEMENT);
            }
            if (new EndorsementBillInfo().getBOSType().equals((Object)BOSUuid.read((String)id).getType())) {
                throw new RecPayException(RecPayException.FROMENDORSEMENTBILLNOTBE);
            }
            if (new PayableTransferBillInfo().getBOSType().equals((Object)BOSUuid.read((String)id).getType())) {
                throw new RecPayException(RecPayException.FROMPAYABLETRANSFERBILLNOTBE);
            }
        }
        if (info.getBizType() != null && (isLinkPay = info.getBizType().getType().equals((Object)SettBizTypeEnum.LINKPAY))) {
            throw new BEException(BEException.LINKPAYCANNOTBE);
        }
        if (info.getBankNumber() != null && (matcher = (pattern = Pattern.compile("[\u4e00-\u9fa5]")).matcher(info.getBankNumber())).find()) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"165_PaymentBillCommitToBeTask", (Locale)ctx.getLocale()));
        }
        if (!info.isIsCBPay() && !info.getPayerBank().getName().trim().replace(" ", "").contains("\u652f\u4ed8\u5b9d")) {
            IContextHelper contextHelper = null;
            contextHelper = ctx == null ? ContextHelperFactory.getRemoteInstance() : ContextHelperFactory.getLocalInstance((Context)ctx);
            String value = contextHelper.getStringParam("BE009", (IObjectPK)new ObjectUuidPK(info.getCompany().getId()));
            if (!EmptyUtil.isEmpty((String)value) && "1".equals(value)) {
                if (info.getPayeeArea() == null) {
                    throw new BEException(BEException.ADDRESSERROR);
                }
            } else if (info.getRecCity() == null || info.getRecProvince() == null) {
                throw new BEException(BEException.RECADDRESSERROR);
            }
        }
        RecPayHelper.checkPSIsClose(ctx, info);
        if (!info.getPayerAccountBank().isIsSetBankInterface()) {
            throw new BOSException(EASResource.getString((String)"com.kingdee.eas.fi.cas.RecPayResource", (String)"PAYER_ACCOUNT_NOT_HAS_BE_INTERFACE"));
        }
        if (info.getBillStatus().equals((Object)BillStatusEnum.AUDITED) && info.getPayerAccountBank() != null && info.getPayerAccountBank().isIsSetBankInterface()) {
            if (info.getSettlementType() == null) {
                throw new RecPayException(RecPayException.SETTLEMENTTYPE_CANNOT_BE_NULL);
            }
            if (!info.getSettlementType().isPayThroughBE()) {
                throw new RecPayException(RecPayException.FORBEMUSTHAVESETTLETYPE);
            }
            FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"payerAccountBank");
            FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"payeeName");
            FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"payeeBank");
            if (info.getPayBillType().isIsFinanceTranUp()) {
                FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"actrecaccountbank");
            }
        }
    }

    protected SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("billStatus"));
        sic.add(new SelectorItemInfo("actPayAmt"));
        sic.add(new SelectorItemInfo("editFlag"));
        sic.add(new SelectorItemInfo("editFlagNew"));
        sic.add(new SelectorItemInfo("isCBPay"));
        sic.add(new SelectorItemInfo("payPlanBillID"));
        sic.add(new SelectorItemInfo("sourceType"));
        sic.add(new SelectorItemInfo("sourceBillId"));
        sic.add(new SelectorItemInfo("recProvince"));
        sic.add(new SelectorItemInfo("recCity"));
        sic.add(new SelectorItemInfo("payeeArea.id"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("bizType.id"));
        sic.add(new SelectorItemInfo("bizType.type"));
        sic.add(new SelectorItemInfo("payBillType.id"));
        sic.add(new SelectorItemInfo("payBillType.isFinanceTranUp"));
        sic.add(new SelectorItemInfo("settlementType.id"));
        sic.add(new SelectorItemInfo("settlementType.payThroughBE"));
        sic.add(new SelectorItemInfo("payeeName"));
        sic.add(new SelectorItemInfo("payeeBank"));
        sic.add(new SelectorItemInfo("payeeAccountBank"));
        sic.add(new SelectorItemInfo("actRecAccountBank.id"));
        sic.add(new SelectorItemInfo("actRecAccountBank.number"));
        sic.add(new SelectorItemInfo("payerBank.id"));
        sic.add(new SelectorItemInfo("payerBank.name"));
        sic.add(new SelectorItemInfo("payerAccountBank.id"));
        sic.add(new SelectorItemInfo("payerAccountBank.isSetBankInterface"));
        sic.add(new SelectorItemInfo("payerAccountBank.bankAccountNumber"));
        sic.add(new SelectorItemInfo("entries.amount"));
        sic.add(new SelectorItemInfo("entries.localAmt"));
        sic.add(new SelectorItemInfo("entries.actualAmt"));
        sic.add(new SelectorItemInfo("entries.actualAmtVc"));
        sic.add(new SelectorItemInfo("entries.actualLocAmt"));
        sic.add(new SelectorItemInfo("entries.sourceBillId"));
        sic.add(new SelectorItemInfo("entries.srcPlanBillEntryId"));
        sic.add(new SelectorItemInfo("entries.sourceBillEntryId"));
        sic.add(new SelectorItemInfo("actPayLocAmt"));
        sic.add(new SelectorItemInfo("actPayLocAmtVc"));
        sic.add(new SelectorItemInfo("actPayAmtVc"));
        sic.add(new SelectorItemInfo("bgAmount"));
        sic.add(new SelectorItemInfo("paymentBillType"));
        sic.add(new SelectorItemInfo("settlementStatus"));
        sic.add(new SelectorItemInfo("bankNumber"));
        sic.add(new SelectorItemInfo("cbPayInfo.transActionType"));
        sic.add(new SelectorItemInfo("cbPayInfo.transType.*"));
        sic.add(new SelectorItemInfo("cbPayInfo.payeeAmount"));
        sic.add(new SelectorItemInfo("cbPayInfo.payeeCurrency.*"));
        return sic;
    }
}

