/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.ArApRecPayException;
import com.kingdee.eas.fi.cas.BgCtrlReceivingBillHandler;
import com.kingdee.eas.fi.cas.BillStatusEnum;
import com.kingdee.eas.fi.cas.CasException;
import com.kingdee.eas.fi.cas.CasRecPayBillTypeEnum;
import com.kingdee.eas.fi.cas.CashPamentBillUtil;
import com.kingdee.eas.fi.cas.DisposerActionEnum;
import com.kingdee.eas.fi.cas.PaymentBillCollection;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.cas.RecPayBgCtrlStrEnum;
import com.kingdee.eas.fi.cas.RecPayException;
import com.kingdee.eas.fi.cas.RecPayHelper;
import com.kingdee.eas.fi.cas.SettlementStatusEnum;
import com.kingdee.eas.fi.cas.SourceTypeEnum;
import com.kingdee.eas.fi.cas.app.AgentRecPayServerHelper;
import com.kingdee.eas.fi.cas.app.ArApRecPayServerHelper;
import com.kingdee.eas.fi.cas.app.RecPaySwapHelper;
import com.kingdee.eas.fi.cas.app.service.IPayAntiAuditService;
import com.kingdee.eas.fi.cas.app.service.handler.ServiceHandler;
import com.kingdee.eas.fi.cas.utils.CASWebUtil;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.fd.FDException;
import com.kingdee.eas.fm.fpl.FpCtrlFacadeFactory;
import com.kingdee.eas.fm.fpl.IFpCtrlFacade;
import com.kingdee.eas.fm.rpm.RPDMatchResultCollection;
import com.kingdee.eas.fm.rpm.RPDMatchResultFactory;
import com.kingdee.eas.fm.rpm.RPMException;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.ma.nbudget.BgControlCaller;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;

public class PayAntiAuditService
implements IPayAntiAuditService {
    private static Logger logger = Logger.getLogger((String)PayAntiAuditService.class.getName());
    protected Context ctx;
    private Set ids = null;
    protected ServiceHandler serviceHandler;
    private PaymentBillCollection coll = null;

    protected ServiceHandler getServiceHandler() {
        return new ServiceHandler();
    }

    @Override
    public void initService(Context ctx, Set idSet) throws EASBizException, BOSException {
        this.ctx = ctx;
        this.ids = idSet;
        this.serviceHandler = this.getServiceHandler();
        this.coll = this.getPaymentBillCollection(ctx, idSet);
        this.verifyInput(this.coll);
    }

    private PaymentBillCollection getPaymentBillCollection(Context ctx, Set idSet) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(this.getSelector());
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        return PaymentBillFactory.getLocalInstance(ctx).getPaymentBillCollection(view);
    }

    @Override
    public void doService() throws EASBizException, BOSException {
        IFpCtrlFacade iFpCtrlFacade = FpCtrlFacadeFactory.getLocalInstance((Context)this.ctx);
        Iterator iter = this.coll.iterator();
        String value = null;
        HashMap<String, String> paramMap = new HashMap<String, String>();
        while (iter.hasNext()) {
            PaymentBillInfo info = (PaymentBillInfo)iter.next();
            String billId = info.getId().toString();
            if (info.isIsBookRL()) {
                throw new RecPayException(RecPayException.HASBOOKGL);
            }
            ArApRecPayServerHelper.injectBizFlow(this.ctx, (IObjectValue)info, BatchActionEnum.UNAUDIT);
            this.serviceHandler.dispose(this.ctx, info, DisposerActionEnum.ANTI_AUDIT);
            if (info.getSourceType() == SourceTypeEnum.AP) {
                UserInfo userInfo;
                this.serviceHandler.checkIsInQueue(this.ctx, info);
                SystemStatusCtrolInfo arapStatus = ArApRecPayServerHelper.getSysStatusCtrolInfo(this.ctx, info.getCompany(), SystemEnum.ACCOUNTSPAYABLE);
                if (info.getBizDate() != null && arapStatus.getCurrentPeriod() != null && (info.isIsInitializeBill() || info.getBizDate().before(arapStatus.getCurrentPeriod().getBeginDate()))) {
                    throw new ArApRecPayException(ArApRecPayException.INITBILLNOANTIAUDIT);
                }
                if (!paramMap.containsKey(info.getCompany().getId().toString())) {
                    value = ParamManager.getParamValue((Context)this.ctx, (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)"AP_026");
                    paramMap.put(info.getCompany().getId().toString(), value);
                } else {
                    value = paramMap.get(info.getCompany().getId().toString()).toString();
                }
                if (value != null && ("true".equalsIgnoreCase(value) || "1".equalsIgnoreCase(value)) && (userInfo = ContextUtil.getCurrentUserInfo((Context)this.ctx)) != null && info.getAuditor() != null && !userInfo.getId().toString().equals(info.getAuditor().getId().toString())) {
                    throw new ArApRecPayException(ArApRecPayException.ARAPBILL_IS_SAMEAUDITOR_PERSON);
                }
            }
            if (info.getSourceType() == SourceTypeEnum.FDC) {
                CashPamentBillUtil._antiAudit4FDC(this.ctx, info.getId());
            }
            if (CasRecPayBillTypeEnum.RealType.equals((Object)info.getPaymentBillType())) {
                PaymentBillInfo pinfo = PaymentBillFactory.getLocalInstance(this.ctx).getPaymentBillInfo((IObjectPK)new ObjectUuidPK(info.getAgentPaymentBillID().toString()));
                if (pinfo.getBillStatus().equals((Object)BillStatusEnum.AUDITED)) {
                    throw new CasException(CasException.NOANTIAUDIT);
                }
                AgentRecPayServerHelper.deleteAgentPaymentBill(this.ctx, info);
            }
            iFpCtrlFacade.innerMomitorCancel(billId);
            if (!paramMap.containsKey(info.getCompany().getId().toString() + "CS043")) {
                value = ParamManager.getParamValue((Context)this.ctx, (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)"CS043");
                paramMap.put(info.getCompany().getId().toString() + "CS043", value);
            } else {
                value = paramMap.get(info.getCompany().getId().toString() + "CS043").toString();
            }
            if (!StringUtils.isEmpty((String)value)) {
                this.serviceHandler.cancelRequestBudget(this.ctx, billId, RecPayBgCtrlStrEnum.Audit_Sub, Integer.valueOf(value));
                if (Integer.valueOf(value) == 1 && info.getSourceType() != null && (SourceTypeEnum.AP.equals((Object)info.getSourceType()) || SourceTypeEnum.CASH.equals((Object)info.getSourceType()))) {
                    BgControlCaller caller = new BgControlCaller();
                    caller.returnBudget(this.ctx, BOSUuid.read((String)billId));
                }
            }
            if (info.getFundDispatchType() == null || info.getFundDispatchType().getValue() == 0) {
                if (!paramMap.containsKey(info.getCompany().getId().toString() + "CS120")) {
                    value = ParamManager.getParamValue((Context)this.ctx, (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)"CS120");
                    paramMap.put(info.getCompany().getId().toString() + "CS120", value);
                } else {
                    value = paramMap.get(info.getCompany().getId().toString() + "CS120").toString();
                }
                if (value != null && "1".equalsIgnoreCase(value)) {
                    try {
                        RecPayHelper helper = new RecPayHelper();
                        HashSet<String> idSet = new HashSet<String>();
                        idSet.add(info.getId().toString());
                        helper.updateFundDisPlan(this.ctx, idSet);
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                        throw new FDException(FDException.UPDATE_PAY_ERROR);
                    }
                }
            }
            if (!paramMap.containsKey(info.getCompany().getId().toString() + "CS079")) {
                value = ParamManager.getParamValue((Context)this.ctx, (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)"CS079");
                paramMap.put(info.getCompany().getId().toString() + "CS079", value);
            } else {
                value = paramMap.get(info.getCompany().getId().toString() + "CS079").toString();
            }
            if (value != null && ("true".equalsIgnoreCase(value) || "1".equalsIgnoreCase(value))) {
                String boName = "com.kingdee.eas.fi.cas.app.PaymentBill";
                String handleName = BgCtrlReceivingBillHandler.class.getName();
                RecPayHelper.OnWaybgCtrl(this.ctx, billId, boName, handleName);
            }
            boolean isCanAntiAuditSwap = false;
            isCanAntiAuditSwap = RecPaySwapHelper.unAuditCheckSwap(this.ctx, billId, false);
            if (!isCanAntiAuditSwap) continue;
            RecPaySwapHelper.deleteSwapBill(this.ctx, billId, false);
        }
        HashSet<String> saveSet = new HashSet<String>();
        HashSet<String> auditSet = new HashSet<String>();
        HashMap<String, Boolean> CS024Map = new HashMap<String, Boolean>();
        for (int i = 0; i < this.coll.size(); ++i) {
            PaymentBillInfo info = this.coll.get(i);
            String companyId = info.getCompany().getId().toString();
            boolean val = false;
            if (CS024Map.containsKey(companyId)) {
                val = (Boolean)CS024Map.get(companyId);
            } else {
                val = ContextHelperFactory.getLocalInstance((Context)this.ctx).getBooleanParam("CS024", (IObjectPK)new ObjectUuidPK(companyId));
                CS024Map.put(companyId, val);
            }
            if (val && info.getSourceType().equals((Object)SourceTypeEnum.CASH) && info.getFundDispatchType().getValue() == 0) {
                auditSet.add(info.getId().toString());
                continue;
            }
            saveSet.add(info.getId().toString());
        }
        if (saveSet.size() > 0) {
            Integer saveStatus = new Integer(10);
            String antiAuditSql = "UPDATE T_CAS_PaymentBill SET FAuditorID = null,FAuditDate = null,FApproverID = null,FApproveDate = null,FBillStatus = " + saveStatus + " WHERE FID IN " + FMHelper.setTran2String(saveSet);
            DbUtil.execute((Context)this.ctx, (String)antiAuditSql);
        }
        if (auditSet.size() > 0) {
            Integer approvedStatus = new Integer(8);
            String cashSql = "UPDATE T_CAS_PaymentBill SET FAuditorID = null,FAuditDate = null,FBillStatus = " + approvedStatus + " WHERE FID IN " + FMHelper.setTran2String(auditSet);
            DbUtil.execute((Context)this.ctx, (String)cashSql);
        }
    }

    private void verifyInput(PaymentBillCollection coll) throws EASBizException, BOSException {
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            PaymentBillInfo info = coll.get(i);
            if (info.isFiVouchered()) {
                throw new RecPayException(RecPayException.VOUCHER_ANTIAUDIT);
            }
            if (info.isPcaVouchered()) {
                throw new RecPayException(RecPayException.PCAVOUCHER_ANTIAUDIT);
            }
            if (info.getSettlementStatus().equals((Object)SettlementStatusEnum.UNSUBMIT)) {
                if (!info.getBillStatus().equals((Object)BillStatusEnum.AUDITED)) {
                    PayAntiAuditService.throwBizException(CASWebUtil.getResource(this.ctx, "com.kingdee.eas.fi.cas.RecPayResource", "Paymentbill_Cannot_Unaudit", new String[]{info.getBillStatus().getAlias()}));
                }
            } else {
                PayAntiAuditService.throwBizException(CASWebUtil.getResource(this.ctx, "com.kingdee.eas.fi.cas.RecPayResource", "Paymentbill_CommitSettle_Unaudit"));
            }
            this.verifyPayDeatilMatchResult(this.ctx, info);
            if (info.getSourceType() != SourceTypeEnum.AP || info.getBillStatus() == null) continue;
            int billStatus = info.getBillStatus().getValue();
            if (billStatus >= 15) {
                throw new RecPayException(ArApRecPayException.CANNOT_ANTIAUDIT_ONPAYED);
            }
            if (billStatus < 12) {
                throw new RecPayException(ArApRecPayException.CANNOT_ANTIAUDIT_NOT_AUDIT);
            }
            if (!info.isFiVouchered() && !info.isPcaVouchered()) continue;
            throw new ArApRecPayException(ArApRecPayException.CANNOT_ANTIAUDIT_VOUCHERED);
        }
    }

    public static void throwBizException(String msg) throws EASBizException {
        NumericExceptionSubItem item = new NumericExceptionSubItem("99", "{0}");
        EASBizException exec = new EASBizException(item, (Object[])new String[]{msg.toString()});
        throw exec;
    }

    private SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.baseCurrency.id"));
        sic.add(new SelectorItemInfo("auditor.id"));
        sic.add(new SelectorItemInfo("entries.*"));
        sic.add(new SelectorItemInfo("payBillType.*"));
        return sic;
    }

    private void verifyPayDeatilMatchResult(Context ctx, PaymentBillInfo info) throws BOSException, RPMException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("resultType", (Object)2));
        filter.getFilterItems().add(new FilterItemInfo("bizObjectId", (Object)info.getId().toString()));
        view.setFilter(filter);
        RPDMatchResultCollection coll = RPDMatchResultFactory.getLocalInstance((Context)ctx).getRPDMatchResultCollection(view);
        if (coll.size() > 0) {
            throw new RPMException(RPMException.PAYNOANTIAUDIT);
        }
    }
}

