/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.bot.IBOTRelation;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BillStatusEnum;
import com.kingdee.eas.fi.cas.CasForArApException;
import com.kingdee.eas.fi.cas.CasForArApUtil;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.cas.SourceTypeEnum;
import com.kingdee.eas.fi.cas.app.ArApRecPayServerHelper;
import com.kingdee.eas.fi.cas.app.service.handler.ServiceHandler;
import com.kingdee.eas.framework.SystemEnum;
import org.apache.log4j.Logger;

public class PayAppointmentVoucherService {
    private static Logger logger = Logger.getLogger((String)PayAppointmentVoucherService.class.getName());
    protected Context ctx;
    protected PaymentBillInfo info;
    ServiceHandler serviceHandler;

    protected ServiceHandler getServiceHandler() {
        return new ServiceHandler();
    }

    public void initService(Context ctx, PaymentBillInfo info) throws EASBizException, BOSException {
        this.ctx = ctx;
        this.info = info;
        this.serviceHandler = this.getServiceHandler();
        if (!(info.getBillStatus().equals((Object)BillStatusEnum.AUDITED) || info.getBillStatus().equals((Object)BillStatusEnum.PAYED) || info.getBillStatus().equals((Object)BillStatusEnum.RECED))) {
            throw new CasForArApException(CasForArApException.POINT_CANCELVOUCHER_UNAUDIT_NOT);
        }
        SystemStatusCtrolInfo arapStatus = ArApRecPayServerHelper.getSysStatusCtrolInfo(ctx, info.getCompany(), SystemEnum.ACCOUNTSPAYABLE);
        PeriodInfo currentPeriod = arapStatus.getCurrentPeriod();
        SystemStatusCtrolInfo cashStatus = ArApRecPayServerHelper.getSysStatusCtrolInfo(ctx, info.getCompany(), SystemEnum.CASHMANAGEMENT);
        PeriodInfo cashPeriod = cashStatus.getCurrentPeriod();
        if (info.getSourceType() != null && (info.getSourceType().getValue() == 101 || info.getSourceType().getValue() == 100) ? info.getBizDate().before(currentPeriod.getBeginDate()) : info.getBizDate().before(cashPeriod.getBeginDate())) {
            throw new CasForArApException(CasForArApException.POINT_CANCELVOUCHER_INITBILL_NOT);
        }
        if (!info.getBillStatus().equals((Object)BillStatusEnum.PAYED) && CasForArApUtil.isPaiedBillVoucher(ctx, info.getCompany().getId().toString())) {
            throw new CasForArApException(CasForArApException.POINT_CANCELVOUCHER_PAYMENT_NOT);
        }
        if (!info.isIsAppointVoucher() || info.getVoucher() == null) {
            throw new CasForArApException(CasForArApException.POINT_CANCELVOUCHER_EXIST_NOT);
        }
        if (!info.isIsAppointVoucher() && !info.getSourceType().equals((Object)SourceTypeEnum.AP) && info.isFiVouchered() && !info.isIsAppointVoucher()) {
            throw new CasForArApException(CasForArApException.POINT_CANCELVOUCHER_CREATED_NOT);
        }
    }

    public void doService() throws EASBizException, BOSException {
        String destObjectId = this.info.getVoucher().getId().toString();
        String srcObjectId = this.info.getId().toString();
        IBOTRelation iBOTRelation = BOTRelationFactory.getLocalInstance((Context)this.ctx);
        BOTRelationCollection botRelationCollection = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("destObjectID", (Object)destObjectId, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("srcObjectId", (Object)srcObjectId, CompareType.EQUALS));
        view.setFilter(filterInfo);
        botRelationCollection = iBOTRelation.getCollection(view);
        if (botRelationCollection.size() > 0) {
            BOTRelationInfo rotpmap = botRelationCollection.get(0);
            ObjectStringPK pkbot = new ObjectStringPK(rotpmap.getId().toString());
            iBOTRelation.delete((IObjectPK)pkbot);
        }
        this.info.setVoucher(null);
        this.info.setVoucherNumber(null);
        this.info.setVoucherType(null);
        this.info.setIsAppointVoucher(false);
        this.info.setFiVouchered(false);
    }
}

