/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BillStatusEnum;
import com.kingdee.eas.fi.cas.FundDispatchTypeEnum;
import com.kingdee.eas.fi.cas.PaymentBillCollection;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.cas.RecPayHelper;
import com.kingdee.eas.fi.cas.SourceTypeEnum;
import com.kingdee.eas.fi.cas.app.service.IPayApproveService;
import com.kingdee.eas.fi.cas.app.service.handler.ServiceHandler;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.NumericExceptionSubItem;
import java.sql.Timestamp;
import java.util.Set;

public class PayApproveService
implements IPayApproveService {
    protected Context ctx;
    protected Set idSet;
    protected ServiceHandler serviceHandler;
    RecPayHelper helper = new RecPayHelper();

    protected ServiceHandler getServiceHandler() {
        return new ServiceHandler();
    }

    @Override
    public void initService(Context ctx, Set idSet) throws EASBizException, BOSException {
        this.ctx = ctx;
        this.idSet = idSet;
        this.serviceHandler = this.getServiceHandler();
    }

    @Override
    public void doService() throws EASBizException, BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.idSet, CompareType.INCLUDE));
        SelectorItemCollection sic = new SelectorItemCollection();
        view.setSelector(sic);
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("company"));
        sic.add(new SelectorItemInfo("billStatus"));
        sic.add(new SelectorItemInfo("sourceType"));
        PaymentBillCollection colls = PaymentBillFactory.getLocalInstance(this.ctx).getPaymentBillCollection(view);
        for (int index = 0; index < colls.size(); ++index) {
            PaymentBillInfo info = colls.get(index);
            IObjectPK pkOut = LogUtil.beginLog((Context)this.ctx, (String)"\u5ba1\u6838", (BOSObjectType)info.getBOSType(), null, (String)info.getNumber(), (String)"cas_paymentBill_approve");
            if (!SourceTypeEnum.AP.equals((Object)info.getSourceType())) {
                if (info.getBillStatus().equals((Object)BillStatusEnum.SUBMIT)) {
                    ObjectUuidPK orgPK = null;
                    orgPK = info.getCompany() != null ? new ObjectUuidPK(info.getCompany().getId()) : new ObjectUuidPK(ContextHelperFactory.getLocalInstance((Context)this.ctx).getCurrentCompany().getId());
                    boolean CS024 = ContextHelperFactory.getLocalInstance((Context)this.ctx).getBooleanParam("CS024", (IObjectPK)orgPK);
                    if (CS024 && (info.getFundDispatchType() == null || info.getFundDispatchType().equals((Object)FundDispatchTypeEnum.PAYMENT_DEFAULT))) {
                        FMHelper.CheckIsInWorkFlow((Context)this.ctx, (String)info.getId().toString());
                        UserInfo userInfo = ContextHelperFactory.getLocalInstance((Context)this.ctx).getCurrentUser();
                        Timestamp currTime = new Timestamp(System.currentTimeMillis());
                        Integer status = new Integer(8);
                        String sql = "UPDATE T_CAS_PaymentBill SET FApproverID = ?, FApproveDate = ?, FBillStatus = ?   WHERE FID = ? ";
                        DbUtil.execute((Context)this.ctx, (String)sql, (Object[])new Object[]{userInfo.getId().toString(), currTime, status, info.getId().toString()});
                    }
                } else if (info.getFundDispatchType() == null || info.getFundDispatchType().equals((Object)FundDispatchTypeEnum.PAYMENT_DEFAULT)) {
                    throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.fi.cas.RecPayResource", (String)"PaymentBill_Status", (Object[])new String[]{info.getBillStatus().getAlias()})));
                }
            }
            LogUtil.afterLog((Context)this.ctx, (IObjectPK)pkOut);
        }
    }
}

