/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.cas.app.service.IPayChequeReimburseService;
import com.kingdee.eas.fi.cas.app.service.handler.ServiceHandler;
import com.kingdee.eas.fm.nt.ChequeFactory;
import com.kingdee.eas.fm.nt.ChequeInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class PayChequeReimburseService
implements IPayChequeReimburseService {
    ChequeInfo cqInfo;
    private static Logger logger = Logger.getLogger((String)PayChequeReimburseService.class.getName());
    protected Context ctx;
    protected String chequeNumber;
    protected String billId;
    protected PaymentBillInfo info;

    protected ServiceHandler getServiceHandler() {
        return new ServiceHandler();
    }

    @Override
    public void initService(Context ctx, String chequeNumber, String billId, PaymentBillInfo info) throws EASBizException, BOSException {
        this.chequeNumber = chequeNumber;
        this.billId = billId;
        this.cqInfo = ChequeFactory.getLocalInstance((Context)ctx).getChequeInfo((IObjectPK)new ObjectUuidPK(chequeNumber));
        this.ctx = ctx;
        this.info = info;
    }

    @Override
    public void doService() throws EASBizException, BOSException {
        ChequeInfo cqInfo = ChequeFactory.getLocalInstance((Context)this.ctx).getChequeInfo((IObjectPK)new ObjectUuidPK(this.chequeNumber));
        String updateCheque = "UPDATE T_CAS_PaymentBill SET FIsRelateCheque = 1, FChequeId = ?  ,FSettlementNumber=?,FPayeeName=?,FPayeeBank=?,FPayeeAccountBank=? WHERE FID = ? ";
        Connection conn = null;
        PreparedStatement ps = null;
        Object[] params = new Object[]{this.chequeNumber, cqInfo.getNumber(), cqInfo.getPayeeName(), cqInfo.getPayeeAcctBank(), cqInfo.getPayeeAcctNumber(), this.billId};
        try {
            conn = EJBFactory.getConnection((Context)this.ctx);
        }
        catch (SQLException exc) {
            SQLUtils.cleanup((Connection)conn);
            throw new BOSException("CONFIG_EXCEPTION", (Throwable)exc);
        }
        try {
            ps = conn.prepareStatement(updateCheque);
            for (int i = 0; i < params.length; ++i) {
                if (params[i] == null || params[i] instanceof String && ((String)params[i]).length() == 0) {
                    ps.setObject(i + 1, null, 12);
                    continue;
                }
                ps.setObject(i + 1, params[i]);
            }
            ps.execute();
        }
        catch (SQLException exc) {
            StringBuffer sb = new StringBuffer("");
            for (int i = 0; i < params.length; ++i) {
                sb.append("param ").append(i).append(" is:").append(params[i]);
            }
            logger.error((Object)("222 sql is:" + updateCheque + " param is:" + sb.toString()), (Throwable)exc);
            throw new BOSException("Sql222 execute exception : " + updateCheque, (Throwable)exc);
        }
        finally {
            SQLUtils.cleanup((Statement)ps, (Connection)conn);
        }
        String sql2 = "UPDATE T_NT_Cheque SET FPaymentBillNum = ? ,Fstate = ? WHERE Fid=? ";
        DbUtil.execute((Context)this.ctx, (String)sql2, (Object[])new Object[]{this.info.getNumber(), 3, this.chequeNumber});
        HashSet<String> idSet = new HashSet<String>(1);
        idSet.add(this.billId);
        PaymentBillFactory.getLocalInstance(this.ctx).pay(idSet);
    }
}

