/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.base.core.util.BOTPUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.CasException;
import com.kingdee.eas.fi.cas.CasWebException;
import com.kingdee.eas.fi.cas.PaymentBillCollection;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.cas.RecPayException;
import com.kingdee.eas.fi.cas.RecPayHelper;
import com.kingdee.eas.fi.cas.SettlementStatusEnum;
import com.kingdee.eas.fi.cas.app.service.IPayCommitSettleService;
import com.kingdee.eas.fi.cas.app.service.handler.ServiceHandler;
import com.kingdee.eas.fi.cas.utils.CASWebHelper;
import com.kingdee.eas.fm.be.BEException;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.common.FMVerifyHelper;
import com.kingdee.eas.fm.fd.FDException;
import com.kingdee.eas.fm.fd.FundDispatchPlanBillCollection;
import com.kingdee.eas.fm.fd.FundDispatchPlanBillFactory;
import com.kingdee.eas.fm.fd.FundDispatchPlanBillInfo;
import com.kingdee.eas.fm.fd.FundDispatchPlanBillWebFacadeFactory;
import com.kingdee.eas.fm.fee.FeeBillInfo;
import com.kingdee.eas.fm.fs.InnerAccountFactory;
import com.kingdee.eas.fm.fs.InnerAccountInfo;
import com.kingdee.eas.fm.fs.SettBizTypeEnum;
import com.kingdee.eas.fm.fs.SettBizTypeInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.NumericExceptionSubItem;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.apache.log4j.Logger;

public class PayCommitSettleService
implements IPayCommitSettleService {
    private static Logger logger = Logger.getLogger((String)PayCommitSettleService.class.getName());
    protected Context ctx;
    private Set idSet = null;
    private PaymentBillCollection coll;
    protected RecPayHelper helper = new RecPayHelper();

    @Override
    public void initService(Context ctx, Set idSet) throws EASBizException, BOSException {
        this.ctx = ctx;
        this.idSet = idSet;
    }

    public void beforeCommitSettle() throws EASBizException, BOSException {
        new ServiceHandler().lockedPaymentIds(this.ctx, new ArrayList(this.idSet));
        this.coll = PayCommitSettleService.getPayColl(this.ctx, this.idSet);
        Set validSet = null;
        validSet = this.helper.getPayValidIdSetByCommit(this.ctx, this.coll, true);
        if (validSet == null || validSet.isEmpty()) {
            throw new RecPayException(RecPayException.HASNOT_VALID_LISTS);
        }
        this.verify(this.ctx, this.coll, true);
    }

    @Override
    public void doService() throws EASBizException, BOSException {
        this.beforeCommitSettle();
        AccountBankInfo payerAcctBankInfo = this.coll.get(0).getPayerAccountBank();
        InnerAccountInfo innerAcctBank = payerAcctBankInfo.getInnerAcct();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("clearingHouse.*");
        innerAcctBank = InnerAccountFactory.getLocalInstance((Context)this.ctx).getInnerAccountInfo((IObjectPK)new ObjectUuidPK(innerAcctBank.getId()), sic);
        BankInfo bank = innerAcctBank.getClearingHouse();
        this.helper.botpTransformSettle(this.ctx, bank, (IObjectCollection)this.coll);
        int size = this.coll.size();
        for (int i = 0; i < size; ++i) {
            PaymentBillFactory.getLocalInstance(this.ctx).commitSettle4WF((IObjectPK)new ObjectUuidPK(this.coll.get(i).getId()));
            IObjectPK pkOut = LogUtil.beginLog((Context)this.ctx, (String)ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"214_PayCommitSettleService", (Locale)this.ctx.getLocale()), (BOSObjectType)this.coll.get(i).getBOSType(), null, (String)this.coll.get(i).getNumber(), (String)"cas_paymentBill_commitSettle");
            LogUtil.afterLog((Context)this.ctx, (IObjectPK)pkOut);
        }
        this.afterCommitSettle();
    }

    protected void afterCommitSettle() throws EASBizException, BOSException {
        this.helper.SignSubmitSymbol(this.ctx, this.idSet);
        String companyId = this.coll.get(0).getCompany().getId().toString();
        boolean CS118 = ContextHelperFactory.getLocalInstance((Context)this.ctx).getBooleanParam("CS118", (IObjectPK)new ObjectUuidPK(companyId));
        if (CS118 && this.verifyReportSetting(this.ctx, this.coll.get(0).getId().toString())) {
            Set planIdSet = this.handleProcess(this.ctx, this.idSet);
            PaymentBillFactory.getLocalInstance(this.ctx).afterCommitSettle(this.idSet, planIdSet, companyId);
        }
    }

    private boolean verifyReportSetting(Context ctx, String payBillId) throws EASBizException, BOSException {
        Map map = FundDispatchPlanBillWebFacadeFactory.getLocalInstance((Context)ctx).getPayFilter();
        String filter = (String)map.get("filter");
        try {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo(filter);
            System.out.println("filter===========" + filter);
            FilterInfo idFilter = new FilterInfo();
            idFilter.getFilterItems().add(new FilterItemInfo("id", (Object)payBillId));
            filterInfo.mergeFilter(idFilter, "AND");
            System.out.println("payBillId===========" + payBillId);
            view.setFilter(filterInfo);
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("id");
            view.setSelector(selector);
            PaymentBillCollection coll = PaymentBillFactory.getLocalInstance(ctx).getPaymentBillCollection(view);
            if (view.getFilter() != null) {
                System.out.println("view.getFilter()===========" + view.getFilter().toSql());
            }
            System.out.println("coll===========" + (Object)((Object)coll));
            if (coll.size() > 0) {
                return true;
            }
        }
        catch (ParserException e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage());
        }
        return false;
    }

    private Set handleProcess(Context ctx, Set idSet) throws EASBizException, BOSException {
        HashSet<String> planIdSet = new HashSet<String>();
        String id = (String)idSet.iterator().next();
        PaymentBillInfo info = this.coll.get(0);
        long current = System.currentTimeMillis();
        long zero = current / 86400000L * 86400000L - (long)TimeZone.getDefault().getRawOffset();
        Date today = new Date(zero);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)info.getCompany().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("billStatus", (Object)8));
        filter.getFilterItems().add(new FilterItemInfo("reportType", (Object)2));
        filter.getFilterItems().add(new FilterItemInfo("expectPayStartDate", (Object)today, CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isInvalid", (Object)false));
        filter.getFilterItems().add(new FilterItemInfo("expectPayEndDate", (Object)today, CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("payerAccountBank.bank.inGroup", (Object)1));
        filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)info.getCurrency().getId().toString(), CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("unusedAmt", (Object)0, CompareType.GREATER));
        EntityViewInfo ev = new EntityViewInfo();
        ev.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        SorterItemInfo sortInfo = new SorterItemInfo("number");
        sortInfo.setSortType(SortType.DESCEND);
        sorter.add(sortInfo);
        ev.setSorter(sorter);
        CoreBaseCollection colls = FundDispatchPlanBillFactory.getLocalInstance((Context)ctx).getCollection(ev);
        for (int i = 0; i < colls.size(); ++i) {
            CoreBaseInfo cInfo = colls.get(i);
            planIdSet.add(cInfo.getId().toString());
        }
        return planIdSet;
    }

    public void verify(Context ctx, PaymentBillCollection coll, Boolean checkAudited) throws EASBizException, BOSException {
        boolean isSettleDateCheck = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("CS058", null);
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            InnerAccountInfo innerAccount;
            String err;
            int sourceType;
            int settlementStatus;
            int billStatus;
            PaymentBillInfo info = coll.get(i);
            boolean CS118 = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("CS118", (IObjectPK)new ObjectUuidPK(info.getCompany().getId().toString()));
            this.checkIsAdjustPeriod(ctx, info);
            boolean isPermission = CASWebHelper.hasFunctionPermission(ctx, ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), "cas_paymentbill_07commitToCH");
            if (!isPermission) {
                throw new CasWebException(CasWebException.NO_COMMITSETTLE_AUTHRIZED055);
            }
            if (checkAudited.booleanValue() && info.getBillStatus() != null && (billStatus = info.getBillStatus().getValue()) != 12) {
                throw new CasWebException(CasWebException.COMMITSETTLE_MUSTAUDITED_057);
            }
            if (info.getSettlementStatus() != null && (settlementStatus = info.getSettlementStatus().getValue()) != 10) {
                throw new CasWebException(CasWebException.CANNOT_MULTI_COMMITSETTLE_058);
            }
            if (info.getSourceBillId() != null && new FeeBillInfo().getBOSType().equals((Object)BOSUuid.read((String)info.getSourceBillId()).getType())) {
                throw new CasWebException(CasWebException.FEEBILL_CANNOT_COMMITSETTLE_059);
            }
            SettBizTypeInfo bizTypeInfo = info.getBizType();
            if (info.getSourceType() != null && ((sourceType = info.getSourceType().getValue()) == 105 || bizTypeInfo == null)) {
                throw new CasWebException(CasWebException.PAYMENTBILL_CANNOT_COMMITSETTLE_063);
            }
            AccountBankInfo payerAcctBankInfo = info.getPayerAccountBank();
            if (EmptyUtil.isEmpty((CoreBaseInfo)payerAcctBankInfo.getInnerAcct())) {
                throw new RecPayException(RecPayException.PAYERACCTNOTINNERACCT);
            }
            boolean canCommitCH = true;
            if (!EmptyUtil.isEmpty((CoreBaseInfo)info.getAgentPayCompany())) {
                boolean isCleaningHouseCompany;
                String agentCompany = info.getAgentPayCompany().getId().toString();
                canCommitCH = isCleaningHouseCompany = BankFactory.getLocalInstance((Context)ctx).isClearinghouseCompany(agentCompany);
            }
            if (!canCommitCH) {
                throw new CasException(CasException.AGENTPAYCOMPANYNOTCH);
            }
            InnerAccountInfo innerAcctBank = payerAcctBankInfo.getInnerAcct();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("clearingHouse.*"));
            innerAcctBank = InnerAccountFactory.getLocalInstance((Context)ctx).getInnerAccountInfo((IObjectPK)new ObjectUuidPK(innerAcctBank.getId()), sic);
            BankInfo bank = innerAcctBank.getClearingHouse();
            SettBizTypeInfo settBizTypeInfo = info.getBizType();
            if (bank == null || !bank.isInGroup()) {
                throw new RecPayException(RecPayException.PAYERBANK_CAN_BE_INGROUP);
            }
            if (info.getDescription() == null) {
                throw new RecPayException(RecPayException.DESCRIPTIONISNULL);
            }
            if (settBizTypeInfo == null) {
                throw new RecPayException(RecPayException.SETTBIZTYPE_CANNOT_NULL);
            }
            if (info.getSettlementStatus().equals((Object)SettlementStatusEnum.SUBMITED)) {
                throw new RecPayException(RecPayException.ALREADYCOMMSETTLE);
            }
            if (settBizTypeInfo.getType() == SettBizTypeEnum.PAYINSIDE) {
                FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"oppInnerAcct");
            }
            if (settBizTypeInfo != null && settBizTypeInfo.getType() == SettBizTypeEnum.PAYINSIDE && info.getPayeeAccountBank() != null && info.getOppInnerAcct() == null) {
                throw new RecPayException(RecPayException.PAYEEACCOUNTMUSTHAVEINNERACCOUNT);
            }
            if (isSettleDateCheck) {
                Date settleDate = bank.getSettleDate();
                Date bizDate = info.getBizDate();
                if (settleDate != null && bizDate != null && settleDate.after(bizDate)) {
                    throw new RecPayException(RecPayException.SETTLEDATECHECKINVALID);
                }
            }
            if (CS118) {
                if (info.getFundDispatchPlanStatus().getValue() == 2) {
                    throw new FDException(FDException.REPORTED_NO_COMMIT);
                }
                if (info.getFundDispatchPlanStatus().getValue() == 3) {
                    FundDispatchPlanBillInfo fdpInfo = this.getFundDisPlanByPayId(ctx, info.getId().toString());
                    long current = System.currentTimeMillis();
                    long zero = current / 86400000L * 86400000L - (long)TimeZone.getDefault().getRawOffset();
                    Date today = new Date(zero);
                    if (!EmptyUtil.isEmpty((CoreBaseInfo)fdpInfo) && (fdpInfo.getExpectPayStartDate().after(today) || fdpInfo.getExpectPayEndDate().before(today))) {
                        throw new FDException(FDException.BILL_OUT_DATE);
                    }
                }
            }
            Set idsSet = BOTPUtil.getDestBillIdSet((Context)ctx, (String)info.getId().toString());
            for (String id : idsSet) {
                if (!BOSUuid.read((String)id).getType().equals((Object)BOSObjectType.create((String)"6E41E17C"))) continue;
                throw new BEException(BEException.COMMON, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"428_PayCommitSettleService", (Locale)ctx.getLocale())});
            }
            IContextHelper contextHelp = ContextHelperFactory.getLocalInstance((Context)ctx);
            int tm105 = contextHelp.getIntParam("TM105", (IObjectPK)new ObjectUuidPK(info.getCompany().getId()));
            if (info.getPayBillType().isIsFinanceTranUp() && tm105 == 0) {
                if (info.getActRecAccountBank() == null || info.getPayerBank() == null || info.getPayerAccount() == null || info.getPayerAccountBank() == null) {
                    err = MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"401_RecPayHelper", (Locale)ctx.getLocale()), info.getNumber());
                    throw new EASBizException(new NumericExceptionSubItem("", err));
                }
            } else {
                if (info.getPayBillType().isIsFinanceTranUp() && tm105 != 0) {
                    err = ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"402_RecPayHelper", (Locale)ctx.getLocale());
                    throw new EASBizException(new NumericExceptionSubItem("", err));
                }
                if (info.getBizType() == null || info.getPayerBank() == null || info.getPayerAccount() == null || info.getPayerAccountBank() == null) {
                    err = MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"403_RecPayHelper", (Locale)ctx.getLocale()), info.getNumber());
                    throw new EASBizException(new NumericExceptionSubItem("", err));
                }
                if (info.getBizType().isNotSubmitHouse()) {
                    err = MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"404_RecPayHelper", (Locale)ctx.getLocale()), info.getNumber());
                    throw new EASBizException(new NumericExceptionSubItem("", err));
                }
            }
            if (tm105 != 0 || !info.getPayBillType().isIsFinanceTranUp()) continue;
            InnerAccountInfo innerAccountInfo = innerAccount = info.getPayerInAcctID() == null ? null : info.getPayerInAcctID().getInnerAcct();
            if (innerAccount != null) continue;
            throw new RecPayException(RecPayException.INNERACCOUNTISNULL);
        }
    }

    protected void checkIsAdjustPeriod(Context ctx, PaymentBillInfo info) throws EASBizException, BOSException {
        String msg = new FMException(FMException.CURRPERIODISADJUST).getMessage();
        PeriodInfo periodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)info.getCompany());
        if (periodInfo != null && periodInfo.isIsAdjustPeriod()) {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{info.getCompany().getName() + ": " + msg});
        }
    }

    public static PaymentBillCollection getPayColl(Context ctx, Set idSet) throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSelector().add("*");
        evi.getSelector().add("payerAccount.*");
        evi.getSelector().add("payerAccount.InnerAcct.*");
        evi.getSelector().add("payerAccountBank.*");
        evi.getSelector().add("payeeAccountBankO.*");
        evi.getSelector().add("payeeAccountBankO.InnerAcct.*");
        evi.getSelector().add("payerAccountBank.InnerAcct.*");
        evi.getSelector().add("payerAccountBank.InnerAcct.clearingHouse.*");
        evi.getSelector().add("settlementType.*");
        evi.getSelector().add("settlementType.ntType.*");
        evi.getSelector().add("cheque.*");
        evi.getSelector().add("payerBank.*");
        evi.getSelector().add("bizType.*");
        evi.getSelector().add("oppInnerAcct.*");
        evi.getSelector().add("oppAccount.*");
        evi.getSelector().add("company.*");
        evi.getSelector().add("payBillType.*");
        evi.getSelector().add("actRecAccountBank.*");
        evi.getSelector().add("payerInAcctID.*");
        evi.getSelector().add(new SelectorItemInfo("entries.*"));
        evi.getSelector().add("fundDispatchPlanBillStatus");
        evi.getSelector().add(new SelectorItemInfo("CU.*"));
        return PaymentBillFactory.getLocalInstance(ctx).getPaymentBillCollection(evi);
    }

    private FundDispatchPlanBillInfo getFundDisPlanByPayId(Context ctx, String id) throws BOSException {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        SelectorItemCollection sel = new SelectorItemCollection();
        sel.add(new SelectorItemInfo("*"));
        entityViewInfo.setSelector(sel);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("sourceBillId", (Object)id, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("reportType", (Object)1, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isInvalid", (Object)false));
        entityViewInfo.setFilter(filter);
        FundDispatchPlanBillCollection colls = FundDispatchPlanBillFactory.getLocalInstance((Context)ctx).getFundDispatchPlanBillCollection(entityViewInfo);
        if (colls.size() > 0) {
            return colls.get(0);
        }
        return null;
    }

    public void beforeCommitSettleForAudit() throws EASBizException, BOSException {
        new ServiceHandler().lockedPaymentIds(this.ctx, new ArrayList(this.idSet));
        this.coll = PayCommitSettleService.getPayColl(this.ctx, this.idSet);
        Set validSet = null;
        validSet = this.helper.getPayValidIdSetByCommit(this.ctx, this.coll, false);
        if (validSet == null || validSet.isEmpty()) {
            throw new RecPayException(RecPayException.HASNOT_VALID_LISTS);
        }
        this.verify(this.ctx, this.coll, false);
    }
}

