/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.CasException;
import com.kingdee.eas.fi.cas.CashPamentBillUtil;
import com.kingdee.eas.fi.cas.DisposerActionEnum;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.cas.SourceTypeEnum;
import com.kingdee.eas.fi.cas.app.service.IPayDelVoucherService;
import com.kingdee.eas.fi.cas.app.service.handler.ServiceHandler;
import com.kingdee.eas.fi.cas.utils.ArApSelectorFactory;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.util.app.DbUtil;
import java.util.HashSet;
import java.util.Set;

public class PayDelVoucherService
implements IPayDelVoucherService {
    protected Context ctx;
    private IObjectPK sourceBillPk;
    private ServiceHandler serviceHandler = new ServiceHandler();

    @Override
    public void initService(Context ctx, IObjectPK sourceBillPk) throws EASBizException, BOSException {
        this.ctx = ctx;
        this.sourceBillPk = sourceBillPk;
    }

    @Override
    public boolean doService() throws EASBizException, BOSException {
        boolean result = false;
        SelectorItemCollection sic = new SelectorItemCollection();
        sic = ArApSelectorFactory.getApPaymentBillSelector();
        PaymentBillInfo info = PaymentBillFactory.getLocalInstance(this.ctx).getPaymentBillInfo(this.sourceBillPk, sic);
        String billId = null;
        this.veryBeforeDelVoucher(info);
        if (!info.isIsAppointVoucher() && info.isFiVouchered()) {
            billId = info.getId().toString();
        }
        if (billId != null) {
            Set idSet = FMHelper.getSrcBillIdCollBySrcId((Context)this.ctx, billId);
            if (info != null && info.getVoucher() != null) {
                HashSet<String> idJournalSet = new HashSet<String>();
                idJournalSet.add(info.getVoucher().getId().toString());
                this.setJournal(this.ctx, idJournalSet);
            }
            this.setAccountant(this.ctx, idSet, 90);
            if (info != null && info.getSourceType() == SourceTypeEnum.FDC) {
                CashPamentBillUtil._deleteVoucher(this.ctx, info);
            }
            if (info != null) {
                this.serviceHandler.dispose(this.ctx, info, DisposerActionEnum.DEL_VOUCHER);
                result = true;
            }
        }
        return result;
    }

    private void veryBeforeDelVoucher(PaymentBillInfo info) throws BOSException, EASBizException {
        boolean hasPermission = PermissionFactory.getLocalInstance((Context)this.ctx).hasFunctionPermission(this.ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), "cas_paymentbill_12delVoucher");
        if (!hasPermission) {
            throw new CasException(CasException.DELVOUCHERPERMISSION, new Object[]{info.getCompany().getName()});
        }
    }

    private void setAccountant(Context ctx, Set idSet, int isVouchered) throws BOSException {
        if (idSet == null || idSet.size() < 1) {
            return;
        }
        String ids = FMHelper.setTran2String((Set)idSet);
        StringBuffer sql = new StringBuffer();
        sql.append(" UPDATE T_CAS_PaymentBill SET FAccountantID= null ").append(" WHERE FID IN ").append(ids);
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private void setJournal(Context ctx, Set idSet) throws BOSException {
        if (idSet == null || idSet.size() < 1) {
            return;
        }
        String ids = FMHelper.setTran2String((Set)idSet);
        StringBuffer sql = new StringBuffer();
        sql.append(" UPDATE T_CAS_Journal SET fvoucherid=null,fvouchertypeid=null,fvouchernumber=null ").append(" WHERE fvoucherid IN ").append(ids);
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    @Override
    public void afterService(IObjectPK sourceBillPk) throws EASBizException, BOSException {
    }
}

