/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.IBOTRelation;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.core.util.NumberRuleUtil;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.wssc.BillImageFacadeFactory;
import com.kingdee.eas.base.wssc.BillImageMapCollection;
import com.kingdee.eas.base.wssc.BillImageMapFactory;
import com.kingdee.eas.base.wssc.BillImageMapInfo;
import com.kingdee.eas.base.wssc.IBillImageMap;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.DisposerActionEnum;
import com.kingdee.eas.fi.cas.FundDispatchTypeEnum;
import com.kingdee.eas.fi.cas.PaymentBillEntryCollection;
import com.kingdee.eas.fi.cas.PaymentBillEntryInfo;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.cas.RecPayBgCtrlStrEnum;
import com.kingdee.eas.fi.cas.RecPayException;
import com.kingdee.eas.fi.cas.SourceTypeEnum;
import com.kingdee.eas.fi.cas.app.service.IPayDeleteService;
import com.kingdee.eas.fi.cas.app.service.handler.ServiceHandler;
import com.kingdee.eas.fm.be.TransDetailFactory;
import com.kingdee.eas.fm.be.TransDetailInfo;
import com.kingdee.eas.fm.common.H;
import com.kingdee.eas.fm.common.util.BizRelateReceivableBillUtil;
import com.kingdee.eas.fm.fee.FeeBillInfo;
import com.kingdee.eas.fm.fin.CompUnTimeDepositBillFactory;
import com.kingdee.eas.fm.fin.CompUnTimeDepositBillInfo;
import com.kingdee.eas.fm.fin.app.LoanReverseHelper;
import com.kingdee.eas.fm.fs.SettlementBillFactory;
import com.kingdee.eas.fm.fs.SettlementBillInfo;
import com.kingdee.eas.fm.ft.FundTransferBill;
import com.kingdee.eas.fm.ft.FundTransferBillFactory;
import com.kingdee.eas.fm.ft.FundTransferBillInfo;
import com.kingdee.eas.fm.nt.AssureAmountFactory;
import com.kingdee.eas.fm.nt.AssureAmountInfo;
import com.kingdee.eas.fm.nt.AssureStateEnum;
import com.kingdee.eas.fm.nt.NTTypeGroupEnum;
import com.kingdee.eas.fm.nt.ReceivableBillFactory;
import com.kingdee.eas.fm.td.TimeDepositApplyFactory;
import com.kingdee.eas.fm.td.TimeDepositApplyInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class PayDeleteService
implements IPayDeleteService {
    private static Logger logger = Logger.getLogger((String)PayDeleteService.class.getName());
    protected Context ctx;
    protected PaymentBillInfo info;
    protected IObjectPK pk;
    IObjectPK pkOut;
    protected ServiceHandler serviceHandler;
    protected UserInfo userInfo;
    protected IPermission iPermission;
    protected boolean isHasValue = false;
    private String botpSrcBillId;

    private ServiceHandler getServiceHandler() {
        return new ServiceHandler();
    }

    @Override
    public void initService(Context ctx, IObjectPK pk, PaymentBillInfo info) throws EASBizException, BOSException {
        this.ctx = ctx;
        this.pk = pk;
        this.info = info;
        this.serviceHandler = this.getServiceHandler();
        this.userInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        this.iPermission = PermissionFactory.getLocalInstance((Context)ctx);
    }

    @Override
    public void beforeDelete() throws EASBizException, BOSException {
        int paymentBillType = this.info.getPaymentBillType().getValue();
        boolean isAgentBill = 3 == paymentBillType;
        String sourceBillId = this.info.getSourceBillId();
        if (!EmptyUtil.isEmpty((String)sourceBillId)) {
            BOSUuid sbid = BOSUuid.read((String)sourceBillId);
            if (!Integer.valueOf(1).equals(this.ctx.get((Object)"deleteFromAgentOrgFlag")) && sbid.getType().equals((Object)new PaymentBillInfo().getBOSType()) && !EmptyUtil.isEmpty((String)this.info.getSrcAgenPaymentBillID())) {
                throw new RecPayException(RecPayException.AGENTPAYBILLNOTDELETE);
            }
        }
        int billStatus = this.info.getBillStatus().getValue();
        boolean isGenVoucher = this.info.isFiVouchered();
        if (isGenVoucher) {
            throw new RecPayException(RecPayException.CANNOT_DEL_VOUCHERED);
        }
        if (billStatus == 15) {
            throw new RecPayException(RecPayException.CANNOT_DEL_PAYED);
        }
        if (billStatus == 8) {
            throw new RecPayException(RecPayException.CANNOT_DEL_APPROVED);
        }
        if (!isAgentBill && billStatus == 12) {
            throw new RecPayException(RecPayException.CANNOT_DEL_AUDITED);
        }
        int fundDispatchPlanStatus = this.info.getFundDispatchPlanStatus().getValue();
        if (fundDispatchPlanStatus == 2 || fundDispatchPlanStatus == 3) {
            throw new RecPayException(RecPayException.NO_DEL_REPORTED);
        }
        if (this.info.isIsSchCreated() && EmptyUtil.isEmpty((Object)this.ctx.get((Object)"deleteFromSchedule"))) {
            throw new RecPayException(RecPayException.CANNOT_DEL_SCHEDULE);
        }
        this.checkCanDeleteInitBill(this.ctx, this.info);
        if (this.info.getSourceType() != SourceTypeEnum.AP && this.info.getNumber() != null && this.info.getNumber().trim().length() > 0) {
            NumberRuleUtil.recycleNumber((Context)this.ctx, (CoreBaseInfo)this.info, (String)this.info.getCompany().getId().toString());
        }
        this.serviceHandler.deletePaymentReport(this.ctx, this.info);
        if (this.info.getSourceSysType() == SourceTypeEnum.EIP) {
            throw new RecPayException(RecPayException.NODELETE_EIP);
        }
        if (!this.isHasValue && !this.info.isIsDiffCurSettlement()) {
            this.serviceHandler.dispose(this.ctx, this.info, DisposerActionEnum.DELETE);
        }
        if (!this.info.isIsSchCreated() && this.info.getSettlementType() != null && this.info.getSettlementType().getNtType() != null && NTTypeGroupEnum.RECEIVABLE.equals((Object)this.info.getSettlementType().getNtType().getSuperGroup())) {
            ReceivableBillFactory.getLocalInstance((Context)this.ctx).lockReceivanleBill((CoreBaseInfo)this.info, "delete");
        }
        this.serviceHandler.cancelRequestBudget(this.ctx, this.pk.toString(), RecPayBgCtrlStrEnum.Sumbit_Sub, null);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("srcEntityID", (Object)new TransDetailInfo().getBOSType(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("destObjectID", (Object)this.info.getId(), CompareType.EQUALS));
        evi.setFilter(filter);
        IBOTRelation iBOTRelation = BOTRelationFactory.getLocalInstance((Context)this.ctx);
        BOTRelationCollection relateColl = iBOTRelation.getCollection(evi);
        if (relateColl != null && relateColl.size() > 0) {
            this.botpSrcBillId = relateColl.get(0).getSrcObjectID();
        }
    }

    private void checkCanDeleteInitBill(Context ctx, PaymentBillInfo info) throws RecPayException, BOSException {
        PaymentBillEntryCollection entryColl = info.getEntries();
        Iterator it = entryColl.iterator();
        BigDecimal unLockAmt = null;
        BigDecimal hisUnVcAmt = null;
        String number = info.getNumber();
        if (info.isIsInitializeBill()) {
            PaymentBillEntryInfo entryInfo = null;
            while (it.hasNext()) {
                entryInfo = (PaymentBillEntryInfo)it.next();
                unLockAmt = entryInfo.getUnLockAmt();
                if (unLockAmt.compareTo(hisUnVcAmt = entryInfo.getHisUnVcAmount()) == 0) continue;
                throw new RecPayException(RecPayException.CANNOT_DELETE_INIT, new String[]{number});
            }
        }
    }

    @Override
    public void afterDelete() throws EASBizException, BOSException {
        BOSUuid bosId;
        LoanReverseHelper.getInstance().paymentBillDelete(this.ctx, this.info);
        String id = this.info.getSourceBillId();
        if (!EmptyUtil.isEmpty((String)this.botpSrcBillId) && (bosId = BOSUuid.read((String)this.botpSrcBillId)).getType().equals((Object)BOSObjectType.create((String)"380D4F63"))) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(this.botpSrcBillId);
            HashMap valueMap = new HashMap();
            HashMap<String, Object> value = new HashMap<String, Object>();
            value.put("isReced", Boolean.FALSE);
            value.put("recedBillType", this.info.getBOSType());
            value.put("recedBillNumber", this.info.getNumber());
            valueMap.put(this.botpSrcBillId, value);
            TransDetailFactory.getLocalInstance((Context)this.ctx).disposeRecInfo(list, valueMap);
        }
        if (id != null && id.length() > 0) {
            bosId = BOSUuid.read((String)id);
            if (bosId.getType().equals((Object)BOSObjectType.create((String)"5BE5C252"))) {
                PaymentBillEntryCollection eColl = this.info.getEntries();
                for (int i = 0; i < eColl.size(); ++i) {
                    PaymentBillEntryInfo eInfo = eColl.get(i);
                    String eSourcBillId = eInfo.getSourceBillId();
                    AssureAmountInfo assureAmountInfo = AssureAmountFactory.getLocalInstance((Context)this.ctx).getAssureAmountInfo((IObjectPK)new ObjectUuidPK(eSourcBillId));
                    assureAmountInfo.setIsGenePayBill(false);
                    if (AssureStateEnum.PAIED.equals((Object)assureAmountInfo.getAssureState())) {
                        assureAmountInfo.setAssureState(AssureStateEnum.SAVED);
                    }
                    SelectorItemCollection sic = new SelectorItemCollection();
                    sic.add(new SelectorItemInfo("isGenePayBill"));
                    sic.add(new SelectorItemInfo("assureState"));
                    AssureAmountFactory.getLocalInstance((Context)this.ctx).updatePartial((CoreBaseInfo)assureAmountInfo, sic);
                }
            } else if (bosId.getType().equals((Object)BOSObjectType.create((String)"BCDA3EC6"))) {
                TimeDepositApplyInfo timeDepositApplyInfo = TimeDepositApplyFactory.getLocalInstance((Context)this.ctx).getTimeDepositApplyInfo((IObjectPK)new ObjectUuidPK(id));
                timeDepositApplyInfo.setIsCreatePayment(false);
                TimeDepositApplyFactory.getLocalInstance((Context)this.ctx).update((IObjectPK)new ObjectUuidPK(id), (CoreBaseInfo)timeDepositApplyInfo);
            } else if (bosId.getType().equals((Object)BOSObjectType.create((String)"F60C7B9E"))) {
                CompUnTimeDepositBillInfo unTimeDepositInfo = CompUnTimeDepositBillFactory.getLocalInstance((Context)this.ctx).getCompUnTimeDepositBillInfo((IObjectPK)new ObjectUuidPK(id));
                unTimeDepositInfo.setIsCreatePayment(false);
                CompUnTimeDepositBillFactory.getLocalInstance((Context)this.ctx).update((IObjectPK)new ObjectUuidPK(id), unTimeDepositInfo);
            } else if (bosId.getType().equals((Object)BOSObjectType.create((String)"326AFB8F"))) {
                IBOTRelation botRel = BOTRelationFactory.getLocalInstance((Context)this.ctx);
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("destObjectID", (Object)this.pk.toString(), CompareType.INCLUDE));
                filter.getFilterItems().add(new FilterItemInfo("srcEntityID", (Object)new FeeBillInfo().getBOSType().toString(), CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("destEntityID", (Object)new PaymentBillInfo().getBOSType().toString(), CompareType.EQUALS));
                EntityViewInfo view = new EntityViewInfo();
                view.setFilter(filter);
                BOTRelationCollection botp = botRel.getCollection(view);
                if (botp != null && botp.size() > 0) {
                    botRel.delete((IObjectPK)new ObjectUuidPK(botp.get(0).getId()));
                }
                String sql = "update T_FE_FeeBill set FIsPayBill=0 where fid='" + id + "'";
                DbUtil.execute((Context)this.ctx, (String)sql);
            } else if (bosId.getType().equals((Object)BOSObjectType.create((String)"6E41E17C"))) {
                SettlementBillInfo settltmentBillInfo = SettlementBillFactory.getLocalInstance((Context)this.ctx).getSettlementBillInfo((IObjectPK)new ObjectUuidPK(id));
                settltmentBillInfo.setIsGenPaymentBill(false);
                SettlementBillFactory.getLocalInstance((Context)this.ctx).update((IObjectPK)new ObjectUuidPK(id), (CoreBaseInfo)settltmentBillInfo);
            } else if (bosId.getType().equals((Object)new FundTransferBill().getType())) {
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("paymentBill.id"));
                FundTransferBillInfo transBillInfo = FundTransferBillFactory.getLocalInstance((Context)this.ctx).getFundTransferBillInfo((IObjectPK)new ObjectUuidPK(id), sic);
                if (transBillInfo != null && !EmptyUtil.isEmpty((CoreBaseInfo)transBillInfo.getPaymentBill()) && transBillInfo.getPaymentBill().getId().equals((Object)this.info.getId())) {
                    String sql = "update T_FT_FundTransferBill SET FISGENPAYBILL = 0 ,FPAYMENTBILLID = NULL where fid='" + id + "'";
                    DbUtil.execute((Context)this.ctx, (String)sql);
                }
            }
        }
        this.serviceHandler.reverseConsignment(this.ctx, this.info, "0");
        this.deleteBillImageByBillID(this.ctx, this.info.getId().toString());
        BizRelateReceivableBillUtil.deleteReceivableEntry((Context)this.ctx, (CoreBaseInfo)this.info, (IObjectPK)this.pk);
        this.RefundPaymentDelete(this.ctx, this.info);
        if (!this.info.getFundDispatchType().equals((Object)FundDispatchTypeEnum.PAYMENT_DEFAULT)) {
            String sql = "update T_FD_FundDispatchPlatformEntry set FFundDispatchBillId=''  where FFundDispatchBillId = ?";
            DbUtil.execute((Context)this.ctx, (String)sql, (Object[])new Object[]{this.info.getId().toString()});
        }
        this.pkOut = LogUtil.beginLog((Context)this.ctx, (String)"delete", (BOSObjectType)this.info.getBOSType(), null, (String)this.info.getLogInfo(), (String)"cas_paymentBill_remove");
        LogUtil.afterLog((Context)this.ctx, (IObjectPK)this.pkOut);
    }

    private void RefundPaymentDelete(Context ctx, PaymentBillInfo info) throws BOSException {
        String tid;
        if (H.isEmpty((Object)info.getRefundPayBillId())) {
            return;
        }
        String aid = info.getRefundPayBillId();
        String bid = H.IDSTR((Object)info);
        Map row = H.getOneRow((Context)ctx, (String)("select FDESTOBJECTID from  T_BOT_Relation where FDESTENTITYID = '" + H.BOSTYPE(TransDetailInfo.class) + "'  and FSrcObjectID = '" + aid + "' "));
        if (row == null || (tid = (String)row.get("fdestobjectid")) == null) {
            return;
        }
        String sql2 = "UPDATE T_BE_TransDetail SET FhasRefundPay = 0  WHERE FID = ? ";
        DbUtil.execute((Context)ctx, (String)sql2, (Object[])new Object[]{tid});
        this.deleteBotpRelation(ctx, tid, bid);
        this.deleteBotpRelation(ctx, aid, tid);
        this.deleteBotpRelation(ctx, aid, bid);
    }

    private void deleteBotpRelation(Context ctx, String srcObjectId, String destObjectId) throws BOSException {
        String sql2 = "delete T_BOT_Relation WHERE FSrcObjectID  = ? and FDestObjectID = ? ";
        DbUtil.execute((Context)ctx, (String)sql2, (Object[])new Object[]{srcObjectId, destObjectId});
    }

    private void deleteBillImageByBillID(Context ctx, String billId) throws BOSException {
        ObjectUuidPK uuidPK = new ObjectUuidPK(billId);
        String bosType = uuidPK.getObjectType().toString();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("bosType", (Object)bosType));
        filter.getFilterItems().add(new FilterItemInfo("billID", (Object)billId));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("imageNumber"));
        view.setSelector(sic);
        BillImageMapInfo billImageMapInfo = null;
        IBillImageMap billImageMap = BillImageMapFactory.getLocalInstance((Context)ctx);
        BillImageMapCollection billImageMapCollection = billImageMap.getBillImageMapCollection(view);
        if (billImageMapCollection == null || billImageMapCollection.size() == 0) {
            logger.error((Object)"_deleteBillImageByBillID cannot getBillImageMapCollection by billId ");
            return;
        }
        billImageMapInfo = billImageMapCollection.get(0);
        try {
            BillImageFacadeFactory.getLocalInstance((Context)ctx).deleteBillImage(billImageMapInfo.getImageNumber(), "1", ctx.getUserName(), ctx.getUserName());
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
    }
}

