/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.btp.BTPException;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.BOTPUtil;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.BankAreaTypeEnum;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.arap.ARAPCommonServerFacadeFactory;
import com.kingdee.eas.fi.cas.ArApRecPayException;
import com.kingdee.eas.fi.cas.BillStatusEnum;
import com.kingdee.eas.fi.cas.CasForArApUtil;
import com.kingdee.eas.fi.cas.CashPamentBillUtil;
import com.kingdee.eas.fi.cas.DisposerActionEnum;
import com.kingdee.eas.fi.cas.PaymentBillBookNotifyBuilder;
import com.kingdee.eas.fi.cas.PaymentBillCollection;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.cas.RecPayBgCtrlStrEnum;
import com.kingdee.eas.fi.cas.RecPayBillInfo;
import com.kingdee.eas.fi.cas.RecPayException;
import com.kingdee.eas.fi.cas.RecPayHelper;
import com.kingdee.eas.fi.cas.RecPayOverDraftCtrlEnum;
import com.kingdee.eas.fi.cas.ReceivingBillCollection;
import com.kingdee.eas.fi.cas.ReceivingBillFactory;
import com.kingdee.eas.fi.cas.ReceivingBillInfo;
import com.kingdee.eas.fi.cas.SourceTypeEnum;
import com.kingdee.eas.fi.cas.app.service.IPayPayService;
import com.kingdee.eas.fi.cas.app.service.handler.ServiceHandler;
import com.kingdee.eas.fi.cas.utils.ThreadLocalUtil;
import com.kingdee.eas.fi.cas.validate.IValidator;
import com.kingdee.eas.fi.cas.validate.ValidateResult;
import com.kingdee.eas.fi.cas.validate.ValidatorFactory;
import com.kingdee.eas.fm.cbs.CBPaymentInfo;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.fin.FinancingBillTypeEnum;
import com.kingdee.eas.fm.fin.RepaymentCollection;
import com.kingdee.eas.fm.fin.RepaymentFactory;
import com.kingdee.eas.fm.fin.RepaymentInfo;
import com.kingdee.eas.fm.fs.TransUpBillInfo;
import com.kingdee.eas.fm.nt.BillMakeTypeEnum;
import com.kingdee.eas.fm.nt.BillSourceEnum;
import com.kingdee.eas.fm.nt.ChequeAppRecInfo;
import com.kingdee.eas.fm.nt.ChequeCollection;
import com.kingdee.eas.fm.nt.ChequeFactory;
import com.kingdee.eas.fm.nt.ChequeInfo;
import com.kingdee.eas.fm.nt.ChequeStatusEnum;
import com.kingdee.eas.fm.nt.ElecBillStatusEnum;
import com.kingdee.eas.fm.nt.NTTypeGroupEnum;
import com.kingdee.eas.fm.nt.PayableBillCollection;
import com.kingdee.eas.fm.nt.PayableBillFactory;
import com.kingdee.eas.fm.nt.PayableBillInfo;
import com.kingdee.eas.fm.pp.PaySchDetailBillFactory;
import com.kingdee.eas.fm.pp.PaySchDetailBillInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.app.DbUtil;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class PayPayService
implements IPayPayService {
    private static Logger logger = Logger.getLogger((String)PayPayService.class.getName());
    protected Context ctx;
    Set s;
    boolean ifBookPayable = false;
    boolean isInvokeWF = false;
    boolean validateThrowExp = true;
    protected ServiceHandler serviceHandler;
    RecPayHelper helper = new RecPayHelper();
    ObjectUuidPK orgPK;
    protected PaymentBillCollection coll = null;

    public PayPayService() {
    }

    public PayPayService(PaymentBillCollection coll) {
        this.coll = coll;
    }

    protected ServiceHandler getServiceHandler() {
        return new ServiceHandler();
    }

    public void beforeService(Set validSet) throws EASBizException, BOSException {
        String ids = FMHelper.setTran2String((Set)validSet);
        String sql = "UPDATE T_CAS_PAYMENTBILL SET FID = FID WHERE FID IN " + ids;
        DbUtil.execute((Context)this.ctx, (String)sql);
    }

    @Override
    public void initService(Context ctx, Set set, boolean ifBookPayable, boolean isInvokeWF, boolean validateThrowExp) throws EASBizException, BOSException {
        this.ctx = ctx;
        this.s = set;
        this.ifBookPayable = ifBookPayable;
        this.isInvokeWF = isInvokeWF;
        this.serviceHandler = this.getServiceHandler();
        this.validateThrowExp = validateThrowExp;
        this.beforeService(this.s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map doService() throws EASBizException, BOSException {
        IValidator payValidate = ValidatorFactory.getValidator(this.ctx, "com.kingdee.eas.fi.cas.validate.PaymentBillPayValidator");
        ValidateResult vr = null;
        vr = this.coll != null ? payValidate.validate(this.ctx, (IObjectCollection)this.coll, this.validateThrowExp) : payValidate.validate(this.ctx, this.s, this.validateThrowExp);
        Set validSet = vr.getValidIdSet();
        if (validSet == null || validSet.size() == 0) {
            return vr.getErrorMsg();
        }
        PaymentBillCollection coll = (PaymentBillCollection)vr.getValidObjColl();
        PaymentBillInfo info1 = null;
        this.orgPK = coll != null && coll.size() > 0 ? new ObjectUuidPK(coll.get(0).getCompany().getId()) : new ObjectUuidPK(ContextHelperFactory.getLocalInstance((Context)this.ctx).getCurrentCompany().getId());
        IObjectPK pkOut = LogUtil.beginLog((Context)this.ctx, null, (BOSObjectType)new PaymentBillInfo().getBOSType(), null, (String)this.getNumbers(coll), (String)"cas_paymentBill_pay", (String)this.orgPK.toString(), null);
        Set<String> idCommitSet = new HashSet();
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            String id;
            info1 = coll.get(i);
            this.checkIsAdjustPeriod(this.ctx, info1);
            HashMap paramMap = new HashMap();
            paramMap.put("TM105", info1.getCompany().getId());
            paramMap.put("PAYBILL_PurPayAmtOverAmt", info1.getCompany().getId());
            IParamControl pc = ParamControlFactory.getLocalInstance((Context)this.ctx);
            paramMap = pc.getParamHashMap(paramMap);
            int tm105 = Integer.parseInt((String)paramMap.get("TM105"));
            if (tm105 != 0) continue;
            if (SourceTypeEnum.AP.equals((Object)info1.getSourceType())) {
                this.serviceHandler.checkIsInQueue(this.ctx, info1);
            }
            if ((id = info1.getSourceBillId()) != null && id.length() > 0) {
                boolean isCreateFromTransUpbill;
                BOSObjectType transUpbillBOSType = new TransUpBillInfo().getBOSType();
                boolean bl = isCreateFromTransUpbill = info1.getSourceBillId() != null && BOSUuid.read((String)info1.getSourceBillId()).getType().equals((Object)transUpbillBOSType);
                if (isCreateFromTransUpbill) continue;
            }
            if (info1.getPayBillType() == null || !info1.getPayBillType().isIsFinanceTranUp()) continue;
            idCommitSet.add(info1.getId().toString());
        }
        if (idCommitSet.size() > 0) {
            PaymentBillCollection coll2 = RecPayHelper.getPayColl(this.ctx, idCommitSet);
            this.helper.checkAcctViewIsValid(this.ctx, (IObjectCollection)coll2);
            idCommitSet = this.helper.getPayValidIdSetByCommit(this.ctx, coll2, true);
            if (idCommitSet.size() > 0) {
                PaymentBillCollection coll1 = RecPayHelper.getPayColl(this.ctx, idCommitSet);
                this.helper.botpTransformSettleNew(this.ctx, (IObjectCollection)coll1);
            }
        }
        String ids = FMHelper.setTran2String((Set)validSet);
        UserInfo userInfo = ContextHelperFactory.getLocalInstance((Context)this.ctx).getCurrentUser();
        String sql = "UPDATE T_CAS_PaymentBill SET FCashierID = ?, FPayDate = ?, FBillStatus = ?, FConceit = null, FIsBackToBE = 0 WHERE FID IN " + ids;
        Timestamp currTime = new Timestamp(System.currentTimeMillis());
        Integer status = new Integer(15);
        DbUtil.execute((Context)this.ctx, (String)sql, (Object[])new Object[]{userInfo.getId().toString(), currTime, status});
        if (this.ifBookPayable) {
            for (String billId : validSet) {
                if (!this.isNeedBookNow(coll, billId)) continue;
                HashSet<String> idSet = new HashSet<String>();
                idSet.add(billId);
                this.helper.bookPaymentBill(this.ctx, PaymentBillBookNotifyBuilder.class.getName(), idSet);
            }
        }
        String billId = null;
        PaymentBillInfo info = new PaymentBillInfo();
        String companyId = null;
        String payeeId = null;
        HashSet<String> apSet = new HashSet<String>();
        HashMap<String, BigDecimal> apBalanceMap = new HashMap<String, BigDecimal>();
        BigDecimal apBal = BigDecimal.ZERO;
        if (coll != null && coll.size() > 0) {
            int size2 = coll.size();
            for (int i = 0; i < size2; ++i) {
                ReceivingBillCollection collrec;
                Set idSet;
                info = coll.get(i);
                billId = info.getId().toString();
                HashMap paramMap = new HashMap();
                paramMap.put("CS011", new ObjectUuidPK(info.getCompany().getId()));
                paramMap.put("CS043", new ObjectUuidPK(info.getCompany().getId()));
                paramMap.put("CS053", new ObjectUuidPK(info.getCompany().getId()));
                paramMap.put("CS047", new ObjectUuidPK(info.getCompany().getId()));
                paramMap.put("CS070_01", new ObjectUuidPK(info.getCompany().getId()));
                paramMap.put("TM105", new ObjectUuidPK(info.getCompany().getId()));
                paramMap.put("PAYBILL_PurPayAmtOverAmt", new ObjectUuidPK(info.getCompany().getId()));
                IParamControl pc = ParamControlFactory.getLocalInstance((Context)this.ctx);
                paramMap = pc.getParamHashMap(paramMap);
                if (info.getSourceType() == SourceTypeEnum.AP) {
                    boolean isPAYBILL_PurPayAmtOverAmt = false;
                    if (paramMap.get("PAYBILL_PurPayAmtOverAmt") != null && ("true".equalsIgnoreCase(paramMap.get("PAYBILL_PurPayAmtOverAmt").toString()) || "1".equalsIgnoreCase(paramMap.get("PAYBILL_PurPayAmtOverAmt").toString()))) {
                        isPAYBILL_PurPayAmtOverAmt = true;
                    }
                    if (!isPAYBILL_PurPayAmtOverAmt) {
                        companyId = info.getCompany().getId().toString();
                        payeeId = info.getPayeeID();
                        apBal = apBalanceMap.get(companyId + payeeId) != null ? (BigDecimal)apBalanceMap.get(companyId + payeeId) : CasForArApUtil.getApBalance(this.ctx, info);
                        if (info.getBillStatus().equals((Object)BillStatusEnum.AUDITED)) {
                            if (apBal.compareTo(BigDecimal.ZERO) < 0) {
                                throw new ArApRecPayException(ArApRecPayException.APBALANCE_OVER);
                            }
                        } else if (info.getLocalAmt() != null && info.getLocalAmt().compareTo(apBal) > 0) {
                            throw new ArApRecPayException(ArApRecPayException.PURPAYAMTOVERAMT, new Object[]{apBal.toString(), info.getLocalAmt().subtract(apBal).toString()});
                        }
                        apBal = apBal.subtract(info.getLocalAmt());
                        apBalanceMap.put(companyId + payeeId, apBal);
                    }
                }
                int bgCtrlParam = Integer.parseInt((String)paramMap.get("CS043"));
                int overCtrlParam = Integer.parseInt((String)paramMap.get("CS053"));
                boolean isAutoVerifyPayableBill = false;
                if ("true".equals((String)paramMap.get("CS070_01"))) {
                    isAutoVerifyPayableBill = true;
                }
                if (SourceTypeEnum.FDC.equals((Object)info.getSourceType())) {
                    CashPamentBillUtil._pay4FDC(this.ctx, info);
                }
                if (!info.isIsRelateCheque() || !NTTypeGroupEnum.TELE_ORDER.equals((Object)info.getSettlementType().getNtType().getGroup())) {
                    this.serviceHandler.dispose(this.ctx, info, DisposerActionEnum.PAY);
                }
                if (!info.isIsRelateCheque() && info.getSettlementType() != null && info.getSettlementType().getNtType() != null && info.getSettlementType().getNtType().getGroup() != null && NTTypeGroupEnum.TELE_ORDER.equals((Object)info.getSettlementType().getNtType().getGroup()) && info.getCheque() != null) {
                    String updateSql = "UPDATE T_CAS_PaymentBill SET FIsRelateCheque = 1 WHERE FID = ?";
                    DbUtil.execute((Context)this.ctx, (String)updateSql, (Object[])new Object[]{info.getId().toString()});
                    this.reWriteTeleOrder(this.ctx, info);
                    if (info.getCheque() != null && info.getCheque().getId() != null) {
                        String updateChequeSql = "UPDATE T_NT_Cheque SET FPaymentBillNum = ? ,Fstate = ? WHERE Fid=? ";
                        DbUtil.execute((Context)this.ctx, (String)updateChequeSql, (Object[])new Object[]{info.getNumber(), 3, info.getCheque().getId().toString()});
                    }
                }
                this.serviceHandler.bgCtrlAndAudit(this.ctx, (IObjectPK)new ObjectUuidPK(billId), RecPayBgCtrlStrEnum.PayOrRec_Sub, bgCtrlParam);
                this.serviceHandler.overDraftCtrls(this.ctx, (IObjectPK)new ObjectUuidPK(billId), RecPayOverDraftCtrlEnum.recOrPay_ctrl, overCtrlParam);
                if (SourceTypeEnum.AP.equals((Object)info.getSourceType())) {
                    apSet.add(info.getId().toString());
                }
                if (this.isInvokeWF) {
                    PaymentBillFactory.getLocalInstance(this.ctx).pay4WF((IObjectPK)new ObjectUuidPK(billId));
                }
                boolean canBook = false;
                AccountViewInfo acct = info.getPayerAccount();
                if (acct != null && (acct.isIsBank() || acct.isIsCash())) {
                    canBook = true;
                }
                if (isAutoVerifyPayableBill && canBook) {
                    this.WriteOffPayableBill(this.ctx, info, info.getCompany().getId().toString());
                }
                HashSet<String> srcSet = new HashSet<String>();
                if (info.isIsRefundmentPay()) {
                    srcSet.add(info.getId().toString());
                }
                if (!EmptyUtil.isEmpty((Collection)(idSet = BOTPUtil.getSrcBillIdSet((Context)this.ctx, srcSet))) && idSet.size() > 0 && info.isIsRefundmentPay() && (collrec = RecPayHelper.getRecColl(this.ctx, idSet)) != null && !collrec.isEmpty()) {
                    try {
                        Map<String, Object> params = ThreadLocalUtil.getThreadObject();
                        params.put("CASrefundmentREC", true);
                        ThreadLocalUtil.addThreadObject(params);
                        ReceivingBillFactory.getLocalInstance(this.ctx).rec(idSet);
                    }
                    finally {
                        ThreadLocalUtil.cleanThreadObject();
                    }
                }
                if (!info.isIsSchCreated()) continue;
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add("id");
                selector.add("payPlan.id");
                selector.add("payPlan.cashVerifyAmt");
                selector.add("payPlan.paperVerifyAmt");
                for (int j = 0; j < info.getEntries().size(); ++j) {
                    String payPlanSql;
                    BigDecimal amt = info.getEntries().get(j).getActualAmt();
                    String paySchId = info.getEntries().get(j).getSrcPlanBillEntryID();
                    PaySchDetailBillInfo paySchInfo = PaySchDetailBillFactory.getLocalInstance((Context)this.ctx).getPaySchDetailBillInfo((IObjectPK)new ObjectUuidPK(paySchId), selector);
                    BigDecimal ntAmt = paySchInfo.getPayPlan().getPaperVerifyAmt();
                    BigDecimal cashAmt = paySchInfo.getPayPlan().getCashVerifyAmt();
                    String payPlanId = paySchInfo.getPayPlan().getId().toString();
                    if (!EmptyUtil.isEmpty((CoreBaseInfo)info.getSettlementType().getNtType()) && !EmptyUtil.isEmpty((Object)info.getSettlementType().getNtType().getSuperGroup()) && (info.getSettlementType().getNtType().getSuperGroup().equals((Object)NTTypeGroupEnum.PAYABLE) || info.getSettlementType().getNtType().getSuperGroup().equals((Object)NTTypeGroupEnum.RECEIVABLE))) {
                        payPlanSql = " update T_PP_PayPlanBill set FPaperVerifyAmt=?,FVerifyAmount=? where fid=? ";
                        DbUtil.execute((Context)this.ctx, (String)payPlanSql, (Object[])new Object[]{ntAmt.add(amt), ntAmt.add(amt).add(cashAmt), payPlanId});
                        continue;
                    }
                    payPlanSql = " update T_PP_PayPlanBill set FCashVerifyAmt=?,FVerifyAmount=? where fid=? ";
                    DbUtil.execute((Context)this.ctx, (String)payPlanSql, (Object[])new Object[]{cashAmt.add(amt), cashAmt.add(amt).add(ntAmt), payPlanId});
                }
            }
        }
        if (coll != null) {
            this.genReceivingbill(this.ctx, coll);
        }
        if (apSet.size() > 0) {
            if (info.isIsDiffCurSettlement()) {
                ARAPCommonServerFacadeFactory.getLocalInstance((Context)this.ctx).autoVerifyNoCondition((RecPayBillInfo)info, false);
            } else {
                ARAPCommonServerFacadeFactory.getLocalInstance((Context)this.ctx).autoVerify(this.orgPK.toString(), apSet, false);
            }
        }
        LogUtil.afterLog((Context)this.ctx, (IObjectPK)pkOut);
        return vr.getErrorMsg();
    }

    protected void checkIsAdjustPeriod(Context ctx, PaymentBillInfo info) throws EASBizException, BOSException {
        String msg = new FMException(FMException.CURRPERIODISADJUST).getMessage();
        PeriodInfo periodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)info.getCompany());
        if (periodInfo != null && periodInfo.isIsAdjustPeriod()) {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{info.getCompany().getName() + ": " + msg});
        }
    }

    public void WriteOffPayableBill(Context ctx, PaymentBillInfo info, String companyID) throws BOSException, EASBizException {
        PayableBillInfo payableBillInfo = null;
        ArrayList<String> srcList = new ArrayList<String>();
        ArrayList<String> payablebillList = new ArrayList<String>();
        if (info.getSettlementType() != null && info.getSettlementType().getNtType() != null && info.getSettlementType().getNtType().getGroup() != null && NTTypeGroupEnum.PAYABLE.equals((Object)info.getSettlementType().getNtType().getSuperGroup()) && info.getSettlementNumber() != null) {
            String settleNumber = info.getSettlementNumber().replaceAll("\\s|\u3000", "");
            String mateNumber = settleNumber.replaceAll("(.{1})", "$1%");
            mateNumber = mateNumber.substring(0, mateNumber.length() - 1);
            EntityViewInfo query = new EntityViewInfo();
            SelectorItemCollection sic = this.getBOTPSelector();
            query.setSelector(sic);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("draftNumber", (Object)("%" + mateNumber), CompareType.LIKE));
            filter.getFilterItems().add(new FilterItemInfo("expiredDate", (Object)new Date(), CompareType.LESS_EQUALS));
            HashSet<Integer> setState = new HashSet<Integer>();
            setState.add(new Integer(5));
            setState.add(new Integer(2));
            setState.add(new Integer(3));
            filter.getFilterItems().add(new FilterItemInfo("billState", setState, CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("company", (Object)companyID));
            query.setFilter(filter);
            PayableBillCollection coll = PayableBillFactory.getLocalInstance((Context)ctx).getPayableBillCollection(query);
            for (int i = 0; i < coll.size(); ++i) {
                payableBillInfo = coll.get(i);
                if (payableBillInfo.getDraftSource() == BillSourceEnum.BYECDS && (payableBillInfo.getElecBillStatus() == null || payableBillInfo.getElecBillStatus() == ElecBillStatusEnum.NT000002 || payableBillInfo.getMakeType() == BillMakeTypeEnum.ENTRUST || payableBillInfo.getMakeType() == BillMakeTypeEnum.SUB && payableBillInfo.getConfirmer() == null && !payableBillInfo.isIsFromEntrust()) || !payableBillInfo.getDraftNumber().replaceAll("\\s|\u3000", "").equals(settleNumber)) continue;
                payablebillList.clear();
                payablebillList.add(payableBillInfo.getId().toString());
                srcList.add(info.getId().toString());
                RepaymentInfo repayInfo = new RepaymentInfo();
                repayInfo.setAmount(payableBillInfo.getBalance());
                repayInfo.setUseAssureBill(payableBillInfo.isUseAssureBill());
                repayInfo.setAssExRate(payableBillInfo.getAssExRate());
                repayInfo.setSourceCurrency(payableBillInfo.getCurrency());
                repayInfo.setSourceCurExRate(Constants.ONE);
                repayInfo.setIsIncredit(payableBillInfo.isIsInCredit());
                repayInfo.setCreditLimit(payableBillInfo.getCreditLimit());
                repayInfo.setCreditPercetage(Constants.ONE_HUNDRED);
                repayInfo.setCreditCurExRate(payableBillInfo.getCreditCurExRate());
                repayInfo.setReturnedQuota(payableBillInfo.getUsedQuota());
                repayInfo.setBizDate(new Date());
                repayInfo.setCompany(payableBillInfo.getCompany());
                repayInfo.setCreateTime(DateUtil.getTimeStampDayBegin());
                repayInfo.setCreator(ContextHelperFactory.getRemoteInstance().getCurrentUser());
                repayInfo.setSourceAmount(payableBillInfo.getAmount());
                repayInfo.setInterest(FMHelper.multiply((BigDecimal)repayInfo.getAmount(), (BigDecimal)repayInfo.getIntRate()));
                repayInfo.setPayment(FMHelper.add((BigDecimal)repayInfo.getAmount(), (BigDecimal)repayInfo.getInterest()));
                repayInfo.setLocalAmount(FMHelper.multiply((BigDecimal)repayInfo.getAmount(), (BigDecimal)repayInfo.getLocalCurExRate()));
                repayInfo.setSourceType(FinancingBillTypeEnum.CommercialDraft);
                repayInfo.setRegion(BankAreaTypeEnum.In);
                repayInfo.setBat4Payable(true);
                repayInfo.setRepaySeq(1);
                repayInfo.setSourceBillId(payableBillInfo.getId().toString());
                repayInfo.setLocalCurExRate(payableBillInfo.getLocalCurExRate());
                repayInfo.setCurrency(payableBillInfo.getCurrency());
                repayInfo.setBankAcct(payableBillInfo.getOutBankAccount());
                repayInfo.setSourceBillNum(payableBillInfo.getNumber());
                repayInfo.setApplyUnit(payableBillInfo.getApplyUnit());
                RepaymentCollection repayBillColl = new RepaymentCollection();
                repayBillColl.add(repayInfo);
                PayableBillCollection payableColl = new PayableBillCollection();
                payableColl.add(payableBillInfo);
                PayableBillFactory.getLocalInstance((Context)ctx).batchRepayment(repayBillColl, payableColl, false);
                repayInfo = RepaymentFactory.getLocalInstance((Context)ctx).getRepaymentInfo("where sourcebillid = '" + payableBillInfo.getId().toString() + "'");
                FMHelper.saveBOTRelation((Context)ctx, srcList, (String)repayInfo.getId().toString());
                BOTPUtil.saveBOTRelation((Context)ctx, payablebillList, (String)repayInfo.getId().toString());
            }
        }
    }

    private SelectorItemCollection getBOTPSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("CreditLimit.*"));
        sic.add(new SelectorItemInfo("assureBill.*"));
        sic.add(new SelectorItemInfo("guaranteeEntrys.*"));
        sic.add(new SelectorItemInfo("Institution.*"));
        return sic;
    }

    private void reWriteTeleOrder(Context ctx, PaymentBillInfo info) throws EASBizException, BOSException {
        ChequeInfo chequeInfo = ChequeFactory.getLocalInstance((Context)ctx).getChequeInfo((IObjectPK)new ObjectUuidPK(info.getCheque().getId()));
        if (ChequeStatusEnum.NEW.equals((Object)chequeInfo.getState())) {
            ChequeAppRecInfo recInfo = new ChequeAppRecInfo();
            recInfo.setApplyCompany(info.getCompany());
            recInfo.setCeiling(info.getActPayAmt());
            chequeInfo.setApplyRec(recInfo);
            chequeInfo.setOppAccount(info.getOppAccount());
            chequeInfo.setBankAcct(info.getPayerAccountBank());
            chequeInfo.setPayeeName(info.getPayeeName());
            chequeInfo.setPayeeAcctBank(info.getPayeeBank());
            chequeInfo.setPayeeAcctNumber(info.getPayeeAccountBank());
            chequeInfo.setPaymentBillNum(info.getNumber());
            chequeInfo.setIssueDate(new Date());
            chequeInfo.setAmount(info.getActPayAmt());
            chequeInfo.setCurrency(info.getCurrency());
            ChequeCollection coll = new ChequeCollection();
            coll.add(chequeInfo);
            ChequeFactory.getLocalInstance((Context)ctx).apply(coll);
        }
    }

    private void genReceivingbill(Context ctx, PaymentBillCollection collForRec) throws BOSException, BTPException, EASBizException {
        PaymentBillCollection collForRecRemove = new PaymentBillCollection();
        for (int i = 0; i < collForRec.size(); ++i) {
            boolean payeeAcctIsOtherUnit;
            BOSUuid sbid;
            PaymentBillInfo srcBill = collForRec.get(i);
            boolean isFromReceivingbill = false;
            if (!EmptyUtil.isEmpty((String)srcBill.getSourceBillId()) && ((sbid = BOSUuid.read((String)srcBill.getSourceBillId())).getType().equals((Object)new ReceivingBillInfo().getBOSType()) || sbid.getType().equals((Object)new TransUpBillInfo().getBOSType()))) {
                isFromReceivingbill = true;
            }
            boolean isPayerBankSettle = srcBill.getPayerBank() != null && srcBill.getPayerBank().isInGroup();
            boolean bl = payeeAcctIsOtherUnit = srcBill.getPayeeAccountBankO() != null && srcBill.getPayerAccountBank() != null && !srcBill.getPayeeAccountBankO().getCompany().getId().equals((Object)srcBill.getPayerAccountBank().getCompany().getId());
            if (srcBill.getPayeeAccountBankO() != null && srcBill.getPayerAccountBank() == null && !srcBill.getPayeeAccountBankO().getCompany().getId().equals((Object)srcBill.getCompany().getId())) {
                payeeAcctIsOtherUnit = true;
            }
            boolean isReceivingRecbill = false;
            if (srcBill.getPayeeAccountBankO() != null) {
                isReceivingRecbill = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("CS047", (IObjectPK)new ObjectUuidPK(srcBill.getPayeeAccountBankO().getCompany().getId()));
            }
            boolean isBankSettleNull = srcBill.getPayerBank() == null;
            boolean isNotBankSettleOrNull = true;
            if (isBankSettleNull || !isPayerBankSettle) {
                isNotBankSettleOrNull = false;
            }
            boolean isFinanceTransUp = false;
            if (srcBill.getPayBillType() != null && srcBill.getPayBillType().isIsFinanceTranUp()) {
                isFinanceTransUp = true;
            }
            if (!isFinanceTransUp && !isFromReceivingbill && !isNotBankSettleOrNull && payeeAcctIsOtherUnit && isReceivingRecbill) continue;
            collForRecRemove.add(srcBill);
        }
        for (int j = 0; j < collForRecRemove.size(); ++j) {
            collForRec.remove(collForRecRemove.get(j));
        }
        if (collForRec.size() > 0) {
            this.helper.botpTransformReceivingbill(ctx, (IObjectCollection)collForRec);
        }
    }

    private String getNumbers(PaymentBillCollection coll) {
        String retStr = "";
        for (int i = 0; i < coll.size(); ++i) {
            retStr = retStr + coll.get(i).getNumber();
            if (i == coll.size() - 1) continue;
            retStr = retStr + ",";
        }
        return retStr;
    }

    private boolean isNeedBookNow(PaymentBillCollection coll, String billId) throws EASBizException, BOSException {
        boolean isNeedBookNow = true;
        PaymentBillInfo info = coll.get(BOSUuid.read((String)billId));
        if (info.isIsCBPay() && info.getCbPayInfo() != null) {
            String paymentCurrency;
            CBPaymentInfo cbPayInfo = info.getCbPayInfo();
            if (EmptyUtil.isEmpty((String)cbPayInfo.getPayeeCurrency().getIsoCode()) || EmptyUtil.isEmpty((String)cbPayInfo.getPaymentCurrency().getIsoCode())) {
                throw new RecPayException(RecPayException.ISO_NOT_NULL);
            }
            String payeeCurrency = cbPayInfo.getPayeeCurrency().getIsoCode();
            if (!payeeCurrency.equals(paymentCurrency = cbPayInfo.getPaymentCurrency().getIsoCode())) {
                isNeedBookNow = false;
            }
        }
        return isNeedBookNow;
    }
}

