/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.wssc.BillImageFacadeFactory;
import com.kingdee.eas.base.wssc.IBillImageFacade;
import com.kingdee.eas.basedata.assistant.PaymentTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BillStatusEnum;
import com.kingdee.eas.fi.cas.DisposerActionEnum;
import com.kingdee.eas.fi.cas.PaymentBillDataProcess;
import com.kingdee.eas.fi.cas.PaymentBillEntryCollection;
import com.kingdee.eas.fi.cas.PaymentBillEntryInfo;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.cas.RecPayException;
import com.kingdee.eas.fi.cas.RecPayHelper;
import com.kingdee.eas.fi.cas.SourceTypeEnum;
import com.kingdee.eas.fi.cas.app.AgentRecPayServerHelper;
import com.kingdee.eas.fi.cas.app.ArApRecPayServerHelper;
import com.kingdee.eas.fi.cas.app.service.IPaySaveService;
import com.kingdee.eas.fi.cas.app.service.handler.ServiceHandler;
import com.kingdee.eas.fm.common.FMVerifyHelper;
import com.kingdee.eas.fm.common.util.BizRelateReceivableBillUtil;
import com.kingdee.eas.fm.ft.FundTransferBillFactory;
import com.kingdee.eas.fm.ft.FundTransferBillInfo;
import com.kingdee.eas.fm.ivt.FinancingAccountApplyFactory;
import com.kingdee.eas.fm.ivt.FinancingAccountApplyInfo;
import com.kingdee.eas.fm.ivt.FinancingAccountFactory;
import com.kingdee.eas.fm.ivt.FinancingAccountInfo;
import com.kingdee.eas.fm.nt.NTTypeGroupEnum;
import com.kingdee.eas.fm.nt.ReceivableBillFactory;
import com.kingdee.eas.fm.td.TimeDepositApplyFactory;
import com.kingdee.eas.fm.td.TimeDepositApplyInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import org.apache.log4j.Logger;

public class PaySaveService
implements IPaySaveService {
    private static Logger logger = Logger.getLogger((String)PaySaveService.class.getName());
    protected Context ctx;
    protected PaymentBillInfo info;
    protected PaymentBillEntryCollection coll;
    protected HashMap param = new HashMap();
    protected boolean isAddNew = true;
    protected IObjectPK pk;
    protected ServiceHandler serviceHandler;
    String sourceBillId = "";

    protected ServiceHandler getServiceHandler() {
        return new ServiceHandler();
    }

    @Override
    public void initService(Context ctx, PaymentBillInfo info) throws EASBizException, BOSException {
        this.ctx = ctx;
        this.info = info;
        this.serviceHandler = this.getServiceHandler();
        if (null != info.getId() && PaymentBillFactory.getLocalInstance(ctx).exists((IObjectPK)new ObjectUuidPK(info.getId()))) {
            this.isAddNew = false;
        }
    }

    public void initDeleteEntry(Context ctx, PaymentBillEntryCollection coll) throws EASBizException, BOSException {
        this.ctx = ctx;
        this.coll = coll;
    }

    @Override
    public void beforeSave() throws EASBizException, BOSException {
        this.setPropertyForBeforeSave();
        boolean cs064 = this.getParamCS064();
        PaymentBillDataProcess.setCasAmount(this.ctx, this.info);
        this.serviceHandler.setCommonPropertyValue(this.ctx, this.info);
        AgentRecPayServerHelper.saveOrSubmitPaymentBillForAgentPay(this.ctx, this.info);
        this.serviceHandler.checkPayInfoValue(this.ctx, this.info, cs064);
        FMVerifyHelper.checkBlank((Context)this.ctx, (IObjectValue)this.info, (String)"sourceType");
        if (SourceTypeEnum.CASH.equals((Object)this.info.getSourceType()) && (this.info.getActPayAmt() == null || this.info.getActPayAmt().compareTo(BigDecimal.ZERO) == 0)) {
            throw new RecPayException(RecPayException.COMMON, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fi.cas.web.CasWebResource", (String)"285_PAYMENTBILL_ACTPAYAMT_ZERO", (Locale)this.ctx.getLocale())});
        }
        RecPayHelper.setBgCtrlAmt(this.info);
        if (this.info.getSourceSysType() == null && this.info.getSourceType() != null && this.info.getSourceBillId() != null) {
            this.info.setSourceSysType(this.info.getSourceType());
        }
        if (!this.info.isIsSchCreated() && EmptyUtil.isEmpty((Object)this.ctx.get((Object)"fromSchedule")) && this.info.getSettlementType() != null && this.info.getSettlementType().getNtType() != null && NTTypeGroupEnum.RECEIVABLE.equals((Object)this.info.getSettlementType().getNtType().getSuperGroup())) {
            ReceivableBillFactory.getLocalInstance((Context)this.ctx).lockReceivanleBill((CoreBaseInfo)this.info, "edit");
        }
    }

    @Override
    public void afterSave(IObjectPK pk) throws EASBizException, BOSException {
        BizRelateReceivableBillUtil.relateReceivableBill((Context)this.ctx, (CoreBaseInfo)this.info, (IObjectPK)pk);
        ArApRecPayServerHelper.injectBizFlow(this.ctx, (IObjectValue)this.info, BatchActionEnum.SAVE);
        this.serviceHandler.dispose(this.ctx, this.info, this.coll, DisposerActionEnum.SAVE);
        this.updateResourceBill();
        this.info.setId(BOSUuid.read((String)pk.toString()));
        if (SourceTypeEnum.AP.equals((Object)this.info.getSourceType())) {
            try {
                IBillImageFacade image = BillImageFacadeFactory.getLocalInstance((Context)this.ctx);
                String imageNumber = image.getImageNumber(this.info.getBOSType().toString(), pk.toString());
                if (StringUtils.isEmpty((String)imageNumber)) {
                    String string = image.genImageNumber(this.info.getBOSType().toString(), pk.toString());
                }
            }
            catch (BOSException e) {
                logger.error((Object)"\u8c03\u7528\u57fa\u7840\u7684\u6761\u7801\u63a5\u53e3\u62a5\u9519");
                logger.error((Object)e);
            }
        }
    }

    protected void updateResourceBill() throws BOSException, EASBizException {
        String sourcBillId = this.info.getSourceBillId();
        if (sourcBillId != null && sourcBillId.length() > 0) {
            ObjectUuidPK objectPk = new ObjectUuidPK(sourcBillId);
            BOSUuid bosId = BOSUuid.read((String)sourcBillId);
            if (bosId.getType().equals((Object)new FundTransferBillInfo().getBOSType())) {
                FundTransferBillFactory.getLocalInstance((Context)this.ctx).updatePaymentBillID((IObjectPK)objectPk, (IObjectPK)new ObjectUuidPK(this.info.getId()));
            } else if (new TimeDepositApplyInfo().getBOSType().equals((Object)bosId.getType())) {
                TimeDepositApplyInfo timeDepositApplyInfo = TimeDepositApplyFactory.getLocalInstance((Context)this.ctx).getTimeDepositApplyInfo((IObjectPK)new ObjectUuidPK(this.sourceBillId));
                timeDepositApplyInfo.setIsCreatePayment(true);
                TimeDepositApplyFactory.getLocalInstance((Context)this.ctx).update((IObjectPK)new ObjectStringPK(this.sourceBillId), (CoreBaseInfo)timeDepositApplyInfo);
            } else if (new FinancingAccountApplyInfo().getBOSType().equals((Object)bosId.getType())) {
                FinancingAccountApplyInfo finAccAppInfo = FinancingAccountApplyFactory.getLocalInstance((Context)this.ctx).getFinancingAccountApplyInfo((IObjectPK)new ObjectUuidPK(this.sourceBillId));
                finAccAppInfo.setIsGenePayBill(true);
                FinancingAccountApplyFactory.getLocalInstance((Context)this.ctx).update((IObjectPK)new ObjectStringPK(this.sourceBillId), (CoreBaseInfo)finAccAppInfo);
            } else if (new FinancingAccountInfo().getBOSType().equals((Object)bosId.getType())) {
                FinancingAccountInfo finAccountInfo = FinancingAccountFactory.getLocalInstance((Context)this.ctx).getFinancingAccountInfo((IObjectPK)new ObjectUuidPK(this.sourceBillId));
                finAccountInfo.setIsGenePayBill(true);
                FinancingAccountFactory.getLocalInstance((Context)this.ctx).update((IObjectPK)new ObjectUuidPK(this.sourceBillId), (CoreBaseInfo)finAccountInfo);
            }
        }
        this.serviceHandler.reverseConsignment(this.ctx, this.info, "1");
    }

    protected boolean getParamCS064() throws BOSException, EASBizException {
        HashMap param = new HashMap();
        param.put("CS064", null);
        param = this.serviceHandler.getParam(this.ctx, (IObjectPK)new ObjectUuidPK(this.info.getCompany().getId().toString()), param);
        boolean cs064 = false;
        if (param.get("CS064") != null) {
            cs064 = ((String)param.get("CS064")).equals("true");
        }
        return cs064;
    }

    protected void setPropertyForBeforeSave() throws EASBizException, BOSException {
        String number;
        if (this.info.getCompany() == null) {
            this.info.setCompany(ContextHelperFactory.getLocalInstance((Context)this.ctx).getCurrentCompany());
        }
        if (this.info.getPaymentType() == null) {
            String paymentTypeId = "2fa35444-5a23-43fb-99ee-6d4fa5f260da6BCA0AB5";
            PaymentTypeInfo paymentTypeInfo = new PaymentTypeInfo();
            paymentTypeInfo.setId(BOSUuid.read((String)paymentTypeId));
            this.info.setPaymentType(paymentTypeInfo);
        }
        if (this.info.getBillStatus() == null) {
            this.info.setBillStatus(BillStatusEnum.SAVE);
        }
        this.sourceBillId = this.info.getSourceBillId();
        if (this.sourceBillId != null && this.sourceBillId.length() > 0 && BOSUuid.read((String)this.sourceBillId).getType().equals((Object)new FundTransferBillInfo().getBOSType())) {
            this.info.setSourceType(SourceTypeEnum.FT);
        }
        this.info.setBizDate(DateTimeUtils.truncateDate((Date)this.info.getBizDate()));
        if (this.isAddNew && this.info.getId() != null && PaymentBillFactory.getLocalInstance(this.ctx).exists((IObjectPK)new ObjectUuidPK(this.info.getId()))) {
            this.isAddNew = false;
        }
        if (!SourceTypeEnum.AP.equals((Object)this.info.getSourceType()) && (number = this.info.getNumber()) != null && number.length() > 0) {
            this.serviceHandler.checkNumberDup(this.ctx, (IObjectValue)this.info);
        }
        if (this.info.getFundDispatchType() != null && this.info.getFundDispatchType().getValue() != 0) {
            if (EmptyUtil.isEmpty((AbstractObjectCollection)this.info.getEntries()) && this.info.getEntries().size() == 0) {
                PaymentBillEntryInfo newEntryInfo = new PaymentBillEntryInfo();
                newEntryInfo.setActualAmt(this.info.getActPayAmt());
                newEntryInfo.setActualLocAmt(this.info.getActPayLocAmt());
                this.info.getEntries().add(newEntryInfo);
            } else {
                this.info.getEntries().get(0).setActualAmt(this.info.getActPayAmt());
                this.info.getEntries().get(0).setActualLocAmt(this.info.getActPayLocAmt());
            }
        }
    }
}

