/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app.service;

import com.kingdee.bos.Context;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.cas.SourceTypeEnum;
import com.kingdee.eas.fi.cas.app.ArApRecPayServerHelper;
import com.kingdee.eas.fi.cas.app.service.IPaySaveService;
import com.kingdee.util.StringUtils;
import org.apache.log4j.Logger;

public class PaySaveServiceFactory {
    private static Logger logger = Logger.getLogger((String)PaySaveServiceFactory.class.getName());

    public static IPaySaveService getPaySaveService(Context ctx, PaymentBillInfo info) {
        String serviceClass;
        SourceTypeEnum sourceType = info.getSourceType();
        SourceTypeEnum sourceSysType = info.getSourceSysType();
        if (SourceTypeEnum.AP.equals((Object)sourceType)) {
            serviceClass = ArApRecPayServerHelper.getExtServiceClassName(ctx, PaySaveServiceFactory.class.getName(), sourceType);
            if (StringUtils.isEmpty((String)serviceClass)) {
                serviceClass = "com.kingdee.eas.fi.ap.app.service.ApPaySaveService";
            }
        } else {
            serviceClass = SourceTypeEnum.PS.equals((Object)sourceType) || SourceTypeEnum.PS.equals((Object)sourceSysType) ? "com.kingdee.eas.fm.ps.app.service.PsPaySaveService" : (SourceTypeEnum.FDC.equals((Object)sourceType) || SourceTypeEnum.FDC.equals((Object)sourceSysType) ? "com.kingdee.eas.fi.cas.app.service.FdcPaySaveService" : (SourceTypeEnum.NT.equals((Object)sourceType) || SourceTypeEnum.NT.equals((Object)sourceSysType) ? "com.kingdee.eas.fi.cas.app.service.NtPaySaveService" : "com.kingdee.eas.fi.cas.app.service.CasPaySaveService"));
        }
        try {
            return (IPaySaveService)Class.forName(serviceClass).newInstance();
        }
        catch (InstantiationException e) {
            logger.error((Object)e);
        }
        catch (IllegalAccessException e) {
            logger.error((Object)e);
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)e);
        }
        return null;
    }
}

