/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.wssc.BillImageFacadeFactory;
import com.kingdee.eas.base.wssc.IBillImageFacade;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PaymentTypeInfo;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.ExpenseTypeCollection;
import com.kingdee.eas.cp.bc.ExpenseTypeFactory;
import com.kingdee.eas.fi.cas.AbstractPaymentBillInfo;
import com.kingdee.eas.fi.cas.AbstractRecPayBillInfo;
import com.kingdee.eas.fi.cas.BgCtrlPaymentBillHandler;
import com.kingdee.eas.fi.cas.BgCtrlReceivingBillHandler;
import com.kingdee.eas.fi.cas.BillStatusEnum;
import com.kingdee.eas.fi.cas.CasException;
import com.kingdee.eas.fi.cas.CasForArApUtil;
import com.kingdee.eas.fi.cas.DisposerActionEnum;
import com.kingdee.eas.fi.cas.FundDispatchTypeEnum;
import com.kingdee.eas.fi.cas.PaymentBillCollection;
import com.kingdee.eas.fi.cas.PaymentBillDataProcess;
import com.kingdee.eas.fi.cas.PaymentBillEntryCollection;
import com.kingdee.eas.fi.cas.PaymentBillEntryInfo;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.cas.RecPayBgCtrlStrEnum;
import com.kingdee.eas.fi.cas.RecPayBillTypeEnum;
import com.kingdee.eas.fi.cas.RecPayException;
import com.kingdee.eas.fi.cas.RecPayHelper;
import com.kingdee.eas.fi.cas.RecPayOverDraftCtrlEnum;
import com.kingdee.eas.fi.cas.SourceTypeEnum;
import com.kingdee.eas.fi.cas.app.AgentRecPayServerHelper;
import com.kingdee.eas.fi.cas.app.service.IPaySubmitService;
import com.kingdee.eas.fi.cas.app.service.handler.ServiceHandler;
import com.kingdee.eas.fm.be.BEBankCollection;
import com.kingdee.eas.fm.be.BEBankFactory;
import com.kingdee.eas.fm.common.FMBGHelper;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FmMbgHelper;
import com.kingdee.eas.fm.common.IFMBgUsed;
import com.kingdee.eas.fm.common.util.BizRelateReceivableBillUtil;
import com.kingdee.eas.fm.common.util.MessageDigestTools;
import com.kingdee.eas.fm.fd.FDException;
import com.kingdee.eas.fm.fd.FundDispatchPlanBillCollection;
import com.kingdee.eas.fm.fd.FundDispatchPlanBillFactory;
import com.kingdee.eas.fm.fd.FundDispatchPlanBillInfo;
import com.kingdee.eas.fm.fd.FundDispatchPlanBillWebFacadeFactory;
import com.kingdee.eas.fm.fee.FeeBillInfo;
import com.kingdee.eas.fm.fin.CompUnTimeDepositBillFactory;
import com.kingdee.eas.fm.fin.CompUnTimeDepositBillInfo;
import com.kingdee.eas.fm.fs.InAcctDataTypeEnum;
import com.kingdee.eas.fm.fs.InAcctFactory;
import com.kingdee.eas.fm.fs.InnerAccountFactory;
import com.kingdee.eas.fm.fs.InnerAccountInfo;
import com.kingdee.eas.fm.fs.SettBizTypeEnum;
import com.kingdee.eas.fm.fs.SettBizTypeInfo;
import com.kingdee.eas.fm.fs.SettlementBillFactory;
import com.kingdee.eas.fm.fs.SettlementBillInfo;
import com.kingdee.eas.fm.fs.TransUpBillInfo;
import com.kingdee.eas.fm.ft.FundTransferBillFactory;
import com.kingdee.eas.fm.ft.FundTransferBillInfo;
import com.kingdee.eas.fm.ivt.LoanInterestBillInfo;
import com.kingdee.eas.fm.nt.NTTypeGroupEnum;
import com.kingdee.eas.fm.nt.ReceivableBillFactory;
import com.kingdee.eas.fm.td.TimeDepositApplyFactory;
import com.kingdee.eas.fm.td.TimeDepositApplyInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.nbudget.BgControlCaller;
import com.kingdee.eas.ma.nbudget.face.IBudgetBalance;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class PaySubmitService
implements IPaySubmitService {
    private static Logger logger = Logger.getLogger((String)PaySubmitService.class.getName());
    protected Context ctx;
    protected PaymentBillInfo info;
    protected PaymentBillEntryCollection coll;
    protected HashMap param = new HashMap();
    protected boolean isAddNew = true;
    protected IObjectPK pk;
    protected ServiceHandler serviceHandler;
    private final BOSObjectType billBosType = BOSObjectType.create((String)"40284E81");

    protected ServiceHandler getServiceHandler() {
        return new ServiceHandler();
    }

    @Override
    public void initService(Context ctx, PaymentBillInfo info) throws EASBizException, BOSException {
        this.ctx = ctx;
        this.info = info;
        this.serviceHandler = this.getServiceHandler();
    }

    @Override
    public void beforeSubmit() throws EASBizException, BOSException {
        String be022;
        this.getParams();
        if (null != this.info.getId() && PaymentBillFactory.getLocalInstance(this.ctx).exists((IObjectPK)new ObjectUuidPK(this.info.getId()))) {
            this.isAddNew = false;
        }
        this.setDefaultPropertyValue();
        boolean CS129 = false;
        try {
            CS129 = ContextHelperFactory.getLocalInstance((Context)this.ctx).getBooleanParam("CS129", (IObjectPK)new ObjectUuidPK(this.info.getCompany().getId()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (CS129) {
            BgControlCaller caller = new BgControlCaller();
            IBudgetBalance budgetBalance = caller.queryBalance(this.ctx, (IObjectValue)this.info);
            caller.checkBudget(this.ctx, budgetBalance);
        }
        this.verify();
        this.fillBgItem();
        RecPayHelper.setBgCtrlAmt(this.info);
        if (this.info.getSourceSysType() == null && this.info.getSourceType() != null && this.info.getSourceBillId() != null) {
            this.info.setSourceSysType(this.info.getSourceType());
        }
        if (!this.info.isIsSchCreated() && this.info.getSettlementType() != null && this.info.getSettlementType().getNtType() != null && NTTypeGroupEnum.RECEIVABLE.equals((Object)this.info.getSettlementType().getNtType().getSuperGroup())) {
            ReceivableBillFactory.getLocalInstance((Context)this.ctx).lockReceivanleBill((CoreBaseInfo)this.info, "edit");
        }
        if ((be022 = ContextHelperFactory.getLocalInstance((Context)this.ctx).getStringParam("BE022", (IObjectPK)new ObjectUuidPK(this.info.getCompany().getId()))) != null && "1".equals(be022)) {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("id");
            selector.add("number");
            selector.add("settlementType.id");
            selector.add("settlementType.payThroughBE");
            AbstractRecPayBillInfo paymentInfo = null;
            if (this.info.getSettlementType() != null && !this.info.getSettlementType().isPayThroughBE() && PaymentBillFactory.getLocalInstance(this.ctx).exists((IObjectPK)new ObjectUuidPK(this.info.getId()))) {
                paymentInfo = PaymentBillFactory.getLocalInstance(this.ctx).getPaymentBillInfo((IObjectPK)new ObjectUuidPK(this.info.getId()), selector);
            }
            if (this.info.getSettlementType() != null && this.info.getSettlementType().isPayThroughBE() && !this.info.isIsCBPay() || paymentInfo != null && paymentInfo.getSettlementType() != null && paymentInfo.getSettlementType().isPayThroughBE() && !((AbstractPaymentBillInfo)paymentInfo).isIsCBPay()) {
                String beBankNumber = this.info.getBankNumber();
                String beBankName = this.info.getPayeeBank();
                String province = this.info.getRecProvince();
                String city = this.info.getRecCity();
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)beBankNumber, CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("name", (Object)beBankName, CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("State", (Object)1, CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("BeProvince", (Object)province, CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("BeCity", (Object)city, CompareType.EQUALS));
                view.setFilter(filter);
                BEBankCollection coll = BEBankFactory.getLocalInstance((Context)this.ctx).getBEBankCollection(view);
                if (coll == null || coll.size() == 0) {
                    throw new RecPayException(RecPayException.COMMON, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"286_PaySubmitService", (Locale)this.ctx.getLocale())});
                }
            }
        }
    }

    @Override
    public void afterSubmit(IObjectPK pk) throws EASBizException, BOSException {
        SourceTypeEnum sourceType;
        BizRelateReceivableBillUtil.relateReceivableBill((Context)this.ctx, (CoreBaseInfo)this.info, (IObjectPK)pk);
        try {
            IBillImageFacade image = BillImageFacadeFactory.getLocalInstance((Context)this.ctx);
            String imageNumber = image.getImageNumber(this.billBosType.toString(), pk.toString());
            if (StringUtils.isEmpty((String)imageNumber)) {
                imageNumber = image.genImageNumber(this.billBosType.toString(), pk.toString());
            }
        }
        catch (BOSException e) {
            logger.error((Object)"\u8c03\u7528\u57fa\u7840\u7684\u6761\u7801\u63a5\u53e3\u62a5\u9519");
            logger.error((Object)e);
        }
        this.pk = pk;
        this.overDraftControl();
        this.updateSourceBill();
        if (!this.info.isIsInitializeBill()) {
            this.bgControl();
        }
        if ((sourceType = this.info.getSourceType()) == null || SourceTypeEnum.AP.equals((Object)sourceType) || SourceTypeEnum.CASH.equals((Object)sourceType)) {
            String CS120 = ContextHelperFactory.getLocalInstance((Context)this.ctx).getStringParam("CS120", (IObjectPK)new ObjectUuidPK(this.info.getCompany().getId().toString()));
            HashSet<String> idSet = new HashSet<String>();
            idSet.add(pk.toString());
            if (!this.info.isIsCBPay() && CS120 != null && CS120.equals("1") && this.verifyBizTypeSubmit(this.info) && (this.info.getFundDispatchType() == null || this.info.getFundDispatchType().equals((Object)FundDispatchTypeEnum.PAYMENT_DEFAULT))) {
                if (this.info.getFundDispatchPlanStatus().getValue() == 2) {
                    throw new FDException(FDException.REPORTED_NO_SUBMIT);
                }
                if (this.info.getPayerAccountBank() == null && this.info.getFundDispatchPlanStatus().getValue() != 3) {
                    throw new FDException(FDException.REPORTED_NO_SUBMIT);
                }
                PaymentBillFactory.getLocalInstance(this.ctx).beforeCommitSubmit(idSet, this.info.getCompany().getId().toString());
                if (this.info.getFundDispatchPlanStatus().getValue() == 3) {
                    FundDispatchPlanBillInfo fdpInfo = this.getFundDisPlanByPayId(this.ctx, this.info.getId().toString());
                    long current = System.currentTimeMillis();
                    long zero = current / 86400000L * 86400000L - (long)TimeZone.getDefault().getRawOffset();
                    Date today = new Date(zero);
                    if (!EmptyUtil.isEmpty((CoreBaseInfo)fdpInfo) && (fdpInfo.getExpectPayStartDate().after(today) || fdpInfo.getExpectPayEndDate().before(today))) {
                        throw new FDException(FDException.BILLSUBMIT_OUT_DATE);
                    }
                }
                if (!this.verifyReportSetting(this.ctx, this.info.getId().toString())) {
                    return;
                }
                this.handleProcess(this.ctx, pk.toString());
                try {
                    String comapnyId = this.info.getCompany().getId().toString();
                    String sql = "SELECT FID FROM T_FD_TEMP WHERE FCOMPANYID ='" + comapnyId + "'";
                    IRowSet rowSet = DbUtil.executeQuery((Context)this.ctx, (String)sql);
                    HashSet<String> planIdSet = new HashSet<String>();
                    String fid = null;
                    while (rowSet.next()) {
                        fid = rowSet.getString("FID");
                        planIdSet.add(fid);
                    }
                    if (planIdSet.size() >= 0) {
                        PaymentBillFactory.getLocalInstance(this.ctx).afterCommitSubmit(idSet, planIdSet, null);
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    throw new FDException(FDException.UPDATE_PAY_ERROR);
                }
            }
            if (this.info.isIsCBPay() || CS120 == null || !CS120.equals("1") || !this.verifyBizTypeSubmit(this.info) || this.info.getFundDispatchType() == null || this.info.getFundDispatchType().equals((Object)FundDispatchTypeEnum.PAYMENT_DEFAULT)) {
                // empty if block
            }
        }
    }

    private boolean verifyReportSetting(Context ctx, String payBillId) throws EASBizException, BOSException {
        Map map = FundDispatchPlanBillWebFacadeFactory.getLocalInstance((Context)ctx).getPayFilter();
        String filter = (String)map.get("filter");
        try {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo(filter);
            FilterInfo idFilter = new FilterInfo();
            idFilter.getFilterItems().add(new FilterItemInfo("id", (Object)payBillId));
            filterInfo.mergeFilter(idFilter, "AND");
            view.setFilter(filterInfo);
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("id");
            view.setSelector(selector);
            PaymentBillCollection coll = PaymentBillFactory.getLocalInstance(ctx).getPaymentBillCollection(view);
            if (coll.size() > 0) {
                return true;
            }
        }
        catch (ParserException e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage());
        }
        return false;
    }

    private FundDispatchPlanBillInfo getFundDisPlanByPayId(Context ctx, String id) throws BOSException {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        SelectorItemCollection sel = new SelectorItemCollection();
        sel.add(new SelectorItemInfo("*"));
        entityViewInfo.setSelector(sel);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("sourceBillId", (Object)id, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("reportType", (Object)1, CompareType.EQUALS));
        entityViewInfo.setFilter(filter);
        FundDispatchPlanBillCollection colls = FundDispatchPlanBillFactory.getLocalInstance((Context)ctx).getFundDispatchPlanBillCollection(entityViewInfo);
        if (colls.size() > 0) {
            return colls.get(0);
        }
        return null;
    }

    private boolean verifyBizTypeSubmit(PaymentBillInfo info) throws FDException {
        boolean flag = false;
        if (info.getBizType() == null || info.getBizType().getType().getValue() == 10) {
            flag = true;
        }
        return flag;
    }

    private void handleProcess(Context ctx, String id) throws EASBizException, BOSException {
        String CS120 = ContextHelperFactory.getLocalInstance((Context)ctx).getStringParam("CS120", (IObjectPK)new ObjectUuidPK(this.info.getCompany().getId().toString()));
        if (CS120 == null || CS120.equals("0")) {
            return;
        }
        long current = System.currentTimeMillis();
        long zero = current / 86400000L * 86400000L - (long)TimeZone.getDefault().getRawOffset();
        Date today = new Date(zero);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.info.getCompany().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("billStatus", (Object)8));
        filter.getFilterItems().add(new FilterItemInfo("reportType", (Object)2));
        filter.getFilterItems().add(new FilterItemInfo("expectPayStartDate", (Object)today, CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("expectPayEndDate", (Object)today, CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)this.info.getCurrency().getId().toString(), CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("payerAccountBank.id", (Object)this.info.getPayerAccountBank().getId().toString(), CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("unusedAmt", (Object)0, CompareType.GREATER));
        EntityViewInfo ev = new EntityViewInfo();
        ev.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        SorterItemInfo sortInfo = new SorterItemInfo("number");
        sortInfo.setSortType(SortType.DESCEND);
        sorter.add(sortInfo);
        ev.setSorter(sorter);
        CoreBaseCollection colls = FundDispatchPlanBillFactory.getLocalInstance((Context)ctx).getCollection(ev);
        HashSet<String> planIdSet = new HashSet<String>();
        for (int i = 0; i < colls.size(); ++i) {
            CoreBaseInfo cInfo = colls.get(i);
            planIdSet.add(cInfo.getId().toString());
        }
        PaymentBillFactory.getLocalInstance(ctx).updateTmpTable(planIdSet);
    }

    protected void fillBgItem() throws BOSException, EASBizException {
        FMBGHelper.fillBgItem((Context)this.ctx, (IFMBgUsed)this.info);
        IFMBgUsed[] entryInfoNumber = new IFMBgUsed[this.info.getEntries().size()];
        int n = this.info.getEntries().size();
        for (int i = 0; i < n; ++i) {
            entryInfoNumber[i] = this.info.getEntries().get(i);
        }
        FMBGHelper.fillBgItem((Context)this.ctx, (IFMBgUsed[])entryInfoNumber);
    }

    protected void verify() throws EASBizException, BOSException {
        Boolean MBG_C001;
        if (this.info.getPayerAccount() != null) {
            String acctComId = "";
            if (EmptyUtil.isEmpty((CoreBaseInfo)this.info.getPayerAccount().getCompanyID())) {
                AccountViewInfo avInfo = AccountViewFactory.getLocalInstance((Context)this.ctx).getAccountViewInfo("select id,companyid where id='" + this.info.getPayerAccount().getId().toString() + "'");
                acctComId = avInfo.getCompanyID().getId().toString();
            } else {
                acctComId = this.info.getPayerAccount().getCompanyID().getId().toString();
            }
            if (!this.info.getCompany().getId().toString().equals(acctComId)) {
                throw new FMException(FMException.COMMMONEXCEPTION, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"282_PayAddNewService", (Locale)this.ctx.getLocale())});
            }
        }
        if ("true".equals(this.param.get("CS006")) && !(MBG_C001 = Boolean.valueOf(FmMbgHelper.isMBG_C001((Context)this.ctx, (String)this.info.getCompany().getId().toString()))).booleanValue() && EmptyUtil.isEmpty((String)this.info.getOutBgItemNumber())) {
            throw new CasException(CasException.OUTBGITEMNULL);
        }
        if (!EmptyUtil.isEmpty((String)this.info.getPayeeAccountBank())) {
            AccountBankInfo payerAcctBankInfo;
            boolean sameAccountAllowable = false;
            if (this.param.get("CS073") != null) {
                sameAccountAllowable = ((String)this.param.get("CS073")).equals("true");
            }
            if ((payerAcctBankInfo = this.info.getPayerAccountBank()) != null && EmptyUtil.isEmpty((String)payerAcctBankInfo.getBankAccountNumber())) {
                payerAcctBankInfo = AccountBankFactory.getLocalInstance((Context)this.ctx).getAccountBankInfo((IObjectPK)new ObjectUuidPK(payerAcctBankInfo.getId()));
            }
            if (payerAcctBankInfo != null && !sameAccountAllowable && this.info.getPayeeAccountBank().equals(payerAcctBankInfo.getBankAccountNumber())) {
                throw new RecPayException(RecPayException.COMMON, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fi.cas.web.CasWebResource", (String)"324_CantBeSameAccount", (Locale)this.ctx.getLocale())});
            }
        }
        if (this.info.getCostCenter() != null) {
            this.serviceHandler.checkCostCenter(this.ctx, this.info.getCostCenter());
        }
        if (this.info.getFundDispatchType() == null || this.info.getFundDispatchType().equals((Object)FundDispatchTypeEnum.PAYMENT_DEFAULT)) {
            MBG_C001 = FmMbgHelper.isMBG_C001((Context)this.ctx, (String)this.info.getCompany().getId().toString());
            if ("true".equals(this.param.get("CS015")) && !MBG_C001.booleanValue()) {
                PaymentBillEntryCollection entryCollection = this.info.getEntries();
                PaymentBillEntryInfo billEntryInfo = null;
                for (int i = 0; i < entryCollection.size(); ++i) {
                    billEntryInfo = entryCollection.get(i);
                    if (EmptyUtil.isEmpty((String)billEntryInfo.getOutBgItemNumber())) {
                        throw new CasException(CasException.ENTRYSBGITEMNULL);
                    }
                    if (billEntryInfo.getCostCenter() == null) continue;
                    this.serviceHandler.checkCostCenter(this.ctx, billEntryInfo.getCostCenter());
                }
            }
        }
        boolean cs064 = false;
        if (this.param.get("CS064") != null) {
            cs064 = ((String)this.param.get("CS064")).equals("true");
        }
        this.serviceHandler.checkPayInfoValue(this.ctx, this.info, cs064);
        boolean cs071 = false;
        if (this.param.get("CS071") != null) {
            cs071 = ((String)this.param.get("CS071")).equals("true");
        }
        this.checkInfoIsValid(this.ctx, this.info, cs071);
        this.checkOppAccountInfo(this.ctx, this.info);
        this.checkExpenseType(this.ctx, this.info);
        CasForArApUtil.checkFundFlowItem(this.ctx, this.info);
    }

    protected void getParams() throws EASBizException, BOSException {
        this.setDefaultCompany();
        String companyId = this.info.getCompany().getId().toString();
        List numberList = this.getParamNumberList();
        for (String paramNumber : numberList) {
            this.param.put(paramNumber, null);
        }
        this.param = this.serviceHandler.getParam(this.ctx, (IObjectPK)new ObjectUuidPK(companyId), this.param);
    }

    protected List getParamNumberList() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("CS053");
        list.add("CS043");
        list.add("CS064");
        list.add("CS015");
        list.add("CS006");
        list.add("CS071");
        list.add("CS073");
        list.add("CS079");
        list.add("TM105");
        list.add("CS031");
        list.add("CS109");
        return list;
    }

    protected void setDefaultCompany() {
        if (this.info.getCompany() == null) {
            this.info.setCompany(ContextHelperFactory.getLocalInstance((Context)this.ctx).getCurrentCompany());
        }
    }

    protected void setDefaultPropertyValue() throws BOSException, EASBizException {
        Pattern pattern;
        Matcher isNum;
        String sourceBillId;
        String editFlag;
        this.setDefaultCompany();
        if (this.info.getPaymentType() == null) {
            String paymentTypeId = "2fa35444-5a23-43fb-99ee-6d4fa5f260da6BCA0AB5";
            PaymentTypeInfo paymentTypeInfo = new PaymentTypeInfo();
            paymentTypeInfo.setId(BOSUuid.read((String)paymentTypeId));
            this.info.setPaymentType(paymentTypeInfo);
        }
        int tm105 = 0;
        if (this.param.get("TM105") != null) {
            tm105 = Integer.parseInt((String)this.param.get("TM105"));
        }
        PaymentBillDataProcess.setCasAmount(this.ctx, this.info);
        if (this.info.getFundDispatchType() != null && this.info.getFundDispatchType().getValue() != 0) {
            if (EmptyUtil.isEmpty((AbstractObjectCollection)this.info.getEntries()) && this.info.getEntries().size() == 0) {
                PaymentBillEntryInfo newEntryInfo = new PaymentBillEntryInfo();
                newEntryInfo.setActualAmt(this.info.getActPayAmt());
                newEntryInfo.setActualLocAmt(this.info.getActPayLocAmt());
                this.info.getEntries().add(newEntryInfo);
            } else {
                this.info.getEntries().get(0).setActualAmt(this.info.getActPayAmt());
                this.info.getEntries().get(0).setActualLocAmt(this.info.getActPayLocAmt());
            }
        }
        this.serviceHandler.setCommonPropertyValue(this.ctx, this.info);
        AgentRecPayServerHelper.saveOrSubmitPaymentBillForAgentPay(this.ctx, this.info);
        if (this.info.getBillStatus() == null || this.info.getBillStatus().equals((Object)BillStatusEnum.SAVE)) {
            this.info.setBillStatus(BillStatusEnum.SUBMIT);
        }
        if (BillStatusEnum.SUBMIT.equals((Object)this.info.getBillStatus())) {
            this.info.setLastExhangeRate(this.info.getExchangeRate());
        }
        if (this.info.getBillStatus().equals((Object)BillStatusEnum.AUDITED) && "true".equals(this.param.get("CS031"))) {
            editFlag = this.generateEditFlag(this.info);
            this.info.setEditFlag(editFlag);
            this.info.setEditFlagNew(editFlag);
        }
        if (this.info.getBillStatus().equals((Object)BillStatusEnum.AUDITED) && "true".equals(this.param.get("CS109"))) {
            editFlag = this.generateEditFlag(this.info);
            this.info.setEditFlag(editFlag);
            this.info.setEditFlagNew(editFlag);
        }
        if ((sourceBillId = this.info.getSourceBillId()) != null && sourceBillId.length() > 0) {
            try {
                if (FMHelper.isInstanceof((String)sourceBillId, FundTransferBillInfo.class) && FundTransferBillFactory.getLocalInstance((Context)this.ctx).exists((IObjectPK)new ObjectUuidPK(sourceBillId))) {
                    this.info.setSourceType(SourceTypeEnum.FT);
                }
            }
            catch (Exception ex) {
                logger.info((Object)ex);
                throw new BOSException((Throwable)ex);
            }
        }
        this.info.setBizDate(DateTimeUtils.truncateDate((Date)this.info.getBizDate()));
        if (!EmptyUtil.isEmpty((String)this.info.getPayeeAccountBank()) && !(isNum = (pattern = Pattern.compile("^[^\\s]*$")).matcher(this.info.getPayeeAccountBank().toString())).matches()) {
            throw new CasException(CasException.ISNOTNUMBER);
        }
        if (this.info.getSettlementType() != null && this.info.getSettlementType().isPayThroughBE()) {
            if (this.info.getPayBillType() != null && this.info.getPayBillType().isIsFinanceTranUp() ? EmptyUtil.isEmpty((CoreBaseInfo)this.info.getActRecAccountBank()) : EmptyUtil.isEmpty((String)this.info.getPayeeAccountBank())) {
                throw new CasException(CasException.PAYEEACCOUNTBANKBLANK);
            }
            char[] chars_test2 = null;
            if (this.info.getPayBillType() != null && this.info.getPayBillType().isIsFinanceTranUp()) {
                if (!this.info.isIsCBPay() && !this.info.getActRecAccountBank().getBankAccountNumber().matches("^\\w(\\w*-\\w+)*\\w*$")) {
                    throw new CasException(CasException.MUSTNUMBER);
                }
                chars_test2 = this.info.getActRecAccountBank().getBankAccountNumber().toString().toCharArray();
            } else {
                if (!this.info.isIsCBPay() && !this.info.getPayeeAccountBank().matches("^\\w(\\w*-\\w+)*\\w*$")) {
                    throw new CasException(CasException.MUSTNUMBER);
                }
                chars_test2 = this.info.getPayeeAccountBank().toString().toCharArray();
            }
            for (int i = 0; i < chars_test2.length; ++i) {
                String temp = String.valueOf(chars_test2[i]);
                if (!temp.matches("[^\\x00-\\xff]")) continue;
                throw new CasException(CasException.RECACCT_CANNOT_FULL);
            }
        }
    }

    protected String generateEditFlag(PaymentBillInfo info) {
        String srcPayerAccountBankNumber = info.getPayerAccountBank() != null ? info.getPayerAccountBank().getBankAccountNumber() : "";
        String srcPayeeAccountBankNumber = info.getPayeeAccountBank();
        String srcCurrency = info.getCurrency().getId().toString();
        String srcActPayAmt = info.getActPayAmt().toString();
        String srcActRecAccountBank = null;
        if (info.getActRecAccountBank() != null) {
            srcActRecAccountBank = info.getActRecAccountBank().getNumber();
        }
        AbstractPaymentBillInfo newInfo = null;
        try {
            newInfo = PaymentBillFactory.getLocalInstance(this.ctx).getPaymentBillInfo((IObjectPK)new ObjectUuidPK(info.getId().toString()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!EmptyUtil.isEmpty(newInfo) && !EmptyUtil.isEmpty((Object)newInfo.getActPayAmt())) {
            srcActPayAmt = newInfo.getActPayAmt().toString();
        }
        String srcString = srcPayerAccountBankNumber + srcPayeeAccountBankNumber + srcCurrency + srcActPayAmt + srcActRecAccountBank;
        if (info.isIsCBPay() && info.getCbPayInfo() != null) {
            String srcPayeeCurrency = info.getCbPayInfo().getPayeeCurrency().getId().toString();
            String srcPayeeAmount = info.getCbPayInfo().getPayeeAmount().toString();
            srcString = srcPayerAccountBankNumber + srcPayeeAccountBankNumber + srcCurrency + srcActPayAmt + srcActRecAccountBank + srcPayeeCurrency + srcPayeeAmount;
        }
        return MessageDigestTools.getSpecialFlag((String)srcString);
    }

    protected void bgControl() throws BOSException, EASBizException {
        int bgCtrlParam = 0;
        if (this.param.get("CS043") != null) {
            bgCtrlParam = Integer.parseInt((String)this.param.get("CS043"));
        }
        boolean onWaybgCtrl = false;
        if (this.param.get("CS079") != null) {
            onWaybgCtrl = ((String)this.param.get("CS079")).equals("true");
        }
        if (onWaybgCtrl) {
            String boName = "com.kingdee.eas.fi.cas.app.PaymentBill";
            String handleName = BgCtrlReceivingBillHandler.class.getName();
            RecPayHelper.OnWaybgCtrl(this.ctx, this.pk.toString(), boName, handleName);
        } else if (this.info.isIsTransOtherBill() && bgCtrlParam != 0) {
            String billId = this.pk.toString();
            String boName = "com.kingdee.eas.fi.cas.app.PaymentBill";
            String handleName = BgCtrlPaymentBillHandler.class.getName();
            RecPayHelper.bgCtrlAudit(this.ctx, billId);
        } else {
            this.serviceHandler.bgCtrlAndAudit(this.ctx, this.pk, RecPayBgCtrlStrEnum.Sumbit_Sub, bgCtrlParam);
        }
    }

    protected void updateSourceBill() throws EASBizException, BOSException {
        this.serviceHandler.dispose(this.ctx, this.info, this.coll, DisposerActionEnum.SUBMIT);
        String sourceBillId = this.info.getSourceBillId();
        if (sourceBillId != null && sourceBillId.trim().length() > 0) {
            ObjectUuidPK objectPk = new ObjectUuidPK(sourceBillId);
            BOSUuid bosId = BOSUuid.read((String)sourceBillId);
            if (bosId.getType().equals((Object)new FundTransferBillInfo().getBOSType())) {
                FundTransferBillFactory.getLocalInstance((Context)this.ctx).updatePaymentBillID((IObjectPK)objectPk, (IObjectPK)new ObjectUuidPK(this.info.getId()));
            } else if (new TimeDepositApplyInfo().getBOSType().equals((Object)bosId.getType())) {
                TimeDepositApplyInfo timeDepositApplyInfo = TimeDepositApplyFactory.getLocalInstance((Context)this.ctx).getTimeDepositApplyInfo((IObjectPK)new ObjectUuidPK(sourceBillId));
                timeDepositApplyInfo.setIsCreatePayment(true);
                TimeDepositApplyFactory.getLocalInstance((Context)this.ctx).update((IObjectPK)new ObjectStringPK(sourceBillId), (CoreBaseInfo)timeDepositApplyInfo);
            } else if (new CompUnTimeDepositBillInfo().getBOSType().equals((Object)bosId.getType())) {
                CompUnTimeDepositBillInfo unTimeDepositInfo = CompUnTimeDepositBillFactory.getLocalInstance((Context)this.ctx).getCompUnTimeDepositBillInfo((IObjectPK)new ObjectUuidPK(sourceBillId));
                unTimeDepositInfo.setIsCreatePayment(true);
                CompUnTimeDepositBillFactory.getLocalInstance((Context)this.ctx).update((IObjectPK)new ObjectStringPK(sourceBillId), unTimeDepositInfo);
            }
        }
        this.serviceHandler.reverseConsignment(this.ctx, this.info, "1");
    }

    protected void overDraftControl() throws BOSException, EASBizException {
        int overCtrlParam = 0;
        if (this.param.get("CS053") != null) {
            overCtrlParam = Integer.parseInt((String)this.param.get("CS053"));
        }
        if (this.info.getBizType() == null || !SettBizTypeEnum.LINKPAY.equals((Object)this.info.getBizType().getType())) {
            if (this.info.getSourceBillId() != null) {
                BOSUuid sbid = BOSUuid.read((String)this.info.getSourceBillId());
                if (sbid.getType().equals((Object)new SettlementBillInfo().getBOSType())) {
                    SettlementBillInfo settlementBillInfo = SettlementBillFactory.getLocalInstance((Context)this.ctx).getSettlementBillInfo((IObjectPK)new ObjectUuidPK(sbid));
                    if (!(SettBizTypeEnum.PAYOUTSIDE.equals((Object)settlementBillInfo.getType()) || SettBizTypeEnum.PAYINSIDE.equals((Object)settlementBillInfo.getType()) || SettBizTypeEnum.PAYINSIDEDIF.equals((Object)settlementBillInfo.getType()) || SettBizTypeEnum.PAYOUTDIFFCUR.equals((Object)settlementBillInfo.getType()))) {
                        this.serviceHandler.overDraftCtrls(this.ctx, (IObjectValue)this.info, RecPayOverDraftCtrlEnum.submit_ctrl, overCtrlParam);
                    }
                } else if (!sbid.getType().equals((Object)new TransUpBillInfo().getBOSType())) {
                    this.serviceHandler.overDraftCtrls(this.ctx, (IObjectValue)this.info, RecPayOverDraftCtrlEnum.submit_ctrl, overCtrlParam);
                }
            } else {
                this.serviceHandler.overDraftCtrls(this.ctx, (IObjectValue)this.info, RecPayOverDraftCtrlEnum.submit_ctrl, overCtrlParam);
            }
        }
    }

    protected void checkInfoIsValid(Context ctx, PaymentBillInfo info, boolean cs071) throws BOSException, EASBizException {
        if (info == null || info.getEntries() == null || info.getEntries().size() < 1) {
            throw new RecPayException(RecPayException.BILLENTRY_ISNULL);
        }
        this.checkPayInfoIsValid(ctx, info);
        this.checkOverDraft(ctx, info, cs071);
    }

    protected void checkOverDraft(Context ctx, PaymentBillInfo info, boolean cs071) throws BOSException, EASBizException {
        CompanyOrgUnitInfo companyInfo = info.getCompany();
        if (!cs071) {
            return;
        }
        SettBizTypeInfo bizType = info.getBizType();
        if (bizType == null) {
            return;
        }
        boolean notSubmitHouse = false;
        if (bizType != null) {
            notSubmitHouse = bizType.isNotSubmitHouse();
        }
        if (cs071 && !notSubmitHouse) {
            BigDecimal amount;
            BOSUuid sbid;
            String sourceBid = info.getSourceBillId();
            if (sourceBid != null && ((sbid = BOSUuid.read((String)sourceBid)).getType().equals((Object)new SettlementBillInfo().getBOSType()) || sbid.getType().equals((Object)new FeeBillInfo().getBOSType()) || sbid.getType().equals((Object)new LoanInterestBillInfo().getBOSType()))) {
                return;
            }
            AccountBankInfo accountBankInfo = info.getPayerAccountBank();
            if (accountBankInfo == null) {
                return;
            }
            InnerAccountInfo innerAccount = accountBankInfo.getInnerAcct();
            if (innerAccount == null) {
                return;
            }
            BOSUuid innerAccountId = innerAccount.getId();
            innerAccount = InnerAccountFactory.getLocalInstance((Context)ctx).getInnerAccountInfo((IObjectPK)new ObjectUuidPK(innerAccountId));
            CurrencyInfo currency = info.getCurrency();
            ObjectUuidPK chCompanyPk = new ObjectUuidPK(innerAccount.getCompany().getId());
            CompanyOrgUnitInfo chCompany = null;
            chCompany = companyInfo.getId().toString().equals(innerAccount.getCompany().getId().toString()) ? companyInfo : CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)chCompanyPk);
            BankInfo clearingHouse = BankFactory.getLocalInstance((Context)ctx).getClearingHouse(chCompany.getId().toString());
            Date unSettleDate = clearingHouse.getSettleDate();
            BigDecimal balance = InAcctFactory.getLocalInstance((Context)ctx).inAcct(chCompany.getNumber(), innerAccount.getNumber(), currency.getNumber(), unSettleDate, unSettleDate, InAcctDataTypeEnum.K);
            boolean cs071_01 = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("CS071_01", (IObjectPK)new ObjectUuidPK(info.getCompany().getId().toString()));
            System.out.println("balance===" + balance);
            if (cs071_01) {
                BigDecimal onwayAmt = this.getOnWayPayAmtNew(ctx, info);
                System.out.println("onwayAmt===" + onwayAmt);
                balance = balance.subtract(onwayAmt);
                System.out.println("balance12121===" + balance);
            }
            if ((amount = info.getActPayAmt()).compareTo(balance) > 0) {
                throw new RecPayException(RecPayException.INNERACCOUNTCANNOTOVERDRAFT, new String[]{accountBankInfo.getBankAccountNumber(), innerAccount.getNumber()});
            }
        }
    }

    protected void checkPayInfoIsValid(Context ctx, PaymentBillInfo info) throws EASBizException, BOSException {
        boolean isCommitSettle;
        if (info == null) {
            throw new NullPointerException("ReceivingBillInfo should not be null!");
        }
        if (info.getPayBillType() == null) {
            throw new RecPayException(RecPayException.PAYBILLTYPEISNULL);
        }
        String recPayType = null;
        recPayType = ResourceBase.getString((String)"com.kingdee.eas.fi.cas.RecPayResource", (String)"PayType", (Locale)ctx.getLocale());
        int payType = 201;
        try {
            payType = Integer.parseInt(info.getPayBillType().getNumber());
        }
        catch (NumberFormatException e) {
            payType = 201;
        }
        if ((payType == RecPayBillTypeEnum.PAY_AP_REFUNDMENT_STOCK_PAYMENT.getValue() || payType == RecPayBillTypeEnum.PAY_AP_REFUNDMENT_PRE_PAYMENT.getValue() || payType == RecPayBillTypeEnum.PAY_CP_REFUNDMENT_BILL.getValue() || payType == RecPayBillTypeEnum.PAY_AP_REFUNDMENT_AGENT.getValue()) && (isCommitSettle = info.isIsCommitSettle())) {
            throw new RecPayException(RecPayException.CANNOT_COMMIT_HAS_NEGATIVE, new String[]{recPayType});
        }
        if (SourceTypeEnum.AP.equals((Object)info.getSourceType()) && info.getPayeeID() != null && info.getPayeeType() != null && info.getCompany() != null && !RecPayHelper.isExistAsstActByCompany(ctx, info.getCompany(), info.getPayeeType(), info.getPayeeID())) {
            throw new RecPayException(RecPayException.ACCTCUSSENT_NOTBELONGCOMORG);
        }
        if (info.isIsInitializeBill()) {
            return;
        }
        AccountViewInfo view = null;
        if (info.getPayerAccount() != null) {
            view = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewInfo((IObjectPK)new ObjectUuidPK(info.getPayerAccount().getId()));
        }
        if (view != null && view.isIsCFreeze()) {
            throw new RecPayException(RecPayException.ACCT_IS_FREEZE);
        }
    }

    private BigDecimal getOnWayPayAmtNew(Context ctx, PaymentBillInfo paymentBill) throws BOSException, EASBizException {
        BigDecimal amount = FMConstants.ZERO;
        StringBuffer casSql = new StringBuffer();
        casSql.append(" select sum(FActualPayAmount) famount from t_cas_paymentbill a").append("\n");
        casSql.append(" where a.fpayerAccountBankid=?").append("\n");
        casSql.append(" and a.fcurrencyid=?").append("\n");
        casSql.append(" and a.fsettlementStatus=?").append("\n");
        casSql.append(" and a.fbillStatus!=?").append("\n");
        casSql.append(" and a.fisNeedPay=1").append("\n");
        if (!FMHelper.isEmpty((Object)paymentBill.getId())) {
            casSql.append(" and a.fid!=?").append("\n");
        }
        casSql.append(" and not exists").append("\n");
        casSql.append(" (select 1 from t_fs_settlementbill b where b.fid=a.fsourceBillId)").append("\n");
        casSql.append(" and not exists").append("\n");
        casSql.append(" (select 1 from T_FE_FeeBill c where c.fid=a.fsourceBillId)").append("\n");
        casSql.append(" and not exists").append("\n");
        casSql.append(" (select 1 from T_IVT_LoanInterestBill d where d.fid=a.fsourceBillId)");
        StringBuffer settleSql = new StringBuffer();
        settleSql.append(" select sum(famount) result from t_fs_settlementbill a ").append("\n");
        settleSql.append("  where a.fpayerInnerAcctid = ? ").append("\n");
        settleSql.append("  and  a.fcurrencyid = ? ").append("\n");
        settleSql.append("  and not exists ").append("\n");
        settleSql.append("  (select 1 from t_fs_SubsidiaryLedger b where b.fbillid=a.fid) ").append("\n");
        settleSql.append("  and not exists ").append("\n");
        settleSql.append("  (select 1 from t_fs_settlementbill c where c.fid=a.fsourceBillId) ");
        StringBuffer sql = new StringBuffer();
        sql.append(" select sum(famount) result ").append("\n");
        sql.append(" from ").append("\n");
        sql.append(" ( ").append("\n");
        sql.append(casSql).append("\n");
        sql.append(" union all ").append("\n");
        sql.append(settleSql).append("\n");
        sql.append(" ) h ").append("\n");
        IRowSet rs = !FMHelper.isEmpty((Object)paymentBill.getId()) ? DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{paymentBill.getPayerAccountBank().getId().toString(), paymentBill.getCurrency().getId().toString(), new Integer(10), new Integer(10), paymentBill.getId().toString(), paymentBill.getPayerAccountBank().getInnerAcct().getId().toString(), paymentBill.getCurrency().getId().toString()}) : DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{paymentBill.getPayerAccountBank().getId().toString(), paymentBill.getCurrency().getId().toString(), new Integer(10), new Integer(10), paymentBill.getPayerAccountBank().getInnerAcct().getId().toString(), paymentBill.getCurrency().getId().toString()});
        try {
            while (rs.next()) {
                if (rs.getBigDecimal("result") == null) continue;
                amount = rs.getBigDecimal("result");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        System.out.println("sql========" + sql.toString());
        System.out.println("amount========" + amount);
        return amount;
    }

    private void checkOppAccountInfo(Context ctx, PaymentBillInfo info) throws BOSException, EASBizException {
        AccountViewInfo avInfo;
        PaymentBillEntryCollection entryCollection = info.getEntries();
        PaymentBillEntryInfo billEntryInfo = null;
        AccountViewInfo entriesInfo = null;
        for (int i = 0; i < entryCollection.size(); ++i) {
            billEntryInfo = entryCollection.get(i);
            if (EmptyUtil.isEmpty((CoreBaseInfo)billEntryInfo.getOppAccount()) || EmptyUtil.isEmpty((Object)billEntryInfo.getOppAccount().getId()) || EmptyUtil.isEmpty((CoreBaseInfo)(entriesInfo = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewInfo("select id,companyid,isleaf where id='" + billEntryInfo.getOppAccount().getId().toString() + "'"))) || entriesInfo.isIsLeaf()) continue;
            throw new CasException(CasException.ENTRYSTARGETPROJECTISLEAF);
        }
        if (!(EmptyUtil.isEmpty((CoreBaseInfo)info.getOppAccount()) || EmptyUtil.isEmpty((Object)info.getOppAccount().getId()) || EmptyUtil.isEmpty((CoreBaseInfo)(avInfo = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewInfo("select id,companyid,isleaf where id='" + info.getOppAccount().getId().toString() + "'"))) || avInfo.isIsLeaf())) {
            throw new CasException(CasException.PROJECTISLEAF);
        }
    }

    private void checkExpenseType(Context ctx, PaymentBillInfo info) throws BOSException, EASBizException {
        PaymentBillEntryCollection entryCollection = info.getEntries();
        PaymentBillEntryInfo billEntryInfo = null;
        for (int i = 0; i < entryCollection.size(); ++i) {
            billEntryInfo = entryCollection.get(i);
            if (EmptyUtil.isEmpty((CoreBaseInfo)billEntryInfo.getExpenseType()) || EmptyUtil.isEmpty((Object)billEntryInfo.getExpenseType().getId())) continue;
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)billEntryInfo.getExpenseType().getId(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("billTypeName", (Object)"%\u4ed8\u6b3e\u5355%", CompareType.LIKE));
            ev.setFilter(filter);
            ExpenseTypeCollection coll = ExpenseTypeFactory.getLocalInstance((Context)ctx).getExpenseTypeCollection(ev);
            if (coll.size() != 0) continue;
            throw new CasException(CasException.EXPENSETYPECHECK);
        }
    }

    public void initDeleteEntry(Context ctx, PaymentBillEntryCollection coll) throws EASBizException, BOSException {
        this.ctx = ctx;
        this.coll = coll;
    }
}

