/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BillStatusEnum;
import com.kingdee.eas.fi.cas.PaymentBillCollection;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.cas.RecPayHelper;
import com.kingdee.eas.fi.cas.app.service.IPayUntiApproveService;
import com.kingdee.eas.fi.cas.app.service.handler.ServiceHandler;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.NumericExceptionSubItem;
import java.util.Set;

public class PayUntiApproveService
implements IPayUntiApproveService {
    protected Context ctx;
    protected Set idSet;
    protected ServiceHandler serviceHandler;
    RecPayHelper helper = new RecPayHelper();

    protected ServiceHandler getServiceHandler() {
        return new ServiceHandler();
    }

    @Override
    public void initService(Context ctx, Set idSet) throws EASBizException, BOSException {
        this.ctx = ctx;
        this.idSet = idSet;
        this.serviceHandler = this.getServiceHandler();
    }

    @Override
    public void doService() throws EASBizException, BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.idSet, CompareType.INCLUDE));
        SelectorItemCollection sic = new SelectorItemCollection();
        view.setSelector(sic);
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("billStatus"));
        sic.add(new SelectorItemInfo("sourceType"));
        PaymentBillCollection colls = PaymentBillFactory.getLocalInstance(this.ctx).getPaymentBillCollection(view);
        for (int index = 0; index < colls.size(); ++index) {
            PaymentBillInfo info = colls.get(index);
            IObjectPK pkOut = LogUtil.beginLog((Context)this.ctx, (String)"\u53cd\u5ba1\u6838", (BOSObjectType)info.getBOSType(), null, (String)info.getNumber(), (String)"cas_paymentBill_antiApprove");
            ObjectUuidPK pk = new ObjectUuidPK(info.getId());
            FMHelper.CheckIsInWorkFlow((Context)this.ctx, (String)pk.toString());
            if (!info.getBillStatus().equals((Object)BillStatusEnum.APPROVED)) {
                throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.fi.cas.RecPayResource", (String)"PaymentBill_Status", (Object[])new String[]{info.getBillStatus().getAlias()})));
            }
            LogUtil.afterLog((Context)this.ctx, (IObjectPK)pkOut);
        }
        String ids = FMHelper.setTran2String((Set)this.idSet);
        String sql = "UPDATE T_CAS_PaymentBill SET FApproverID = '',FApproveDate = null,FBillStatus = ? WHERE FID IN " + ids;
        Integer status = new Integer(10);
        DbUtil.execute((Context)this.ctx, (String)sql, (Object[])new Object[]{status});
    }
}

