/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.service.ServiceStateManager;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.ArApRecPayException;
import com.kingdee.eas.fi.cas.BillStatusEnum;
import com.kingdee.eas.fi.cas.PaymentBillDataProcess;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.cas.PaymentBillTypeFactory;
import com.kingdee.eas.fi.cas.PaymentBillTypeInfo;
import com.kingdee.eas.fi.cas.RecPayHelper;
import com.kingdee.eas.fi.cas.app.AgentRecPayServerHelper;
import com.kingdee.eas.fi.cas.app.ArApRecPayServerHelper;
import com.kingdee.eas.fi.cas.app.service.IPayUpdateService;
import com.kingdee.eas.fi.cas.app.service.handler.ServiceHandler;
import com.kingdee.eas.fi.cas.utils.PayAdmitUtils;
import com.kingdee.eas.fm.common.util.AccountCurrencyVerifyUtil;
import com.kingdee.eas.fm.nt.ChequeInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import java.math.BigDecimal;

public class PayUpdateService
implements IPayUpdateService {
    protected Context ctx;
    protected IObjectPK pk;
    protected IObjectValue value;
    protected PaymentBillInfo info;
    protected ServiceHandler serviceHandler;
    ArApRecPayServerHelper arapHelper = new ArApRecPayServerHelper();

    protected ServiceHandler getServiceHandler() {
        return new ServiceHandler();
    }

    @Override
    public void initService(Context ctx, IObjectPK pk, IObjectValue value) throws EASBizException, BOSException {
        this.ctx = ctx;
        this.pk = pk;
        this.value = value;
        this.info = (PaymentBillInfo)value;
        this.serviceHandler = this.getServiceHandler();
    }

    @Override
    public void beforeService() throws EASBizException, BOSException {
        PayAdmitUtils.verifyPayadmit(this.ctx, (CoreBaseInfo)this.info, false);
        this.serviceHandler.setCommonPropertyValue(this.ctx, this.info);
        PaymentBillDataProcess.setCasAmount(this.ctx, this.info);
        RecPayHelper.checkAcctViewIsValid(this.ctx, this.info);
        this.checkAccountAndCurrency();
    }

    @Override
    public void doService() throws EASBizException, BOSException {
        if (BillStatusEnum.SUBMIT.equals((Object)this.info.getBillStatus())) {
            this.updateSubmitedBill();
        }
        this.setProperty();
        ServiceStateManager.getInstance().enableNextCallService("PERMISSION_SERVICE");
    }

    protected void updateSubmitedBill() throws BOSException, EASBizException {
        if (this.info.getPayBillType() != null) {
            Integer payType = null;
            if (this.info.getPayBillType().isIsPreSet()) {
                payType = Integer.valueOf(this.info.getPayBillType().getNumber());
            } else if (this.info.getPayBillType().getPreSetBillType() != null) {
                PaymentBillTypeInfo prePayType = PaymentBillTypeFactory.getLocalInstance(this.ctx).getPaymentBillTypeInfo((IObjectPK)new ObjectUuidPK(this.info.getPayBillType().getPreSetBillType().getId()));
                payType = new Integer(prePayType.getNumber());
            }
            boolean blueFlag = this.arapHelper.checkIsDefaultBlueBillType(payType);
            boolean redFlag = this.arapHelper.checkIsDefaultRedBillType(payType);
            int sign = 0;
            BigDecimal amt = this.info.getAmount();
            if (amt != null) {
                sign = amt.signum();
            }
            if (blueFlag && sign == -1 || redFlag && sign == 1) {
                throw new ArApRecPayException(ArApRecPayException.PAY_TYPEAMTNOTMATCH);
            }
        }
    }

    protected void setProperty() {
        Object chequeID;
        Integer temp;
        if (this.info.getSourceType() == null) {
            this.info.setSourceType(this.info.getPayBillType().getSourceSysType());
        }
        if (this.value.get("settleBizType") instanceof Integer && (temp = (Integer)this.value.get("settleBizType")) == 0) {
            this.info.setSettleBizType(null);
        }
        if (BillStatusEnum.SUBMIT.equals((Object)this.info.getBillStatus())) {
            this.info.setLastExhangeRate(this.info.getExchangeRate());
        }
        if ((chequeID = this.value.get("cheque")) instanceof BOSUuid) {
            ChequeInfo chequeInfo = new ChequeInfo();
            chequeInfo.setId((BOSUuid)chequeID);
            this.value.put("cheque", (Object)chequeInfo);
        }
    }

    protected void changeAgentPayBill() throws BOSException, EASBizException {
        PaymentBillInfo relatePayInfo = AgentRecPayServerHelper.getSynchronizedInfo(this.ctx, this.info);
        if (relatePayInfo != null) {
            PaymentBillFactory.getLocalInstance(this.ctx).getSuperUpdate((IObjectPK)new ObjectUuidPK(relatePayInfo.getId().toString()), (IObjectValue)relatePayInfo);
        }
    }

    protected void changePaymentBill() throws BOSException, EASBizException {
        String agentPaymentBillID = this.info.getSrcAgenPaymentBillID();
        ObjectUuidPK srcAgentBillPK = new ObjectUuidPK(agentPaymentBillID);
        PaymentBillInfo srcAgentBill = PaymentBillFactory.getLocalInstance(this.ctx).getPaymentBillInfo((IObjectPK)srcAgentBillPK);
        AccountBankInfo agentAcctBank = this.info.getPayerAccountBank();
        if (agentAcctBank != null) {
            agentAcctBank = AccountBankFactory.getLocalInstance((Context)this.ctx).getAccountBankInfo((IObjectPK)new ObjectUuidPK(agentAcctBank.getId()));
        }
        if (agentAcctBank != null && agentAcctBank.getCompany().getId().equals((Object)srcAgentBill.getCompany().getId())) {
            srcAgentBill.setPayerAccountBank(agentAcctBank);
            srcAgentBill.setPayerBank(agentAcctBank.getBank());
            srcAgentBill.setPayerAccount(agentAcctBank.getAccount());
            srcAgentBill.setNull("bizType");
            PaymentBillFactory.getLocalInstance(this.ctx).getSuperUpdate((IObjectPK)srcAgentBillPK, (IObjectValue)srcAgentBill);
        } else if (agentAcctBank != null && !agentAcctBank.getCompany().getId().equals((Object)srcAgentBill.getCompany().getId())) {
            srcAgentBill.setNull("bizType");
            PaymentBillFactory.getLocalInstance(this.ctx).getSuperUpdate((IObjectPK)srcAgentBillPK, (IObjectValue)srcAgentBill);
        }
    }

    protected void checkAccountAndCurrency() throws BOSException, EASBizException {
        boolean val = ContextHelperFactory.getLocalInstance((Context)this.ctx).getBooleanParam("CS064", (IObjectPK)new ObjectUuidPK(this.info.getCompany().getId()));
        if (this.info.getPayerAccount() != null && val) {
            AccountCurrencyVerifyUtil.verifyAccountCurrency((Context)this.ctx, (String)this.info.getPayerAccount().getId().toString(), (String)this.info.getCurrency().getId().toString(), (CompanyOrgUnitInfo)this.info.getCompany());
        }
        if (this.info.getOppAccount() != null && val) {
            AccountCurrencyVerifyUtil.verifyAccountCurrency((Context)this.ctx, (String)this.info.getOppAccount().getId().toString(), (String)this.info.getCurrency().getId().toString(), (CompanyOrgUnitInfo)this.info.getCompany());
        }
    }

    @Override
    public void afterService() throws EASBizException, BOSException {
    }
}

