/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.DefineSysEnum;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.botp.util.MappingCache;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BillStatusEnum;
import com.kingdee.eas.fi.cas.CasException;
import com.kingdee.eas.fi.cas.CashPamentBillUtil;
import com.kingdee.eas.fi.cas.DisposerActionEnum;
import com.kingdee.eas.fi.cas.PaymentBillCollection;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.cas.RecPayHelper;
import com.kingdee.eas.fi.cas.SourceTypeEnum;
import com.kingdee.eas.fi.cas.app.service.IPayVoucherService;
import com.kingdee.eas.fi.cas.app.service.handler.ServiceHandler;
import com.kingdee.eas.fi.cas.utils.ArApSelectorFactory;
import com.kingdee.eas.fi.gl.VoucherCollection;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.tm.common.invoicePool.utils.InvoicePoolService;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class PayVoucherService
implements IPayVoucherService {
    protected Context ctx;
    protected IObjectCollection sourceBillCollection;
    protected PaymentBillCollection validColl;
    protected IObjectPK botMappingPK;
    private ServiceHandler serviceHandler = new ServiceHandler();
    private RecPayHelper helper = new RecPayHelper();

    @Override
    public void initService(Context ctx, IObjectCollection sourceBillCollection, IObjectPK botMappingPK) throws EASBizException, BOSException {
        this.ctx = ctx;
        this.sourceBillCollection = sourceBillCollection;
        this.botMappingPK = botMappingPK;
    }

    @Override
    public CoreBillBaseCollection doService() throws EASBizException, BOSException {
        CoreBillBaseCollection srcColl = (CoreBillBaseCollection)this.sourceBillCollection;
        HashSet<String> idSet = new HashSet<String>();
        for (int index = 0; index < srcColl.size(); ++index) {
            PaymentBillInfo info = (PaymentBillInfo)srcColl.get(index);
            idSet.add(info.getId().toString());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        view.setSelector(ArApSelectorFactory.getPayBillSelector(true));
        CoreBillBaseCollection coll = PaymentBillFactory.getLocalInstance(this.ctx).getCoreBillBaseCollection(view);
        this.veryBeforeVoucher(coll);
        coll = CashPamentBillUtil._generateVoucher(this.ctx, coll);
        Object map = null;
        BOTMappingInfo botMappingInfo = MappingCache.getInstance((Context)this.ctx).getMappingInfo(this.botMappingPK, this.ctx);
        this.helper.checkAgentRecPayIsPayed(this.ctx, (IObjectCollection)coll);
        this.helper.checkAcctViewIsValid(this.ctx, (IObjectCollection)coll);
        this.validColl = this.verifyInput(coll, botMappingInfo);
        HashMap<String, Integer> sortMap = new HashMap<String, Integer>();
        int volidSize = this.validColl.size();
        Object[] strPayNumbers = new String[volidSize];
        String strPayNumber = "";
        PaymentBillInfo recInfo = null;
        for (int i = 0; i < volidSize; ++i) {
            recInfo = this.validColl.get(i);
            strPayNumber = recInfo.getNumber();
            strPayNumbers[i] = strPayNumber;
            sortMap.put(strPayNumber, new Integer(i));
        }
        if (volidSize > 1) {
            Arrays.sort(strPayNumbers);
        }
        CoreBillBaseCollection sortColls = new CoreBillBaseCollection();
        for (int i = 0; i < volidSize; ++i) {
            sortColls.add((CoreBillBaseInfo)this.validColl.get((Integer)sortMap.get(strPayNumbers[i])));
        }
        return sortColls;
    }

    private void veryBeforeVoucher(CoreBillBaseCollection coll) throws BOSException, EASBizException {
        HashSet<String> companyIds = new HashSet<String>();
        IPermission iPermission = PermissionFactory.getLocalInstance((Context)this.ctx);
        for (int i = 0; i < coll.size(); ++i) {
            PaymentBillInfo info = (PaymentBillInfo)coll.get(i);
            if (companyIds.contains(info.getCompany().getId().toString())) continue;
            companyIds.add(info.getCompany().getId().toString());
            boolean hasPermission = iPermission.hasFunctionPermission(this.ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), "cas_paymentbill_11voucher");
            if (hasPermission) continue;
            throw new CasException(CasException.VOUCHERPERMISSION, new Object[]{info.getCompany().getName()});
        }
    }

    private void setAccountant(Context ctx, Set idSet, int isVouchered) throws BOSException {
        UserInfo userInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        if (idSet == null || idSet.size() < 1) {
            return;
        }
        String ids = FMHelper.setTran2String((Set)idSet);
        StringBuffer sql = new StringBuffer();
        sql.append(" UPDATE T_CAS_PaymentBill SET FAccountantID= ? ").append(" WHERE FID IN ").append(ids);
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{userInfo.getId().toString()});
    }

    protected PaymentBillCollection verifyInput(CoreBillBaseCollection coll, BOTMappingInfo botMappingInfo) throws EASBizException, BOSException {
        DefineSysEnum VoucherType = botMappingInfo.getDefineSys();
        PaymentBillCollection resultCol = new PaymentBillCollection();
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            PaymentBillInfo info = (PaymentBillInfo)coll.get(i);
            CompanyOrgUnitInfo companyInfo = info.getCompany();
            IContextHelper contextHelper = null;
            contextHelper = this.ctx == null ? ContextHelperFactory.getRemoteInstance() : ContextHelperFactory.getLocalInstance((Context)this.ctx);
            boolean val = contextHelper.getBooleanParam("CS017", (IObjectPK)new ObjectUuidPK(companyInfo.getId()));
            if (val) {
                if (info.getBillStatus().equals((Object)BillStatusEnum.PAYED)) {
                    resultCol.add(info);
                }
            } else if (info.getBillStatus().equals((Object)BillStatusEnum.AUDITED) || info.getBillStatus().equals((Object)BillStatusEnum.PAYED)) {
                resultCol.add(info);
            }
            if (VoucherType.getValue() == 50) {
                if (info.isPcaVouchered()) {
                    resultCol.add(info);
                }
            } else if (info.isFiVouchered()) {
                resultCol.add(info);
            }
            if (info.getSourceType() != SourceTypeEnum.AP) continue;
            this.helper.checkPayInfoAP(this.ctx, info);
        }
        return resultCol;
    }

    @Override
    public void afterService(CoreBillBaseCollection sourceBillCollection) throws EASBizException, BOSException {
        HashSet<String> validIdSet = new HashSet<String>();
        int size = this.validColl.size();
        for (int i = 0; i < size; ++i) {
            PaymentBillInfo info = this.validColl.get(i);
            this.serviceHandler.dispose(this.ctx, info, DisposerActionEnum.VOUCHER);
            validIdSet.add(info.getId().toString());
            IObjectPK pkOut = LogUtil.beginLog((Context)this.ctx, (String)EASResource.getString((String)"com.kingdee.eas.fi.ar.ARRecPayResource", (String)"PaymentBillCreateVo"), (BOSObjectType)BOSObjectType.create((String)"40284E81"), null, (String)info.getNumber(), (String)"cas_paymentBill_voucher");
            LogUtil.afterLog((Context)this.ctx, (IObjectPK)pkOut);
        }
        PaymentBillInfo info = null;
        CoreBillBaseCollection voucherColl = new CoreBillBaseCollection();
        int size2 = this.validColl.size();
        for (int i = 0; i < size2; ++i) {
            info = this.validColl.get(i);
            this.serviceHandler.dispose(this.ctx, info, DisposerActionEnum.VOUCHER);
            info = PaymentBillFactory.getLocalInstance(this.ctx).getPaymentBillInfo((IObjectPK)new ObjectUuidPK(info.getId().toString()));
            if (info.getVoucher() == null) continue;
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getVoucher().getId().toString(), CompareType.EQUALS));
            view.setFilter(filter);
            VoucherCollection voucherCollection = VoucherFactory.getLocalInstance((Context)this.ctx).getVoucherCollection(view);
            if (voucherCollection == null || voucherCollection.size() <= 0) continue;
            voucherColl.add((CoreBillBaseInfo)voucherCollection.get(0));
        }
        String billBizId = null;
        if (info != null && info.getSourceBillId() != null) {
            billBizId = info.getSourceBillId().toString();
        }
        InvoicePoolService.updateVoucherInfo((Context)this.ctx, billBizId, (IObjectCollection)voucherColl, (String)"update");
        this.setAccountant(this.ctx, validIdSet, 80);
    }
}

