/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.bot.BOTMappingCollection;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.bot.IBOTRelation;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BillStatusEnum;
import com.kingdee.eas.fi.cas.CasException;
import com.kingdee.eas.fi.cas.PaymentBillCollection;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.cas.app.SystemStatusCtrolUtils;
import com.kingdee.eas.fi.cas.utils.ArApSelectorFactory;
import com.kingdee.eas.fi.gl.VoucherCollection;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.UuidException;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Set;

public class PaymentBillVoucherAppointService {
    public static PaymentBillCollection getPaymentBillCollection(Context ctx, Set idSet) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        evi.setSelector(ArApSelectorFactory.getApPaymentBillSelector());
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        evi.setFilter(fi);
        return PaymentBillFactory.getLocalInstance(ctx).getPaymentBillCollection(evi);
    }

    public static BOTRelationCollection getRelatedBill(Context ctx, String paymentBillId, String srcBosType) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("srcObjectID");
        sic.add("destEntityID");
        evi.setSelector(sic);
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("destObjectID", (Object)paymentBillId, CompareType.EQUALS));
        fi.getFilterItems().add(new FilterItemInfo("srcEntityID", (Object)srcBosType, CompareType.EQUALS));
        fi.getFilterItems().add(new FilterItemInfo("destEntityID", (Object)"40284E81", CompareType.EQUALS));
        evi.setFilter(fi);
        return BOTRelationFactory.getLocalInstance((Context)ctx).getCollection(evi);
    }

    public static VoucherCollection getRelatedVoucher(Context ctx, String sourcebillid) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("cashier");
        sic.add("number");
        sic.add("voucherType");
        sic.add("period.*");
        evi.setSelector(sic);
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("sourcebillid", (Object)sourcebillid, CompareType.EQUALS));
        evi.setFilter(fi);
        return VoucherFactory.getLocalInstance((Context)ctx).getVoucherCollection(evi);
    }

    public static void appointVoucher(Context ctx, String paymentBillId, String voucherId) throws BOSException, EASBizException {
        PaymentBillInfo paymentBillInfo = PaymentBillFactory.getLocalInstance(ctx).getPaymentBillInfo((IObjectPK)new ObjectUuidPK(paymentBillId), ArApSelectorFactory.getApPaymentBillSelector());
        IObjectValue voucherInfo = VoucherFactory.getLocalInstance((Context)ctx).getVoucherWithoutPermissionCheck((IObjectPK)new ObjectUuidPK(voucherId), PaymentBillVoucherAppointService.getVoucherSelectors());
        PaymentBillVoucherAppointService.appointVoucher(ctx, paymentBillInfo, (VoucherInfo)voucherInfo);
    }

    private static SelectorItemCollection getVoucherSelectors() {
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("cashier");
        selectors.add("number");
        selectors.add("voucherType");
        selectors.add("period.*");
        return selectors;
    }

    private static void appointVoucher(Context ctx, PaymentBillInfo paymentBillInfo, VoucherInfo voucherInfo) throws BOSException, EASBizException {
        EntityObjectInfo entity = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity(paymentBillInfo.getBOSType());
        if (!paymentBillInfo.getBillStatus().equals((Object)BillStatusEnum.PAYED)) {
            throw new CasException(CasException.COMMMON, new Object[]{MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CasResource", (String)"53_ArApRecPayBillBaseListUI", (Locale)ctx.getLocale()), paymentBillInfo.getNumber(), entity.getAlias())});
        }
        if (paymentBillInfo.isIsInitializeBill()) {
            throw new CasException(CasException.COMMMON, new Object[]{MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CasResource", (String)"56_ArApRecPayBillBaseListUI", (Locale)ctx.getLocale()), paymentBillInfo.getNumber(), entity.getAlias())});
        }
        PeriodInfo apPeriodInfo = SystemStatusCtrolUtils.getStartPeriod(ctx, SystemEnum.ACCOUNTSPAYABLE, paymentBillInfo.getCompany());
        if (paymentBillInfo.getBizDate().before(apPeriodInfo.getBeginDate())) {
            throw new CasException(CasException.COMMMON, new Object[]{MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CasResource", (String)"56_ArApRecPayBillBaseListUI", (Locale)ctx.getLocale()), paymentBillInfo.getNumber(), entity.getAlias())});
        }
        if (!paymentBillInfo.isIsAppointVoucher() && paymentBillInfo.isFiVouchered()) {
            throw new CasException(CasException.COMMMON, new Object[]{MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CasResource", (String)"57_ArApRecPayBillBaseListUI", (Locale)ctx.getLocale()), paymentBillInfo.getNumber(), entity.getAlias())});
        }
        PeriodInfo periodInfo = SystemStatusCtrolUtils.getStartPeriod(ctx, SystemEnum.GENERALLEDGER, paymentBillInfo.getCompany());
        if (voucherInfo.getPeriod().getBeginDate().before(periodInfo.getBeginDate())) {
            throw new CasException(CasException.PAST_VOUCHERED_APPOINT_FORBIDDEN);
        }
        String accountantId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        String sql = "update T_CAS_PaymentBill  set FVoucherID = ?,FVoucherNumber = ?,FVoucherTypeID = ?,FIsAppointVoucher = 1,FFiVouchered = 1, FAccountantID = ? where fid = ?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{voucherInfo.getId().toString(), voucherInfo.getNumber(), voucherInfo.getVoucherType().getId().toString(), accountantId, paymentBillInfo.getId().toString()});
        PaymentBillVoucherAppointService.deleteBOTPRelation(ctx, paymentBillInfo.getId().toString());
        PaymentBillVoucherAppointService.createBOTPRelation(ctx, paymentBillInfo.getId().toString(), voucherInfo.getId().toString());
    }

    private static void deleteBOTPRelation(Context ctx, String srcObjectId) throws BOSException, UuidException {
        IBOTRelation iBOTRelation = BOTRelationFactory.getLocalInstance((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        String srcBosType = BOSUuid.read((String)srcObjectId).getType().toString();
        filterInfo.getFilterItems().add(new FilterItemInfo("srcEntityID", (Object)srcBosType, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("destEntityID", (Object)new VoucherInfo().getBOSType().toString(), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("srcObjectId", (Object)srcObjectId, CompareType.EQUALS));
        view.setFilter(filterInfo);
        BOTRelationCollection botRelationCollection = iBOTRelation.getCollection(view);
        if (!botRelationCollection.isEmpty()) {
            BOTRelationInfo rotpmap = botRelationCollection.get(0);
            ObjectStringPK pkbot = new ObjectStringPK(rotpmap.getId().toString());
            iBOTRelation.delete((IObjectPK)pkbot);
        }
    }

    private static void createBOTPRelation(Context ctx, String srcObjectId, String destObjectId) throws BOSException, UuidException {
        if (StringUtils.isEmpty((String)srcObjectId) || StringUtils.isEmpty((String)destObjectId)) {
            return;
        }
        IBOTRelation iBOTRelation = BOTRelationFactory.getLocalInstance((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        String srcBosType = BOSUuid.read((String)srcObjectId).getType().toString();
        String destBosType = BOSUuid.read((String)destObjectId).getType().toString();
        filterInfo.getFilterItems().add(new FilterItemInfo("destObjectID", (Object)destObjectId, CompareType.EQUALS));
        view.setFilter(filterInfo);
        BOTRelationCollection botRelationCollection = iBOTRelation.getCollection(view);
        if (botRelationCollection != null && botRelationCollection.size() > 0) {
            BOTRelationInfo rotpmap = botRelationCollection.get(0);
            BOTRelationInfo info = new BOTRelationInfo();
            info.setSrcEntityID(srcBosType);
            info.setDestEntityID(destBosType);
            info.setSrcObjectID(srcObjectId);
            info.setDestObjectID(destObjectId);
            info.setDate(new Date());
            info.setOperatorID("system");
            info.setIsEffected(true);
            info.setBOTMappingID(rotpmap.getBOTMappingID());
            info.setType(0);
            iBOTRelation.addnew(info);
        } else {
            BOTRelationInfo info = new BOTRelationInfo();
            info.setSrcEntityID(srcBosType);
            info.setDestEntityID(destBosType);
            info.setSrcObjectID(srcObjectId);
            info.setDestObjectID(destObjectId);
            info.setDate(new Date());
            info.setOperatorID("system");
            info.setIsEffected(true);
            BOTMappingCollection botMappingColl = BOTMappingFactory.getLocalInstance((Context)ctx).getBOTMappingCollection(" select id where SrcEntityName='40284E81' and DestEntityName='2652E01E'");
            if (botMappingColl != null && botMappingColl.size() > 0) {
                info.setBOTMappingID(botMappingColl.get(0).getId().toString());
            }
            info.setType(0);
            iBOTRelation.addnew(info);
        }
    }
}

