/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.ExpenseTypeSubjectMappingCollection;
import com.kingdee.eas.cp.bc.ExpenseTypeSubjectMappingFactory;
import com.kingdee.eas.fi.cas.CasDataException;
import com.kingdee.eas.fi.cas.RecPayException;
import com.kingdee.eas.fi.cas.ReceivingBillEntryCollection;
import com.kingdee.eas.fi.cas.ReceivingBillEntryInfo;
import com.kingdee.eas.fi.cas.ReceivingBillInfo;
import com.kingdee.eas.fi.cas.SettlementStatusEnum;
import com.kingdee.eas.fi.cas.SourceTypeEnum;
import com.kingdee.eas.fi.cas.app.service.IRecAddNewService;
import com.kingdee.eas.fi.cas.app.service.handler.ServiceHandler;
import com.kingdee.eas.fm.common.util.AccountCurrencyVerifyUtil;
import com.kingdee.eas.fm.fin.app.LoanReverseHelper;
import com.kingdee.eas.fm.ivt.FinancingRedeemInfo;
import com.kingdee.eas.fm.nt.LetterOfCreditReceiveInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.app.DbUtil;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class RecAddNewService
implements IRecAddNewService {
    private static Logger logger = Logger.getLogger((String)RecAddNewService.class.getName());
    protected Context ctx;
    protected ReceivingBillInfo info;
    IObjectPK pkOut;
    protected ServiceHandler serviceHandler;

    protected ServiceHandler getServiceHandler() {
        return new ServiceHandler();
    }

    @Override
    public void initService(Context ctx, ReceivingBillInfo info) throws EASBizException, BOSException {
        this.ctx = ctx;
        this.info = info;
        this.serviceHandler = this.getServiceHandler();
        boolean addPast = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("CS103", (IObjectPK)new ObjectUuidPK(info.getCompany().getId()));
        if (!addPast && !SourceTypeEnum.AR.equals((Object)info.getSourceType())) {
            PeriodInfo periodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)info.getCompany());
            if (periodInfo == null) {
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("name"));
                CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(info.getCompany().getId()), sic);
                throw new RecPayException(RecPayException.REC_PERIODNOTNULL, new Object[]{company.getName()});
            }
            if (EmptyUtil.isEmpty((Object)info.getBizDate())) {
                throw new CasDataException(CasDataException.BIZDATENOTNULL);
            }
            if (info.getBizDate().before(periodInfo.getBeginDate())) {
                throw new RecPayException(RecPayException.CANNOTADDPASTBILL);
            }
        }
    }

    @Override
    public void beforeService() throws EASBizException, BOSException {
        this.serviceHandler.setCommonPropertyValue(this.ctx, this.info);
        this.setProperties();
        this.checkAccountAndCurrency();
        this.serviceHandler.initAndCheckNumber(this.ctx, (IObjectValue)this.info, 2);
        this.logger();
        if (this.info.getSourceBillId() != null) {
            this.setEntries_oppAccount(this.ctx, this.info);
        }
    }

    @Override
    public void afterService() throws EASBizException, BOSException {
        String sql;
        LoanReverseHelper.getInstance().receivingBillSubmited(this.ctx, this.info.getSourceBillId(), this.info.getId().toString());
        if (this.isGenFromFinRedeem(this.info.getSourceBillId())) {
            sql = "update T_IVT_FinancingRedeem SET FISGENEGATERBILL = 1 where fid= ? ";
            DbUtil.execute((Context)this.ctx, (String)sql, (Object[])new Object[]{this.info.getSourceBillId()});
        }
        if (this.isGenFromLetterOfCreditRec(this.info.getSourceBillId())) {
            sql = "update T_NT_LetterOfCreditReceive SET FIsGenRecBill = 1 where fid= ? ";
            DbUtil.execute((Context)this.ctx, (String)sql, (Object[])new Object[]{this.info.getSourceBillId()});
        }
        LogUtil.afterLog((Context)this.ctx, (IObjectPK)this.pkOut);
    }

    private boolean isGenFromFinRedeem(String sourceBillId) {
        if (BOSUuid.isValid((String)sourceBillId, (boolean)true)) {
            BOSUuid uuid = BOSUuid.read((String)sourceBillId);
            BOSObjectType bosType = uuid.getType();
            return bosType.equals((Object)FinancingRedeemInfo.BOSTYPE);
        }
        return false;
    }

    private boolean isGenFromLetterOfCreditRec(String sourceBillId) {
        if (BOSUuid.isValid((String)sourceBillId, (boolean)true)) {
            BOSUuid uuid = BOSUuid.read((String)sourceBillId);
            BOSObjectType bosType = uuid.getType();
            return bosType.equals((Object)new LetterOfCreditReceiveInfo().getBOSType());
        }
        return false;
    }

    private void logger() {
        this.pkOut = LogUtil.beginLog((Context)this.ctx, null, (BOSObjectType)this.info.getBOSType(), null, (String)this.info.getLogInfo(), (String)"cas_receivingBill_add");
    }

    private void setProperties() {
        if (this.info.getCompany() == null) {
            this.info.setCompany(ContextHelperFactory.getLocalInstance((Context)this.ctx).getCurrentCompany());
        }
        if (this.info.getSettlementStatus() == null) {
            this.info.setSettlementStatus(SettlementStatusEnum.UNSUBMIT);
        }
        if (EmptyUtil.isEmpty((CoreBaseInfo)this.info.getCU())) {
            CompanyOrgUnitInfo companyInfo = this.info.getCompany();
            if (EmptyUtil.isEmpty((CoreBaseInfo)companyInfo.getCU())) {
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("CU"));
                try {
                    companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)this.ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyInfo.getId()), sic);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.info.setCU(companyInfo.getCU());
        }
        int size = this.info.getEntries().size();
        for (int i = 0; i < size; ++i) {
            ReceivingBillEntryInfo receivingBillEntryInfo = this.info.getEntries().get(i);
            if (receivingBillEntryInfo.getAmount() == null || receivingBillEntryInfo.getAmount() != null && receivingBillEntryInfo.getAmount().equals(Constants.ZERO)) {
                receivingBillEntryInfo.setAmount(receivingBillEntryInfo.getActualAmt());
                receivingBillEntryInfo.setRebate(Constants.ZERO);
            }
            if (receivingBillEntryInfo.getLocalAmt() != null && (receivingBillEntryInfo.getLocalAmt() == null || !receivingBillEntryInfo.getLocalAmt().equals(Constants.ZERO))) continue;
            receivingBillEntryInfo.setLocalAmt(receivingBillEntryInfo.getActualLocAmt());
            receivingBillEntryInfo.setRebateLocAmt(Constants.ZERO);
        }
        if (EmptyUtil.isEmpty((CoreBaseInfo)this.info.getLastUpdateUser())) {
            this.info.setLastUpdateUser(this.info.getCreator());
            this.info.setLastUpdateTime(this.info.getCreateTime());
        }
        if (0 == this.info.getPrintCount()) {
            this.info.setPrintCount(1);
        }
    }

    private void checkAccountAndCurrency() throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("accountingcurrency"));
        sic.add(new SelectorItemInfo("accountCurrency.id"));
        sic.add(new SelectorItemInfo("accountCurrency.currency"));
        sic.add(new SelectorItemInfo("accountCurrency.currency.id"));
        AccountViewInfo account = null;
        boolean val = ContextHelperFactory.getLocalInstance((Context)this.ctx).getBooleanParam("CS063", (IObjectPK)new ObjectUuidPK(this.info.getCompany().getId()));
        CurrencyInfo localCurrency = ContextHelperFactory.getLocalInstance((Context)this.ctx).getCompanyBaseCurrency(this.info.getCompany());
        if (this.info.getPayeeAccount() != null) {
            account = AccountViewFactory.getLocalInstance((Context)this.ctx).getAccountViewInfo((IObjectPK)new ObjectUuidPK(this.info.getPayeeAccount().getId()), sic);
            AccountCurrencyVerifyUtil.verifyAccountCurrency((Context)this.ctx, (AccountViewInfo)account, (String)this.info.getCurrency().getId().toString(), (String)localCurrency.getId().toString());
        }
        if (this.info.getOppAccount() != null && val) {
            account = AccountViewFactory.getLocalInstance((Context)this.ctx).getAccountViewInfo((IObjectPK)new ObjectUuidPK(this.info.getOppAccount().getId()), sic);
            AccountCurrencyVerifyUtil.verifyAccountCurrency((Context)this.ctx, (AccountViewInfo)account, (String)this.info.getCurrency().getId().toString(), (String)localCurrency.getId().toString());
        }
    }

    private void setEntries_oppAccount(Context ctx, ReceivingBillInfo info) {
        ReceivingBillEntryCollection entries = info.getEntries();
        Iterator it = entries.iterator();
        while (it.hasNext()) {
            ReceivingBillEntryInfo entryInfo = (ReceivingBillEntryInfo)it.next();
            if (entryInfo.getOppAccount() != null || entryInfo.getExpenseType() == null) continue;
            try {
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                view.setFilter(filter);
                SelectorItemCollection sic = new SelectorItemCollection();
                view.setSelector(sic);
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("loanAccountID.*"));
                filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)info.getCompany().getId()));
                filter.getFilterItems().add(new FilterItemInfo("expenseTypeId.id", (Object)entryInfo.getExpenseType().getId()));
                ExpenseTypeSubjectMappingCollection colls = ExpenseTypeSubjectMappingFactory.getLocalInstance((Context)ctx).getExpenseTypeSubjectMappingCollection(view);
                if (colls == null || colls.size() <= 0) continue;
                entryInfo.setOppAccount(colls.get(0).getLoanAccountID());
            }
            catch (BOSException e) {
                logger.error((Object)e);
            }
        }
    }
}

