/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.ArApRecPayException;
import com.kingdee.eas.fi.cas.BgCtrlReceivingBillHandler;
import com.kingdee.eas.fi.cas.CasForArApException;
import com.kingdee.eas.fi.cas.CasRecPayBillTypeEnum;
import com.kingdee.eas.fi.cas.DisposerActionEnum;
import com.kingdee.eas.fi.cas.RecPayBgCtrlStrEnum;
import com.kingdee.eas.fi.cas.RecPayException;
import com.kingdee.eas.fi.cas.RecPayHelper;
import com.kingdee.eas.fi.cas.ReceivingBillCollection;
import com.kingdee.eas.fi.cas.ReceivingBillInfo;
import com.kingdee.eas.fi.cas.SettlementStatusEnum;
import com.kingdee.eas.fi.cas.SourceTypeEnum;
import com.kingdee.eas.fi.cas.app.AgentRecPayServerHelper;
import com.kingdee.eas.fi.cas.app.ArApRecPayServerHelper;
import com.kingdee.eas.fi.cas.app.service.IRecAntiAuditService;
import com.kingdee.eas.fi.cas.app.service.handler.ServiceHandler;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.fpl.FpCtrlFacadeFactory;
import com.kingdee.eas.fm.fpl.IFpCtrlFacade;
import com.kingdee.eas.fm.rpm.RPDMatchResultCollection;
import com.kingdee.eas.fm.rpm.RPDMatchResultFactory;
import com.kingdee.eas.fm.rpm.RPMException;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.ma.nbudget.BgControlCaller;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class RecAntiAuditService
implements IRecAntiAuditService {
    private static Logger logger = Logger.getLogger((String)RecAntiAuditService.class.getName());
    protected Context ctx;
    protected Set idSet;
    protected Map map;
    protected ServiceHandler serviceHandler;
    protected RecPayHelper helper;
    protected UserInfo userInfo = null;
    protected String value = null;
    protected Map paramMap = new HashMap();

    @Override
    public void initService(Context ctx, Set idSet) throws EASBizException, BOSException {
        this.ctx = ctx;
        this.serviceHandler = this.getServiceHandler();
        this.helper = new RecPayHelper();
        this.idSet = idSet;
        this.userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
    }

    protected ServiceHandler getServiceHandler() {
        return new ServiceHandler();
    }

    @Override
    public void doService() throws EASBizException, BOSException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("billStatus");
        selector.add("isBookRL");
        selector.add("sourceType");
        selector.add("company.*");
        selector.add("company.id");
        selector.add("company.number");
        selector.add("company.name");
        selector.add("company.accountTable");
        selector.add("company.accountTable.id");
        selector.add("isrefundmentPay");
        selector.add("company.baseCurrency.id");
        selector.add("creator");
        selector.add("settlementType");
        selector.add("bizDate");
        selector.add("isInitializeBill");
        selector.add("number");
        selector.add("entries.sourceBillId");
        selector.add("entries.sourceBillEntryId");
        selector.add("entries.unLockAmt");
        selector.add("entries.unLockLocAmt");
        selector.add("entries.lockAmt");
        selector.add("entries.lockLocAmt");
        selector.add("entries.amount");
        selector.add("entries.localAmt");
        selector.add("payeeAccount");
        selector.add("payeeAccountBank");
        selector.add("payeeBank");
        selector.add("sourceBillId");
        selector.add("settlementStatus");
        selector.add("fiVouchered");
        selector.add("pcaVouchered");
        selector.add("auditor");
        selector.add("realRecBillID");
        ReceivingBillCollection coll = ServiceHandler.getRecBillCollection(this.ctx, this.idSet, selector);
        ReceivingBillInfo info = null;
        for (int i = 0; i < coll.size(); ++i) {
            info = coll.get(i);
            this.verify(info);
        }
        String ids = FMHelper.setTran2String((Set)this.idSet);
        String sql = "UPDATE T_CAS_ReceivingBill SET FAuditorID = null,FAuditDate = null,FBillStatus = ? WHERE FID IN " + ids + " AND FSourceType <> 100 ";
        Integer status = new Integer(10);
        DbUtil.execute((Context)this.ctx, (String)sql, (Object[])new Object[]{status});
        String billId = null;
        IFpCtrlFacade iFpCtrlFacade = FpCtrlFacadeFactory.getLocalInstance((Context)this.ctx);
        Object userInfo = null;
        for (int i = 0; i < coll.size(); ++i) {
            info = coll.get(i);
            billId = info.getId().toString();
            ArApRecPayServerHelper.injectBizFlow(this.ctx, (IObjectValue)info, BatchActionEnum.UNAUDIT);
            this.serviceHandler.dispose(this.ctx, info, DisposerActionEnum.ANTI_AUDIT);
            if (CasRecPayBillTypeEnum.AgentType.equals((Object)info.getReceivingBillType())) {
                AgentRecPayServerHelper.deleteRealRecReceivingBill(this.ctx, info);
            }
            iFpCtrlFacade.innerMomitorCancel(billId);
            if (!this.paramMap.containsKey(info.getCompany().getId().toString() + "CS042")) {
                this.value = ParamManager.getParamValue((Context)this.ctx, (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)"CS042");
                this.paramMap.put(info.getCompany().getId().toString(), this.value);
            } else {
                this.value = this.paramMap.get(info.getCompany().getId().toString() + "CS042").toString();
            }
            if (!StringUtils.isEmpty((String)this.value)) {
                this.serviceHandler.cancelRequestBudget(this.ctx, billId, RecPayBgCtrlStrEnum.Audit_Sub, (int)Integer.valueOf(this.value));
                if (Integer.valueOf(this.value) == 1 && info.getSourceType() != null && SourceTypeEnum.AR.equals((Object)info.getSourceType())) {
                    BgControlCaller caller = new BgControlCaller();
                    caller.returnBudget(this.ctx, BOSUuid.read((String)billId));
                }
            }
            if (!this.paramMap.containsKey(info.getCompany().getId().toString() + "CS079")) {
                this.value = ParamManager.getParamValue((Context)this.ctx, (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)"CS079");
                this.paramMap.put(info.getCompany().getId().toString(), this.value);
            } else {
                this.value = this.paramMap.get(info.getCompany().getId().toString() + "CS079").toString();
            }
            if (this.value == null || !"true".equalsIgnoreCase(this.value) && !"1".equalsIgnoreCase(this.value)) continue;
            String boName = "com.kingdee.eas.fi.cas.app.ReceivingBill";
            String handleName = BgCtrlReceivingBillHandler.class.getName();
            RecPayHelper.OnWaybgCtrl(this.ctx, billId, boName, handleName);
        }
        String arSql = "UPDATE T_CAS_ReceivingBill SET FAuditorID = null,FAuditDate = null,FBillStatus = ? WHERE FID IN " + ids + " AND FSourceType = 100 ";
        Integer arStatus = new Integer(10);
        DbUtil.execute((Context)this.ctx, (String)arSql, (Object[])new Object[]{arStatus});
    }

    protected void verify(ReceivingBillInfo info) throws CasForArApException, EASBizException, BOSException {
        if (info.getBillStatus() != null) {
            int billStatus = info.getBillStatus().getValue();
            if (billStatus >= 14) {
                throw new RecPayException(ArApRecPayException.CANNOT_ANTIAUDIT_ONRECED);
            }
            if (billStatus < 12) {
                throw new RecPayException(ArApRecPayException.CANNOT_ANTIAUDIT_NOT_AUDIT);
            }
            if (info.isFiVouchered()) {
                throw new ArApRecPayException(ArApRecPayException.CANNOT_ANTIAUDIT_VOUCHERED);
            }
            if (info.isPcaVouchered()) {
                throw new ArApRecPayException(ArApRecPayException.CANNOT_ANTIAUDIT_PCAVOUCHERED);
            }
            if (!info.getSettlementStatus().equals((Object)SettlementStatusEnum.UNSUBMIT)) {
                throw new RecPayException(RecPayException.CANNOT_ANTIAUDIT_ONCOMMITTED);
            }
        }
        this.verifyRecDeatilMatchResult(this.ctx, info);
        if (info.getSourceType() == SourceTypeEnum.AR) {
            this.serviceHandler.checkIsInQueue(this.ctx, info);
        }
        if (info.isIsBookRL()) {
            throw new RecPayException(RecPayException.HASBOOKGL);
        }
        if (info.getSourceType() == SourceTypeEnum.AR) {
            if (info.isIsRefundmentPay()) {
                StringBuffer checksql = new StringBuffer();
                checksql.append("select fid from t_cas_paymentbill where fsourcebillid = '").append(info.getId().toString()).append("'");
                String sql = checksql.toString();
                IRowSet rows = DbUtil.executeQuery((Context)this.ctx, (String)sql);
                try {
                    if (rows.next()) {
                        throw new ArApRecPayException(ArApRecPayException.BILL_HAS_NEXT);
                    }
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
            }
            SystemStatusCtrolInfo arapStatus = ArApRecPayServerHelper.getSysStatusCtrolInfo(this.ctx, info.getCompany(), SystemEnum.ACCOUNTSRECEIVABLE);
            if (info.getBizDate() != null && arapStatus.getCurrentPeriod() != null && (info.isIsInitializeBill() || info.getBizDate().before(arapStatus.getCurrentPeriod().getBeginDate()))) {
                throw new ArApRecPayException(ArApRecPayException.INITBILLNOANTIAUDIT);
            }
            if (!this.paramMap.containsKey(info.getCompany().getId().toString())) {
                this.value = ParamManager.getParamValue((Context)this.ctx, (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)"AR_034");
                this.paramMap.put(info.getCompany().getId().toString(), this.value);
            } else {
                this.value = this.paramMap.get(info.getCompany().getId().toString()).toString();
            }
            if (this.value != null && ("true".equalsIgnoreCase(this.value) || "1".equalsIgnoreCase(this.value)) && this.userInfo != null && info.getAuditor() != null && !this.userInfo.getId().toString().equals(info.getAuditor().getId().toString())) {
                throw new ArApRecPayException(ArApRecPayException.ARAPBILL_IS_SAMEAUDITOR_PERSON);
            }
        }
    }

    private void verifyRecDeatilMatchResult(Context ctx, ReceivingBillInfo info) throws BOSException, RPMException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("resultType", (Object)1));
        filter.getFilterItems().add(new FilterItemInfo("bizObjectId", (Object)info.getId().toString()));
        view.setFilter(filter);
        RPDMatchResultCollection coll = RPDMatchResultFactory.getLocalInstance((Context)ctx).getRPDMatchResultCollection(view);
        if (coll.size() > 0) {
            throw new RPMException(RPMException.NOANTIAUDIT);
        }
    }
}

