/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.ArApRecPayException;
import com.kingdee.eas.fi.cas.BillStatusEnum;
import com.kingdee.eas.fi.cas.CasForArApException;
import com.kingdee.eas.fi.cas.CasForArApUtil;
import com.kingdee.eas.fi.cas.DisposerActionEnum;
import com.kingdee.eas.fi.cas.RecPayAcctBankStratageCtrl;
import com.kingdee.eas.fi.cas.RecPayBgCtrlStrEnum;
import com.kingdee.eas.fi.cas.RecPayException;
import com.kingdee.eas.fi.cas.RecPayHelper;
import com.kingdee.eas.fi.cas.RecPayOverDraftCtrlEnum;
import com.kingdee.eas.fi.cas.ReceivingBillCollection;
import com.kingdee.eas.fi.cas.ReceivingBillFactory;
import com.kingdee.eas.fi.cas.ReceivingBillInfo;
import com.kingdee.eas.fi.cas.SourceTypeEnum;
import com.kingdee.eas.fi.cas.app.ArApRecPayServerHelper;
import com.kingdee.eas.fi.cas.app.service.IRecAuditService;
import com.kingdee.eas.fi.cas.app.service.handler.ServiceHandler;
import com.kingdee.eas.fi.cas.utils.PayProcessUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import java.sql.Timestamp;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class RecAuditService
implements IRecAuditService {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.cas.app.RecAuditService");
    protected Context ctx;
    protected Set idSet;
    protected UserInfo userInfo;
    protected CompanyOrgUnitInfo companyInfo;
    protected boolean valCS004;
    protected boolean cs025;
    protected int cs052;
    RecPayHelper helper = new RecPayHelper();
    protected IContextHelper contextHelper;
    protected ServiceHandler serviceHandler;
    protected String sql = "UPDATE T_CAS_ReceivingBill SET FAuditorID = ?, FAuditDate = ?, FBillStatus = ? WHERE FID = ?";
    protected Integer status = new Integer(12);
    String resourcePath = "com.kingdee.eas.fi.ar.ARRecPayResource";

    protected ServiceHandler getServiceHandler() {
        return new ServiceHandler();
    }

    @Override
    public void initService(Context ctx, Set idSet) throws EASBizException, BOSException {
        this.ctx = ctx;
        this.idSet = idSet;
        this.serviceHandler = this.getServiceHandler();
        this.contextHelper = ContextHelperFactory.getLocalInstance((Context)ctx);
        this.userInfo = this.contextHelper.getCurrentUser();
        this.companyInfo = this.contextHelper.getCurrentCompany();
        ObjectUuidPK orgPK = new ObjectUuidPK(this.companyInfo.getId());
        this.valCS004 = this.contextHelper.getBooleanParam("CS004", (IObjectPK)orgPK);
        this.cs025 = this.contextHelper.getBooleanParam("CS025", (IObjectPK)orgPK);
        this.cs052 = this.contextHelper.getIntParam("CS052", (IObjectPK)orgPK);
    }

    @Override
    public void doService(Context ctx) throws EASBizException, BOSException {
        Set validSet;
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("billStatus");
        selector.add("sourceType");
        selector.add("company");
        selector.add("company.number");
        selector.add("actRecAmt");
        selector.add("currency.id");
        selector.add("company.baseCurrency.id");
        selector.add("creator");
        selector.add("lastUpdateUser");
        selector.add("settlementType");
        selector.add("bizDate");
        selector.add("isInitializeBill");
        selector.add("number");
        selector.add("entries.sourceBillId");
        selector.add("entries.sourceBillEntryId");
        selector.add("entries.unLockAmt");
        selector.add("entries.unLockLocAmt");
        selector.add("entries.lockAmt");
        selector.add("entries.lockLocAmt");
        selector.add("entries.amount");
        selector.add("entries.localAmt");
        selector.add("payeeAccount");
        selector.add("bizType.type");
        selector.add("bizType.notSubmitHouse");
        selector.add("payeeAccountBank.id");
        selector.add("payeeAccountBank.InnerAcct.clearingHouse.inGroup");
        selector.add("payeeAccountBank.InnerAcct");
        selector.add("payeeBank");
        selector.add("sourceBillId");
        selector.add("settlementStatus");
        selector.add("realRecCompany");
        selector.add("isRefundmentPay");
        selector.add("payerID");
        selector.add("payeeAccount");
        selector.add("payeeAccount.*");
        selector.add("payeeAccountBank");
        selector.add("recBillType.id");
        selector.add("recBillType.number");
        selector.add("recBillType.preSetBillType.id");
        selector.add("isSmart");
        ReceivingBillCollection coll = ServiceHandler.getRecBillCollection(ctx, this.idSet, selector);
        this.verify(coll);
        ReceivingBillInfo info = null;
        for (int i = 0; i < coll.size(); ++i) {
            info = coll.get(i);
            ObjectUuidPK orgPK = new ObjectUuidPK(info.getCompany().getId());
            int overCtrlParam = this.contextHelper.getIntParam("CS052", (IObjectPK)orgPK);
            this.serviceHandler.overDraftCtrls(ctx, (IObjectValue)info, RecPayOverDraftCtrlEnum.audit_ctrl, overCtrlParam);
            this.audit(info);
        }
        if (coll != null && coll.get(0) != null && (coll.get(0).getIsSmart() != null && coll.get(0).getIsSmart().getValue() == 5 || this.companyInfo != null && !this.companyInfo.getId().toString().equals(coll.get(0).getCompany().getId().toString()))) {
            ObjectUuidPK orgPK = new ObjectUuidPK(coll.get(0).getCompany().getId());
            this.cs025 = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("CS025", (IObjectPK)orgPK);
        }
        if (this.cs025 && (validSet = this.helper.getRecValidIdSetByCommit(ctx, coll)).size() > 0) {
            ReceivingBillFactory.getLocalInstance(ctx).commitSettle(validSet);
        }
    }

    protected void verify(ReceivingBillCollection coll) throws BOSException, EASBizException {
        HashSet<String> idSet = new HashSet<String>();
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            ReceivingBillInfo info = coll.get(i);
            if (info.getBillStatus() != null) {
                int billStatus = info.getBillStatus().getValue();
                if (billStatus < 11) {
                    throw new RecPayException(ArApRecPayException.CANNOT_AUDIT_NOT_SUBMIT);
                }
                if (billStatus >= 12) {
                    throw new RecPayException(ArApRecPayException.CANNOT_MULTI_AUDIT);
                }
            }
            PayProcessUtil.checkIfCanRefundPay(info);
            idSet.add(info.getId().toString());
        }
        PayProcessUtil.checkIfHadRefundPaymentBill(this.ctx, idSet);
    }

    protected void audit(ReceivingBillInfo info) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(info.getId().toString());
        IContextHelper localInstance = ContextHelperFactory.getLocalInstance((Context)this.ctx);
        ObjectUuidPK companyPK = new ObjectUuidPK(localInstance.getCurrentCompany().getId());
        int val = localInstance.getIntParam("CS042", (IObjectPK)companyPK);
        int val2 = localInstance.getIntParam("CS052", (IObjectPK)companyPK);
        this.bgCtrlAndAudit(this.ctx, (IObjectPK)pk, RecPayBgCtrlStrEnum.Audit_Sub, val);
        this.overDraftCtrls(this.ctx, (IObjectPK)pk, RecPayOverDraftCtrlEnum.audit_ctrl, val2);
        if (info.getSourceType() == SourceTypeEnum.CASH) {
            if (this.valCS004 && info.getSourceType() != SourceTypeEnum.AP) {
                String creatorId = info.getCreator().getId().toString();
                if (EmptyUtil.isEmpty((CoreBaseInfo)info.getLastUpdateUser())) {
                    info.setLastUpdateUser(info.getCreator());
                }
                String updaterId = info.getLastUpdateUser().getId().toString();
                if (this.userInfo.getId().toString().equals(creatorId) || this.userInfo.getId().toString().equals(updaterId)) {
                    throw new RecPayException(RecPayException.REC_AUDITOR_CANNOT_BE_CREATOR);
                }
            }
        } else if (info.getSourceType() == SourceTypeEnum.AR) {
            this.serviceHandler.checkIsInQueue(this.ctx, info);
            String message = "";
            if (info.getPayeeAccount() == null) {
                message = message + " " + ResourceBase.getString((String)this.resourcePath, (String)"payeeAccount", (Locale)this.ctx.getLocale());
            }
            if (!"".equals(message)) {
                throw new EASBizException(EASBizException.CHECKBLANK, (Object[])new String[]{message});
            }
            SystemStatusCtrolInfo arapStatus = ArApRecPayServerHelper.getSysStatusCtrolInfo(this.ctx, info.getCompany(), SystemEnum.ACCOUNTSRECEIVABLE);
            if (info.getBizDate() != null && arapStatus.getCurrentPeriod() != null) {
                boolean periodFlag = info.getBizDate().before(arapStatus.getCurrentPeriod().getBeginDate());
                if (info.isIsInitializeBill() || periodFlag) {
                    throw new ArApRecPayException(ArApRecPayException.INITBILLNOAUDIT);
                }
            }
            if (info.isIsRefundmentPay()) {
                if (info.getPayeeAccount().isIsCash() || info.getPayeeAccount().isIsBank()) {
                    throw new ArApRecPayException(ArApRecPayException.REFUNDMENTPAYRECACCOUNT);
                }
                if (info.getPayeeAccountBank() != null) {
                    throw new ArApRecPayException(ArApRecPayException.REFUNDMENTPAYRECBANK);
                }
                if (info.getPayerID() == null) {
                    throw new ArApRecPayException(ArApRecPayException.REFUNDMENTPAYERISNULL);
                }
            }
            if (info.getSourceType() == SourceTypeEnum.AR && this.contextHelper.getBooleanParam("ARBILL_IS_SAME_PERSON", (IObjectPK)new ObjectUuidPK(info.getCompany().getId().toString())) && CasForArApUtil.idEquals((CoreBaseInfo)info.getCreator(), (CoreBaseInfo)this.userInfo)) {
                throw new CasForArApException(CasForArApException.ARAPBILL_IS_SAME_PERSON);
            }
        }
        ArApRecPayServerHelper.injectBizFlow(this.ctx, (IObjectValue)info, BatchActionEnum.AUDIT);
        DisposerActionEnum disposerActionEnum = DisposerActionEnum.AUDIT;
        this.serviceHandler.dispose(this.ctx, info, disposerActionEnum);
        Timestamp currTime = new Timestamp(System.currentTimeMillis());
        logger.info((Object)ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"216_RecAuditService", (Locale)this.ctx.getLocale()));
        DbUtil.execute((Context)this.ctx, (String)this.sql, (Object[])new Object[]{this.userInfo.getId().toString(), currTime, this.status, pk.toString()});
        info.setBillStatus(BillStatusEnum.AUDITED);
    }

    private void bgCtrlAndAudit(Context ctx, IObjectPK pk, RecPayBgCtrlStrEnum enums, int val) throws BOSException, EASBizException {
        String billId = pk.toString();
        if (enums.getValue() == val) {
            RecPayHelper.bgCtrlAudit(ctx, billId);
        }
    }

    private void overDraftCtrls(Context ctx, IObjectPK pk, RecPayOverDraftCtrlEnum enums, int val) throws BOSException, EASBizException {
        if (enums.getValue() - 1 == val) {
            RecPayAcctBankStratageCtrl.acctBankBalanceCtrl(ctx, pk);
        }
    }
}

