/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.RecPayException;
import com.kingdee.eas.fi.cas.RecPayHelper;
import com.kingdee.eas.fi.cas.ReceivingBillCollection;
import com.kingdee.eas.fi.cas.ReceivingBillFactory;
import com.kingdee.eas.fi.cas.ReceivingBillInfo;
import com.kingdee.eas.fi.cas.SettlementStatusEnum;
import com.kingdee.eas.fi.cas.SourceTypeEnum;
import com.kingdee.eas.fi.cas.app.service.IRecCommitSettleService;
import com.kingdee.eas.fi.cas.app.service.handler.ServiceHandler;
import com.kingdee.eas.fm.common.FMVerifyHelper;
import com.kingdee.eas.fm.fs.InnerAccountFactory;
import com.kingdee.eas.fm.fs.InnerAccountInfo;
import com.kingdee.eas.fm.fs.SettBizTypeEnum;
import com.kingdee.eas.fm.fs.SettBizTypeInfo;
import com.kingdee.eas.fm.fs.SettlementBillFactory;
import com.kingdee.eas.fm.fs.SettlementBillInfo;
import com.kingdee.eas.util.app.DbUtil;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class RecCommitSettleService
implements IRecCommitSettleService {
    private static Logger logger = Logger.getLogger((String)RecCommitSettleService.class.getName());
    protected Context ctx;
    RecPayHelper helper = new RecPayHelper();
    Set validSet = new HashSet();
    protected ServiceHandler serviceHandler;

    protected ServiceHandler getServiceHandler() {
        return new ServiceHandler();
    }

    @Override
    public void doService(Context ctx, Set s) throws EASBizException, BOSException {
        int i;
        this.serviceHandler = this.getServiceHandler();
        Set validSet = this.helper.getRecValidIdSetByAction(ctx, s, 40);
        this.lockedIds(ctx, new ArrayList(validSet));
        ReceivingBillCollection coll = RecPayHelper.getRecColl(ctx, validSet);
        if (coll.size() == 0) {
            return;
        }
        BankInfo bankInfo = null;
        SettBizTypeInfo settBizTypeInfo = null;
        int size = coll.size();
        for (i = 0; i < size; ++i) {
            AccountBankInfo payeeAcctBankInfo;
            InnerAccountInfo innerAcctBank;
            SettlementBillInfo settlement;
            BOSUuid sbid;
            ReceivingBillInfo info = coll.get(i);
            if (info.getSourceBillId() != null && (sbid = BOSUuid.read((String)info.getSourceBillId())).getType().equals((Object)new SettlementBillInfo().getBOSType()) && (settlement = SettlementBillFactory.getLocalInstance((Context)ctx).getSettlementBillInfo((IObjectPK)new ObjectUuidPK(info.getSourceBillId()))).getType().equals((Object)SettBizTypeEnum.LINKPAY)) {
                throw new RecPayException(RecPayException.CANNOTDELLINKPAYREC);
            }
            if (info.getSourceType() == SourceTypeEnum.AR) {
                this.serviceHandler.checkIsInQueue(ctx, info);
            }
            if ((innerAcctBank = (payeeAcctBankInfo = info.getPayeeAccountBank()).getInnerAcct()) == null) {
                throw new RecPayException(RecPayException.PAYEEACCTNOTINNERACCT);
            }
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("*");
            sic.add("clearingHouse.*");
            innerAcctBank = InnerAccountFactory.getLocalInstance((Context)ctx).getInnerAccountInfo((IObjectPK)new ObjectUuidPK(innerAcctBank.getId()), sic);
            bankInfo = innerAcctBank.getClearingHouse();
            settBizTypeInfo = info.getBizType();
            if (bankInfo == null || !bankInfo.isInGroup()) {
                throw new RecPayException(RecPayException.PAYEEBANK_CAN_BE_INGROUP);
            }
            if (settBizTypeInfo == null) {
                throw new RecPayException(RecPayException.SETTBIZTYPE_CANNOT_NULL);
            }
            if (info.getSettlementStatus().equals((Object)SettlementStatusEnum.SUBMITED)) {
                throw new RecPayException(RecPayException.ALREADYCOMMSETTLE);
            }
            if (settBizTypeInfo.getType() == SettBizTypeEnum.RECINSIDE) {
                FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"oppInnerAcct");
            }
            if (settBizTypeInfo == null || settBizTypeInfo.getType() != SettBizTypeEnum.RECINSIDE || info.getPayerAccountBank() == null || info.getOppInnerAcct() != null) continue;
            throw new RecPayException(RecPayException.PAYERACCOUNTMUSTHAVEINNERACCOUNT);
        }
        this.helper.botpTransformSettle(ctx, bankInfo, (IObjectCollection)coll);
        size = coll.size();
        for (i = 0; i < size; ++i) {
            ReceivingBillFactory.getLocalInstance(ctx).commitSettle4WF((IObjectPK)new ObjectUuidPK(coll.get(i).getId()));
        }
        this.helper.SignSubmitSymbol(ctx, validSet);
    }

    public void lockedIds(Context ctx, List ids) throws BOSException {
        UserInfo user = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        int size = ids.size();
        if (size == 0) {
            return;
        }
        String sql = "update T_CAS_ReceivingBill set FLastUpdateUserID = '" + user.getId().toString() + "', FSubSettDate=?  where fid in ('" + ids.get(0) + "'";
        for (int i = 1; i < size; ++i) {
            sql = sql + ", '" + ids.get(i) + "'";
        }
        sql = sql + ")";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Timestamp(System.currentTimeMillis())});
    }
}

