/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.IBOTRelation;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.core.util.NumberRuleUtil;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.CasException;
import com.kingdee.eas.fi.cas.DisposerActionEnum;
import com.kingdee.eas.fi.cas.IReceivingBill;
import com.kingdee.eas.fi.cas.RecPayBgCtrlStrEnum;
import com.kingdee.eas.fi.cas.RecPayException;
import com.kingdee.eas.fi.cas.ReceivingBillEntryInfo;
import com.kingdee.eas.fi.cas.ReceivingBillFactory;
import com.kingdee.eas.fi.cas.ReceivingBillInfo;
import com.kingdee.eas.fi.cas.SourceTypeEnum;
import com.kingdee.eas.fi.cas.app.ArApRecPayServerHelper;
import com.kingdee.eas.fi.cas.app.service.IRecDeleteService;
import com.kingdee.eas.fi.cas.app.service.handler.ServiceHandler;
import com.kingdee.eas.fm.be.TransDetailFactory;
import com.kingdee.eas.fm.be.TransDetailInfo;
import com.kingdee.eas.fm.cl.ConsignLoanIntBillInfo;
import com.kingdee.eas.fm.cl.ConsingnRepaymentBillInfo;
import com.kingdee.eas.fm.common.FMBGHelper;
import com.kingdee.eas.fm.fin.app.LoanReverseHelper;
import com.kingdee.eas.fm.ft.FundTransferInterestBillInfo;
import com.kingdee.eas.fm.ft.FundTransferRepayBillInfo;
import com.kingdee.eas.fm.ivt.FinancingRedeemInfo;
import com.kingdee.eas.fm.nc.NoticeBillInfo;
import com.kingdee.eas.fm.nt.BillStateEnum;
import com.kingdee.eas.fm.nt.IReceivableBill;
import com.kingdee.eas.fm.nt.LetterOfCreditDisCountInfo;
import com.kingdee.eas.fm.nt.LetterOfCreditReceiveInfo;
import com.kingdee.eas.fm.nt.ReceivableBillFactory;
import com.kingdee.eas.fm.nt.ReceivableBillInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.ma.nbudget.BgControlCaller;
import com.kingdee.eas.scm.sd.sale.ReceivingMatchFactory;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

public class RecDeleteService
implements IRecDeleteService {
    protected Context ctx;
    protected ReceivingBillInfo info;
    protected IObjectPK pk;
    protected ServiceHandler serviceHandler;
    IObjectPK pkOut;
    protected IReceivingBill iReceivingBill = null;

    private ServiceHandler getServiceHandler() {
        return new ServiceHandler();
    }

    @Override
    public void initService(Context ctx, IObjectPK pk, ReceivingBillInfo info) throws EASBizException, BOSException {
        this.ctx = ctx;
        this.pk = pk;
        this.info = info;
        this.serviceHandler = this.getServiceHandler();
        this.iReceivingBill = ReceivingBillFactory.getLocalInstance(ctx);
    }

    @Override
    public void beforeDelete() throws EASBizException, BOSException {
        BOSUuid bosId;
        this.logger();
        this.checkCanDelete(this.ctx, this.info);
        if (this.info.getSourceType() == SourceTypeEnum.AR) {
            this.recycleUseIntermitNumber(this.ctx, this.pk, this.info);
        } else if (this.info.getNumber() != null && this.info.getNumber().trim().length() > 0) {
            NumberRuleUtil.recycleNumber((Context)this.ctx, (CoreBaseInfo)this.info, (String)this.info.getCompany().getId().toString());
        }
        boolean isHasValue = false;
        String tableName = "T_CAS_ReceivingBillEntry";
        HashSet<String> idSet = new HashSet<String>();
        int size = this.info.getEntries().size();
        for (int i = 0; i < size; ++i) {
            if (this.info.getEntries().get(i) == null) continue;
            idSet.add(this.info.getEntries().get(i).getId().toString());
        }
        if (ArApRecPayServerHelper.isExistsBizFlowField(this.ctx, tableName) && ArApRecPayServerHelper.isHasBizFlowValue(this.ctx, tableName, idSet)) {
            isHasValue = true;
        }
        if (!this.info.isIsInitializeBill() && this.info.isAssoGenByArBill() && !this.info.isIsTransBill()) {
            ArApRecPayServerHelper.injectBizFlow(this.ctx, (IObjectValue)this.info, BatchActionEnum.DELETE);
        }
        if (!isHasValue) {
            DisposerActionEnum disposerActionEnum = DisposerActionEnum.DELETE;
            this.serviceHandler.dispose(this.ctx, this.info, disposerActionEnum);
        }
        String botpSrcBillId = null;
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("srcEntityID", (Object)new TransDetailInfo().getBOSType(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("destObjectID", (Object)this.info.getId(), CompareType.EQUALS));
        evi.setFilter(filter);
        IBOTRelation iBOTRelation = BOTRelationFactory.getLocalInstance((Context)this.ctx);
        BOTRelationCollection relateColl = iBOTRelation.getCollection(evi);
        if (relateColl != null && relateColl.size() > 0) {
            botpSrcBillId = relateColl.get(0).getSrcObjectID();
        }
        if (!EmptyUtil.isEmpty(botpSrcBillId) && (bosId = BOSUuid.read(botpSrcBillId)).getType().equals((Object)new TransDetailInfo().getBOSType())) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(botpSrcBillId);
            HashMap valueMap = new HashMap();
            HashMap<String, Object> value = new HashMap<String, Object>();
            value.put("isReced", Boolean.FALSE);
            value.put("recedBillType", this.info.getBOSType());
            value.put("recedBillNumber", this.info.getNumber());
            valueMap.put(botpSrcBillId, value);
            TransDetailFactory.getLocalInstance((Context)this.ctx).disposeRecInfo(list, valueMap);
        }
        this.updateSrcLoanDelete(this.ctx, this.info);
        this.updateConsignRepay(this.ctx, this.info);
        IContextHelper localInstance = ContextHelperFactory.getLocalInstance((Context)this.ctx);
        int val = localInstance.getIntParam("CS042", (IObjectPK)new ObjectUuidPK(this.info.getCompany().getId()));
        this.cancelRequestBudget(this.ctx, this.pk.toString(), RecPayBgCtrlStrEnum.Sumbit_Sub, val);
        FMBGHelper.signBgItemRelease((Context)this.ctx, (IObjectPK)this.pk);
        ObjectStringPK[] entryPks = new ObjectStringPK[this.info.getEntries().size()];
        ReceivingBillEntryInfo entryInfo = null;
        String entryId = null;
        int n = this.info.getEntries().size();
        for (int i = 0; i < n; ++i) {
            entryInfo = this.info.getEntries().get(i);
            entryId = entryInfo.getId().toString();
            entryPks[i] = new ObjectStringPK(entryId);
        }
        FMBGHelper.signBgItemRelease((Context)this.ctx, (IObjectPK[])entryPks);
    }

    @Override
    public void afterDelete() throws EASBizException, BOSException {
        String srcId = this.info.getSourceBillId();
        if (!EmptyUtil.isEmpty((String)srcId)) {
            String sql;
            BOSObjectType bosId = BOSUuid.read((String)srcId).getType();
            ObjectUuidPK objectPk = new ObjectUuidPK(srcId);
            if (bosId.equals((Object)new FundTransferRepayBillInfo().getBOSType())) {
                sql = "update T_FT_FundTransferRepayBill set FRecBillID = null where FID = ?";
                DbUtil.execute((Context)this.ctx, (String)sql, (Object[])new Object[]{srcId.toString()});
            }
            if (bosId.equals((Object)new FundTransferInterestBillInfo().getBOSType())) {
                sql = "update T_FT_FundTransferInterestBill set FRecBillID = null, FIsGatherBill = ? where FID = ?";
                DbUtil.execute((Context)this.ctx, (String)sql, (Object[])new Object[]{Boolean.FALSE, srcId.toString()});
            }
            if (bosId.equals((Object)new LetterOfCreditDisCountInfo().getBOSType())) {
                sql = "Update T_NT_LetterOfCreditDisCount Set FisGenRec = null Where Fid = ? ";
                DbUtil.execute((Context)this.ctx, (String)sql, (Object[])new Object[]{srcId.toString()});
            }
            if (bosId.equals((Object)new ConsignLoanIntBillInfo().getBOSType())) {
                sql = "update T_CL_ConsignLoanIntBill set FISGENRECEIVING = ? where FID = ?";
                DbUtil.execute((Context)this.ctx, (String)sql, (Object[])new Object[]{Boolean.FALSE, srcId.toString()});
            }
            if (bosId.equals((Object)new LetterOfCreditReceiveInfo().getBOSType())) {
                sql = "update T_NT_LetterOfCreditReceive set FISGENRECBILL = ? where FID = ?";
                DbUtil.execute((Context)this.ctx, (String)sql, (Object[])new Object[]{Boolean.FALSE, srcId.toString()});
            }
            if (bosId.equals((Object)FinancingRedeemInfo.BOSTYPE)) {
                sql = "update T_IVT_FinancingRedeem SET FISGENEGATERBILL = 0 where fid= ? ";
                DbUtil.execute((Context)this.ctx, (String)sql, (Object[])new Object[]{srcId.toString()});
            }
        }
        if (!EmptyUtil.isEmpty((CoreBaseInfo)this.info.getRecBillClaim())) {
            DbUtil.execute((Context)this.ctx, (String)"delete from T_RPM_RecBillClaim where freceivingbillid=?", (Object[])new Object[]{this.info.getId().toString()});
        }
        LogUtil.afterLog((Context)this.ctx, (IObjectPK)this.pkOut);
    }

    private void logger() {
        this.pkOut = LogUtil.beginLog((Context)this.ctx, null, (BOSObjectType)this.info.getBOSType(), null, (String)this.info.getLogInfo(), (String)"cas_receivingBill_remove");
    }

    private void checkCanDelete(Context ctx, ReceivingBillInfo info) throws BOSException, EASBizException {
        if (ReceivingMatchFactory.getLocalInstance((Context)ctx).haveMatchRecord(null, info.getId().toString(), null)) {
            throw new RecPayException(RecPayException.BILL_MATCHED_REFUSE_DELETE, new String[]{""});
        }
        int billStatus = info.getBillStatus().getValue();
        int receivingBillType = info.getReceivingBillType().getValue();
        boolean isRealRecBill = 2 == receivingBillType;
        String sourceBillId = info.getSourceBillId();
        if (null != sourceBillId) {
            IReceivableBill irb;
            ReceivableBillInfo rbi;
            BOSObjectType srcBOSType;
            BOSObjectType bosType = new ReceivableBillInfo().getBOSType();
            if (bosType.equals((Object)(srcBOSType = BOSUuid.getBOSObjectType((String)sourceBillId, (boolean)true))) && BillStateEnum.GATHERED.equals((Object)(rbi = (irb = ReceivableBillFactory.getLocalInstance((Context)ctx)).getReceivableBillInfo((IObjectPK)new ObjectUuidPK(sourceBillId))).getBillState())) {
                throw new CasException(CasException.RECBILLNOTDEL);
            }
            if (EmptyUtil.isEmpty((Object)ctx.get((Object)"fromNoticeDelete")) && new NoticeBillInfo().getBOSType().equals((Object)srcBOSType)) {
                throw new CasException(CasException.NOTICEBILLNOTDEL);
            }
        }
        if (billStatus == 14) {
            throw new RecPayException(RecPayException.CANNOT_DEL_RECED);
        }
        if (!isRealRecBill && billStatus == 12) {
            throw new RecPayException(RecPayException.CANNOT_DEL_AUDITED);
        }
        this.checkCanDeleteInitBill(ctx, info.getId().toString());
    }

    private void recycleUseIntermitNumber(Context ctx, IObjectPK pk, ReceivingBillInfo receivingBillInfo) throws CodingRuleException, EASBizException, BOSException {
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        if (receivingBillInfo == null || receivingBillInfo.getNumber() == null || receivingBillInfo.getCompany() == null || receivingBillInfo.getCU() == null) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("number");
            sic.add("company.id");
            sic.add("cu.id");
            receivingBillInfo = this.iReceivingBill.getReceivingBillInfo(pk, sic);
        }
        CompanyOrgUnitInfo aCompanyOrgUnitInfo = receivingBillInfo.getCompany();
        String strCompanyID = aCompanyOrgUnitInfo.getId().toString();
        CodingRuleInfo codingInfo = iCodingRuleManager.getCodingRule((IObjectValue)receivingBillInfo, strCompanyID);
        if (iCodingRuleManager.isExist((IObjectValue)receivingBillInfo, strCompanyID) && (iCodingRuleManager.isUseIntermitNumber((IObjectValue)receivingBillInfo, strCompanyID) || codingInfo.isIsaddnewbreak())) {
            iCodingRuleManager.recycleNumber((IObjectValue)receivingBillInfo, strCompanyID, StringUtils.isEmpty((String)receivingBillInfo.getOldNumber()) ? receivingBillInfo.getNumber() : receivingBillInfo.getOldNumber());
        }
    }

    private void updateSrcLoanDelete(Context ctx, ReceivingBillInfo info) throws BOSException {
        LoanReverseHelper.getInstance().receivingBillDelete(ctx, info.getSourceBillId(), info.getId().toString());
    }

    private void updateConsignRepay(Context ctx, ReceivingBillInfo info) throws BOSException {
        String srcID;
        BOSUuid uuid;
        BOSObjectType bosType;
        if (info.getSourceBillId() != null && (bosType = (uuid = BOSUuid.read((String)(srcID = info.getSourceBillId().toString()))).getType()).equals((Object)ConsingnRepaymentBillInfo.BOSTYPE)) {
            String sql = "update T_CL_ConsingnRepaymentBill set FIsGenRecBill = 0 , FRecBillID=null  where fid = ?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{srcID});
        }
    }

    private void cancelRequestBudget(Context ctx, String billId, RecPayBgCtrlStrEnum enums, int val) throws BOSException, EASBizException {
        if (enums.getValue() == val) {
            BgControlCaller caller = new BgControlCaller();
            caller.returnBudget(ctx, BOSUuid.read((String)billId));
        }
    }

    private void checkCanDeleteInitBill(Context ctx, String billId) throws RecPayException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT a.FNumber, b.FUnLockAmt,b.FHisUnVcAmount FROM T_CAS_ReceivingBill a ").append(" LEFT JOIN T_CAS_ReceivingBillEntry b ON a.fid = b.FReceivingBillID ").append(" WHERE a.FID = ? AND a.FIsinitializeBill = 1 ");
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement(sql.toString());
            DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)1, (String)billId);
            BigDecimal unLockAmt = null;
            BigDecimal hisUnVcAmt = null;
            String number = null;
            rs = pstmt.executeQuery();
            while (rs.next()) {
                unLockAmt = rs.getBigDecimal("FUnLockAmt");
                if (unLockAmt.compareTo(hisUnVcAmt = rs.getBigDecimal("FHisUnVcAmount")) == 0) continue;
                number = rs.getString("FNumber");
                throw new RecPayException(RecPayException.CANNOT_DELETE_INIT, new String[]{number});
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
    }
}

