/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.btp.BTPException;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.arap.ARAPCommonServerFacadeFactory;
import com.kingdee.eas.fi.cas.BillDisposerAction;
import com.kingdee.eas.fi.cas.BillStatusEnum;
import com.kingdee.eas.fi.cas.CasRecPayBillTypeEnum;
import com.kingdee.eas.fi.cas.DisposerActionEnum;
import com.kingdee.eas.fi.cas.IReceivingBill;
import com.kingdee.eas.fi.cas.IReceivingBillEntry;
import com.kingdee.eas.fi.cas.IReceivingDisposer;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.cas.RecPayAcctBankStratageCtrl;
import com.kingdee.eas.fi.cas.RecPayBgCtrlStrEnum;
import com.kingdee.eas.fi.cas.RecPayException;
import com.kingdee.eas.fi.cas.RecPayHelper;
import com.kingdee.eas.fi.cas.RecPayOverDraftCtrlEnum;
import com.kingdee.eas.fi.cas.ReceivingBillBookNotifyBuilder;
import com.kingdee.eas.fi.cas.ReceivingBillCollection;
import com.kingdee.eas.fi.cas.ReceivingBillEntryCollection;
import com.kingdee.eas.fi.cas.ReceivingBillEntryFactory;
import com.kingdee.eas.fi.cas.ReceivingBillEntryInfo;
import com.kingdee.eas.fi.cas.ReceivingBillFactory;
import com.kingdee.eas.fi.cas.ReceivingBillInfo;
import com.kingdee.eas.fi.cas.ReceivingDisposerFactory;
import com.kingdee.eas.fi.cas.SourceTypeEnum;
import com.kingdee.eas.fi.cas.app.AgentRecPayServerHelper;
import com.kingdee.eas.fi.cas.app.ArApRecPayServerHelper;
import com.kingdee.eas.fi.cas.app.service.IRecRecService;
import com.kingdee.eas.fi.cas.app.service.handler.ServiceHandler;
import com.kingdee.eas.fi.cas.utils.ThreadLocalUtil;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.im.AccrualBillInfo;
import com.kingdee.eas.fm.nt.BillSourceEnum;
import com.kingdee.eas.fm.nt.BillStateEnum;
import com.kingdee.eas.fm.nt.ElecBillStatusEnum;
import com.kingdee.eas.fm.nt.IReceivableBill;
import com.kingdee.eas.fm.nt.NTHelper;
import com.kingdee.eas.fm.nt.NTTypeGroupEnum;
import com.kingdee.eas.fm.nt.OprtEnum;
import com.kingdee.eas.fm.nt.ReceivableBillCollection;
import com.kingdee.eas.fm.nt.ReceivableBillFactory;
import com.kingdee.eas.fm.nt.ReceivableBillInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.NumericExceptionSubItem;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class RecRecService
implements IRecRecService {
    protected Context ctx;
    Set idSet;
    boolean ifBookReceivingBill = false;
    boolean isInvokeWF = false;
    protected ServiceHandler serviceHandler;
    RecPayHelper helper = new RecPayHelper();

    protected ServiceHandler getServiceHandler() {
        return new ServiceHandler();
    }

    public void beforeService(Set validSet) throws EASBizException, BOSException {
        String ids = FMHelper.setTran2String((Set)validSet);
        String sql = "UPDATE T_CAS_ReceivingBill SET FID = FID WHERE FID IN " + ids;
        DbUtil.execute((Context)this.ctx, (String)sql);
    }

    @Override
    public void initService(Context ctx, Set set, boolean ifBookReceivingBill, boolean isInvokeWF) throws EASBizException, BOSException {
        this.ctx = ctx;
        this.idSet = set;
        this.ifBookReceivingBill = ifBookReceivingBill;
        this.isInvokeWF = isInvokeWF;
        this.serviceHandler = this.getServiceHandler();
        this.beforeService(this.idSet);
    }

    @Override
    public void doService() throws EASBizException, BOSException {
        ObjectUuidPK companyPK;
        ReceivingBillCollection receivingBillColl = RecRecService.getRecColl(this.ctx, this.idSet);
        this.helper.checkAcctViewIsValid(this.ctx, (IObjectCollection)receivingBillColl);
        this.verifyData(this.ctx, receivingBillColl);
        String ids = FMHelper.setTran2String((Set)this.idSet);
        UserInfo userInfo = ContextHelperFactory.getLocalInstance((Context)this.ctx).getCurrentUser();
        String sql = "UPDATE T_CAS_ReceivingBill SET FCashierID = ?,FBillStatus = ?,FRecDate = ? WHERE FID IN " + ids;
        Integer status = new Integer(14);
        Timestamp currTime = new Timestamp(System.currentTimeMillis());
        DbUtil.execute((Context)this.ctx, (String)sql, (Object[])new Object[]{userInfo.getId().toString(), status, currTime});
        String billId = null;
        ReceivingBillInfo info = null;
        DisposerActionEnum disposerActionEnum = DisposerActionEnum.REC;
        Iterator iter = receivingBillColl != null ? receivingBillColl.iterator() : null;
        HashSet<String> arSet = new HashSet<String>();
        while (iter != null && iter.hasNext()) {
            info = (ReceivingBillInfo)iter.next();
            billId = info.getId().toString();
            companyPK = new ObjectUuidPK(info.getCompany().getId());
            HashMap paramMap = new HashMap();
            paramMap.put("CS010", companyPK);
            paramMap.put("CS042", companyPK);
            paramMap.put("CS052", companyPK);
            paramMap.put("CS070", companyPK);
            paramMap.put("CS048", companyPK);
            IParamControl pc = ParamControlFactory.getLocalInstance((Context)this.ctx);
            paramMap = pc.getParamHashMap(paramMap);
            boolean needComit = Boolean.valueOf((String)paramMap.get("CS010"));
            int bgCtrlParam = Integer.parseInt((String)paramMap.get("CS042"));
            int overCtrlParam = Integer.parseInt((String)paramMap.get("CS052"));
            boolean isAutoVerifyReceivingBill = false;
            if ("true".equals((String)paramMap.get("CS070"))) {
                isAutoVerifyReceivingBill = true;
            }
            if (SourceTypeEnum.AR.equals((Object)info.getSourceType())) {
                Map<String, Object> params = ThreadLocalUtil.getThreadObject();
                if (info.isIsRefundmentPay() && params.get("CASrefundmentREC") == null) {
                    throw new RecPayException(RecPayException.REFUNDMENTPAYCANTRECARAP);
                }
                this.serviceHandler.checkIsInQueue(this.ctx, info);
            }
            if (info.needCommitCH()) {
                String sourceID = info.getSourceBillId();
                boolean isAccualBill = false;
                if (sourceID != null) {
                    isAccualBill = new AccrualBillInfo().getBOSType().equals((Object)BOSUuid.read((String)sourceID).getType());
                }
                if (needComit && !isAccualBill) {
                    throw new RecPayException(RecPayException.CANNOTREC, new Object[]{info.getNumber()});
                }
            }
            if (CasRecPayBillTypeEnum.AgentType.equals((Object)info.getReceivingBillType())) {
                ReceivingBillInfo destBillInfo = AgentRecPayServerHelper.botpTransformRealReceivingbill(this.ctx, info);
                info.setRealRecBillID(destBillInfo.getId().toString());
                String sqlUpdate = "UPDATE T_CAS_ReceivingBill SET FRealRecBillID = ? WHERE FID = ? ";
                DbUtil.execute((Context)this.ctx, (String)sqlUpdate, (Object[])new Object[]{destBillInfo.getId().toString(), info.getId().toString()});
            }
            this.dispose(this.ctx, info, disposerActionEnum);
            if (this.isInvokeWF) {
                ReceivingBillFactory.getLocalInstance(this.ctx).rec4WF((IObjectPK)new ObjectUuidPK(billId));
            }
            this.bgCtrlAndAudit(this.ctx, (IObjectPK)new ObjectUuidPK(billId), RecPayBgCtrlStrEnum.PayOrRec_Sub, bgCtrlParam);
            this.overDraftCtrls(this.ctx, (IObjectPK)new ObjectUuidPK(billId), RecPayOverDraftCtrlEnum.recOrPay_ctrl, overCtrlParam);
            boolean canBook = false;
            AccountViewInfo acct = info.getPayeeAccount();
            if (acct != null && (acct.isIsBank() || acct.isIsCash())) {
                canBook = true;
            }
            if (isAutoVerifyReceivingBill && canBook) {
                this.WriteOffReceivableBill(this.ctx, info, info.getCompany().getId().toString());
            }
            if (SourceTypeEnum.AR.equals((Object)info.getSourceType())) {
                arSet.add(info.getId().toString());
            }
            if (!this.ifBookReceivingBill) continue;
            HashSet<String> idSet = new HashSet<String>();
            idSet.add(billId);
            this.helper.bookReceivingBill(this.ctx, ReceivingBillBookNotifyBuilder.class.getName(), idSet);
        }
        companyPK = receivingBillColl != null && receivingBillColl.size() > 0 ? new ObjectUuidPK(receivingBillColl.get(0).getCompany().getId()) : new ObjectUuidPK(ContextHelperFactory.getLocalInstance((Context)this.ctx).getCurrentCompany().getId());
        if (receivingBillColl != null) {
            this.genPaymentbill(this.ctx, receivingBillColl);
        }
        if (arSet.size() > 0) {
            ARAPCommonServerFacadeFactory.getLocalInstance((Context)this.ctx).autoVerify(companyPK.toString(), arSet, true);
        }
    }

    public static ReceivingBillCollection getRecColl(Context ctx, Set idSet) throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSelector().add("*");
        evi.getSelector().add("payerAccount.*");
        evi.getSelector().add("payeeAccount.*");
        evi.getSelector().add("payeeAccountBank.*");
        evi.getSelector().add("payerAccountBankO.*");
        evi.getSelector().add("payerAccountBankO.InnerAcct.*");
        evi.getSelector().add("payeeAccountBank.InnerAcct.*");
        evi.getSelector().add("payeeAccountBank.InnerAcct.clearingHouse.*");
        evi.getSelector().add("settlementType.*");
        evi.getSelector().add("settlementType.ntType.*");
        evi.getSelector().add("cheque.*");
        evi.getSelector().add("payerBank.*");
        evi.getSelector().add("bizType.*");
        evi.getSelector().add("oppInnerAcct.*");
        evi.getSelector().add("oppAccount.*");
        evi.getSelector().add("company.*");
        evi.getSelector().add("recBillType.*");
        evi.getSelector().add("actRecAccountBank.*");
        evi.getSelector().add("payerInAcctID.*");
        evi.getSelector().add(new SelectorItemInfo("entries.*"));
        evi.getSelector().add(new SelectorItemInfo("entries.recBillType.number"));
        evi.getSelector().add(new SelectorItemInfo("entries.recBillType.name"));
        return ReceivingBillFactory.getLocalInstance(ctx).getReceivingBillCollection(evi);
    }

    public void WriteOffReceivableBill(Context ctx, ReceivingBillInfo info, String companyID) throws BOSException, EASBizException {
        ReceivableBillInfo recvBillInfo = null;
        ArrayList<String> SrcList = new ArrayList<String>();
        if (info.getSettlementType() != null && info.getSettlementType().getNtType() != null && info.getSettlementType().getNtType().getGroup() != null && NTTypeGroupEnum.RECEIVABLE.equals((Object)info.getSettlementType().getNtType().getSuperGroup()) && info.getSettlementNumber() != null && info.getSourceType() == SourceTypeEnum.CASH) {
            String settleNumber = info.getSettlementNumber().replaceAll("\\s|\u3000", "");
            String mateNumber = settleNumber.replaceAll("(.{1})", "$1%");
            mateNumber = mateNumber.substring(0, mateNumber.length() - 1);
            EntityViewInfo query = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            query.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("draftNumber", (Object)("%" + mateNumber), CompareType.LIKE));
            filter.getFilterItems().add(new FilterItemInfo("isWriteOff", (Object)new Integer(0)));
            filter.getFilterItems().add(new FilterItemInfo("billAmt", (Object)info.getActRecAmt()));
            filter.getFilterItems().add(new FilterItemInfo("company", (Object)companyID));
            HashSet<Integer> setState = new HashSet<Integer>();
            setState.add(new Integer(NTHelper.getNTInitState((Context)ctx, (boolean)true)));
            filter.getFilterItems().add(new FilterItemInfo("billState", setState, CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("expiredDate", (Object)new Date(), CompareType.LESS_EQUALS));
            if (info.getCurrency() != null) {
                filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)info.getCurrency().getId().toString()));
            }
            if (info.getSettlementType().getNtType() != null) {
                filter.getFilterItems().add(new FilterItemInfo("ntType.id", (Object)info.getSettlementType().getNtType().getId().toString()));
            }
            ReceivableBillCollection receivableBillCollection = ReceivableBillFactory.getLocalInstance((Context)ctx).getReceivableBillCollection(query);
            for (int i = 0; i < receivableBillCollection.size(); ++i) {
                recvBillInfo = receivableBillCollection.get(i);
                if (!recvBillInfo.getDraftNumber().replaceAll("\\s|\u3000", "").equals(settleNumber)) continue;
                SrcList.add(recvBillInfo.getId().toString());
                if (BillSourceEnum.BYECDS.equals((Object)recvBillInfo.getSource())) {
                    recvBillInfo.setLastElecStatus(recvBillInfo.getElecBillStatus());
                    recvBillInfo.setElecBillStatus(ElecBillStatusEnum.NT000000);
                }
                recvBillInfo.setBillState(BillStateEnum.GATHERED);
                recvBillInfo.setIsWriteOff(true);
                recvBillInfo.setTransferDate(DateTimeUtils.truncateDate((Date)info.getBizDate()));
                recvBillInfo.setReceivingBillId(info.getId().toString());
                info.setSourceBillId(recvBillInfo.getId().toString());
                ReceivingBillEntryInfo entryInfo = info.getEntries().get(0);
                entryInfo.setSourceBillId(recvBillInfo.getId().toString());
                info.setBillStatus(BillStatusEnum.RECED);
                IReceivingBill iReceivingBill = ReceivingBillFactory.getLocalInstance(ctx);
                iReceivingBill.update((IObjectPK)new ObjectUuidPK(info.getId().toString()), (CoreBaseInfo)info);
                IReceivingBillEntry iReceivingBillEntry = ReceivingBillEntryFactory.getLocalInstance(ctx);
                iReceivingBillEntry.update((IObjectPK)new ObjectUuidPK(entryInfo.getId().toString()), (CoreBaseInfo)entryInfo);
                IReceivableBill iReceivableBill = ReceivableBillFactory.getLocalInstance((Context)ctx);
                iReceivableBill.update((IObjectPK)new ObjectUuidPK(recvBillInfo.getId().toString()), (CoreBaseInfo)recvBillInfo);
                FMHelper.saveBOTRelation((Context)ctx, SrcList, (String)info.getId().toString());
                recvBillInfo.setOprtLogDate(info.getBizDate());
                NTHelper.writOprtLog((Context)ctx, (IObjectValue)recvBillInfo, (String)recvBillInfo.getId().toString(), (OprtEnum)OprtEnum.RECEIVE, (OprtEnum)OprtEnum.SAVE);
            }
        }
    }

    private void dispose(Context ctx, ReceivingBillInfo info, DisposerActionEnum disposerActionEnum) throws BOSException, EASBizException {
        ReceivingBillEntryCollection entryColl = info.getEntries();
        ReceivingBillEntryInfo entryInfo = null;
        IReceivingDisposer disposer = null;
        int size = entryColl.size();
        for (int i = 0; i < size; ++i) {
            BOSObjectType bosType;
            entryInfo = entryColl.get(i);
            if (entryInfo == null) continue;
            if (entryInfo.getSourceBillId() != null && (bosType = BOSUuid.read((String)entryInfo.getSourceBillId()).getType()).equals((Object)info.getBOSType()) && "101|102|103|104|105|106".indexOf(info.getRecBillType().getNumber()) >= 0) {
                try {
                    String disposerName = "com.kingdee.eas.fi.ar.ArRefundBillDisposer";
                    disposer = (IReceivingDisposer)Class.forName(disposerName).newInstance();
                    break;
                }
                catch (Exception e) {
                    throw new BOSException((Throwable)e);
                }
            }
            disposer = ArApRecPayServerHelper.getSettlementBillDisPoser(ctx, info);
            if (disposer != null) break;
            disposer = ReceivingDisposerFactory.getInstance(ctx, entryInfo.getSourceBillId());
            break;
        }
        if (disposer != null) {
            BillDisposerAction disposerAction = new BillDisposerAction();
            disposerAction.setDestBill((CoreBaseInfo)info);
            disposerAction.setActionType(disposerActionEnum);
            disposer.dispose(ctx, disposerAction);
        }
    }

    private void bgCtrlAndAudit(Context ctx, IObjectPK pk, RecPayBgCtrlStrEnum enums, int val) throws BOSException, EASBizException {
        String billId = pk.toString();
        if (enums.getValue() == val) {
            RecPayHelper.bgCtrlAudit(ctx, billId);
        }
    }

    private void overDraftCtrls(Context ctx, IObjectPK pk, RecPayOverDraftCtrlEnum enums, int val) throws BOSException, EASBizException {
        if (enums.getValue() - 1 == val) {
            RecPayAcctBankStratageCtrl.acctBankBalanceCtrl(ctx, pk);
        }
    }

    private void genPaymentbill(Context ctx, ReceivingBillCollection collForPay) throws BOSException, BTPException, EASBizException {
        ReceivingBillCollection collForPayRemove = new ReceivingBillCollection();
        for (int i = 0; i < collForPay.size(); ++i) {
            boolean payerAcctIsOtherUnit;
            BOSUuid sbid;
            ReceivingBillInfo srcBill = collForPay.get(i);
            boolean isFromPaymentbill = false;
            if (!EmptyUtil.isEmpty((String)srcBill.getSourceBillId()) && (sbid = BOSUuid.read((String)srcBill.getSourceBillId())).getType().equals((Object)new PaymentBillInfo().getBOSType())) {
                isFromPaymentbill = true;
            }
            boolean isPayeeBankSettle = srcBill.getPayeeBank() != null && srcBill.getPayeeBank().isInGroup();
            boolean bl = payerAcctIsOtherUnit = srcBill.getPayerAccountBankO() != null && srcBill.getPayeeAccountBank() != null && !srcBill.getPayerAccountBankO().getCompany().getId().equals((Object)srcBill.getPayeeAccountBank().getCompany().getId());
            if (srcBill.getPayerAccountBankO() != null && srcBill.getPayeeAccountBank() == null && !srcBill.getPayerAccountBankO().getCompany().getId().equals((Object)srcBill.getCompany().getId())) {
                payerAcctIsOtherUnit = true;
            }
            boolean isReceivingPaybill = false;
            if (srcBill.getPayerAccountBankO() != null) {
                isReceivingPaybill = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("CS048", (IObjectPK)new ObjectUuidPK(srcBill.getPayerAccountBankO().getCompany().getId()));
            }
            boolean isRefundmentPay = srcBill.isIsRefundmentPay();
            boolean isBankSettleNull = srcBill.getPayeeBank() == null;
            boolean isNotBankSettleOrNull = true;
            if (isBankSettleNull || !isPayeeBankSettle) {
                isNotBankSettleOrNull = false;
            }
            if (!isFromPaymentbill && !isNotBankSettleOrNull && payerAcctIsOtherUnit && isReceivingPaybill && !isRefundmentPay) continue;
            collForPayRemove.add(srcBill);
        }
        for (int j = 0; j < collForPayRemove.size(); ++j) {
            collForPay.remove(collForPayRemove.get(j));
        }
        if (collForPay.size() > 0) {
            this.helper.botpTransformPaymentbill(ctx, (IObjectCollection)collForPay);
        }
    }

    private void verifyData(Context ctx, ReceivingBillCollection coll) throws EASBizException, BOSException {
        IContextHelper ctxHelper = ContextHelperFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitInfo companyInfo = coll.get(0).getCompany();
        boolean isSettleAutoRecPay = ctxHelper.getBooleanParam("CS062", (IObjectPK)new ObjectUuidPK(companyInfo.getId()));
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            ReceivingBillInfo info = coll.get(i);
            if (!info.getBillStatus().equals((Object)BillStatusEnum.AUDITED)) {
                String not_Audit = EASResource.getString((String)"com.kingdee.eas.fi.cas.RecPayResource", (String)"Not_Audit_Cannot_Rec", (Locale)ctx.getLocale());
                throw new EASBizException(new NumericExceptionSubItem("", not_Audit));
            }
            if (info.getSourceType() == SourceTypeEnum.AR || !info.getBillStatus().equals((Object)BillStatusEnum.AUDITED)) continue;
            boolean isRecBySettle = this.helper.checkIsActionFromSettle(ctx, info.getId().toString());
            boolean isRecValid = true;
            if (!isRecBySettle && isSettleAutoRecPay) {
                isRecValid = this.helper.isCanManualRecPay(ctx, info);
            }
            if (isRecValid) continue;
            String not_Audit = EASResource.getString((String)"com.kingdee.eas.fi.cas.RecPayResource", (String)"Not_Audit_From_Settle", (Locale)ctx.getLocale());
            throw new EASBizException(new NumericExceptionSubItem("", not_Audit));
        }
    }
}

