/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.wssc.BillImageFacadeFactory;
import com.kingdee.eas.base.wssc.IBillImageFacade;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.PaymentTypeInfo;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.AssItemsForCashRecInfo;
import com.kingdee.eas.fi.cas.DisposerActionEnum;
import com.kingdee.eas.fi.cas.RecPayException;
import com.kingdee.eas.fi.cas.ReceivingBillDataProcess;
import com.kingdee.eas.fi.cas.ReceivingBillEntryInfo;
import com.kingdee.eas.fi.cas.ReceivingBillFactory;
import com.kingdee.eas.fi.cas.ReceivingBillInfo;
import com.kingdee.eas.fi.cas.SourceTypeEnum;
import com.kingdee.eas.fi.cas.app.AgentRecPayServerHelper;
import com.kingdee.eas.fi.cas.app.ArApRecPayServerHelper;
import com.kingdee.eas.fi.cas.app.service.IRecSaveService;
import com.kingdee.eas.fi.cas.app.service.handler.ServiceHandler;
import com.kingdee.eas.fm.cl.ConsignLoanIntBillFactory;
import com.kingdee.eas.fm.cl.ConsignLoanIntBillInfo;
import com.kingdee.eas.fm.cl.ConsingnRepaymentBillFactory;
import com.kingdee.eas.fm.cl.ConsingnRepaymentBillInfo;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.fs.SettBizTypeEnum;
import com.kingdee.eas.fm.ft.FundTransferInterestBillFactory;
import com.kingdee.eas.fm.ft.FundTransferInterestBillInfo;
import com.kingdee.eas.fm.ft.FundTransferRepayBillFactory;
import com.kingdee.eas.fm.ft.FundTransferRepayBillInfo;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class RecSaveService
implements IRecSaveService {
    private static Logger logger = Logger.getLogger((String)RecSaveService.class.getName());
    protected Context ctx;
    protected ReceivingBillInfo info;
    protected boolean isAddNew = true;
    protected ServiceHandler serviceHandler;
    IObjectValue value;
    String resourcePath = "com.kingdee.eas.fi.ar.ARRecPayResource";
    protected static final String CAS_RESOURCE = "com.kingdee.eas.fi.cas.CasResources";
    protected static final String AP_RESOURCE = "com.kingdee.eas.fi.ap.APResources";
    protected ArApRecPayServerHelper arapHelper = new ArApRecPayServerHelper();

    protected ServiceHandler getServiceHandler() {
        return new ServiceHandler();
    }

    @Override
    public void initService(Context ctx, IObjectValue value) throws EASBizException, BOSException {
        this.ctx = ctx;
        this.info = (ReceivingBillInfo)value;
        this.value = value;
        this.serviceHandler = this.getServiceHandler();
    }

    @Override
    public void beforeSave() throws EASBizException, BOSException {
        String number;
        if (this.info.getCompany() == null) {
            this.info.setCompany(ContextHelperFactory.getLocalInstance((Context)this.ctx).getCurrentCompany());
        }
        if (this.info.getPaymentType() == null) {
            String paymentTypeId = "91f078d7-fb90-4827-83e2-3538237b67a06BCA0AB5";
            PaymentTypeInfo paymentTypeInfo = new PaymentTypeInfo();
            paymentTypeInfo.setId(BOSUuid.read((String)paymentTypeId));
            this.info.setPaymentType(paymentTypeInfo);
        }
        if (null != this.info.getRecBillType() && !"fjJCrQESEADgABolwKgSQyqo2zU=".equals(this.info.getRecBillType().getId().toString())) {
            this.info.setPayAccountBank(null);
        }
        this.info.setBizDate(DateTimeUtils.truncateDate((Date)this.info.getBizDate()));
        ReceivingBillDataProcess.setCasAmount(this.ctx, this.info);
        AgentRecPayServerHelper.saveOrSubmitPaymentBillForAgentRec(this.ctx, this.info);
        this.serviceHandler.setCommonPropertyValue(this.ctx, this.info);
        this.updateResourceInfo();
        this.checkRecInfoValue(this.ctx, this.info);
        if (!SourceTypeEnum.AR.equals((Object)this.info.getSourceType()) && (number = this.value.getString("number")) != null && number.length() > 0) {
            this.serviceHandler.checkNumberDup(this.ctx, this.value);
        }
        if (this.info.getId() != null && ReceivingBillFactory.getLocalInstance(this.ctx).exists((IObjectPK)new ObjectUuidPK(this.info.getId()))) {
            this.isAddNew = false;
        }
    }

    @Override
    public void afterSave(IObjectPK pk) throws EASBizException, BOSException {
        this.info.setId(BOSUuid.read((String)pk.toString()));
        if (SourceTypeEnum.AR.equals((Object)this.info.getSourceType())) {
            try {
                IBillImageFacade image = BillImageFacadeFactory.getLocalInstance((Context)this.ctx);
                String imageNumber = image.getImageNumber(this.info.getBOSType().toString(), pk.toString());
                if (StringUtils.isEmpty((String)imageNumber)) {
                    String string = image.genImageNumber(this.info.getBOSType().toString(), pk.toString());
                }
            }
            catch (BOSException e) {
                logger.error((Object)"\u8c03\u7528\u57fa\u7840\u7684\u6761\u7801\u63a5\u53e3\u62a5\u9519");
                logger.error((Object)e);
            }
        }
        if (this.isAddNew) {
            DbUtil.execute((Context)this.ctx, (String)"update T_CAS_ReceivingBill set FLastUpdateUserID=null,FLastUpdateTime=null where FID= ? ", (Object[])new String[]{pk.toString()});
        }
        ArApRecPayServerHelper.injectBizFlow(this.ctx, (IObjectValue)this.info, BatchActionEnum.SAVE);
        this.serviceHandler.dispose(this.ctx, this.info, DisposerActionEnum.SAVE);
    }

    protected void updateResourceInfo() throws BOSException, EASBizException {
        String sourceBillId = this.info.getSourceBillId();
        if (sourceBillId != null && sourceBillId.length() > 0) {
            ObjectUuidPK objectPk = new ObjectUuidPK(sourceBillId);
            BOSUuid bosId = BOSUuid.read((String)sourceBillId);
            IObjectValue objectInfo = null;
            try {
                objectInfo = DynamicObjectFactory.getLocalInstance((Context)this.ctx).getValue(bosId.getType(), (IObjectPK)objectPk);
            }
            catch (BOSException e) {
                logger.error((Object)e);
            }
            if (objectInfo != null && (objectInfo instanceof FundTransferRepayBillInfo || objectInfo instanceof FundTransferInterestBillInfo)) {
                this.info.setSourceType(SourceTypeEnum.FT);
            }
            if (bosId.getType().equals((Object)new FundTransferRepayBillInfo().getBOSType())) {
                FundTransferRepayBillFactory.getLocalInstance((Context)this.ctx).updateRecmentBillID((IObjectPK)objectPk, (IObjectPK)new ObjectUuidPK(this.info.getId()));
            } else if (bosId.getType().equals((Object)new FundTransferInterestBillInfo().getBOSType())) {
                FundTransferInterestBillFactory.getLocalInstance((Context)this.ctx).updateRecmentBillID((IObjectPK)objectPk, (IObjectPK)new ObjectUuidPK(this.info.getId()));
            } else if (bosId.getType().equals((Object)new ConsingnRepaymentBillInfo().getBOSType())) {
                ConsingnRepaymentBillFactory.getLocalInstance((Context)this.ctx).updateRecBill((IObjectPK)objectPk, (IObjectPK)new ObjectUuidPK(this.info.getId()));
            } else if (bosId.getType().equals((Object)new ConsignLoanIntBillInfo().getBOSType())) {
                ConsignLoanIntBillFactory.getLocalInstance((Context)this.ctx).updateRecment((IObjectPK)objectPk);
            }
        }
    }

    protected boolean getCS063() throws BOSException, EASBizException {
        HashMap param = new HashMap();
        param.put("CS063", null);
        param = this.serviceHandler.getParam(this.ctx, (IObjectPK)new ObjectUuidPK(this.info.getCompany().getId().toString()), param);
        boolean cs063 = false;
        if (param.get("CS063") != null) {
            cs063 = ((String)param.get("CS063")).equals("true");
        }
        return cs063;
    }

    protected void checkRecInfoValue(Context ctx, ReceivingBillInfo info) throws EASBizException, BOSException {
        if (EmptyUtil.isEmpty((String)info.getSourceBillId()) && info.getPayeeAccountBank() != null) {
            AccountBankInfo payeeAcctBank = info.getPayeeAccountBank();
            if (info.getPayeeBank() != null && info.getPayeeBank().isInGroup() && info.getBizType() == null) {
                throw new RecPayException(RecPayException.RECBIZTYPEISNULL);
            }
            if (payeeAcctBank.getInnerAcct() != null && info.getBizType() != null) {
                if (info.getBizType() == null) {
                    throw new RecPayException(RecPayException.RECBIZTYPEISNULL);
                }
                if (info.getDescription() == null || info.getDescription().length() == 0) {
                    throw new RecPayException(RecPayException.FORSETTLEMUSTHAVEDESCRIPTIONREC);
                }
                if (EmptyUtil.isEmpty((String)info.getPayerName())) {
                    throw new RecPayException(RecPayException.FORSETTLEMUSTHAVEPAYERNAME);
                }
                if (info.getBizType().getType() == SettBizTypeEnum.RECINSIDE && (info.getPayerAccountBankO() == null || info.getPayerAccountBankO().getInnerAcct() == null)) {
                    throw new RecPayException(RecPayException.PAYERACCOUNTMUSTHAVEINNERACCOUNT);
                }
            }
        }
        BigDecimal actualAmt = new BigDecimal("0");
        BigDecimal actualLocAmt = new BigDecimal("0");
        ReceivingBillEntryInfo entry = null;
        for (int i = info.getEntries().size() - 1; i >= 0; --i) {
            entry = info.getEntries().get(i);
            if (SourceTypeEnum.CASH.equals((Object)info.getSourceType()) && FMHelper.isZERO((BigDecimal)entry.getActualAmt())) {
                info.getEntries().remove(entry);
                int entrySeq = entry.getSeq();
                if (entrySeq > 0 && entrySeq < info.getEntries().size() + 1) {
                    ReceivingBillEntryInfo entryTemp = null;
                    AssItemsForCashRecInfo assTemp = null;
                    int size = info.getEntries().size();
                    for (int j = 0; j < size; ++j) {
                        entryTemp = info.getEntries().get(j);
                        if (entryTemp.getSeq() <= entrySeq) continue;
                        int newEntrySeq = entryTemp.getSeq() - 1;
                        entryTemp.setSeq(newEntrySeq);
                        int n = entryTemp.getAssItemsEntries().size();
                        for (int m = 0; m < n; ++m) {
                            assTemp = entryTemp.getAssItemsEntries().get(m);
                            assTemp.setEntrySeq(newEntrySeq);
                        }
                    }
                }
            }
            if (entry.getActualAmt() != null) {
                actualAmt = actualAmt.add(entry.getActualAmt());
            }
            if (entry.getActualLocAmt() == null) continue;
            actualLocAmt = actualLocAmt.add(entry.getActualLocAmt());
        }
        if (SourceTypeEnum.CASH.equals((Object)info.getSourceType()) && info.getEntries().size() == 0) {
            String msg = EASResource.getString((String)"com.kingdee.eas.fm.common.FMResource", (String)"EntryCanNotBeNull");
            throw new RecPayException(RecPayException.COMMON, new Object[]{msg});
        }
        if (info.getCompany() != null && this.getCS063()) {
            boolean flag = true;
            if (info.getEntries() != null) {
                HashSet<String> idSet = new HashSet<String>();
                ReceivingBillEntryInfo recEntryInfo = null;
                int size = info.getEntries().size();
                for (int i = 0; i < size; ++i) {
                    recEntryInfo = info.getEntries().get(i);
                    if (recEntryInfo.getOppAccount() == null || recEntryInfo.getOppAccount().getId() == null) continue;
                    idSet.add(recEntryInfo.getOppAccount().getId().toString());
                }
                EntityViewInfo view = new EntityViewInfo();
                view.getSelector().add(new SelectorItemInfo("*"));
                view.getSelector().add(new SelectorItemInfo("accountCurrency.*"));
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
                view.setFilter(filter);
                AccountViewCollection acctCollection = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewCollection(view);
                int size2 = info.getEntries().size();
                for (int i = 0; i < size2 && (flag = this.arapHelper.verifyAccountViewBoolean(ctx, acctCollection, (recEntryInfo = info.getEntries().get(i)).getOppAccount(), info.getCurrency(), info.getCompany())); ++i) {
                }
            }
            if (!flag) {
                throw new FMException(FMException.NOACCOUNTCURRENCY);
            }
        }
    }
}

