/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.wssc.BillImageFacadeFactory;
import com.kingdee.eas.base.wssc.IBillImageFacade;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.AccountType;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PaymentTypeInfo;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.ExpenseTypeCollection;
import com.kingdee.eas.cp.bc.ExpenseTypeFactory;
import com.kingdee.eas.fi.cas.ArApRecPayException;
import com.kingdee.eas.fi.cas.BgCtrlReceivingBillHandler;
import com.kingdee.eas.fi.cas.BillStatusEnum;
import com.kingdee.eas.fi.cas.CasException;
import com.kingdee.eas.fi.cas.DisposerActionEnum;
import com.kingdee.eas.fi.cas.RecPayAcctBankStratageCtrl;
import com.kingdee.eas.fi.cas.RecPayBgCtrlStrEnum;
import com.kingdee.eas.fi.cas.RecPayBillTypeEnum;
import com.kingdee.eas.fi.cas.RecPayException;
import com.kingdee.eas.fi.cas.RecPayHelper;
import com.kingdee.eas.fi.cas.RecPayOverDraftCtrlEnum;
import com.kingdee.eas.fi.cas.ReceivingBillDataProcess;
import com.kingdee.eas.fi.cas.ReceivingBillEntryCollection;
import com.kingdee.eas.fi.cas.ReceivingBillEntryInfo;
import com.kingdee.eas.fi.cas.ReceivingBillFactory;
import com.kingdee.eas.fi.cas.ReceivingBillInfo;
import com.kingdee.eas.fi.cas.ReceivingBillTypeInfo;
import com.kingdee.eas.fi.cas.SourceTypeEnum;
import com.kingdee.eas.fi.cas.app.AgentRecPayServerHelper;
import com.kingdee.eas.fi.cas.app.ArApRecPayServerHelper;
import com.kingdee.eas.fi.cas.app.service.IRecSubmitService;
import com.kingdee.eas.fi.cas.app.service.handler.ServiceHandler;
import com.kingdee.eas.fi.cas.utils.CASWebUtil;
import com.kingdee.eas.fm.cl.ConsingnRepaymentBillFactory;
import com.kingdee.eas.fm.cl.ConsingnRepaymentBillInfo;
import com.kingdee.eas.fm.common.FMBGHelper;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.common.IFMBgUsed;
import com.kingdee.eas.fm.fs.SettBizTypeEnum;
import com.kingdee.eas.fm.ft.FundTransferInterestBillFactory;
import com.kingdee.eas.fm.ft.FundTransferInterestBillInfo;
import com.kingdee.eas.fm.ft.FundTransferRepayBillFactory;
import com.kingdee.eas.fm.ft.FundTransferRepayBillInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import org.apache.log4j.Logger;

public class RecSubmitService
implements IRecSubmitService {
    private static Logger logger = Logger.getLogger((String)RecSubmitService.class.getName());
    protected Context ctx;
    protected ReceivingBillInfo info;
    protected HashMap param = new HashMap();
    protected boolean isAddNew = true;
    protected IObjectValue model;
    protected IObjectPK pk;
    protected ServiceHandler serviceHandler;
    protected boolean isHasValue = false;
    private final BOSObjectType billBosType = new ReceivingBillInfo().getBOSType();
    protected static final String AP_RESOURCE = "com.kingdee.eas.fi.ap.APResources";
    protected static final String CAS_RESOURCE = "com.kingdee.eas.fi.cas.CasResources";
    protected ArApRecPayServerHelper arapHelper = new ArApRecPayServerHelper();

    protected ServiceHandler getServiceHandler() {
        return new ServiceHandler();
    }

    @Override
    public void initService(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        this.ctx = ctx;
        this.model = model;
        this.info = (ReceivingBillInfo)model;
        this.serviceHandler = this.getServiceHandler();
        this.param.put("CS052", null);
        this.param.put("CS033", null);
        this.param.put("CS042", null);
        this.param.put("CS063", null);
        this.param.put("CS014", null);
        this.param.put("CS005", null);
        this.param.put("CS073", null);
        this.param.put("CS079", null);
        this.param.put("CS032", null);
        this.param.put("RECBILL_AUDIT_NOW", null);
        if (this.info.getCompany() != null) {
            this.param = this.getParam(ctx, (IObjectPK)new ObjectUuidPK(this.info.getCompany().getId().toString()), this.param);
        }
    }

    @Override
    public void beforeSubmit() throws EASBizException, BOSException {
        BOSUuid bosId;
        String number;
        if (!SourceTypeEnum.AR.equals((Object)this.info.getSourceType()) && (number = this.model.getString("number")) != null && number.length() > 0) {
            this.serviceHandler.checkNumberDup(this.ctx, this.model);
        }
        if (this.info.getCompany() == null) {
            this.info.setCompany(ContextHelperFactory.getLocalInstance((Context)this.ctx).getCurrentCompany());
        }
        if (this.info.getPaymentType() == null) {
            String paymentTypeId = "91f078d7-fb90-4827-83e2-3538237b67a06BCA0AB5";
            PaymentTypeInfo paymentTypeInfo = new PaymentTypeInfo();
            paymentTypeInfo.setId(BOSUuid.read((String)paymentTypeId));
            this.info.setPaymentType(paymentTypeInfo);
        }
        if ("true".equals(this.param.get("CS005")) && EmptyUtil.isEmpty((String)this.info.getOppBgItemNumber())) {
            throw new CasException(CasException.OPPBGITEMNULL);
        }
        if ("true".equals(this.param.get("CS014"))) {
            ReceivingBillEntryCollection entryCollection = this.info.getEntries();
            for (int i = 0; i < entryCollection.size(); ++i) {
                ReceivingBillEntryInfo billEntryInfo = entryCollection.get(i);
                if (!EmptyUtil.isEmpty((String)billEntryInfo.getOppBgItemNumber())) continue;
                throw new CasException(CasException.ENTRYSBGITEMNULL);
            }
        }
        if ("true".equals(this.param.get("CS032")) && !SourceTypeEnum.AR.equals((Object)this.info.getSourceType()) && EmptyUtil.isEmpty((CoreBaseInfo)this.info.getFeeType())) {
            throw new CasException(CasException.FEETYPE_NULL);
        }
        if ("true".equals(this.param.get("CS033")) && EmptyUtil.isEmpty((CoreBaseInfo)this.info.getProject())) {
            throw new CasException(CasException.PROJECT_NULL);
        }
        if (!EmptyUtil.isEmpty((String)this.info.getPayerAccountBank())) {
            AccountBankInfo acctBankInfo;
            boolean sameAccountAllowable = false;
            if (this.param.get("CS073") != null) {
                sameAccountAllowable = ((String)this.param.get("CS073")).equals("true");
            }
            if ((acctBankInfo = this.info.getPayeeAccountBank()) != null && EmptyUtil.isEmpty((String)acctBankInfo.getBankAccountNumber())) {
                acctBankInfo = AccountBankFactory.getLocalInstance((Context)this.ctx).getAccountBankInfo((IObjectPK)new ObjectUuidPK(acctBankInfo.getId()));
            }
            if (acctBankInfo != null && !sameAccountAllowable && this.info.getPayerAccountBank().equals(acctBankInfo.getBankAccountNumber())) {
                throw new RecPayException(RecPayException.COMMON, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fi.cas.web.CasWebResource", (String)"324_CantBeSameAccount", (Locale)this.ctx.getLocale())});
            }
        }
        if (this.info.isIsRefundmentPay()) {
            if (null != this.info.getPayeeAccount() && (this.info.getPayeeAccount().isIsCash() || this.info.getPayeeAccount().isIsBank())) {
                throw new ArApRecPayException(ArApRecPayException.REFUNDMENTPAYRECACCOUNT);
            }
            if (this.info.getPayeeAccountBank() != null) {
                throw new ArApRecPayException(ArApRecPayException.REFUNDMENTPAYRECBANK);
            }
            if (this.info.getPayerID() == null) {
                throw new ArApRecPayException(ArApRecPayException.REFUNDMENTPAYERISNULL);
            }
        }
        if (this.info.getCostCenter() != null) {
            this.serviceHandler.checkCostCenter(this.ctx, this.info.getCostCenter());
        }
        for (int i = 0; i < this.info.getEntries().size(); ++i) {
            if (this.info.getEntries().get(i).getCostCenter() == null) continue;
            this.serviceHandler.checkCostCenter(this.ctx, this.info.getEntries().get(i).getCostCenter());
        }
        this.checkExpenseType(this.ctx, this.info);
        ReceivingBillDataProcess.setCasAmount(this.ctx, this.info);
        FMBGHelper.fillBgItem((Context)this.ctx, (IFMBgUsed)((ReceivingBillInfo)this.model));
        IFMBgUsed[] entryInfoNumber = new IFMBgUsed[this.info.getEntries().size()];
        int n = this.info.getEntries().size();
        for (int i = 0; i < n; ++i) {
            entryInfoNumber[i] = this.info.getEntries().get(i);
        }
        FMBGHelper.fillBgItem((Context)this.ctx, (IFMBgUsed[])entryInfoNumber);
        if (null != this.info.getId() && ReceivingBillFactory.getLocalInstance(this.ctx).exists((IObjectPK)new ObjectUuidPK(this.info.getId()))) {
            this.isAddNew = false;
        }
        if (!(EmptyUtil.isEmpty((CoreBaseInfo)this.info.getPayeeAccountBank()) || EmptyUtil.isEmpty((CoreBaseInfo)this.info.getPayeeAccountBank().getAccount()) || EmptyUtil.isEmpty((CoreBaseInfo)this.info.getPayeeAccount()) || this.info.getPayeeAccountBank().getAccount().getId().equals((Object)this.info.getPayeeAccount().getId()))) {
            throw new CasException(CasException.ACCOUNTVIEWNOTEQUAL);
        }
        if (!EmptyUtil.isEmpty((CoreBaseInfo)this.info.getPayeeAccountBank())) {
            AccountBankInfo payeeAcctBank = AccountBankFactory.getLocalInstance((Context)this.ctx).getAccountBankInfo((IObjectPK)new ObjectUuidPK(this.info.getPayeeAccountBank().getId().toString()));
            ReceivingBillTypeInfo billType = this.info.getRecBillType();
            if (!(billType != null && billType.getId().toString().equals("fjJCrQESEADgABolwKgSQyqo2zU=") || payeeAcctBank.getAccountType() != AccountType.PAYOUT)) {
                throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{EASResource.getString((String)"com.kingdee.eas.fi.cas.RecPayResource", (String)"PayeeAccountNotOut")});
            }
        }
        AgentRecPayServerHelper.saveOrSubmitPaymentBillForAgentRec(this.ctx, this.info);
        this.serviceHandler.setCommonPropertyValue(this.ctx, this.info);
        boolean cs063 = false;
        if (this.param.get("CS063") != null) {
            cs063 = ((String)this.param.get("CS063")).equals("true");
        }
        this.checkRecInfoValue(this.ctx, this.info, cs063);
        String sourceBillId = this.info.getSourceBillId();
        if (sourceBillId != null && sourceBillId.length() > 0 && ((bosId = BOSUuid.read((String)sourceBillId)).equals((Object)new FundTransferRepayBillInfo().getBOSType()) || bosId.equals((Object)new FundTransferInterestBillInfo().getBOSType()))) {
            this.info.setSourceType(SourceTypeEnum.FT);
        }
        if (this.info.getBillStatus() == null || this.info.getBillStatus().equals((Object)BillStatusEnum.SAVE)) {
            this.info.setBillStatus(BillStatusEnum.SUBMIT);
        }
        this.info.setBizDate(DateTimeUtils.truncateDate((Date)this.info.getBizDate()));
        this.serviceHandler.dispose(this.ctx, this.info, DisposerActionEnum.SUBMIT);
        if (BillStatusEnum.SUBMIT.equals((Object)this.info.getBillStatus())) {
            this.info.setLastExhangeRate(this.info.getExchangeRate());
        }
        this.checkInfoIsValid(this.ctx, this.info);
    }

    @Override
    public void afterSubmit(IObjectPK pk) throws EASBizException, BOSException {
        String sourcBillId;
        try {
            IBillImageFacade image = BillImageFacadeFactory.getLocalInstance((Context)this.ctx);
            String imageNumber = image.getImageNumber(this.billBosType.toString(), pk.toString());
            if (StringUtils.isEmpty((String)imageNumber)) {
                imageNumber = image.genImageNumber(this.billBosType.toString(), pk.toString());
            }
        }
        catch (BOSException e) {
            logger.error((Object)"\u8c03\u7528\u57fa\u7840\u7684\u6761\u7801\u63a5\u53e3\u62a5\u9519");
            logger.error((Object)e);
        }
        if (SourceTypeEnum.AR.equals((Object)this.info.getSourceType()) && this.isHasValue) {
            this.info = ReceivingBillFactory.getLocalInstance(this.ctx).getReceivingBillInfo(pk);
        }
        if (pk != null) {
            String settPK = this.info.getSourceBillId();
            int val2 = 0;
            if (this.param.get("CS052") != null) {
                val2 = Integer.parseInt((String)this.param.get("CS052"));
            }
            if (settPK != null) {
                BOSUuid uuid = BOSUuid.read((String)settPK);
                BOSObjectType bosType = uuid.getType();
                if (!"6E41E17C".equals(bosType.toString())) {
                    this.overDraftCtrls(this.ctx, this.model, RecPayOverDraftCtrlEnum.submit_ctrl, val2);
                }
            } else {
                this.overDraftCtrls(this.ctx, this.model, RecPayOverDraftCtrlEnum.submit_ctrl, val2);
            }
        }
        if (!this.info.isIsTransBill() && !this.info.isIsInitializeBill() && this.isAuditNow(this.ctx, this.info)) {
            HashSet<String> idSet = new HashSet<String>();
            idSet.add(pk.toString());
            ReceivingBillFactory.getLocalInstance(this.ctx).audit(idSet);
        }
        int val = 0;
        if (this.param.get("CS042") != null) {
            val = Integer.parseInt((String)this.param.get("CS042"));
        }
        if (!(this.info.isIsInitializeBill() || this.info.isIsTransBill() && !this.info.isIsTransOtherBill())) {
            boolean onWaybgCtrl = false;
            if (this.param.get("CS079") != null) {
                onWaybgCtrl = ((String)this.param.get("CS079")).equals("true");
            }
            if (onWaybgCtrl) {
                String boName = "com.kingdee.eas.fi.cas.app.ReceivingBill";
                String handleName = BgCtrlReceivingBillHandler.class.getName();
                RecPayHelper.OnWaybgCtrl(this.ctx, pk.toString(), boName, handleName);
            } else if (this.info.isIsTransOtherBill() && val != 0) {
                String billId = pk.toString();
                RecPayHelper.bgCtrlAudit(this.ctx, billId);
            } else {
                this.serviceHandler.bgCtrlAndAudit(this.ctx, pk, RecPayBgCtrlStrEnum.Sumbit_Sub, val);
            }
        }
        if ((sourcBillId = this.info.getSourceBillId()) != null && sourcBillId.length() > 0) {
            ObjectUuidPK objectPk = new ObjectUuidPK(sourcBillId);
            BOSUuid bosId = BOSUuid.read((String)sourcBillId);
            if (bosId.getType().equals((Object)new FundTransferRepayBillInfo().getBOSType())) {
                FundTransferRepayBillFactory.getLocalInstance((Context)this.ctx).updateRecmentBillID((IObjectPK)objectPk, (IObjectPK)new ObjectUuidPK(this.info.getId()));
            } else if (bosId.getType().equals((Object)new FundTransferInterestBillInfo().getBOSType())) {
                FundTransferInterestBillFactory.getLocalInstance((Context)this.ctx).updateRecmentBillID((IObjectPK)objectPk, (IObjectPK)new ObjectUuidPK(this.info.getId()));
            } else if (bosId.getType().equals((Object)new ConsingnRepaymentBillInfo().getBOSType())) {
                ConsingnRepaymentBillFactory.getLocalInstance((Context)this.ctx).updateRecBill((IObjectPK)objectPk, (IObjectPK)new ObjectUuidPK(this.info.getId()));
            }
        }
        if (this.isAddNew) {
            DbUtil.execute((Context)this.ctx, (String)"update T_CAS_ReceivingBill set FLastUpdateUserID=null,FLastUpdateTime=null where FID= ? ", (Object[])new String[]{pk.toString()});
        }
    }

    protected HashMap getParam(Context ctx, IObjectPK comPK, HashMap paramMap) throws BOSException, EASBizException {
        Iterator it = paramMap.keySet().iterator();
        while (it.hasNext()) {
            paramMap.put(it.next(), comPK);
        }
        IParamControl pc = ParamControlFactory.getLocalInstance((Context)ctx);
        paramMap = pc.getParamHashMap(paramMap);
        return paramMap;
    }

    protected void checkInfoIsValid(Context ctx, ReceivingBillInfo info) throws BOSException, EASBizException {
        if (info == null || info.getEntries() == null || info.getEntries().size() < 1) {
            throw new RecPayException(RecPayException.BILLENTRY_ISNULL);
        }
        this.checkRecInfoIsValid(ctx, info);
    }

    public void checkRecInfoIsValid(Context ctx, ReceivingBillInfo info) throws EASBizException, BOSException {
        boolean isCommitSettle;
        if (info == null) {
            throw new NullPointerException("ReceivingBillInfo should not be null!");
        }
        if (info.getRecBillType() == null) {
            throw new RecPayException(RecPayException.RECBILLTYPEISNULL);
        }
        String recPayType = null;
        recPayType = ResourceBase.getString((String)"com.kingdee.eas.fi.cas.RecPayResource", (String)"RecType", (Locale)ctx.getLocale());
        int recType = 100;
        try {
            recType = Integer.parseInt(info.getRecBillType().getNumber());
        }
        catch (NumberFormatException e) {
            recType = 100;
        }
        if ((recType == RecPayBillTypeEnum.REC_AR_REFUNDMENT_SELL_REC.getValue() || recType == RecPayBillTypeEnum.REC_AR_REFUNDMENT_PRE_REC.getValue() || recType == RecPayBillTypeEnum.PAY_CP_REFUNDMENT_BILL.getValue() || recType == RecPayBillTypeEnum.REC_AR_REFUNDMENT_AGENT.getValue()) && (isCommitSettle = info.isIsCommitSettle())) {
            throw new RecPayException(RecPayException.CANNOT_COMMIT_HAS_NEGATIVE, new String[]{recPayType});
        }
        if (SourceTypeEnum.AR.equals((Object)info.getSourceType()) && info.getPayerID() != null && info.getPayerType() != null && info.getCompany() != null && !RecPayHelper.isExistAsstActByCompany(ctx, info.getCompany(), info.getPayerType(), info.getPayerID())) {
            throw new RecPayException(RecPayException.ACCTCUSSENT_NOTBELONGCOMORG);
        }
        if (info.isIsInitializeBill()) {
            return;
        }
        AccountBankInfo payeeAcctBank = info.getPayeeAccountBank();
        if (payeeAcctBank != null) {
            AccountViewInfo account;
            CurrencyInfo Crinfo = info.getCurrency();
            CurrencyInfo acctBankCrinfo = payeeAcctBank.getCurrency();
            if (payeeAcctBank.isIsByCurrency() && !acctBankCrinfo.getId().equals((Object)Crinfo.getId())) {
                throw new RecPayException(RecPayException.COMMON, new String[]{CASWebUtil.getResource(ctx, "CURRENCY_AND_ACCTBANKCURRENCY_NOT_SAME")});
            }
            if (payeeAcctBank.getAccount() != null && (account = info.getPayeeAccount()) != null && !payeeAcctBank.getAccount().getId().equals((Object)account.getId())) {
                throw new RecPayException(RecPayException.COMMON, new String[]{CASWebUtil.getResource(ctx, "ACCT_AND_ACCTBANKACCT_NOT_SAME")});
            }
            AccountBankInfo payerAccountBank = info.getPayerAccountBankO();
            String payerAccount = info.getPayerAccountBank();
            if (payerAccountBank != null && payerAccount != null && payerAccountBank.isIsByCurrency() && !Crinfo.getId().equals((Object)payerAccountBank.getCurrency().getId())) {
                throw new RecPayException(RecPayException.COMMON, new String[]{CASWebUtil.getResource(ctx, "302_PAYERCURR_NOTEQ_PAYEECURR")});
            }
        }
    }

    protected void overDraftCtrls(Context ctx, IObjectValue model, RecPayOverDraftCtrlEnum enums, int val) throws BOSException, EASBizException {
        if (enums.getValue() - 1 == val) {
            RecPayAcctBankStratageCtrl.acctBankBalanceCtrl(ctx, model);
        }
    }

    protected boolean isAuditNow(Context ctx, ReceivingBillInfo info) throws BOSException {
        boolean isArRecBill = SourceTypeEnum.AR.equals((Object)info.getSourceType());
        boolean isAuditNow = "true".equalsIgnoreCase(String.valueOf(this.param.get("RECBILL_AUDIT_NOW")));
        return isArRecBill && isAuditNow && !info.isIsInitializeBill();
    }

    protected void bgCtrlAndAudit(Context ctx, IObjectPK pk, RecPayBgCtrlStrEnum enums, int val) throws BOSException, EASBizException {
        String billId = pk.toString();
        if (enums.getValue() == val) {
            RecPayHelper.bgCtrlAudit(ctx, billId);
        }
    }

    protected void checkRecInfoValue(Context ctx, ReceivingBillInfo info, boolean cs063) throws EASBizException, BOSException {
        if (EmptyUtil.isEmpty((String)info.getSourceBillId()) && info.getPayeeAccountBank() != null) {
            AccountBankInfo payeeAcctBank = info.getPayeeAccountBank();
            if (info.getPayeeBank() != null && info.getPayeeBank().isInGroup() && info.getBizType() == null) {
                throw new RecPayException(RecPayException.RECBIZTYPEISNULL);
            }
            if (payeeAcctBank.getInnerAcct() != null && info.getBizType() != null && !info.getBizType().isNotSubmitHouse()) {
                if (info.getBizType() == null) {
                    throw new RecPayException(RecPayException.RECBIZTYPEISNULL);
                }
                if (info.getDescription() == null || info.getDescription().length() == 0) {
                    throw new RecPayException(RecPayException.FORSETTLEMUSTHAVEDESCRIPTIONREC);
                }
                if (info.getBizType().getType() == SettBizTypeEnum.RECINSIDE && (info.getPayerAccountBankO() == null || info.getPayerAccountBankO().getInnerAcct() == null)) {
                    throw new RecPayException(RecPayException.PAYERACCOUNTMUSTHAVEINNERACCOUNT);
                }
                if (EmptyUtil.isEmpty((String)info.getPayerName())) {
                    throw new RecPayException(RecPayException.FORSETTLEMUSTHAVEPAYERNAME);
                }
            }
        }
        if (cs063) {
            boolean flag = true;
            if (info.getEntries() != null) {
                HashSet<String> idSet = new HashSet<String>();
                ReceivingBillEntryInfo recEntryInfo = null;
                int size = info.getEntries().size();
                for (int i = 0; i < size; ++i) {
                    recEntryInfo = info.getEntries().get(i);
                    if (recEntryInfo.getOppAccount() == null || recEntryInfo.getOppAccount().getId() == null) continue;
                    idSet.add(recEntryInfo.getOppAccount().getId().toString());
                }
                EntityViewInfo view = new EntityViewInfo();
                view.getSelector().add(new SelectorItemInfo("*"));
                view.getSelector().add(new SelectorItemInfo("accountCurrency.*"));
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
                view.setFilter(filter);
                AccountViewCollection acctCollection = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewCollection(view);
                int size2 = info.getEntries().size();
                for (int i = 0; i < size2 && (flag = this.arapHelper.verifyAccountViewBoolean(ctx, acctCollection, (recEntryInfo = info.getEntries().get(i)).getOppAccount(), info.getCurrency(), info.getCompany())); ++i) {
                }
            }
            if (!flag) {
                throw new FMException(FMException.NOACCOUNTCURRENCY);
            }
        }
    }

    private void checkExpenseType(Context ctx, ReceivingBillInfo info) throws BOSException, EASBizException {
        ReceivingBillEntryInfo billEntryInfo = null;
        ReceivingBillEntryCollection entryCollection = info.getEntries();
        for (int i = 0; i < entryCollection.size(); ++i) {
            billEntryInfo = entryCollection.get(i);
            if (EmptyUtil.isEmpty((CoreBaseInfo)billEntryInfo.getExpenseType()) || EmptyUtil.isEmpty((Object)billEntryInfo.getExpenseType().getId())) continue;
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)billEntryInfo.getExpenseType().getId(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("billTypeName", (Object)"%\u6536\u6b3e\u5355%", CompareType.LIKE));
            ev.setFilter(filter);
            ExpenseTypeCollection coll = ExpenseTypeFactory.getLocalInstance((Context)ctx).getExpenseTypeCollection(ev);
            if (coll.size() != 0) continue;
            throw new CasException(CasException.EXPENSETYPECHECK);
        }
    }
}

