/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app.service.handler;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.log.define.LogItemCollection;
import com.kingdee.bos.service.log.define.LogItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.base.core.util.BOTPUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.core.util.NumberRuleUtil;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.IAccountBank;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.common.perf.CreateJobFacadeFactory;
import com.kingdee.eas.basedata.common.perf.ICreateJobFacade;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyInfoInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyBankCollection;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyBankInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyInfoInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.BizAccountBillInfo;
import com.kingdee.eas.cp.bc.EvectionLoanBillInfo;
import com.kingdee.eas.cp.bc.ExpenseTypeInfo;
import com.kingdee.eas.cp.bc.ExpenseTypeSubjectMappingCollection;
import com.kingdee.eas.cp.bc.ExpenseTypeSubjectMappingFactory;
import com.kingdee.eas.cp.bc.TravelAccountBillInfo;
import com.kingdee.eas.fi.cas.AssItemsForCashPayCollection;
import com.kingdee.eas.fi.cas.AssItemsForCashPayInfo;
import com.kingdee.eas.fi.cas.AssItemsForCashRecInfo;
import com.kingdee.eas.fi.cas.BillDisposerAction;
import com.kingdee.eas.fi.cas.BillStatusEnum;
import com.kingdee.eas.fi.cas.CasException;
import com.kingdee.eas.fi.cas.CasForArApException;
import com.kingdee.eas.fi.cas.DisposerActionEnum;
import com.kingdee.eas.fi.cas.FundDispatchTypeEnum;
import com.kingdee.eas.fi.cas.IPaymentBill;
import com.kingdee.eas.fi.cas.IPaymentDisposer;
import com.kingdee.eas.fi.cas.IReceivingBill;
import com.kingdee.eas.fi.cas.IsMergencyEnum;
import com.kingdee.eas.fi.cas.PaymentBillCollection;
import com.kingdee.eas.fi.cas.PaymentBillEntryCollection;
import com.kingdee.eas.fi.cas.PaymentBillEntryInfo;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.cas.PaymentBillTypeFactory;
import com.kingdee.eas.fi.cas.PaymentBillTypeInfo;
import com.kingdee.eas.fi.cas.PaymentDisposerFactory;
import com.kingdee.eas.fi.cas.RecPayAcctBankStratageCtrl;
import com.kingdee.eas.fi.cas.RecPayBgCtrlStrEnum;
import com.kingdee.eas.fi.cas.RecPayBillInfo;
import com.kingdee.eas.fi.cas.RecPayException;
import com.kingdee.eas.fi.cas.RecPayHelper;
import com.kingdee.eas.fi.cas.RecPayOverDraftCtrlEnum;
import com.kingdee.eas.fi.cas.ReceivingBillCollection;
import com.kingdee.eas.fi.cas.ReceivingBillEntryCollection;
import com.kingdee.eas.fi.cas.ReceivingBillEntryInfo;
import com.kingdee.eas.fi.cas.ReceivingBillFactory;
import com.kingdee.eas.fi.cas.ReceivingBillInfo;
import com.kingdee.eas.fi.cas.ReceivingBillTypeFactory;
import com.kingdee.eas.fi.cas.ReceivingBillTypeInfo;
import com.kingdee.eas.fi.cas.ReceivingDisposerFactory;
import com.kingdee.eas.fi.cas.SourceTypeEnum;
import com.kingdee.eas.fi.cas.app.ArApRecPayServerHelper;
import com.kingdee.eas.fm.cbs.CBPaymentFactory;
import com.kingdee.eas.fm.cbs.CBPaymentInfo;
import com.kingdee.eas.fm.cl.ConsignmentLoanBillInfo;
import com.kingdee.eas.fm.common.CSBankInfo;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.util.MessageDigestTools;
import com.kingdee.eas.fm.fee.FeeBillInfo;
import com.kingdee.eas.fm.fs.SettBizTypeEnum;
import com.kingdee.eas.fm.fs.SettBizTypeFactory;
import com.kingdee.eas.fm.fs.SettBizTypeInfo;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.IBillBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.ma.nbudget.BgControlCaller;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ServiceHandler {
    private static Logger logger = Logger.getLogger((String)ServiceHandler.class.getName());
    protected static final BigDecimal ZERO = new BigDecimal("0.00");
    protected String resourcePath = "com.kingdee.eas.fi.ar.ARRecPayResource";
    public static final String TAGBILLHEAD = "billHead";
    private static String xmlParserImpl = "org.apache.xerces.jaxp.DocumentBuilderFactoryImpl";

    public HashMap getParam(Context ctx, IObjectPK companyPK, HashMap paramMap) throws BOSException, EASBizException {
        Iterator it = paramMap.keySet().iterator();
        while (it.hasNext()) {
            paramMap.put(it.next(), companyPK);
        }
        IParamControl pc = ParamControlFactory.getLocalInstance((Context)ctx);
        paramMap = pc.getParamHashMap(paramMap);
        return paramMap;
    }

    public void overDraftCtrls(Context ctx, IObjectPK pk, RecPayOverDraftCtrlEnum enums, int val) throws BOSException, EASBizException {
        if (enums.getValue() - 1 == val) {
            RecPayAcctBankStratageCtrl.acctBankBalanceCtrl(ctx, pk);
        }
    }

    public void overDraftCtrls(Context ctx, IObjectValue model, RecPayOverDraftCtrlEnum enums, int val) throws BOSException, EASBizException {
        if (enums.getValue() - 1 == val) {
            RecPayAcctBankStratageCtrl.acctBankBalanceCtrl(ctx, model);
        }
    }

    public void checkBizDate(PaymentBillInfo info) {
        if (info.getBizDate() == null) {
            info.setBizDate(new Date());
        }
    }

    public PeriodInfo checkSystemIfStart(Context ctx, SystemEnum sourceType, CompanyOrgUnitInfo companyInfo) {
        PeriodInfo period = null;
        try {
            period = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)sourceType, (CompanyOrgUnitInfo)companyInfo);
        }
        catch (EASBizException e) {
            logger.info((Object)e);
        }
        catch (BOSException e) {
            logger.info((Object)e);
        }
        return period;
    }

    public BOSObjectType getSrcBillBOSType(PaymentBillInfo info) throws RecPayException {
        if (info == null || info.getEntries() == null || info.getEntries().size() < 1) {
            throw new RecPayException(RecPayException.BILLENTRY_ISNULL);
        }
        String srcBillID = null;
        int i = 0;
        int size = info.getEntries().size();
        if (i < size) {
            if (info.getEntries().get(i).getSourceBillId() == null) {
                return null;
            }
            srcBillID = info.getEntries().get(i).getSourceBillId();
        }
        BOSObjectType srcBOSType = BOSUuid.getBOSObjectType(srcBillID, (boolean)true);
        return srcBOSType;
    }

    public EntityViewInfo getIdSetView(Set idSet) {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        return view;
    }

    public void checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        String number = model.getString("number");
        if (number == null || number.length() <= 0) {
            throw new EASBizException(EASBizException.CHECKNUMBLANK);
        }
        model.setString("number", number.trim());
        FilterInfo filter = NumberRuleUtil.getCheckNumberDupFilter((IObjectValue)model, (boolean)true);
        if (model instanceof PaymentBillInfo && PaymentBillFactory.getLocalInstance(ctx).exists(filter) || model instanceof ReceivingBillInfo && ReceivingBillFactory.getLocalInstance(ctx).exists(filter)) {
            throw new EASBizException(EASBizException.CHECKDUPNUMBER, new Object[]{model.getString("number"), ""});
        }
    }

    public void setCommonPropertyValue(Context ctx, PaymentBillInfo info) throws BOSException, EASBizException {
        if (info.getPayBillType() != null) {
            if (info.getPayBillType().getSourceSysType() != null) {
                info.setSourceType(info.getPayBillType().getSourceSysType());
            } else {
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("sourceSysType"));
                PaymentBillTypeInfo paymentBillType = PaymentBillTypeFactory.getLocalInstance(ctx).getPaymentBillTypeInfo((IObjectPK)new ObjectUuidPK(info.getPayBillType().getId()), sic);
                info.setSourceType(paymentBillType.getSourceSysType());
            }
        } else {
            info.setSourceType(SourceTypeEnum.CASH);
        }
        if (info.getBizType() != null) {
            SettBizTypeInfo sbti = SettBizTypeFactory.getLocalInstance((Context)ctx).getSettBizTypeInfo((IObjectPK)new ObjectUuidPK(info.getBizType().getId()));
            info.setSettleBizType(sbti.getType());
        }
        if (info.getIsEmergency() == null) {
            info.setIsEmergency(IsMergencyEnum.normal);
        }
        if (null != info.getPayBillType()) {
            boolean isRealTrue = false;
            if (!info.getPayBillType().isIsFinanceTranUp()) {
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("isFinanceTranUp"));
                PaymentBillTypeInfo paymentBillType = PaymentBillTypeFactory.getLocalInstance(ctx).getPaymentBillTypeInfo((IObjectPK)new ObjectUuidPK(info.getPayBillType().getId()), sic);
                isRealTrue = paymentBillType.isIsFinanceTranUp();
            }
            if (info.getPayBillType().isIsFinanceTranUp() || isRealTrue) {
                if (info.getActRecAccountBank() == null) {
                    info.setActRecAccountBank(info.getPayeeAccountBankO());
                }
                info.setPayeeAccountBank(null);
                info.setPayeeAccountBankO(null);
            } else {
                info.setActRecAccountBank(null);
            }
        }
        if (info.getCompany() != null && info.getCompany().getBaseCurrency() == null) {
            CompanyOrgUnitInfo cmp = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectStringPK(info.getCompany().getId().toString()));
            info.setCompany(cmp);
        }
        if (info.getPayBillType() != null && info.getPayBillType().getId() != null) {
            PaymentBillTypeInfo payBillType = PaymentBillTypeFactory.getLocalInstance(ctx).getPaymentBillTypeInfo((IObjectPK)new ObjectUuidPK(info.getPayBillType().getId()));
            if (payBillType.isIsReturnBg() && info.getActPayAmt() != null) {
                info.setBgCtrlAmt(info.getActPayAmt().multiply(Constants._ONE));
            } else {
                info.setBgCtrlAmt(info.getActPayAmt());
            }
        }
        if (info.getPayerAccount() != null) {
            AccountViewInfo accInfo = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewInfo((IObjectPK)new ObjectStringPK(info.getPayerAccount().getId().toString()));
            info.setPayerAccount(accInfo);
        }
        if (!SourceTypeEnum.AP.equals((Object)info.getSourceType()) && info.getPayeeType() instanceof AsstActTypeInfo) {
            try {
                this.setOtherPropertyForAsstAct(ctx, info);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        if (EmptyUtil.isEmpty((CoreBaseInfo)info.getCurrency())) {
            String msg = EASResource.getString((String)"com.kingdee.eas.fm.common.FMResource", (String)"currencyCanNotBeNullValue");
            throw new RecPayException(RecPayException.COMMON, new Object[]{msg});
        }
        BigDecimal actualAmt = new BigDecimal("0");
        BigDecimal actualLocAmt = new BigDecimal("0");
        PaymentBillEntryInfo entry = null;
        for (int i = info.getEntries().size() - 1; i >= 0; --i) {
            entry = info.getEntries().get(i);
            if (SourceTypeEnum.CASH.equals((Object)info.getSourceType()) && FMHelper.isZERO((BigDecimal)entry.getActualAmt())) {
                info.getEntries().remove(entry);
                int entrySeq = entry.getSeq();
                if (entrySeq > 0 && entrySeq < info.getEntries().size() + 1) {
                    PaymentBillEntryInfo entryTemp = null;
                    AssItemsForCashPayInfo assTemp = null;
                    int size = info.getEntries().size();
                    for (int j = 0; j < size; ++j) {
                        entryTemp = info.getEntries().get(j);
                        if (entryTemp.getSeq() <= entrySeq) continue;
                        int newEntrySeq = entryTemp.getSeq() - 1;
                        entryTemp.setSeq(newEntrySeq);
                        int n = entryTemp.getAssItemsEntries().size();
                        for (int m = 0; m < n; ++m) {
                            assTemp = entryTemp.getAssItemsEntries().get(m);
                            assTemp.setEntrySeq(newEntrySeq);
                        }
                    }
                }
            }
            if (entry.getActualAmt() != null) {
                actualAmt = actualAmt.add(entry.getActualAmt());
            }
            if (entry.getActualLocAmt() == null) continue;
            actualLocAmt = actualLocAmt.add(entry.getActualLocAmt());
        }
        if (SourceTypeEnum.CASH.equals((Object)info.getSourceType()) && info.getEntries().size() == 0) {
            String msg = "";
            FundDispatchTypeEnum fundDispatchType = info.getFundDispatchType();
            msg = FundDispatchTypeEnum.NOT_SAME_NAME.equals((Object)fundDispatchType) || FundDispatchTypeEnum.SAME_COMPANY.equals((Object)fundDispatchType) ? EASResource.getString((String)"com.kingdee.eas.fm.common.FMResource", (String)"AmountCanNotBeZero") : EASResource.getString((String)"com.kingdee.eas.fm.common.FMResource", (String)"EntryCanNotBeNull");
            throw new RecPayException(RecPayException.COMMON, new Object[]{msg});
        }
        if (!info.isIsCBPay()) {
            info.setActPayAmt(actualAmt);
            info.setActPayLocAmt(actualLocAmt);
        }
        if (EmptyUtil.isEmpty((CoreBaseInfo)info.getLastUpdateUser())) {
            info.setLastUpdateUser(info.getCreator());
            info.setLastUpdateTime(info.getCreateTime());
        }
        if (EmptyUtil.isEmpty((CoreBaseInfo)info.getPayBillType())) {
            PaymentBillTypeInfo paytype = new PaymentBillTypeInfo();
            paytype.setId(BOSUuid.read((String)"NLGLdwEREADgAAIGwKgSRj6TKVs="));
            info.setPayBillType(paytype);
        }
        if (!EmptyUtil.isEmpty((CoreBaseInfo)info.getPayeeAccountBankO())) {
            info.setOppInnerAcct(info.getPayeeAccountBankO().getInnerAcct());
        } else {
            info.setOppInnerAcct(null);
        }
        this.initEntryOppAccount(ctx, info);
    }

    protected void initEntryOppAccount(Context ctx, PaymentBillInfo info) throws BOSException, EASBizException {
        BOSUuid sbid;
        if (!EmptyUtil.isEmpty((String)info.getSourceBillId()) && ((sbid = BOSUuid.read((String)info.getSourceBillId())).getType().equals((Object)new BizAccountBillInfo().getBOSType()) || sbid.getType().equals((Object)new TravelAccountBillInfo().getBOSType()) || sbid.getType().equals((Object)new EvectionLoanBillInfo().getBOSType()))) {
            for (int index = 0; index < info.getEntries().size(); ++index) {
                ExpenseTypeInfo expenseType = info.getEntries().get(index).getExpenseType();
                if (EmptyUtil.isEmpty((CoreBaseInfo)expenseType)) continue;
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                view.setFilter(filter);
                SelectorItemCollection sic = new SelectorItemCollection();
                view.setSelector(sic);
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("accountId.*"));
                filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)info.getCompany().getId().toString()));
                filter.getFilterItems().add(new FilterItemInfo("expenseTypeId.id", (Object)expenseType.getId().toString()));
                ExpenseTypeSubjectMappingCollection colls = ExpenseTypeSubjectMappingFactory.getLocalInstance((Context)ctx).getExpenseTypeSubjectMappingCollection(view);
                if (colls.size() <= 0) continue;
                AccountViewInfo oppAcct = colls.get(0).getAccountId();
                if (!EmptyUtil.isEmpty((CoreBaseInfo)info.getEntries().get(index).getOppAccount())) continue;
                ObjectUuidPK pk = new ObjectUuidPK(info.getId());
                if (!EmptyUtil.isEmpty((Object)info.getId()) && (EmptyUtil.isEmpty((Object)info.getId()) || PaymentBillFactory.getLocalInstance(ctx).exists((IObjectPK)pk))) continue;
                info.getEntries().get(index).setOppAccount(oppAcct);
            }
        }
    }

    public void setCommonPropertyValue(Context ctx, ReceivingBillInfo info) throws BOSException, EASBizException {
        if (info.getSourceType() == null) {
            if (info.getRecBillType() != null) {
                if (info.getRecBillType().getSourceSysType() != null) {
                    info.setSourceType(info.getRecBillType().getSourceSysType());
                } else {
                    SelectorItemCollection sic = new SelectorItemCollection();
                    sic.add(new SelectorItemInfo("sourceSysType"));
                    ReceivingBillTypeInfo receivingBillType = ReceivingBillTypeFactory.getLocalInstance(ctx).getReceivingBillTypeInfo((IObjectPK)new ObjectUuidPK(info.getRecBillType().getId()), sic);
                    info.setSourceType(receivingBillType.getSourceSysType());
                }
            } else {
                info.setSourceType(SourceTypeEnum.CASH);
            }
        }
        if (info.getPayerAccountBankO() == null) {
            String accountBankNumber = info.getPayerAccountBank();
            if (accountBankNumber == null || accountBankNumber.equals("")) {
                info.setPayerAccountBankO(null);
            } else {
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("bankAccountNumber", (Object)accountBankNumber, CompareType.EQUALS));
                view.setFilter(filter);
                AccountBankCollection accountBankColl = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankCollection(view);
                if (accountBankColl.size() > 0) {
                    info.setPayerAccountBankO(accountBankColl.get(0));
                }
            }
        }
        if (info.getBizType() != null) {
            SettBizTypeInfo sbti = SettBizTypeFactory.getLocalInstance((Context)ctx).getSettBizTypeInfo((IObjectPK)new ObjectUuidPK(info.getBizType().getId()));
            info.setSettleBizType(sbti.getType());
        }
        if (info.getCompany() != null && info.getCompany().getBaseCurrency() == null) {
            CompanyOrgUnitInfo cmp = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectStringPK(info.getCompany().getId().toString()));
            info.setCompany(cmp);
        }
        if (info.getPayerAccountBankO() != null) {
            AccountBankInfo bankInfo = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankInfo((IObjectPK)new ObjectStringPK(info.getPayerAccountBankO().getId().toString()));
            info.setPayerAccountBankO(bankInfo);
        }
        if (info.getPayeeAccount() != null) {
            AccountViewInfo accInfo = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewInfo((IObjectPK)new ObjectStringPK(info.getPayeeAccount().getId().toString()));
            info.setPayeeAccount(accInfo);
        }
        if (info.getRecBillType() != null) {
            ReceivingBillTypeInfo recInfo = ReceivingBillTypeFactory.getLocalInstance(ctx).getReceivingBillTypeInfo((IObjectPK)new ObjectStringPK(info.getRecBillType().getId().toString()));
            info.setRecBillType(recInfo);
            if (recInfo.isIsReturnBg()) {
                info.setBgCtrlAmt(info.getActRecAmt().multiply(Constants._ONE));
            } else {
                info.setBgCtrlAmt(info.getActRecAmt());
            }
        }
        BigDecimal actualAmt = new BigDecimal("0");
        BigDecimal actualLocAmt = new BigDecimal("0");
        ReceivingBillEntryInfo entry = null;
        for (int i = info.getEntries().size() - 1; i >= 0; --i) {
            entry = info.getEntries().get(i);
            if (SourceTypeEnum.CASH.equals((Object)info.getSourceType()) && FMHelper.isZERO((BigDecimal)entry.getActualAmt())) {
                info.getEntries().remove(entry);
                int entrySeq = entry.getSeq();
                if (entrySeq > 0 && entrySeq < info.getEntries().size() + 1) {
                    ReceivingBillEntryInfo entryTemp = null;
                    AssItemsForCashRecInfo assTemp = null;
                    int size = info.getEntries().size();
                    for (int j = 0; j < size; ++j) {
                        entryTemp = info.getEntries().get(j);
                        if (entryTemp.getSeq() <= entrySeq) continue;
                        int newEntrySeq = entryTemp.getSeq() - 1;
                        entryTemp.setSeq(newEntrySeq);
                        int n = entryTemp.getAssItemsEntries().size();
                        for (int m = 0; m < n; ++m) {
                            assTemp = entryTemp.getAssItemsEntries().get(m);
                            assTemp.setEntrySeq(newEntrySeq);
                        }
                    }
                }
            }
            if (entry.getActualAmt() != null) {
                actualAmt = actualAmt.add(entry.getActualAmt());
            }
            if (entry.getActualLocAmt() == null) continue;
            actualLocAmt = actualLocAmt.add(entry.getActualLocAmt());
        }
        info.setActRecAmt(actualAmt);
        info.setActRecLocAmt(actualLocAmt);
        if (info.getPayerType() instanceof AsstActTypeInfo) {
            try {
                this.setOtherPropertyForAsstAct(ctx, info);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        String payertype = "";
        if (info.getPayerType() != null) {
            payertype = info.getPayerType().getRealtionDataObject();
        }
        if (0 == info.getPrintCount()) {
            info.setPrintCount(1);
        }
    }

    public void setOtherPropertyForAsstAct(Context ctx, ReceivingBillInfo info) throws Exception {
        String id = info.getPayerID();
        if (info.getPayerAccountBank() == null) {
            CSBankInfo bankInfo;
            if ("supplier".equals(info.getPayerType().getAsstHGAttribute()) || "provider".equals(info.getPayerType().getAsstHGAttribute())) {
                SupplierInfo realSupplier = SupplierFactory.getLocalInstance((Context)ctx).getSupplierInfo((IObjectPK)new ObjectUuidPK(id));
                SupplierCompanyInfoInfo supplierCompany = SupplierFactory.getLocalInstance((Context)ctx).getCompanyInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()));
                if (supplierCompany != null) {
                    bankInfo = FMHelper.getCSBankInfo((Context)ctx, (Object)realSupplier, (String)info.getCompany().getId().toString());
                    info.setPayerAccountBank(bankInfo.getBankAccount());
                    info.setPayerBank(bankInfo.getBank());
                } else {
                    info.setPayerAccountBank(null);
                    info.setPayerBank(null);
                }
            }
            if ("customer".equals(info.getPayerType().getAsstHGAttribute())) {
                CustomerInfo customer = CustomerFactory.getLocalInstance((Context)ctx).getCustomerInfo((IObjectPK)new ObjectUuidPK(id));
                CustomerCompanyInfoInfo companyCompany = CustomerFactory.getLocalInstance((Context)ctx).getCustomerCompanyInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()));
                if (companyCompany != null) {
                    bankInfo = FMHelper.getCSBankInfo((Context)ctx, (Object)customer, (String)info.getCompany().getId().toString());
                    info.setPayerAccountBank(bankInfo.getBankAccount());
                    info.setPayerBank(bankInfo.getBank());
                } else {
                    info.setPayerAccountBank(null);
                    info.setPayerBank(null);
                }
            }
        }
    }

    private void setOtherPropertyForAsstAct(Context ctx, PaymentBillInfo info) throws Exception {
        String id;
        block21: {
            block22: {
                CustomerCompanyInfoInfo customerCompany;
                SupplierCompanyBankInfo bankInfo;
                block24: {
                    int i;
                    SupplierCompanyBankCollection coll;
                    block23: {
                        SelectorItemCollection spcSelector;
                        block17: {
                            block18: {
                                SupplierCompanyInfoInfo supplierCompany;
                                block20: {
                                    block19: {
                                        id = info.getPayeeID();
                                        if (EmptyUtil.isEmpty((String)id)) {
                                            return;
                                        }
                                        if (!"supplier".equals(info.getPayeeType().getAsstHGAttribute()) && !"provider".equals(info.getPayeeType().getAsstHGAttribute())) break block17;
                                        spcSelector = new SelectorItemCollection();
                                        spcSelector.add(new SelectorItemInfo("id"));
                                        spcSelector.add(new SelectorItemInfo("supplierBank.*"));
                                        supplierCompany = SupplierFactory.getLocalInstance((Context)ctx).getCompanyInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), spcSelector);
                                        if (supplierCompany == null || supplierCompany.getSupplierBank() == null || supplierCompany.getSupplierBank().size() <= 0) break block18;
                                        coll = supplierCompany.getSupplierBank();
                                        bankInfo = null;
                                        if (info.getPayeeAccountBank() != null) break block19;
                                        for (i = 0; i < coll.size(); ++i) {
                                            if (!coll.get(i).isIsDefault()) continue;
                                            bankInfo = coll.get(i);
                                            break;
                                        }
                                        if (bankInfo == null) {
                                            bankInfo = coll.get(0);
                                        }
                                        if (info.getCbPayInfo() != null && info.getCbPayInfo().getTransType() != null && info.getCbPayInfo().getTransType().getValue() == 11 && (info.getCbPayInfo().getPayeePhoneCode() != null || info.getCbPayInfo().getPayeePhone() != null || info.getCbPayInfo().getPayeeFPSNum() != null || info.getEmail() != null) || info.getPayeeBank() != null) break block20;
                                        info.setPayeeAccountBank(bankInfo.getBankAccount());
                                        break block20;
                                    }
                                    for (i = 0; i < coll.size(); ++i) {
                                        if (!info.getPayeeAccountBank().equals(coll.get(i).getBankAccount())) continue;
                                        bankInfo = coll.get(i);
                                        break;
                                    }
                                }
                                if (info.getPayeeBank() == null && bankInfo != null) {
                                    info.setPayeeBank(bankInfo.getBank());
                                }
                                if (EmptyUtil.isEmpty((String)info.getEmail()) && !info.isIsCBPay()) {
                                    info.setEmail(supplierCompany.getEmail());
                                }
                                break block17;
                            }
                            if (info.getPayeeAccountBank() == null) {
                                info.setPayeeAccountBank(null);
                            }
                            if (info.getPayeeBank() == null) {
                                info.setPayeeBank(null);
                            }
                        }
                        if (!"customer".equals(info.getPayeeType().getAsstHGAttribute())) break block21;
                        spcSelector = new SelectorItemCollection();
                        spcSelector.add(new SelectorItemInfo("id"));
                        spcSelector.add(new SelectorItemInfo("customerBank.*"));
                        customerCompany = CustomerFactory.getLocalInstance((Context)ctx).getCustomerCompanyInfo((IObjectPK)new ObjectUuidPK(info.getPayeeID()), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), spcSelector);
                        if (customerCompany == null || customerCompany.getCustomerBank() == null || customerCompany.getCustomerBank().size() <= 0) break block22;
                        coll = customerCompany.getCustomerBank();
                        bankInfo = null;
                        if (info.getPayeeAccountBank() != null) break block23;
                        for (i = 0; i < coll.size(); ++i) {
                            if (!coll.get(i).isIsDefault()) continue;
                            bankInfo = coll.get(i);
                            break;
                        }
                        if (bankInfo == null) {
                            bankInfo = coll.get(0);
                        }
                        if (info.getCbPayInfo() != null && info.getCbPayInfo().getTransType() != null && info.getCbPayInfo().getTransType().getValue() == 11 && (info.getCbPayInfo().getPayeePhoneCode() != null || info.getCbPayInfo().getPayeePhone() != null || info.getCbPayInfo().getPayeeFPSNum() != null || info.getEmail() != null) || info.getPayeeBank() != null) break block24;
                        info.setPayeeAccountBank(bankInfo.getBankAccount());
                        break block24;
                    }
                    for (i = 0; i < coll.size(); ++i) {
                        if (!info.getPayeeAccountBank().equals(coll.get(i).getBankAccount())) continue;
                        bankInfo = coll.get(i);
                        break;
                    }
                }
                if (info.getPayeeBank() == null && bankInfo != null) {
                    info.setPayeeBank(bankInfo.getBank());
                }
                if (EmptyUtil.isEmpty((String)info.getEmail()) && !info.isIsCBPay()) {
                    info.setEmail(customerCompany.getEmail());
                }
                break block21;
            }
            if (info.getPayeeAccountBank() == null) {
                info.setPayeeAccountBank(null);
            }
            if (info.getPayeeBank() == null) {
                info.setPayeeBank(null);
            }
        }
        if ("person".equals(info.getPayeeType().getAsstHGAttribute())) {
            PersonInfo person = PersonFactory.getLocalInstance((Context)ctx).getPersonInfo((IObjectPK)new ObjectUuidPK(id));
            if (EmptyUtil.isEmpty((String)info.getEmail()) && !info.isIsCBPay()) {
                info.setEmail(person.getEmail());
            }
        }
    }

    public void checkPayInfoValue(Context ctx, PaymentBillInfo info, boolean cs064) throws EASBizException, BOSException {
        if (info.getPayerAccountBank() != null) {
            AccountBankInfo payerAcctBank = info.getPayerAccountBank();
            if (!(info.getPayerBank() == null || !info.getPayerBank().isInGroup() || info.getPayBillType().isIsFinanceTranUp() || info.getBillStatus() == BillStatusEnum.SAVE || info.getSourceBillId() != null && new FeeBillInfo().getBOSType().equals((Object)BOSUuid.read((String)info.getSourceBillId()).getType()) || info.getBizType() != null)) {
                throw new RecPayException(RecPayException.PAYBIZTYPEISNULL);
            }
            if (payerAcctBank.getInnerAcct() != null && info.getBizType() != null && !info.getBizType().isNotSubmitHouse()) {
                if (info.getBizType() == null) {
                    throw new RecPayException(RecPayException.PAYBIZTYPEISNULL);
                }
                if (EmptyUtil.isEmpty((String)info.getSourceBillId())) {
                    boolean isProvinceRequred;
                    if (!EmptyUtil.isEmpty((String)info.getPayeeAccountBank())) {
                        info.setPayeeAccountBankO(this.getBankByPayeeAccountBank(ctx, info.getPayeeAccountBank()));
                    }
                    if (info.getBizType().getType() == SettBizTypeEnum.PAYINSIDE) {
                        if (info.getPayeeAccountBankO() == null || info.getPayeeAccountBankO().getInnerAcct() == null) {
                            throw new RecPayException(RecPayException.PAYEEACCOUNTMUSTHAVEINNERACCOUNT);
                        }
                    } else if ((info.getBizType().getType().equals((Object)SettBizTypeEnum.PAYOUTSIDE) || info.getBizType().getType().equals((Object)SettBizTypeEnum.LINKPAY)) && info.getRecProvince() == null && EmptyUtil.isEmpty((Object)ctx.get((Object)"fromSchedule")) && (isProvinceRequred = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("CS051", (IObjectPK)new ObjectUuidPK(info.getCompany().getId())))) {
                        throw new RecPayException(RecPayException.FORSETTLEMUSTHAVEPROVINCE);
                    }
                    if (EmptyUtil.isEmpty((Object)ctx.get((Object)"fromSchedule")) && (info.getSourceBillId() == null || !new FeeBillInfo().getBOSType().equals((Object)BOSUuid.read((String)info.getSourceBillId()).getType())) && EmptyUtil.isEmpty((String)info.getDescription())) {
                        throw new RecPayException(RecPayException.FORSETTLEMUSTHAVEDESCRIPTION);
                    }
                    if (EmptyUtil.isEmpty((String)info.getPayeeName())) {
                        throw new RecPayException(RecPayException.FORSETTLEMUSTHAVEPAYEENAME);
                    }
                }
            }
        }
        if (info.getCompany() != null && cs064) {
            boolean flag = true;
            if (info.getEntries() != null) {
                HashSet<String> idSet = new HashSet<String>();
                PaymentBillEntryInfo payEntryInfo = null;
                int size = info.getEntries().size();
                for (int i = 0; i < size; ++i) {
                    payEntryInfo = info.getEntries().get(i);
                    if (payEntryInfo.getOppAccount() == null || payEntryInfo.getOppAccount().getId() == null) continue;
                    idSet.add(payEntryInfo.getOppAccount().getId().toString());
                }
                EntityViewInfo view = new EntityViewInfo();
                view.getSelector().add(new SelectorItemInfo("*"));
                view.getSelector().add(new SelectorItemInfo("accountCurrency.*"));
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
                view.setFilter(filter);
                AccountViewCollection acctCollection = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewCollection(view);
                ArApRecPayServerHelper arapHelper = new ArApRecPayServerHelper();
                int size2 = info.getEntries().size();
                for (int i = 0; i < size2 && (flag = arapHelper.verifyAccountViewBoolean(ctx, acctCollection, (payEntryInfo = info.getEntries().get(i)).getOppAccount(), info.getCurrency(), info.getCompany())); ++i) {
                }
            }
            if (!flag) {
                throw new FMException(FMException.NOACCOUNTCURRENCY);
            }
        }
        if (info.getSourceSysType() == SourceTypeEnum.EIP && info.getId() != null) {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("actPayAmt"));
            IPaymentBill iPaymentBill = PaymentBillFactory.getLocalInstance(ctx);
            if (iPaymentBill.exists((IObjectPK)new ObjectUuidPK(info.getId().toString()))) {
                PaymentBillInfo paymentBillInfo = iPaymentBill.getPaymentBillInfo((IObjectPK)new ObjectUuidPK(info.getId().toString()), selector);
                if (info.getActPayAmt().compareTo(paymentBillInfo.getActPayAmt()) != 0) {
                    throw new RecPayException(RecPayException.NOEDIT_EIP);
                }
            }
        }
    }

    public void dispose(Context ctx, ReceivingBillInfo info, DisposerActionEnum disposerActionEnum) throws BOSException, EASBizException {
        String className = "";
        ReceivingBillEntryCollection entryColl = info.getEntries();
        ReceivingBillEntryInfo entryInfo = null;
        Object disposer = null;
        int size = entryColl.size();
        for (int i = 0; i < size; ++i) {
            entryInfo = entryColl.get(i);
            if (entryInfo == null) continue;
            if (DisposerActionEnum.CANCEL_REC.equals((Object)disposerActionEnum) && (disposer = ArApRecPayServerHelper.getSettlementBillDisPoser(ctx, info)) != null || EmptyUtil.isEmpty((Object)(disposer = ReceivingDisposerFactory.getInstance(ctx, entryInfo.getSourceBillId())))) break;
            break;
        }
        if (disposer != null) {
            if (disposer.getClass() != null && !StringUtils.isEmpty((String)disposer.getClass().getName())) {
                className = disposer.getClass().getName();
            }
            if (DisposerActionEnum.REC != disposerActionEnum && DisposerActionEnum.CANCEL_REC != disposerActionEnum && ("com.kingdee.eas.fi.ar.OtherBillDisposer".equals(className) || "com.kingdee.eas.scm.sd.sale.SaleOrderDisposer".equals(className) || "com.kingdee.eas.scm.sd.sale.SaleContractDisposer".equals(className))) {
                HashSet<String> idSet = new HashSet<String>();
                int size2 = info.getEntries().size();
                for (int i = 0; i < size2; ++i) {
                    if (info.getEntries().get(i) == null || info.getEntries().get(i).getId() == null) continue;
                    idSet.add(info.getEntries().get(i).getId().toString());
                }
            }
            BillDisposerAction disposerAction = new BillDisposerAction();
            disposerAction.setDestBill((CoreBaseInfo)info);
            disposerAction.setActionType(disposerActionEnum);
            disposer.dispose(ctx, disposerAction);
        }
    }

    private SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("lastUpdateUser.id"));
        sic.add(new SelectorItemInfo("payerBank.*"));
        sic.add(new SelectorItemInfo("company.*"));
        sic.add(new SelectorItemInfo("settlementType.ntType.*"));
        sic.add(new SelectorItemInfo("entries.*"));
        sic.add(new SelectorItemInfo("payerAccountBank.*"));
        sic.add(new SelectorItemInfo("payerAccountBank.InnerAcct.*"));
        sic.add(new SelectorItemInfo("payerAccountBank.InnerAcct.clearingHouse.*"));
        sic.add(new SelectorItemInfo("bizType.*"));
        sic.add(new SelectorItemInfo("actRecAccountBank.*"));
        sic.add(new SelectorItemInfo("payerInAcctID.*"));
        sic.add(new SelectorItemInfo("payBillType.*"));
        sic.add(new SelectorItemInfo("cheque.*"));
        sic.add(new SelectorItemInfo("cheque.applyRec.applyCompany.id"));
        return sic;
    }

    public void dispose(Context ctx, PaymentBillInfo info, DisposerActionEnum disposerActionEnum) throws BOSException, EASBizException {
        IPaymentDisposer disposer;
        String className = "";
        boolean isAPSystem = SourceTypeEnum.AP == info.getSourceType();
        BillStatusEnum billstatus = info.getBillStatus();
        Object isFromRefund = info.get("isFromRefund");
        if (info != null && info.getId() != null && (info != null && info.getSourceBillId() == null || info != null && info.getEntries() != null && info.getEntries().get(0) != null && (info.getEntries().get(0).getSourceBillId() == null || info.getEntries().get(0).getSourceBillEntryId() == null)) && PaymentBillFactory.getLocalInstance(ctx).exists((IObjectPK)new ObjectUuidPK(info.getId().toString()))) {
            info = PaymentBillFactory.getLocalInstance(ctx).getPaymentBillInfo((IObjectPK)new ObjectUuidPK(info.getId().toString()), this.getSelector());
            if (isAPSystem) {
                info.setBillStatus(billstatus);
                info.put("isFromRefund", isFromRefund);
            }
        }
        if ((disposer = this.getDisposer(ctx, info)) != null) {
            CBPaymentInfo cbPayInfo;
            if (disposer.getClass() != null && !StringUtils.isEmpty((String)disposer.getClass().getName())) {
                className = disposer.getClass().getName();
            }
            if (DisposerActionEnum.PAY != disposerActionEnum && DisposerActionEnum.CANCEL_PAY != disposerActionEnum && ("com.kingdee.eas.fi.ap.OtherBillDisposer".equals(className) || "com.kingdee.eas.scm.sm.sc.SubContractOrderDisposer".equals(className) || "com.kingdee.eas.scm.sm.pur.PurContractDisposer".equals(className) || "com.kingdee.eas.scm.sm.pur.PurOrderDisposer".equals(className) || "com.kingdee.eas.fi.ap.PayRequestBillDisposer".equals(className))) {
                HashSet<String> idSet = new HashSet<String>();
                int size = info.getEntries().size();
                for (int i = 0; i < size; ++i) {
                    if (info.getEntries().get(i) == null || info.getEntries().get(i).getId() == null) continue;
                    idSet.add(info.getEntries().get(i).getId().toString());
                }
            }
            if (info.isIsCBPay() && !EmptyUtil.isEmpty((CoreBaseInfo)(cbPayInfo = this.getCBPaymentInfo(ctx, info.getId().toString()))) && cbPayInfo != null) {
                info.setCbPayInfo(cbPayInfo);
            }
            BillDisposerAction disposerAction = new BillDisposerAction();
            disposerAction.setDestBill((CoreBaseInfo)info);
            disposerAction.setActionType(disposerActionEnum);
            disposer.dispose(ctx, disposerAction);
            if (!EmptyUtil.isEmpty((String)info.getPayPlanBillID())) {
                IPaymentDisposer disposer4Ps = PaymentDisposerFactory.getInstance(ctx, info.getPayPlanBillID());
                disposer4Ps.dispose(ctx, disposerAction);
            }
        }
    }

    public void dispose(Context ctx, PaymentBillInfo info, PaymentBillEntryCollection coll, DisposerActionEnum disposerActionEnum) throws BOSException, EASBizException {
        IPaymentDisposer disposer;
        String className = "";
        boolean isAPSystem = SourceTypeEnum.AP == info.getSourceType();
        BillStatusEnum billstatus = info.getBillStatus();
        if (info != null && info.getId() != null && (info != null && info.getSourceBillId() == null || info != null && info.getEntries() != null && info.getEntries().get(0) != null && (info.getEntries().get(0).getSourceBillId() == null || info.getEntries().get(0).getSourceBillEntryId() == null)) && PaymentBillFactory.getLocalInstance(ctx).exists((IObjectPK)new ObjectUuidPK(info.getId().toString()))) {
            info = PaymentBillFactory.getLocalInstance(ctx).getPaymentBillInfo((IObjectPK)new ObjectUuidPK(info.getId().toString()), this.getSelector());
            if (isAPSystem) {
                info.setBillStatus(billstatus);
            }
        }
        if ((disposer = this.getDisposer(ctx, info)) != null) {
            CBPaymentInfo cbPayInfo;
            if (disposer.getClass() != null && !StringUtils.isEmpty((String)disposer.getClass().getName())) {
                className = disposer.getClass().getName();
            }
            if (DisposerActionEnum.PAY != disposerActionEnum && DisposerActionEnum.CANCEL_PAY != disposerActionEnum && ("com.kingdee.eas.fi.ap.OtherBillDisposer".equals(className) || "com.kingdee.eas.scm.sm.sc.SubContractOrderDisposer".equals(className) || "com.kingdee.eas.scm.sm.pur.PurContractDisposer".equals(className) || "com.kingdee.eas.scm.sm.pur.PurOrderDisposer".equals(className) || "com.kingdee.eas.fi.ap.PayRequestBillDisposer".equals(className))) {
                HashSet<String> idSet = new HashSet<String>();
                int size = info.getEntries().size();
                for (int i = 0; i < size; ++i) {
                    if (info.getEntries().get(i) == null || info.getEntries().get(i).getId() == null) continue;
                    idSet.add(info.getEntries().get(i).getId().toString());
                }
            }
            if (info.isIsCBPay() && !EmptyUtil.isEmpty((CoreBaseInfo)(cbPayInfo = this.getCBPaymentInfo(ctx, info.getId().toString()))) && cbPayInfo != null) {
                info.setCbPayInfo(cbPayInfo);
            }
            BillDisposerAction disposerAction = new BillDisposerAction();
            disposerAction.setDestBill((CoreBaseInfo)info);
            disposerAction.setDeleteEntry((AbstractObjectCollection)coll);
            disposerAction.setActionType(disposerActionEnum);
            disposer.dispose(ctx, disposerAction);
            if (!EmptyUtil.isEmpty((String)info.getPayPlanBillID())) {
                IPaymentDisposer disposer4Ps = PaymentDisposerFactory.getInstance(ctx, info.getPayPlanBillID());
                disposer4Ps.dispose(ctx, disposerAction);
            }
        }
    }

    public void reverseConsignment(Context ctx, PaymentBillInfo info, String isCreate) throws BOSException, EASBizException {
        String srcBillId = info.getSourceBillId();
        if (null != srcBillId && FMHelper.isInstanceof((String)srcBillId, ConsignmentLoanBillInfo.class)) {
            String sql = "Update T_CL_ConsignmentLoanBill set FIsCreateCpayment =? where Fid=?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new String[]{isCreate, srcBillId});
        }
    }

    public void bgCtrlAndAudit(Context ctx, IObjectPK pk, RecPayBgCtrlStrEnum enums, int val) throws BOSException, EASBizException {
        String billId = pk.toString();
        if (enums.getValue() == val) {
            RecPayHelper.bgCtrlAudit(ctx, billId);
        }
    }

    public String getNumbers(PaymentBillCollection coll) {
        String retStr = "";
        for (int i = 0; i < coll.size(); ++i) {
            retStr = retStr + coll.get(i).getNumber();
            if (i == coll.size() - 1) continue;
            retStr = retStr + ",";
        }
        return retStr;
    }

    public void checkIfByEdited(Context ctx, PaymentBillInfo info) throws BOSException, EASBizException, RecPayException {
        boolean editFlagValid;
        String srcPayerAccountBankNumber = info.getPayerAccountBank() != null ? info.getPayerAccountBank().getBankAccountNumber() : "";
        String srcPayeeAccountBankNumber = info.getPayeeAccountBank();
        String srcCurrency = info.getCurrency().getId().toString();
        String srcActPayAmt = info.getActPayAmt().toString();
        String editFlag = EmptyUtil.isEmpty((String)info.getEditFlagNew()) ? info.getEditFlag() : info.getEditFlagNew();
        String srcActRecAccountBank = null;
        if (info.getActRecAccountBank() != null) {
            srcActRecAccountBank = info.getActRecAccountBank().getNumber();
        }
        String srcString = srcPayerAccountBankNumber + srcPayeeAccountBankNumber + srcCurrency + srcActPayAmt + srcActRecAccountBank;
        if (info.isIsCBPay() && info.getCbPayInfo() != null && !EmptyUtil.isEmpty((String)info.getEditFlagNew())) {
            String srcPayeeCurrency = info.getCbPayInfo().getPayeeCurrency().getId().toString();
            String srcPayeeAmount = info.getCbPayInfo().getPayeeAmount().toString();
            srcString = srcPayerAccountBankNumber + srcPayeeAccountBankNumber + srcCurrency + srcActPayAmt + srcActRecAccountBank + srcPayeeCurrency + srcPayeeAmount;
        }
        if (!(editFlagValid = MessageDigestTools.checkIfValid((String)srcString, (String)editFlag))) {
            int size = info.getEntries().size();
            BigDecimal sumAmt = new BigDecimal(0);
            for (int i = 0; i < size; ++i) {
                sumAmt = sumAmt.add(info.getEntries().get(i).getAmount());
            }
            if (info.getActPayAmt().compareTo(sumAmt) != 0) {
                throw new RecPayException(RecPayException.PAYBILLINFOBYEDITED, new String[]{info.getNumber()});
            }
            srcActPayAmt = sumAmt.toString();
            boolean editFlagValidNew = MessageDigestTools.checkIfValid((String)srcString, (String)editFlag);
            if (!editFlagValidNew) {
                throw new RecPayException(RecPayException.PAYBILLINFOBYEDITED, new String[]{info.getNumber()});
            }
        }
    }

    public void lockedPaymentIds(Context ctx, List ids) throws BOSException {
        int size = ids.size();
        if (size == 0) {
            return;
        }
        String sql = "update T_CAS_PaymentBill set FSubSettDate=?  where fid in ('" + ids.get(0) + "'";
        for (int i = 1; i < size; ++i) {
            sql = sql + ", '" + ids.get(i) + "'";
        }
        sql = sql + ")";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Timestamp(System.currentTimeMillis())});
    }

    public void checkIsInQueue(Context ctx, ReceivingBillInfo recInfo) throws BOSException, EASBizException, CasForArApException {
        ICreateJobFacade createJobFacade = CreateJobFacadeFactory.getLocalInstance((Context)ctx);
        if (recInfo.getCompany() != null) {
            if (recInfo.getCompany().getNumber() != null) {
                if (createJobFacade.checkDuplicateTask("SCM_FI_AR_001" + recInfo.getCompany().getNumber())) {
                    throw new CasException(CasException.ARCLOSRACCOUNTISINQUEUE);
                }
            } else {
                CompanyOrgUnitInfo currentCompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo("select number where id='" + recInfo.getCompany().getId().toString() + "'");
                if (createJobFacade.checkDuplicateTask("SCM_FI_AR_001" + currentCompany.getNumber())) {
                    throw new CasException(CasException.ARCLOSRACCOUNTISINQUEUE);
                }
            }
        }
    }

    public void checkIsInQueue(Context ctx, PaymentBillInfo payInfo) throws BOSException, EASBizException, CasForArApException {
        if (payInfo.getCompany() != null) {
            ICreateJobFacade createJobFacade = CreateJobFacadeFactory.getLocalInstance((Context)ctx);
            if (payInfo.getCompany().getNumber() != null) {
                if (createJobFacade.checkDuplicateTask("SCM_FI_AP_001" + payInfo.getCompany().getNumber())) {
                    throw new CasException(CasException.ARCLOSRACCOUNTISINQUEUE);
                }
            } else {
                CompanyOrgUnitInfo currentCompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo("select number where id='" + payInfo.getCompany().getId().toString() + "'");
                if (createJobFacade.checkDuplicateTask("SCM_FI_AP_001" + currentCompany.getNumber())) {
                    throw new CasException(CasException.ARCLOSRACCOUNTISINQUEUE);
                }
            }
        }
    }

    public boolean getBooleanParamValue(Context ctx, String sCompanyId, String paramNumber) {
        ObjectUuidPK pk = new ObjectUuidPK(sCompanyId);
        String value = null;
        try {
            value = ParamManager.getParamValue((Context)ctx, (IObjectPK)pk, (String)paramNumber);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return "true".equalsIgnoreCase(value) || "1".equalsIgnoreCase(value);
    }

    public static void execute(Context ctx, String[] sql) throws BOSException {
        Connection conn = null;
        Statement statement = null;
        StringBuffer sqlstr = new StringBuffer();
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            statement = conn.createStatement();
            if (sql != null) {
                for (int i = 0; i < sql.length; ++i) {
                    statement.addBatch(sql[i]);
                    sqlstr.append(sql[i]).append("\t\n");
                }
            }
            statement.executeBatch();
            statement.clearBatch();
        }
        catch (SQLException exc) {
            try {
                throw new BOSException("Sql execute exception : " + sqlstr, (Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(statement, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)statement, (Connection)conn);
    }

    public AccountBankInfo getBankByPayeeAccountBank(Context ctx, String number) throws BOSException {
        AccountBankInfo accountBank = null;
        try {
            IAccountBank iaccountBank = AccountBankFactory.getLocalInstance((Context)ctx);
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("bankAccountNumber", (Object)number));
            view.setFilter(fi);
            AccountBankCollection collection = iaccountBank.getAccountBankCollection(view);
            if (collection != null && collection.size() > 0) {
                accountBank = collection.get(0);
            }
        }
        catch (BOSException e) {
            throw new BOSException(e.getMessage());
        }
        return accountBank;
    }

    public String getMethodNameByLogItem(Context ctx, String itemInnerID) {
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        LogItemCollection loitmeCol = loader.getLog().getLogItems();
        String methodName = "";
        for (LogItemInfo item : loitmeCol) {
            if (!item.getInnerID().equals("")) continue;
            methodName = item.getAlias();
            break;
        }
        return methodName;
    }

    public void initAndCheckNumber(Context ctx, IObjectValue model, int i) throws EASBizException, BOSException {
        RecPayBillInfo info;
        if (i == 1) {
            info = (PaymentBillInfo)model;
            ServiceHandler.initPaymentBillNumber(ctx, info);
            this.checkNumberDup(ctx, model);
        }
        if (i == 2) {
            info = (ReceivingBillInfo)model;
            ServiceHandler.initReceivingBillNumber(ctx, info);
            this.checkNumberDup(ctx, model);
        }
    }

    private static void initPaymentBillNumber(Context ctx, BillBaseInfo info) throws BOSException, EASBizException {
        FilterInfo filter;
        if (!EmptyUtil.isEmpty((String)info.getNumber())) {
            return;
        }
        int i = 0;
        do {
            String numberSilent = null;
            try {
                numberSilent = NumberRuleUtil.getNumberSilent((Context)ctx, (CoreBaseInfo)info, (String)info.getCompany().getId().toString());
            }
            catch (CodingRuleException e) {
                logger.info((Object)e);
            }
            if (EmptyUtil.isEmpty(numberSilent)) {
                return;
            }
            info.setNumber(numberSilent);
            filter = NumberRuleUtil.getCheckNumberDupFilter((IObjectValue)info, (boolean)true);
            ++i;
        } while (PaymentBillFactory.getLocalInstance(ctx).exists(filter));
    }

    private static void initReceivingBillNumber(Context ctx, BillBaseInfo info) throws BOSException, EASBizException {
        FilterInfo filter;
        if (!EmptyUtil.isEmpty((String)info.getNumber())) {
            return;
        }
        int i = 0;
        do {
            String numberSilent;
            if (EmptyUtil.isEmpty((String)(numberSilent = NumberRuleUtil.getNumberSilent((Context)ctx, (CoreBaseInfo)info, (String)info.getCompany().getId().toString())))) {
                return;
            }
            info.setNumber(numberSilent);
            filter = NumberRuleUtil.getCheckNumberDupFilter((IObjectValue)info, (boolean)true);
            ++i;
        } while (ReceivingBillFactory.getLocalInstance(ctx).exists(filter));
    }

    public void cancelRequestBudget(Context ctx, String billId, RecPayBgCtrlStrEnum enums) throws BOSException, EASBizException {
        this.cancelRequestBudget(ctx, billId, enums, null);
    }

    public void cancelRequestBudget(Context ctx, String billId, RecPayBgCtrlStrEnum enums, Integer cs043) throws BOSException, EASBizException {
        int val;
        if (cs043 == null) {
            BOSObjectType type = new ObjectUuidPK(billId).getObjectType();
            BillBaseInfo info = this.getBillBaseInfo(ctx, type, billId);
            IContextHelper localInstance = ContextHelperFactory.getLocalInstance((Context)ctx);
            val = localInstance.getIntParam("CS043", (IObjectPK)new ObjectUuidPK(info.getCompany().getId()));
        } else {
            val = cs043;
        }
        if (enums.getValue() == val) {
            BgControlCaller caller = new BgControlCaller();
            caller.returnBudget(ctx, BOSUuid.read((String)billId));
        }
    }

    private BillBaseInfo getBillBaseInfo(Context ctx, BOSObjectType type, String billId) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)billId, CompareType.EQUALS));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSelector().add("id");
        evi.getSelector().add("number");
        evi.getSelector().add("company.id");
        evi.getSelector().add("company.name");
        evi.getSelector().add("company.number");
        IBillBase iBillBase = null;
        iBillBase = ctx == null ? (IBillBase)BOSObjectFactory.createRemoteBOSObject((BOSObjectType)type, IBillBase.class) : (IBillBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)type);
        return iBillBase.getBillBaseInfo((IObjectPK)new ObjectUuidPK(billId));
    }

    private IPaymentDisposer getDisposer(Context ctx, PaymentBillInfo info) throws BOSException {
        Set srcBillIdSet;
        IPaymentDisposer disposer = null;
        PaymentBillEntryCollection entryColl = info.getEntries();
        PaymentBillEntryInfo entryInfo = null;
        if (info.getSourceSysType() == SourceTypeEnum.EIP) {
            String eipDisoser = "com.kingdee.eas.fi.cas.EipDisposer";
            try {
                disposer = (IPaymentDisposer)Class.forName(eipDisoser).newInstance();
                return disposer;
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
        int size = entryColl.size();
        for (int i = 0; i < size; ++i) {
            BOSObjectType bosType;
            entryInfo = entryColl.get(i);
            if (entryInfo == null) continue;
            if (entryInfo.getSourceBillId() != null && (bosType = BOSUuid.read((String)entryInfo.getSourceBillId()).getType()).equals((Object)info.getBOSType()) && "201|202|203|204|205|206".indexOf(info.getPayBillType().getNumber()) >= 0) {
                try {
                    String disposerName = "com.kingdee.eas.fi.ap.ApRefundBillDisposer";
                    disposer = (IPaymentDisposer)Class.forName(disposerName).newInstance();
                    break;
                }
                catch (Exception e) {
                    throw new BOSException((Throwable)e);
                }
            }
            disposer = PaymentDisposerFactory.getInstance(ctx, entryInfo.getSourceBillId());
            break;
        }
        if (disposer == null) {
            disposer = PaymentDisposerFactory.getInstance(ctx, info.getSourceBillId());
        }
        if (disposer == null && info.getId() != null && info.getSourceBillId() != null && (srcBillIdSet = BOTPUtil.getSrcBillIdSet((Context)ctx, (String)info.getId().toString())) != null && srcBillIdSet.size() > 0) {
            disposer = PaymentDisposerFactory.getInstance(ctx, srcBillIdSet.toArray()[0].toString());
        }
        return disposer;
    }

    public static ReceivingBillCollection getRecBillCollection(Context ctx, Set idSet, SelectorItemCollection selector) throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        if (selector == null) {
            selector = new SelectorItemCollection();
            selector.add("*");
        }
        IReceivingBill iReceivingBill = null;
        iReceivingBill = ctx == null ? ReceivingBillFactory.getRemoteInstance() : ReceivingBillFactory.getLocalInstance(ctx);
        return iReceivingBill.getReceivingBillCollection(EntityViewInfo.getInstance((FilterInfo)filter, (SelectorItemCollection)selector, null));
    }

    public void checkCostCenter(Context ctx, CostCenterOrgUnitInfo costCenter) throws BOSException, EASBizException {
        CostCenterOrgUnitInfo cinfo = CostCenterOrgUnitFactory.getLocalInstance((Context)ctx).getCostCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(costCenter.getId()));
        if (cinfo.isIsOUSealUp()) {
            throw new CasException(CasException.COSTCENTERERR);
        }
    }

    public void transAsstAccount(Context ctx, PaymentBillInfo info) throws EASBizException, BOSException {
        AssItemsForCashPayInfo assItem;
        AssItemsForCashPayInfo assItemInfo;
        AssItemsForCashPayCollection assItems;
        IContextHelper localInstance = ContextHelperFactory.getLocalInstance((Context)ctx);
        int cs001 = localInstance.getIntParam("CS001", (IObjectPK)new ObjectUuidPK(info.getCompany().getId()));
        int cs106 = localInstance.getIntParam("CS106", (IObjectPK)new ObjectUuidPK(info.getCompany().getId()));
        for (int i = 0; i < info.getEntries().size(); ++i) {
            PaymentBillEntryInfo entry = info.getEntries().get(i);
            if (entry.getOppAccount() == null || entry.getOppAccount().get("assgrp") == null) continue;
            Map assgrp = (Map)entry.getOppAccount().get("assgrp");
            List detail = (List)assgrp.get("detail");
            String caaId = (String)assgrp.get("CAAId");
            entry.getAssItemsEntries().clear();
            info.getAssItems().clear();
            for (int j = 0; j < detail.size(); ++j) {
                Map asstType = (Map)detail.get(j);
                AsstActTypeInfo asstTypeInfo = AsstActTypeFactory.getLocalInstance((Context)ctx).getAsstActTypeInfo((IObjectPK)new ObjectUuidPK(asstType.get("id").toString()));
                Map value = (Map)asstType.get("value");
                AssItemsForCashPayInfo assItemInfo2 = new AssItemsForCashPayInfo();
                assItemInfo2.setEntrySeq(i + 1);
                if (value != null) {
                    assItemInfo2.setFromID(value.get("id").toString());
                    assItemInfo2.setFromNumber(value.get("number").toString());
                }
                assItemInfo2.setIsSelected(value != null);
                assItemInfo2.setMappingFileds(asstTypeInfo.getMappingFieldName());
                assItemInfo2.setTableName(asstTypeInfo.getRealtionDataObject());
                assItemInfo2.setAsstActType(asstTypeInfo);
                entry.getAssItemsEntries().add(assItemInfo2);
            }
        }
        PaymentBillEntryInfo entry = info.getEntries().get(0);
        if (EmptyUtil.isEmpty((CoreBaseInfo)info.getOppAccount()) && EmptyUtil.isEmpty((Object)info.getId())) {
            info.getAssItems().clear();
            if (cs001 == 0 && cs106 == 0) {
                info.setOppAccount(entry.getOppAccount());
            }
            assItems = entry.getAssItemsEntries();
            for (int j = 0; j < assItems.size(); ++j) {
                assItemInfo = assItems.get(j);
                assItem = new AssItemsForCashPayInfo();
                assItem.setEntrySeq(-99);
                assItem.setFromID(assItemInfo.getFromID());
                assItem.setFromNumber(assItemInfo.getFromNumber());
                assItem.setIsSelected(assItemInfo.isIsSelected());
                assItem.setMappingFileds(assItemInfo.getMappingFileds());
                assItem.setTableName(assItemInfo.getTableName());
                assItem.setAsstActType(assItemInfo.getAsstActType());
                info.getAssItems().add(assItem);
            }
        }
        if (entry != null && entry.getOppAccount() != null && (entry.getOppAccount().isIsBank() || entry.getOppAccount().isIsCash())) {
            if (cs001 == 0 && cs106 == 0) {
                info.setOppAccount(entry.getOppAccount());
            }
            info.getAssItems().clear();
            assItems = entry.getAssItemsEntries();
            for (int j = 0; j < assItems.size(); ++j) {
                assItemInfo = assItems.get(j);
                assItem = new AssItemsForCashPayInfo();
                assItem.setEntrySeq(-99);
                assItem.setFromID(assItemInfo.getFromID());
                assItem.setFromNumber(assItemInfo.getFromNumber());
                assItem.setIsSelected(assItemInfo.isIsSelected());
                assItem.setMappingFileds(assItemInfo.getMappingFileds());
                assItem.setTableName(assItemInfo.getTableName());
                assItem.setAsstActType(assItemInfo.getAsstActType());
                info.getAssItems().add(assItem);
            }
        }
    }

    public void deletePaymentReport(Context ctx, PaymentBillInfo info) throws BOSException, EASBizException {
        String sql = "delete from t_cas_paymentReport where fpaymentbillid = '" + info.getId().toString() + "'";
        DbUtil.execute((Context)ctx, (String)sql);
    }

    private CBPaymentInfo getCBPaymentInfo(Context ctx, String Id) throws BOSException, EASBizException {
        CBPaymentInfo cbPayInfo = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("paymentbillid", (Object)Id));
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("*");
        selector.add("payeeCurrency.*");
        selector.add("paymentCurrency.*");
        selector.add("payTransaction.*");
        view.setSelector(selector);
        cbPayInfo = CBPaymentFactory.getLocalInstance((Context)ctx).getCBPaymentCollection(view).get(0);
        return cbPayInfo;
    }
}

