/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app.service.handler;

import com.kingdee.eas.fi.cas.app.service.handler.TextFilter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.xerces.jaxp.DocumentBuilderFactoryImpl;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.TreeWalker;
import org.xml.sax.SAXException;

public class XMLUtil {
    public static final String TAGBILLHEAD = "billHead";
    public static final String TAGBILLENTRYS = "billEntries";
    public static final String TAGBILLENTRY = "entry";
    public static final String ENTRYPATH = "//billEntries/entry";
    private static String xmlParserImpl = "org.apache.xerces.jaxp.DocumentBuilderFactoryImpl";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DocumentBuilderFactory getDocumentBuilderFactory() {
        ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
        try {
            String oldDocBuilderFactory = null;
            DocumentBuilderFactory factory = null;
            try {
                Thread.currentThread().setContextClassLoader(DocumentBuilderFactoryImpl.class.getClassLoader());
                oldDocBuilderFactory = System.getProperty("javax.xml.parsers.DocumentBuilderFactory");
                if (!xmlParserImpl.equals(oldDocBuilderFactory)) {
                    System.setProperty("javax.xml.parsers.DocumentBuilderFactory", xmlParserImpl);
                }
                factory = DocumentBuilderFactory.newInstance();
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            if (oldDocBuilderFactory != null) {
                System.setProperty("javax.xml.parsers.DocumentBuilderFactory", oldDocBuilderFactory);
            }
            DocumentBuilderFactory documentBuilderFactory = factory;
            return documentBuilderFactory;
        }
        finally {
            try {
                Thread.currentThread().setContextClassLoader(oldCL);
            }
            catch (SecurityException securityException) {}
        }
    }

    public static Document builderDocument() throws ParserConfigurationException {
        DocumentBuilderFactory factory = XMLUtil.getDocumentBuilderFactory();
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.newDocument();
    }

    public static Document builderDocumentFromFile(String filePath) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory factory = XMLUtil.getDocumentBuilderFactory();
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.parse(filePath);
    }

    public static Document builderDocument(String xmlContent) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory builder = XMLUtil.getDocumentBuilderFactory();
        ByteArrayInputStream input = new ByteArrayInputStream(xmlContent.getBytes("UTF-8"));
        DocumentBuilder parser = builder.newDocumentBuilder();
        return parser.parse(input);
    }

    public static HashMap getBillHead(Document doc) {
        if (doc == null) {
            return null;
        }
        HashMap<String, String> headMap = null;
        NodeList childs = doc.getElementsByTagName(TAGBILLHEAD);
        String value = null;
        if (childs != null && childs.getLength() > 0) {
            headMap = new HashMap<String, String>();
            NodeList subChilds = childs.item(0).getChildNodes();
            for (int i = 0; subChilds != null && i < subChilds.getLength(); ++i) {
                Element subElement;
                Node subChild;
                if (subChilds.item(i).getNodeType() != 1 || (subChild = (subElement = (Element)subChilds.item(i)).getFirstChild()) == null || (value = subChild.getNodeValue()) == null) continue;
                headMap.put(subElement.getTagName(), value.trim());
            }
        }
        return headMap;
    }

    public static ArrayList getBillEntries(Document doc) throws TransformerException {
        return XMLUtil.getBillEntries(doc, ENTRYPATH);
    }

    public static ArrayList getBillEntries(Document doc, String xpath) throws TransformerException {
        if (doc == null) {
            return null;
        }
        NodeList subChilds = XMLUtil.getNodeListFromXpath(doc, xpath);
        ArrayList entries = new ArrayList();
        HashMap<String, String> entryMap = null;
        String value = null;
        for (int i = 0; subChilds != null && i < subChilds.getLength(); ++i) {
            if (subChilds.item(i).getNodeType() != 1) continue;
            entryMap = new HashMap<String, String>();
            Element entryElement = (Element)subChilds.item(i);
            if (entryElement != null) {
                NodeList entryChildList = entryElement.getChildNodes();
                for (int j = 0; entryChildList != null && j < entryChildList.getLength(); ++j) {
                    Node textNode;
                    Node subChild;
                    if (entryChildList.item(j).getNodeType() != 1 || (subChild = entryChildList.item(j)) == null || subChild.getNodeType() != 1 || (textNode = XMLUtil.getChildTextNode(subChild)) == null || (value = textNode.getNodeValue()) == null) continue;
                    entryMap.put(subChild.getNodeName(), value.trim());
                }
            }
            entries.add(entryMap);
        }
        return entries;
    }

    public static Node getChildTextNode(Node ele) {
        Document doc;
        DOMImplementation domImpl;
        if (ele != null && (domImpl = (doc = ele.getOwnerDocument()).getImplementation()).hasFeature("Traversal", "2.0")) {
            DocumentTraversal traversal = (DocumentTraversal)((Object)doc);
            int whatToShow = -1;
            TextFilter filter = new TextFilter();
            TreeWalker tree = traversal.createTreeWalker(ele, whatToShow, filter, false);
            return tree.firstChild();
        }
        return null;
    }

    public static NodeList getNodeListFromXpath(Node node, String partern) throws TransformerException {
        String elementTag;
        if (partern != null && partern.lastIndexOf("/") > 0 && (elementTag = partern.substring(partern.lastIndexOf("/") + 1)) != null) {
            if (node.getNodeType() == 1) {
                return ((Element)node).getElementsByTagName(elementTag);
            }
            if (node.getNodeType() == 9) {
                return ((Document)node).getElementsByTagName(elementTag);
            }
        }
        return null;
    }

    public static final synchronized boolean writeXmlFile(String fileName, Document document) throws Exception {
        DOMSource doms = new DOMSource(document);
        File file = new File(fileName);
        StreamResult result = new StreamResult(file);
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer();
        Properties properties = transformer.getOutputProperties();
        properties.setProperty("encoding", "UTF-8");
        properties.setProperty("method", "xml");
        properties.setProperty("indent", "yes");
        transformer.setOutputProperties(properties);
        transformer.transform(doms, result);
        return true;
    }

    public static final String domToString(Document document) throws Exception {
        DOMSource doms = new DOMSource(document);
        StringWriter strWriter = new StringWriter();
        StreamResult result = new StreamResult(strWriter);
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer();
        Properties properties = transformer.getOutputProperties();
        properties.setProperty("encoding", "UTF-8");
        properties.setProperty("method", "xml");
        properties.setProperty("indent", "yes");
        transformer.setOutputProperties(properties);
        transformer.transform(doms, result);
        return strWriter.toString();
    }

    public static Date convertStrToDate(String strDate, String parttern) throws ParseException {
        if (strDate != null) {
            SimpleDateFormat dateFormat = new SimpleDateFormat(parttern);
            return dateFormat.parse(strDate);
        }
        return null;
    }

    public static Document buildDocument(InputStream in) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = XMLUtil.getDocumentBuilderFactory();
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.parse(in);
    }
}

