/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app.servicenew.plugin;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.ormapping.SQLAccessException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.ReceivingBillInfo;
import com.kingdee.eas.fi.cas.app.servicenew.IService;
import com.kingdee.eas.fi.cas.app.servicenew.plugin.AbstractPlugin;
import com.kingdee.eas.fi.cas.utils.CASWebUtil;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class AdjustPeriodCheckPlugin
extends AbstractPlugin {
    protected Map<String, Boolean> isAdjustPeriodMap = new HashMap<String, Boolean>();

    public AdjustPeriodCheckPlugin(IService service) {
        super(service);
    }

    @Override
    public String[] getInfoProps() {
        return new String[]{"number"};
    }

    @Override
    public void setUp() throws EASBizException, BOSException {
        String[] orgUnitIds = this.service.getOrgUnits();
        StringBuffer sql = new StringBuffer();
        sql.append("select T0.FCompanyID,T2.FIsAdjustPeriod ");
        sql.append("from T_BD_SystemStatusCtrol T0 ");
        sql.append("inner join T_BD_SystemStatus T1 on T0.FSystemStatusID=T1.FID ");
        sql.append("inner join T_BD_Period T2 on T0.FCurrentPeriodID = T2.FID ");
        sql.append(" and T0.FCompanyID in (");
        for (int i = 0; i < orgUnitIds.length; ++i) {
            sql.append("'" + orgUnitIds[i] + "',");
        }
        sql.deleteCharAt(sql.length() - 1);
        sql.append(") and T1.FName=" + SystemEnum.CASHMANAGEMENT.getValue());
        IRowSet iRowSet = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
        if (iRowSet != null && iRowSet.size() > 0) {
            try {
                if (iRowSet.next()) {
                    String orgUnitId = iRowSet.getString("FCompanyID");
                    int isAdjustPeriod = iRowSet.getInt("FIsAdjustPeriod");
                    this.isAdjustPeriodMap.put(orgUnitId, isAdjustPeriod == 1);
                }
            }
            catch (SQLException e) {
                throw new SQLAccessException(e);
            }
        }
    }

    @Override
    public void beforeService(String id) throws EASBizException, BOSException {
        ReceivingBillInfo info = (ReceivingBillInfo)this.service.getInfo(id);
        if (this.isAdjustPeriodMap.get(this.service.getOrgUnitId(info)).booleanValue()) {
            throw new RuntimeException(CASWebUtil.getResource(this.ctx, "IN_ADJUST_PERIOD", new String[]{info.getNumber()}));
        }
    }
}

