/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app.servicenew.plugin;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.cas.RecPayBillEntryInfo;
import com.kingdee.eas.fi.cas.RecPayBillInfo;
import com.kingdee.eas.fi.cas.ReceivingBillInfo;
import com.kingdee.eas.fi.cas.SourceTypeEnum;
import com.kingdee.eas.fi.cas.app.ArApRecPayServerHelper;
import com.kingdee.eas.fi.cas.app.servicenew.IService;
import com.kingdee.eas.fi.cas.app.servicenew.plugin.AbstractPlugin;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.scm.framework.bizflow.util.BizBillValueChangeUtil;
import java.util.HashSet;

public class ArApBizFlowWriteBackPlugin
extends AbstractPlugin<RecPayBillInfo> {
    protected boolean isRec = false;

    public ArApBizFlowWriteBackPlugin(IService service, boolean isRec) {
        super(service);
        this.isRec = isRec;
    }

    @Override
    public String[] getInfoProps() {
        return new String[]{"billStatus"};
    }

    @Override
    public void afterService(String id) throws EASBizException, BOSException {
        RecPayBillInfo info = (RecPayBillInfo)this.service.getInfo(id);
        if (this.isRec) {
            // empty if block
        }
        if (info.getSourceType() == SourceTypeEnum.AR || info.getSourceType() == SourceTypeEnum.AP) {
            String tableName = "T_CAS_ReceivingBillEntry";
            if (!this.isRec) {
                tableName = "T_CAS_PaymentBillEntry";
            }
            boolean isHasBizFlow = false;
            HashSet<String> idSet = new HashSet<String>();
            AbstractObjectCollection entries = null;
            entries = this.isRec ? ((ReceivingBillInfo)info).getEntries() : ((PaymentBillInfo)info).getEntries();
            int size = entries.size();
            for (int i = 0; i < size; ++i) {
                idSet.add(((RecPayBillEntryInfo)entries.getObject(i)).getId().toString());
            }
            if (ArApRecPayServerHelper.isExistsBizFlowField(this.ctx, tableName) && ArApRecPayServerHelper.isHasBizFlowValue(this.ctx, tableName, idSet)) {
                isHasBizFlow = true;
            }
            if (isHasBizFlow) {
                if (info != null && info.getBillStatus().getValue() == 11) {
                    try {
                        BizBillValueChangeUtil.handleBillSubmit((Context)this.ctx, (IObjectValue)info, (IObjectValue)info);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ArApRecPayServerHelper.doWriteBack(this.ctx, (IObjectValue)info, BatchActionEnum.SUBMIT);
                if (info != null && info.getBillStatus().getValue() == 11) {
                    try {
                        BizBillValueChangeUtil.resetBillChange((Context)this.ctx, (IObjectValue)info);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }
}

