/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app.servicenew.plugin;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.ReceivingBillInfo;
import com.kingdee.eas.fi.cas.app.servicenew.IService;
import com.kingdee.eas.fi.cas.app.servicenew.plugin.AbstractPlugin;
import com.kingdee.eas.fi.cas.utils.CASWebHelper;
import java.util.HashMap;
import java.util.Map;

public class PermissionCheckPlugin
extends AbstractPlugin {
    protected String permItemName = null;
    protected Map<String, Boolean> hasFunctionPermissionMap = new HashMap<String, Boolean>();
    protected EASBizException noPermissionException = null;

    public PermissionCheckPlugin(IService service, String permItemName, EASBizException noPermissionException) {
        super(service);
        this.permItemName = permItemName;
        this.noPermissionException = noPermissionException;
    }

    @Override
    public void setUp() throws EASBizException, BOSException {
        String[] orgUnitIds = this.service.getOrgUnits();
        for (int i = 0; i < orgUnitIds.length; ++i) {
            this.hasFunctionPermissionMap.put(orgUnitIds[i], CASWebHelper.hasFunctionPermission(this.ctx, this.ctx.getCaller(), (IObjectPK)new ObjectUuidPK(orgUnitIds[i]), this.permItemName));
        }
    }

    @Override
    public void beforeService(String id) throws EASBizException, BOSException {
        ReceivingBillInfo info = (ReceivingBillInfo)this.service.getInfo(id);
        if (!this.hasFunctionPermissionMap.get(this.service.getOrgUnitId(info)).booleanValue()) {
            throw this.noPermissionException;
        }
    }
}

