/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app.servicenew.plugin.receivingbill;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.DisposerActionEnum;
import com.kingdee.eas.fi.cas.ReceivingBillFactory;
import com.kingdee.eas.fi.cas.ReceivingBillInfo;
import com.kingdee.eas.fi.cas.SourceTypeEnum;
import com.kingdee.eas.fi.cas.app.service.handler.ServiceHandler;
import com.kingdee.eas.fi.cas.app.servicenew.IService;
import com.kingdee.eas.fi.cas.app.servicenew.plugin.AbstractPlugin;
import com.kingdee.eas.fm.cl.ConsingnRepaymentBillFactory;
import com.kingdee.eas.fm.cl.ConsingnRepaymentBillInfo;
import com.kingdee.eas.fm.ft.FundTransferInterestBillFactory;
import com.kingdee.eas.fm.ft.FundTransferInterestBillInfo;
import com.kingdee.eas.fm.ft.FundTransferRepayBillFactory;
import com.kingdee.eas.fm.ft.FundTransferRepayBillInfo;
import java.util.HashSet;
import java.util.Map;

public class DisposePlugin
extends AbstractPlugin<ReceivingBillInfo> {
    public DisposePlugin(IService<ReceivingBillInfo> service) {
        super(service);
    }

    @Override
    public String[] getParams() {
        return new String[]{"RECBILL_AUDIT_NOW"};
    }

    @Override
    public void afterService(String id) throws EASBizException, BOSException {
        String sourcBillId;
        ReceivingBillInfo info = (ReceivingBillInfo)this.service.getInfo(id);
        Map<String, Object> param = this.service.getParamMap(info.getCompany().getId().toString());
        ServiceHandler serviceHandler = new ServiceHandler();
        serviceHandler.dispose(this.ctx, info, DisposerActionEnum.SUBMIT);
        if (!info.isIsTransBill() && !info.isIsInitializeBill() && this.isAuditNow(this.ctx, info, param)) {
            HashSet<String> idSet = new HashSet<String>();
            idSet.add(id);
            ReceivingBillFactory.getLocalInstance(this.ctx).audit(idSet);
        }
        if ((sourcBillId = info.getSourceBillId()) != null && sourcBillId.length() > 0) {
            ObjectUuidPK objectPk = new ObjectUuidPK(sourcBillId);
            BOSUuid bosId = BOSUuid.read((String)sourcBillId);
            if (bosId.getType().equals((Object)new FundTransferRepayBillInfo().getBOSType())) {
                FundTransferRepayBillFactory.getLocalInstance((Context)this.ctx).updateRecmentBillID((IObjectPK)objectPk, (IObjectPK)new ObjectUuidPK(info.getId()));
            } else if (bosId.getType().equals((Object)new FundTransferInterestBillInfo().getBOSType())) {
                FundTransferInterestBillFactory.getLocalInstance((Context)this.ctx).updateRecmentBillID((IObjectPK)objectPk, (IObjectPK)new ObjectUuidPK(info.getId()));
            } else if (bosId.getType().equals((Object)new ConsingnRepaymentBillInfo().getBOSType())) {
                ConsingnRepaymentBillFactory.getLocalInstance((Context)this.ctx).updateRecBill((IObjectPK)objectPk, (IObjectPK)new ObjectUuidPK(info.getId()));
            }
        }
    }

    protected boolean isAuditNow(Context ctx, ReceivingBillInfo info, Map param) throws BOSException {
        boolean isArRecBill = SourceTypeEnum.AR.equals((Object)info.getSourceType());
        boolean isAuditNow = (Boolean)param.get("RECBILL_AUDIT_NOW");
        return isArRecBill && isAuditNow && !info.isIsInitializeBill();
    }
}

