/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app.servicenew.plugin.receivingbill;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.PaymentTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.AssItemsForCashRecInfo;
import com.kingdee.eas.fi.cas.BillStatusEnum;
import com.kingdee.eas.fi.cas.ReceivingBillDataProcess;
import com.kingdee.eas.fi.cas.ReceivingBillEntryInfo;
import com.kingdee.eas.fi.cas.ReceivingBillInfo;
import com.kingdee.eas.fi.cas.SourceTypeEnum;
import com.kingdee.eas.fi.cas.app.AgentRecPayServerHelper;
import com.kingdee.eas.fi.cas.app.service.handler.ServiceHandler;
import com.kingdee.eas.fi.cas.app.servicenew.IService;
import com.kingdee.eas.fi.cas.app.servicenew.plugin.AbstractPlugin;
import com.kingdee.eas.fm.common.FMBGHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.IFMBgUsed;
import com.kingdee.eas.fm.ft.FundTransferInterestBillInfo;
import com.kingdee.eas.fm.ft.FundTransferRepayBillInfo;
import com.kingdee.util.DateTimeUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class SubmitFillModelPlugin
extends AbstractPlugin<ReceivingBillInfo> {
    protected Map<String, AccountBankInfo> accountBankMap = new HashMap<String, AccountBankInfo>();

    public SubmitFillModelPlugin(IService<ReceivingBillInfo> service) {
        super(service);
    }

    @Override
    public String[] getInfoProps() {
        return new String[]{"currency.id", "exchangeRate", "outBgItemID", "outBgItemNumber", "outBgItemName", "OppBgItemID", "OppBgItemNumber", "OppBgItemName", "entries.rebate", "entries.rebateLocAmt", "entries.actualAmt", "entries.actualLocAmt", "entries.amount", "entries.localAmt", "entries.actualAmtVc", "entries.actualLocAmtVc", "entries.oppBgItemId", "entries.oppBgItemNumber", "entries.oppBgItemName", "entries.seq", "entries.assItemsEntries.entrySeq", "bizType.id", "bizType.type", "settleBizType", "receivingBillType", "exchangeRate"};
    }

    @Override
    public void setUp() throws EASBizException, BOSException {
        List<String> ids = this.service.getIds();
        HashSet<String> accountBankNumberSet = new HashSet<String>();
        for (int i = 0; i < ids.size(); ++i) {
            String accountBankNumber = ((ReceivingBillInfo)this.service.getInfo(ids.get(i))).getPayerAccountBank();
            if (accountBankNumber == null || accountBankNumber.equals("")) continue;
            accountBankNumberSet.add(accountBankNumber);
        }
        if (accountBankNumberSet.size() > 0) {
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("bankAccountNumber"));
            sic.add(new SelectorItemInfo("isByCurrency"));
            sic.add(new SelectorItemInfo("currency.id"));
            sic.add(new SelectorItemInfo("account.id"));
            sic.add(new SelectorItemInfo("accountType"));
            sic.add(new SelectorItemInfo("bank.name"));
            view.setSelector(sic);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("bankAccountNumber", accountBankNumberSet, CompareType.INCLUDE));
            view.setFilter(filter);
            AccountBankCollection accountBankColl = AccountBankFactory.getLocalInstance((Context)this.ctx).getAccountBankCollection(view);
            for (int i = 0; i < accountBankColl.size(); ++i) {
                this.accountBankMap.put(accountBankColl.get(i).getBankAccountNumber(), accountBankColl.get(i));
            }
        }
    }

    @Override
    public void beforeService(String id) throws EASBizException, BOSException {
        BOSUuid bosId;
        String sourceBillId;
        String number;
        ReceivingBillInfo info = (ReceivingBillInfo)this.service.getInfo(id);
        info.setBillStatus(BillStatusEnum.SUBMIT);
        info.setPayerAccountBankO(this.accountBankMap.get(info.getPayerAccountBank()));
        ServiceHandler serviceHandler = new ServiceHandler();
        if (!SourceTypeEnum.AR.equals((Object)info.getSourceType()) && (number = info.getNumber()) != null && number.length() > 0) {
            serviceHandler.checkNumberDup(this.ctx, (IObjectValue)info);
        }
        if (info.getPaymentType() == null) {
            String paymentTypeId = "91f078d7-fb90-4827-83e2-3538237b67a06BCA0AB5";
            PaymentTypeInfo paymentTypeInfo = new PaymentTypeInfo();
            paymentTypeInfo.setId(BOSUuid.read((String)paymentTypeId));
            info.setPaymentType(paymentTypeInfo);
        }
        ReceivingBillDataProcess.setCasAmount(this.ctx, info);
        IFMBgUsed[] infos = new ReceivingBillInfo[this.service.getIds().size()];
        ArrayList<ReceivingBillEntryInfo> entryList = new ArrayList<ReceivingBillEntryInfo>();
        for (int i = 0; i < infos.length; ++i) {
            infos[i] = (ReceivingBillInfo)this.service.getInfo(id);
            int n = infos[i].getEntries().size();
            for (int j = 0; j < n; ++j) {
                entryList.add(infos[i].getEntries().get(j));
            }
        }
        IFMBgUsed[] entries = new ReceivingBillEntryInfo[entryList.size()];
        entries = entryList.toArray(entries);
        FMBGHelper.fillBgItem((Context)this.ctx, (IFMBgUsed[])infos);
        FMBGHelper.fillBgItem((Context)this.ctx, (IFMBgUsed[])entries);
        AgentRecPayServerHelper.saveOrSubmitPaymentBillForAgentRec(this.ctx, info);
        serviceHandler.setCommonPropertyValue(this.ctx, info);
        if (info.getBizType() != null) {
            info.setSettleBizType(info.getBizType().getType());
        }
        BigDecimal actualAmt = new BigDecimal("0");
        BigDecimal actualLocAmt = new BigDecimal("0");
        ReceivingBillEntryInfo entry = null;
        for (int i = info.getEntries().size() - 1; i >= 0; --i) {
            entry = info.getEntries().get(i);
            if (SourceTypeEnum.CASH.equals((Object)info.getSourceType()) && FMHelper.isZERO((BigDecimal)entry.getActualAmt())) {
                info.getEntries().remove(entry);
                int entrySeq = entry.getSeq();
                if (entrySeq > 0 && entrySeq < info.getEntries().size() + 1) {
                    ReceivingBillEntryInfo entryTemp = null;
                    AssItemsForCashRecInfo assTemp = null;
                    int size = info.getEntries().size();
                    for (int j = 0; j < size; ++j) {
                        entryTemp = info.getEntries().get(j);
                        if (entryTemp.getSeq() <= entrySeq) continue;
                        int newEntrySeq = entryTemp.getSeq() - 1;
                        entryTemp.setSeq(newEntrySeq);
                        int n = entryTemp.getAssItemsEntries().size();
                        for (int m = 0; m < n; ++m) {
                            assTemp = entryTemp.getAssItemsEntries().get(m);
                            assTemp.setEntrySeq(newEntrySeq);
                        }
                    }
                }
            }
            if (entry.getActualAmt() != null) {
                actualAmt = actualAmt.add(entry.getActualAmt());
            }
            if (entry.getActualLocAmt() == null) continue;
            actualLocAmt = actualLocAmt.add(entry.getActualLocAmt());
        }
        info.setActRecAmt(actualAmt);
        info.setActRecLocAmt(actualLocAmt);
        if (info.getPayerType() instanceof AsstActTypeInfo) {
            try {
                serviceHandler.setOtherPropertyForAsstAct(this.ctx, info);
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
        if ((sourceBillId = info.getSourceBillId()) != null && sourceBillId.length() > 0 && ((bosId = BOSUuid.read((String)sourceBillId)).equals((Object)new FundTransferRepayBillInfo().getBOSType()) || bosId.equals((Object)new FundTransferInterestBillInfo().getBOSType()))) {
            info.setSourceType(SourceTypeEnum.FT);
        }
        info.setBizDate(DateTimeUtils.truncateDate((Date)info.getBizDate()));
        info.setLastExhangeRate(info.getExchangeRate());
    }
}

