/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app.servicenew.plugin.receivingbill;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.ormapping.SQLAccessException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.AccountType;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.account.AccountCurrencyCollection;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.AccountingCurrencyEnum;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.AssItemsForCashRecCollection;
import com.kingdee.eas.fi.cas.AssItemsForCashRecInfo;
import com.kingdee.eas.fi.cas.BgCtrlReceivingBillHandler;
import com.kingdee.eas.fi.cas.CasException;
import com.kingdee.eas.fi.cas.RecPayBgCtrlStrEnum;
import com.kingdee.eas.fi.cas.RecPayBillTypeEnum;
import com.kingdee.eas.fi.cas.RecPayException;
import com.kingdee.eas.fi.cas.RecPayHelper;
import com.kingdee.eas.fi.cas.ReceivingBillEntryCollection;
import com.kingdee.eas.fi.cas.ReceivingBillEntryInfo;
import com.kingdee.eas.fi.cas.ReceivingBillInfo;
import com.kingdee.eas.fi.cas.ReceivingBillTypeInfo;
import com.kingdee.eas.fi.cas.SourceTypeEnum;
import com.kingdee.eas.fi.cas.app.service.handler.ServiceHandler;
import com.kingdee.eas.fi.cas.app.servicenew.IService;
import com.kingdee.eas.fi.cas.app.servicenew.plugin.AbstractPlugin;
import com.kingdee.eas.fi.cas.utils.CASWebUtil;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.fs.SettBizTypeEnum;
import com.kingdee.eas.fm.fs.SettBizTypeInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class SubmitValidModelPlugin
extends AbstractPlugin<ReceivingBillInfo> {
    protected Map<String, PeriodInfo> startPeriodMap = new HashMap<String, PeriodInfo>();
    protected Map<String, Map<Integer, Boolean>> isStartMap = new HashMap<String, Map<Integer, Boolean>>();
    Map<String, String> companyBankNumberMap = new HashMap<String, String>();

    public SubmitValidModelPlugin(IService service) {
        super(service);
    }

    @Override
    public String[] getOldInfoProps() {
        return new String[]{"billStatus", "settlementStatus", "fiVouchered"};
    }

    @Override
    public String[] getInfoProps() {
        return new String[]{"*", "entries.*", "assItems.*", "company.name", "recBillType.number", "recBillType.sourceSysType", "payerType.realtionDataObject", "payeeAccountBank.isByCurrency", "payeeAccountBank.bank.inGroup", "payeeAccountBank.currency.id", "payeeAccountBank.account.id", "payeeAccountBank.accountType", "payeeAccount.isBank", "payeeAccount.CompanyID.id", "payerAccountBankO.isByCurrency", "entries.oppAccount.isBank", "payeeAcctBank.bank.inGroup", "costCenter.isOUSealUp", "company.baseCurrency.precision", "payeeBank.inGroup", "payeeAccountBank.bankAccountNumber", "payeeAccountBank.InnerAcct.id", "payerAccountBankO.innerAcct.id", "entries.AssItemsEntries.id", "entries.AssItemsEntries.isSelected", "entries.AssItemsEntries.fromNumber", "entries.costCenter.isOUSealUp", "entries.opptAccount.accountCurrency.currency.id", "entries.opptAccount.accountingcurrency"};
    }

    @Override
    public String[] getParams() {
        return new String[]{"CS032", "CS033", "CS044", "CS014", "CS073", "CS005", "CS014", "CS063", "CS079", "CS042"};
    }

    @Override
    public void setUp() throws EASBizException, BOSException {
        int i;
        String[] orgUnitIds = this.service.getOrgUnits();
        StringBuffer sql = new StringBuffer();
        sql.append("select T0.FCompanyID,T2.FID,T2.FBeginDate ");
        sql.append("from T_BD_SystemStatusCtrol T0 ");
        sql.append("inner join T_BD_SystemStatus T1 on T0.FSystemStatusID=T1.FID ");
        sql.append("inner join T_BD_Period T2 on T0.FCurrentPeriodID = T2.FID ");
        sql.append(" and T0.FCompanyID in (");
        for (int i2 = 0; i2 < orgUnitIds.length; ++i2) {
            sql.append("'" + orgUnitIds[i2] + "',");
        }
        sql.deleteCharAt(sql.length() - 1);
        sql.append(") and T1.FName=" + SystemEnum.CASHMANAGEMENT.getValue());
        IRowSet iRowSet = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
        if (iRowSet != null && iRowSet.size() > 0) {
            try {
                if (iRowSet.next()) {
                    String orgUnitId = iRowSet.getString("FCompanyID");
                    PeriodInfo periodInfo = new PeriodInfo();
                    periodInfo.setId(BOSUuid.read((String)iRowSet.getString("FID")));
                    periodInfo.setBeginDate((Date)iRowSet.getTimestamp("FBeginDate"));
                    this.startPeriodMap.put(orgUnitId, periodInfo);
                }
            }
            catch (SQLException e) {
                throw new SQLAccessException(e);
            }
        }
        HashMap<String, String> arapSourceOrgUnitIdMap = new HashMap<String, String>();
        List<String> ids = this.service.getIds();
        for (i = 0; i < ids.size(); ++i) {
            ReceivingBillInfo info = (ReceivingBillInfo)this.service.getInfo(ids.get(i));
            if (info.getRecBillType().equals(SourceTypeEnum.CASH) || info.isIsInitializeBill()) continue;
            arapSourceOrgUnitIdMap.put(info.getCompany().getId().toString(), "");
        }
        if (arapSourceOrgUnitIdMap.size() > 0) {
            String[] arapSourceOrgUnitId = new String[]{};
            arapSourceOrgUnitId = arapSourceOrgUnitIdMap.keySet().toArray(arapSourceOrgUnitId);
            sql = new StringBuffer();
            sql.append("select T0.FCompanyID,T0.FIsStart,T1.FName ");
            sql.append("from T_BD_SystemStatusCtrol T0 ");
            sql.append("inner join T_BD_SystemStatus T1 on T0.FSystemStatusID=T1.FID ");
            sql.append(" and T0.FCompanyID in (");
            for (int i3 = 0; i3 < arapSourceOrgUnitId.length; ++i3) {
                sql.append("'" + arapSourceOrgUnitId[i3] + "',");
            }
            sql.deleteCharAt(sql.length() - 1);
            sql.append(") and T1.FName IN (" + SystemEnum.ACCOUNTSRECEIVABLE.getValue() + "," + SystemEnum.ACCOUNTSPAYABLE.getValue() + ")");
            iRowSet = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
            if (iRowSet != null && iRowSet.size() > 0) {
                try {
                    if (iRowSet.next()) {
                        String orgUnitId = iRowSet.getString("FCompanyID");
                        int system = iRowSet.getInt("FName");
                        int isStart = iRowSet.getInt("FIsStart");
                        Map<Integer, Boolean> systemMap = this.isStartMap.get(orgUnitId);
                        if (systemMap == null) {
                            systemMap = new HashMap<Integer, Boolean>();
                            this.isStartMap.put(orgUnitId, systemMap);
                        }
                        systemMap.put(system, isStart == 1);
                    }
                }
                catch (SQLException e) {
                    throw new SQLAccessException(e);
                }
            }
        }
        sql = new StringBuffer();
        sql.append("SELECT FCompanyID,FAccountID,fbankaccountnumber FROM T_BD_AccountBanks ");
        sql.append("WHERE FCompanyID in (");
        for (i = 0; i < orgUnitIds.length; ++i) {
            sql.append("'" + orgUnitIds[i] + "',");
        }
        sql.deleteCharAt(sql.length() - 1);
        sql.append(")");
        iRowSet = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
        if (iRowSet != null && iRowSet.size() > 0) {
            try {
                if (iRowSet.next()) {
                    String orgUnitId = iRowSet.getString("FCompanyID");
                    String accountId = iRowSet.getString("FAccountID");
                    String bankAccountNumber = iRowSet.getString("fbankaccountnumber");
                    this.companyBankNumberMap.put(orgUnitId + "!" + bankAccountNumber, "");
                    this.companyBankNumberMap.put(orgUnitId + "!" + bankAccountNumber + "!" + accountId, "");
                }
            }
            catch (SQLException e) {
                throw new SQLAccessException(e);
            }
        }
    }

    @Override
    public void beforeService(String id) throws EASBizException, BOSException {
        boolean isCommitSettle;
        SettBizTypeInfo bizTypeInfo;
        boolean val;
        ReceivingBillInfo info = (ReceivingBillInfo)this.service.getInfo(id);
        Map<String, Object> param = this.service.getParamMap(info.getCompany().getId().toString());
        if (info.getBillStatus().getValue() != 10 && info.getBillStatus().getValue() != 11) {
            throw new BOSException(CASWebUtil.getResource(this.ctx, "BILL_STATUS_NOT_SAVEORSUBMIT"));
        }
        boolean changed = false;
        ReceivingBillInfo oldInfo = (ReceivingBillInfo)this.service.getOldInfo(id);
        if (info.getBillStatus() != oldInfo.getBillStatus()) {
            changed = true;
        }
        if (info.getSettlementStatus() != oldInfo.getSettlementStatus()) {
            changed = true;
        }
        if (info.isFiVouchered() != oldInfo.isFiVouchered()) {
            changed = true;
        }
        if (changed) {
            throw new RuntimeException(CASWebUtil.getResource(this.ctx, "CANNOT_SUBMIT_BILL_STATUS_CHANGED"));
        }
        if (EmptyUtil.isEmpty((String)info.getNumber()) && !SourceTypeEnum.AR.equals((Object)info.getSourceType())) {
            throw new RuntimeException(CASWebUtil.getResource(this.ctx, "289_BILLNUMBER_NOT_EMPTY"));
        }
        if (info.getPayeeAccount() == null && !info.isIsInitializeBill()) {
            throw new RuntimeException(CASWebUtil.getResource(this.ctx, "PAYEEACCOUNT_EMPTY_BATCH"));
        }
        if (((Boolean)param.get("CS032")).booleanValue() && !SourceTypeEnum.AR.equals((Object)info.getSourceType()) && info.getFeeType() == null) {
            throw new RuntimeException(CASWebUtil.getResource(this.ctx, "RECBILLTYPE_REQUIRED"));
        }
        if (info.getRecBillType() == null) {
            throw new RecPayException(RecPayException.RECBILLTYPEISNULL);
        }
        if (((Boolean)param.get("CS033")).booleanValue() && info.getProject() == null) {
            throw new RuntimeException(CASWebUtil.getResource(this.ctx, "PROJECT_REQUIRED"));
        }
        if (info.getRealRecCompany() != null && info.getRealRecCompany().getId().equals((Object)info.getCompany().getId())) {
            throw new RuntimeException(CASWebUtil.getResource(this.ctx, "COMPANY_AND_REALCOMPANY_CANNOT_SAME"));
        }
        if (SourceTypeEnum.AR.equals((Object)info.getSourceType())) {
            PeriodInfo periodInfo = this.startPeriodMap.get(info.getCompany().getId().toString());
            if (periodInfo == null) {
                throw new RecPayException(RecPayException.AR_ISNOT_START);
            }
            if (periodInfo.getBeginDate() != null && !info.isIsInitializeBill() && info.getCreateTime().compareTo(periodInfo.getBeginDate()) < 0) {
                throw new RecPayException(RecPayException.BILLDATEMUSTGREATTHANBEGINDATE);
            }
            if (periodInfo.getBeginDate() != null && !info.isIsInitializeBill() && info.getCreateTime().compareTo(periodInfo.getBeginDate()) >= 0) {
                String str = EASCommonResource.getString((String)"com.kingdee.eas.fi.cas.RecPayResource", (String)"DateAfterStartDate", (Locale)this.ctx.getLocale());
                throw new RecPayException(new NumericExceptionSubItem("DateAfterStartDate", str));
            }
        }
        if (info.getActRecAmt() == null || info.getActRecAmt().doubleValue() == 0.0) {
            throw new RuntimeException(CASWebUtil.getResource(this.ctx, "RECEIVINGBILL_ACTREC_CANNOTBEZERO"));
        }
        if (info.getActRecLocAmt() == null || info.getActRecLocAmt().doubleValue() == 0.0) {
            throw new RuntimeException(CASWebUtil.getResource(this.ctx, "RECEIVINGBILL_ACTRECLOC_CANNOTBEZERO"));
        }
        boolean feeTypeAndProjectAllRequrie = (Boolean)param.get("CS044");
        if (feeTypeAndProjectAllRequrie && (info.getFeeType() != null && info.getProject() == null || info.getFeeType() == null && info.getProject() != null)) {
            throw new RuntimeException(CASWebUtil.getResource(this.ctx, "feeTypeAndProjectAllRequrie"));
        }
        ReceivingBillTypeInfo receiveType = info.getRecBillType();
        SourceTypeEnum billTypeEnum = receiveType.getSourceSysType();
        if (!receiveType.equals(SourceTypeEnum.CASH) && !info.isIsInitializeBill()) {
            Map<Integer, Boolean> arapStart = this.isStartMap.get(info.getCompany().getId().toString());
            boolean flagRec = arapStart.get(SystemEnum.ACCOUNTSRECEIVABLE) != null && arapStart.get(SystemEnum.ACCOUNTSRECEIVABLE) != false;
            boolean flagPay = arapStart.get(SystemEnum.ACCOUNTSPAYABLE) != null && arapStart.get(SystemEnum.ACCOUNTSPAYABLE) != false;
            Object[] args = new String[]{billTypeEnum.toString(), billTypeEnum.toString()};
            String messageRec = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.cas.RecPayResource", (String)"ArIsNotStart"), args);
            String messagePay = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.cas.RecPayResource", (String)"ApIsNotStart"), args);
            if (!flagPay && billTypeEnum.equals((Object)SourceTypeEnum.AP)) {
                throw new RuntimeException(CASWebUtil.getResource(this.ctx, "AP_NOT_START"));
            }
            if (!flagRec && billTypeEnum.equals((Object)SourceTypeEnum.AR)) {
                throw new RuntimeException(CASWebUtil.getResource(this.ctx, "AR_NOT_START"));
            }
        }
        if (receiveType != null && (receiveType.getSourceSysType().equals((Object)SourceTypeEnum.AP) || receiveType.getSourceSysType().equals((Object)SourceTypeEnum.AR))) {
            AsstActTypeInfo payeeType = info.getPayerType();
            if (payeeType != null && payeeType.equals((Object)FMSysDefinedEnum.OTHER)) {
                String msg = EASResource.getString((String)"com.kingdee.eas.fi.cas.RecPayResource", (String)"ArApPayerTypeNotOther");
                throw new RuntimeException(CASWebUtil.getResource(this.ctx, "ArApPayerTypeNotOther"));
            }
            if (info.getPayerName() == null || info.getPayerName().equals("")) {
                throw new RuntimeException(CASWebUtil.getResource(this.ctx, "PAYER_CANNOT_BENULL"));
            }
        }
        if (info.getPayeeAccount() != null && info.getPayeeAccount().isIsBank() && info.getPayeeAccountBank() == null) {
            throw new RuntimeException(CASWebUtil.getResource(this.ctx, "PAYEEACCOUNTBANK_CANNOT_BENULL"));
        }
        AccountBankInfo payeeAcctBank = info.getPayeeAccountBank();
        if (payeeAcctBank != null) {
            AccountViewInfo account;
            CurrencyInfo Crinfo = info.getCurrency();
            CurrencyInfo acctBankCrinfo = payeeAcctBank.getCurrency();
            if (payeeAcctBank.isIsByCurrency() && !acctBankCrinfo.getId().equals((Object)Crinfo.getId())) {
                throw new RuntimeException(CASWebUtil.getResource(this.ctx, "CURRENCY_AND_ACCTBANKCURRENCY_NOT_SAME"));
            }
            if (payeeAcctBank != null && payeeAcctBank.getAccount() != null && (account = info.getPayeeAccount()) != null && !payeeAcctBank.getAccount().getId().equals((Object)account.getId())) {
                throw new RuntimeException(CASWebUtil.getResource(this.ctx, "ACCT_AND_ACCTBANKACCT_NOT_SAME"));
            }
            if (!(receiveType != null && receiveType.getId().toString().equals("fjJCrQESEADgABolwKgSQyqo2zU=") || payeeAcctBank.getAccountType() != AccountType.PAYOUT)) {
                throw new RuntimeException(CASWebUtil.getResource(this.ctx, "ACCOUNTBANK_CANNOT_BEOUT"));
            }
            AccountBankInfo payerAccountBank = info.getPayerAccountBankO();
            if (payerAccountBank != null && payerAccountBank.isIsByCurrency() && !Crinfo.getId().toString().equals(payerAccountBank.getCurrency().getId().toString())) {
                throw new RuntimeException(CASWebUtil.getResource(this.ctx, "302_PAYERCURR_NOTEQ_PAYEECURR"));
            }
        }
        boolean isOppAccountBank = false;
        for (int i = 0; i < info.getEntries().size(); ++i) {
            AccountViewInfo acct = info.getEntries().get(i).getOppAccount();
            if (acct == null || !acct.isIsBank()) continue;
            isOppAccountBank = true;
            break;
        }
        if (isOppAccountBank) {
            String bankAccountNumber;
            if (info.getPayerAccountBank() == null || info.getPayerAccountBank().equals("")) {
                throw new BOSException(CASWebUtil.getResource(this.ctx, "PAYERACCOUNTBANK_CANNOT_BENULL"));
            }
            String companyId = info.getCompany().getId().toString();
            if (!this.getBankAccountNumberBelong(this.ctx, companyId, bankAccountNumber = info.getPayerAccountBank())) {
                throw new BOSException(CASWebUtil.getResource(this.ctx, "PAYERACCOUNTBANK_NOT_EXIST"));
            }
            String accountId = info.getOppAccount().getId().toString();
            if (!this.getAccountBelong(this.ctx, companyId, accountId, bankAccountNumber)) {
                throw new BOSException(CASWebUtil.getResource(this.ctx, "RelAcctViewNotEqualOppAcctView"));
            }
        }
        if (val = ((Boolean)param.get("CS014")).booleanValue()) {
            for (int i = 0; i < info.getEntries().size(); ++i) {
                ReceivingBillEntryInfo entryInfo = info.getEntries().get(i);
                if (entryInfo.getOppBgItemId() != null && !entryInfo.getOppBgItemId().equals("")) continue;
                throw new RuntimeException(CASWebUtil.getResource(this.ctx, "ENTRYOPPITEM_REQUIRED"));
            }
        }
        boolean isOutBank = true;
        if (payeeAcctBank != null && payeeAcctBank.getBank().isInGroup()) {
            isOutBank = false;
        }
        if (!FMHelper.isEmpty((String)info.getPayerBank()) && !FMHelper.isEmpty((CoreBaseInfo)info.getPayeeBank()) && !isOutBank && (info.getPayerBank().equals(info.getPayeeBank()) ? (bizTypeInfo = info.getBizType()) != null && !SettBizTypeEnum.RECINSIDE.equals((Object)bizTypeInfo.getType()) : (bizTypeInfo = info.getBizType()) != null && !SettBizTypeEnum.RECOUTSIDE.equals((Object)bizTypeInfo.getType()) && !SettBizTypeEnum.RECINSIDEDIF.equals((Object)bizTypeInfo.getType()))) {
            throw new RuntimeException(CASWebUtil.getResource(this.ctx, "mustRecinSide"));
        }
        if (info.getPayerAccountBank() != null) {
            boolean sameAccountAllowable = (Boolean)param.get("CS073");
            AccountBankInfo acctBankInfo = info.getPayeeAccountBank();
            if (acctBankInfo != null && !sameAccountAllowable && info.getPayerAccountBank().equals(acctBankInfo.getBankAccountNumber())) {
                throw new RuntimeException(CASWebUtil.getResource(this.ctx, "CantBeSameAccount"));
            }
        }
        AssItemsForCashRecCollection ac = info.getAssItems();
        for (int i = 0; i < ac.size(); ++i) {
            AssItemsForCashRecInfo infoAc = ac.get(i);
            if (infoAc.isIsSelected() && infoAc.getFromNumber().equals("")) {
                throw new BOSException(CASWebUtil.getResource(this.ctx, "OPPITEM_REQUIRED"));
            }
            if (infoAc.getFromNumber().equals("") || infoAc.isIsSelected()) continue;
            throw new BOSException(CASWebUtil.getResource(this.ctx, "OPPITEM_SHOULD_BENULL"));
        }
        ReceivingBillEntryCollection entryCol = info.getEntries();
        int size = entryCol.size();
        for (int i = 0; i < size; ++i) {
            ReceivingBillEntryInfo entryInfo = entryCol.get(i);
            AssItemsForCashRecCollection assCol = entryInfo.getAssItemsEntries();
            int assColSize = assCol.size();
            for (int j = 0; j < assColSize; ++j) {
                AssItemsForCashRecInfo infoAc = assCol.get(j);
                if (infoAc.isIsSelected() && infoAc.getFromNumber().equals("")) {
                    throw new RuntimeException(CASWebUtil.getResource(this.ctx, "OPPITEM_REQUIRED"));
                }
                if (infoAc.getFromNumber().equals("") || infoAc.isIsSelected()) continue;
                throw new RuntimeException(CASWebUtil.getResource(this.ctx, "OPPITEM_SHOULD_BENULL"));
            }
        }
        if (info.getPayeeAccount() != null && !info.getCompany().getId().equals((Object)info.getPayeeAccount().getCompanyID().getId())) {
            throw new FMException(FMException.COMMMONEXCEPTION, (Object[])new String[]{EASResource.getString((String)"com.kingdee.eas.fi.cas.RecPayResource", (String)"195_SubmitValidModelPlugin", (Locale)this.ctx.getLocale())});
        }
        if (((Boolean)param.get("CS005")).booleanValue() && EmptyUtil.isEmpty((String)info.getOppBgItemNumber())) {
            throw new CasException(CasException.OPPBGITEMNULL);
        }
        if (((Boolean)param.get("CS014")).booleanValue()) {
            ReceivingBillEntryCollection entryCollection = info.getEntries();
            ReceivingBillEntryInfo billEntryInfo = null;
            for (int i = 0; i < entryCollection.size(); ++i) {
                billEntryInfo = entryCollection.get(i);
                if (!EmptyUtil.isEmpty((String)billEntryInfo.getOppBgItemNumber())) continue;
                throw new CasException(CasException.ENTRYSBGITEMNULL);
            }
        }
        ServiceHandler serviceHandler = new ServiceHandler();
        if (info.getCostCenter() != null && info.getCostCenter().isIsOUSealUp()) {
            throw new CasException(CasException.COSTCENTERERR);
        }
        for (int i = 0; i < info.getEntries().size(); ++i) {
            if (info.getEntries().get(i).getCostCenter() == null || !info.getEntries().get(i).getCostCenter().isIsOUSealUp()) continue;
            throw new CasException(CasException.COSTCENTERERR);
        }
        if (EmptyUtil.isEmpty((String)info.getSourceBillId()) && info.getPayeeAccountBank() != null) {
            if (info.getPayeeBank() != null && info.getPayeeBank().isInGroup() && info.getBizType() == null) {
                throw new RecPayException(RecPayException.RECBIZTYPEISNULL);
            }
            if (payeeAcctBank.getInnerAcct() != null && info.getBizType() != null) {
                if (info.getBizType() == null) {
                    throw new RecPayException(RecPayException.RECBIZTYPEISNULL);
                }
                if (info.getDescription() == null || info.getDescription().length() == 0) {
                    throw new RecPayException(RecPayException.FORSETTLEMUSTHAVEDESCRIPTIONREC);
                }
                if (info.getBizType().getType() == SettBizTypeEnum.RECINSIDE && (info.getPayerAccountBankO() == null || info.getPayerAccountBankO().getInnerAcct() == null)) {
                    throw new RecPayException(RecPayException.PAYERACCOUNTMUSTHAVEINNERACCOUNT);
                }
                if (EmptyUtil.isEmpty((String)info.getPayerName())) {
                    throw new RecPayException(RecPayException.FORSETTLEMUSTHAVEPAYERNAME);
                }
            }
        }
        if (((Boolean)param.get("CS063")).booleanValue() && SourceTypeEnum.CASH.equals((Object)info.getSourceType())) {
            boolean flag = true;
            if (info.getEntries() != null) {
                int i;
                AccountViewCollection acctCollection = new AccountViewCollection();
                ReceivingBillEntryInfo recEntryInfo = null;
                int size2 = info.getEntries().size();
                for (i = 0; i < size2; ++i) {
                    recEntryInfo = info.getEntries().get(i);
                    if (recEntryInfo.getOppAccount() == null || recEntryInfo.getOppAccount().getId() == null) continue;
                    acctCollection.add(recEntryInfo.getOppAccount());
                }
                size2 = info.getEntries().size();
                for (i = 0; i < size2 && (flag = this.verifyAccountViewBoolean(this.ctx, acctCollection, (recEntryInfo = info.getEntries().get(i)).getOppAccount(), info.getCurrency(), info.getCompany())); ++i) {
                }
            }
            if (!flag) {
                throw new FMException(FMException.NOACCOUNTCURRENCY);
            }
        }
        if (info == null || info.getEntries() == null || info.getEntries().size() < 1) {
            throw new RecPayException(RecPayException.BILLENTRY_ISNULL);
        }
        String recPayType = null;
        recPayType = ResourceBase.getString((String)"com.kingdee.eas.fi.cas.RecPayResource", (String)"RecType", (Locale)this.ctx.getLocale());
        int recType = 100;
        try {
            recType = Integer.parseInt(info.getRecBillType().getNumber());
        }
        catch (NumberFormatException e) {
            recType = 100;
        }
        if ((recType == RecPayBillTypeEnum.REC_AR_REFUNDMENT_SELL_REC.getValue() || recType == RecPayBillTypeEnum.REC_AR_REFUNDMENT_PRE_REC.getValue() || recType == RecPayBillTypeEnum.PAY_CP_REFUNDMENT_BILL.getValue() || recType == RecPayBillTypeEnum.REC_AR_REFUNDMENT_AGENT.getValue()) && (isCommitSettle = info.isIsCommitSettle())) {
            throw new RecPayException(RecPayException.CANNOT_COMMIT_HAS_NEGATIVE, new String[]{recPayType});
        }
        if (SourceTypeEnum.AR.equals((Object)info.getSourceType()) && info.getPayerID() != null && info.getPayerType() != null && info.getCompany() != null && !RecPayHelper.isExistAsstActByCompany(this.ctx, info.getCompany(), info.getPayerType(), info.getPayerID())) {
            throw new RecPayException(RecPayException.ACCTCUSSENT_NOTBELONGCOMORG);
        }
        if (!(info.isIsInitializeBill() || info.isIsTransBill() && !info.isIsTransOtherBill())) {
            boolean onWaybgCtrl = (Boolean)param.get("CS079");
            if (onWaybgCtrl) {
                String boName = "com.kingdee.eas.fi.cas.app.ReceivingBill";
                String handleName = BgCtrlReceivingBillHandler.class.getName();
                RecPayHelper.OnWaybgCtrl(this.ctx, id, boName, handleName);
            } else {
                int cs042 = 0;
                if (param.get("CS042") != null) {
                    cs042 = Integer.parseInt((String)param.get("CS042"));
                }
                if (info.isIsTransOtherBill() && cs042 != 0) {
                    RecPayHelper.bgCtrlAudit(this.ctx, id);
                } else {
                    serviceHandler.bgCtrlAndAudit(this.ctx, (IObjectPK)new ObjectUuidPK(id), RecPayBgCtrlStrEnum.Sumbit_Sub, cs042);
                }
            }
        }
    }

    public boolean verifyAccountViewBoolean(Context ctx, AccountViewCollection acctCollection, AccountViewInfo acctViewInfo, CurrencyInfo currInfo, CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        boolean isValid;
        block9: {
            AccountCurrencyCollection acctCurrColl;
            AccountViewInfo viewInfo;
            block8: {
                if (acctViewInfo == null || currInfo == null) {
                    return true;
                }
                viewInfo = null;
                acctCurrColl = null;
                if (acctViewInfo.getCurrencyID() == null) {
                    if (acctCollection.containsKey((Object)acctViewInfo.getId())) {
                        viewInfo = acctCollection.get((Object)acctViewInfo.getId());
                        acctCurrColl = viewInfo.getAccountCurrency();
                    }
                } else {
                    acctCurrColl = acctViewInfo.getAccountCurrency();
                }
                isValid = false;
                if (viewInfo == null || !AccountingCurrencyEnum.NOCURRENCY.equals((Object)viewInfo.getAccountingcurrency())) break block8;
                if (!company.getBaseCurrency().getId().toString().equals(currInfo.getId().toString())) break block9;
                isValid = true;
                break block9;
            }
            if (viewInfo != null && AccountingCurrencyEnum.ALLCURRENCY.equals((Object)viewInfo.getAccountingcurrency())) {
                isValid = true;
            } else if (acctCurrColl != null) {
                int size = acctCurrColl.size();
                for (int i = 0; i < size; ++i) {
                    if (!acctCurrColl.get(i).getCurrency().getId().equals((Object)currInfo.getId())) continue;
                    isValid = true;
                    break;
                }
            }
        }
        return isValid;
    }

    private boolean getBankAccountNumberBelong(Context ctx, String companyId, String bankAccountNumber) {
        return this.companyBankNumberMap.containsKey(companyId + "!" + bankAccountNumber);
    }

    private boolean getAccountBelong(Context ctx, String companyId, String accountId, String bankAccountNumber) {
        return this.companyBankNumberMap.containsKey(companyId + "!" + bankAccountNumber + "!" + accountId);
    }
}

