/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app.webservice;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ProjectInfo;
import com.kingdee.eas.basedata.assistant.SettlementTypeInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.GeneralAsstActTypeInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.fi.cas.BillStatusEnum;
import com.kingdee.eas.fi.cas.BizTypeEnum;
import com.kingdee.eas.fi.cas.FeeTypeInfo;
import com.kingdee.eas.fi.cas.IPaymentBill;
import com.kingdee.eas.fi.cas.PaymentBillEntryCollection;
import com.kingdee.eas.fi.cas.PaymentBillEntryInfo;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.cas.PaymentBillTypeInfo;
import com.kingdee.eas.fi.cas.SettlementStatusEnum;
import com.kingdee.eas.fi.cas.SourceTypeEnum;
import com.kingdee.eas.fi.cas.VcStatusEnum;
import com.kingdee.eas.fi.cas.app.webservice.AbstractPayBillFacadeControllerBean;
import com.kingdee.eas.fi.cas.app.webservice.util.BillProertiesConvertor;
import com.kingdee.eas.fi.cas.app.webservice.util.BillPropertiesReader;
import com.kingdee.eas.fi.cas.app.webservice.util.WrongArgumentException;
import com.kingdee.eas.fm.fpl.FpItemInfo;
import com.kingdee.eas.fm.fs.InnerAccountInfo;
import com.kingdee.eas.fm.fs.SettBizTypeEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.util.StringUtils;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.xml.sax.SAXException;

public class PayBillFacadeControllerBean
extends AbstractPayBillFacadeControllerBean {
    private static final long serialVersionUID = 6120422023307037115L;
    private static final String SUCCESS = "Y";
    private static final String FAILED = "N";
    private static final String BILLHEAD = "head";
    private static final String BILLENTRIS = "entry";
    private static final String OTHER = "other";
    private static final String BILLTYPE = "PayBill";
    private static final String ENTRYXPATH = "//billEntries/entry";
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.sac.app.webservice.PayBillFacadeControllerBean");
    private FilterItemInfo cuFilter = null;

    @Override
    protected String[] _submit(Context ctx, String xmlData) throws BOSException {
        this.cuFilter = null;
        BillPropertiesReader helper = null;
        try {
            helper = new BillPropertiesReader(xmlData, BILLTYPE);
        }
        catch (WrongArgumentException e) {
            logger.debug((Object)"wrong bill type");
            return new String[]{FAILED, e.getTypeNumber(), OTHER, "wrong bill type"};
        }
        catch (IOException e) {
            logger.debug((Object)e.getMessage());
            return new String[]{FAILED, "1006", OTHER, e.getMessage()};
        }
        catch (SAXException e) {
            logger.debug((Object)e.getMessage());
            return new String[]{FAILED, "1006", OTHER, e.getMessage()};
        }
        Map head = helper.getHeadProperties("billHead");
        List entries = helper.getEntriesProperties(ENTRYXPATH);
        PaymentBillInfo info = new PaymentBillInfo();
        try {
            if (head == null) {
                return new String[]{FAILED, "1011", OTHER, "No head!"};
            }
            this.setHead(info, head, ctx);
        }
        catch (WrongArgumentException e) {
            logger.debug((Object)(e.getTypeNumber() + ":head field " + e.getField() + " error"));
            return new String[]{FAILED, e.getTypeNumber(), BILLHEAD, e.getField()};
        }
        try {
            if (entries.size() == 0) {
                return new String[]{FAILED, "1009", OTHER, "no entries"};
            }
            this.setEntries(info, entries, ctx);
        }
        catch (WrongArgumentException e) {
            logger.debug((Object)(e.getTypeNumber() + ":entry field " + e.getField() + " error"));
            return new String[]{FAILED, e.getTypeNumber(), BILLENTRIS, e.getField()};
        }
        IPaymentBill iPaymentBill = PaymentBillFactory.getLocalInstance(ctx);
        try {
            iPaymentBill.save((CoreBaseInfo)info);
        }
        catch (Exception e) {
            logger.debug((Object)e.getMessage());
            return new String[]{FAILED, "1006", OTHER, "error occur when saving bill"};
        }
        return new String[]{SUCCESS};
    }

    private void setHead(PaymentBillInfo info, Map head, Context ctx) throws BOSException, WrongArgumentException {
        SettlementStatusEnum settlementstatus;
        SettBizTypeEnum settlebiztype;
        this.verifyFieldNotNull("CU", head.get("CU"));
        CtrlUnitInfo cu = (CtrlUnitInfo)BillProertiesConvertor.getValueObject(head.get("CU"), CtrlUnitInfo.class, null, ctx);
        info.setCU(cu);
        this.verifyFieldNotNull("CU", cu);
        if ("yes".equals(head.get("CUNeed"))) {
            this.cuFilter = new FilterItemInfo("CU.id", (Object)cu.getId(), CompareType.EQUALS);
        }
        info.setBillStatus(BillStatusEnum.SAVE);
        this.verifyFieldNotNull("creator", head.get("creator"));
        UserInfo creator = (UserInfo)BillProertiesConvertor.getValueObject(head.get("creator"), UserInfo.class, this.cuFilter, ctx);
        this.verifyFieldNotNull("creator", creator);
        info.setCreator(creator);
        this.verifyFieldFormat("createtime", head.get("createtime"), "date");
        Timestamp createTime = BillProertiesConvertor.getTimestamp((String)head.get("createtime"));
        info.setCreateTime(createTime);
        UserInfo lastUpdater = (UserInfo)BillProertiesConvertor.getValueObject(head.get("lastupdateuser"), UserInfo.class, this.cuFilter, ctx);
        info.setLastUpdateUser(lastUpdater);
        if (!this.isNull(head.get("lastupdatetime"))) {
            this.verifyFieldFormat("lastupdatetime", head.get("lastupdatetime"), "date");
        }
        Timestamp lastUpdateTime = BillProertiesConvertor.getTimestamp((String)head.get("lastupdatetime"));
        info.setLastUpdateTime(lastUpdateTime);
        this.verifyFieldNotNull("number", head.get("number"));
        info.setNumber((String)head.get("number"));
        this.verifyFieldFormat("bizdate", head.get("bizdate"), "date");
        Timestamp bizDate = BillProertiesConvertor.getTimestamp((String)head.get("bizdate"));
        info.setBizDate(bizDate);
        UserInfo handler = (UserInfo)BillProertiesConvertor.getValueObject(head.get("handler"), UserInfo.class, this.cuFilter, ctx);
        info.setHandler(handler);
        info.setDescription((String)head.get("description"));
        boolean hasEffected = BillProertiesConvertor.getBool((String)head.get("haseffected"));
        info.setHasEffected(hasEffected);
        UserInfo auditor = (UserInfo)BillProertiesConvertor.getValueObject(head.get("auditor"), UserInfo.class, this.cuFilter, ctx);
        info.setAuditor(auditor);
        info.setSourceBillId((String)head.get("sourcebillid"));
        info.setSourceFunction((String)head.get("sourcefunction"));
        this.verifyFieldNotNull("company", head.get("company"));
        CompanyOrgUnitInfo comInfo = (CompanyOrgUnitInfo)BillProertiesConvertor.getValueObject(head.get("company"), CompanyOrgUnitInfo.class, this.cuFilter, ctx);
        this.verifyFieldNotNull("company", comInfo);
        info.setCompany(comInfo);
        this.verifyFieldFormat("sourcesystype", head.get("sourcesystype"), "int");
        SourceTypeEnum sourcesystype = SourceTypeEnum.getEnum((int)BillProertiesConvertor.getInt((String)head.get("sourcesystype")));
        this.verifyFieldNotNull("sourcesystype", sourcesystype);
        info.setSourceSysType(sourcesystype);
        this.verifyFieldFormat("sourcetype", head.get("sourcetype"), "int");
        SourceTypeEnum sourceType = SourceTypeEnum.getEnum((int)BillProertiesConvertor.getInt((String)head.get("sourcetype")));
        this.verifyFieldNotNull("sourcetype", sourceType);
        info.setSourceType(sourceType);
        this.verifyFieldNotNull("currency", head.get("currency"));
        CurrencyInfo currency = (CurrencyInfo)BillProertiesConvertor.getValueObject(head.get("currency"), CurrencyInfo.class, this.cuFilter, ctx);
        this.verifyFieldNotNull("currency", currency);
        info.setCurrency(currency);
        this.verifyFieldFormat("exchangerate", head.get("exchangerate"), "bigdecimal");
        info.setExchangeRate(BillProertiesConvertor.getBigDecimal((String)head.get("exchangerate")));
        if (!this.isNull(head.get("isexchanged"))) {
            this.verifyFieldFormat("isexchanged", head.get("isexchanged"), "bool");
        }
        info.setIsExchanged(BillProertiesConvertor.getBool((String)head.get("isexchanged")));
        if (!this.isNull(head.get("lastexhangerate"))) {
            this.verifyFieldFormat("lastexhangerate", head.get("lastexhangerate"), "bigdecimal");
        }
        info.setLastExhangeRate(BillProertiesConvertor.getBigDecimal((String)head.get("lastexhangerate")));
        SettlementTypeInfo settlementType = (SettlementTypeInfo)BillProertiesConvertor.getValueObject(head.get("settlementtype"), SettlementTypeInfo.class, null, ctx);
        info.setSettlementType(settlementType);
        info.setSettlementNumber((String)head.get("settlementnumber"));
        AccountViewInfo oppAccount = (AccountViewInfo)BillProertiesConvertor.getValueObject(head.get("oppaccount"), AccountViewInfo.class, this.cuFilter, ctx);
        info.setOppAccount(oppAccount);
        FpItemInfo fpitem = (FpItemInfo)BillProertiesConvertor.getValueObject(head.get("fpitem"), FpItemInfo.class, this.cuFilter, ctx);
        info.setFpItem(fpitem);
        if (!this.isNull(head.get("iscommitsettle"))) {
            this.verifyFieldFormat("iscommitsettle", head.get("iscommitsettle"), "bool");
        }
        info.setIsCommitSettle(BillProertiesConvertor.getBool((String)head.get("iscommitsettle")));
        if (!this.isNull(head.get("settlebiztype"))) {
            this.verifyFieldFormat("settlebiztype", head.get("settlebiztype"), "int");
        }
        if ((settlebiztype = SettBizTypeEnum.getEnum((int)BillProertiesConvertor.getInt((String)head.get("settlebiztype")))) != null) {
            info.setSettleBizType(settlebiztype);
        }
        if (!this.isNull(head.get("auditdate"))) {
            this.verifyFieldFormat("auditdate", head.get("auditdate"), "date");
        }
        info.setAuditDate(BillProertiesConvertor.getTimestamp((String)head.get("auditdate")));
        UserInfo cashier = (UserInfo)BillProertiesConvertor.getValueObject(head.get("cashier"), UserInfo.class, this.cuFilter, ctx);
        info.setCashier(cashier);
        UserInfo accountant = (UserInfo)BillProertiesConvertor.getValueObject(head.get("accountant"), UserInfo.class, this.cuFilter, ctx);
        info.setAccountant(accountant);
        if (!this.isNull(head.get("isinitializebill"))) {
            this.verifyFieldFormat("isinitializebill", head.get("isinitializebill"), "bool");
        }
        info.setIsInitializeBill(BillProertiesConvertor.getBool((String)head.get("isinitializebill")));
        info.setFiVouchered(false);
        if (!this.isNull(head.get("settlementstatus"))) {
            this.verifyFieldFormat("settlementstatus", head.get("settlementstatus"), "int");
        }
        if ((settlementstatus = SettlementStatusEnum.getEnum(BillProertiesConvertor.getInt((String)head.get("settlementstatus")))) != null) {
            info.setSettlementStatus(settlementstatus);
        }
        this.verifyFieldFormat("fundtype", head.get("fundtype"), "int");
        BizTypeEnum fundtype = BizTypeEnum.getEnum(BillProertiesConvertor.getInt((String)head.get("fundtype")));
        this.verifyFieldNotNull("fundtype", (Object)fundtype);
        info.setFundType(fundtype);
        if (!this.isNull(head.get("isimport"))) {
            this.verifyFieldFormat("isimport", head.get("isimport"), "bool");
        }
        info.setIsImport(BillProertiesConvertor.getBool((String)head.get("isimport")));
        if (!this.isNull(head.get("amount"))) {
            this.verifyFieldFormat("amount", head.get("amount"), "bigdecimal");
        }
        info.setAmount(BillProertiesConvertor.getBigDecimal((String)head.get("amount")));
        if (!this.isNull(head.get("localamt"))) {
            this.verifyFieldFormat("localamt", head.get("localamt"), "bigdecimal");
        }
        info.setLocalAmt(BillProertiesConvertor.getBigDecimal((String)head.get("localamt")));
        AdminOrgUnitInfo adminOrgUnit = (AdminOrgUnitInfo)BillProertiesConvertor.getValueObject(head.get("adminorgunit"), AdminOrgUnitInfo.class, this.cuFilter, ctx);
        info.setAdminOrgUnit(adminOrgUnit);
        PersonInfo person = (PersonInfo)BillProertiesConvertor.getValueObject(head.get("person"), PersonInfo.class, this.cuFilter, ctx);
        info.setPerson(person);
        if (!this.isNull(head.get("accessoryamt"))) {
            this.verifyFieldFormat("accessoryamt", head.get("accessoryamt"), "int");
        }
        info.setAccessoryAmt(BillProertiesConvertor.getInt((String)head.get("accessoryamt")));
        info.setConceit((String)head.get("conceit"));
        info.setSummary((String)head.get("summary"));
        info.setContractNo((String)head.get("contractno"));
        if (!this.isNull(head.get("dayaccount"))) {
            this.verifyFieldFormat("dayaccount", head.get("dayaccount"), "bigdecimal");
        }
        info.setDayaccount(BillProertiesConvertor.getBigDecimal((String)head.get("dayaccount")));
        info.setCapitalAmount((String)head.get("capitalamount"));
        info.setContractBillId((String)head.get("contractbillid"));
        FeeTypeInfo feeType = (FeeTypeInfo)BillProertiesConvertor.getValueObject(head.get("feetype"), FeeTypeInfo.class, null, ctx);
        info.setFeeType(feeType);
        ProjectInfo project = (ProjectInfo)BillProertiesConvertor.getValueObject(head.get("project"), ProjectInfo.class, this.cuFilter, ctx);
        info.setProject(project);
        PersonInfo projectManager = (PersonInfo)BillProertiesConvertor.getValueObject(head.get("projectmanager"), PersonInfo.class, this.cuFilter, ctx);
        info.setProjectManager(projectManager);
        PaymentBillTypeInfo recType = (PaymentBillTypeInfo)BillProertiesConvertor.getValueObject(head.get("paytype"), PaymentBillTypeInfo.class, null, ctx);
        this.verifyFieldNotNull("paytype", recType);
        info.setPayBillType(recType);
        if (!this.isNull(head.get("actrecamt"))) {
            this.verifyFieldFormat("actrecamt", head.get("actrecamt"), "bigdecimla");
        }
        info.setActPayAmt(BillProertiesConvertor.getBigDecimal((String)head.get("actrecamt")));
        if (!this.isNull(head.get("actrecamtvc"))) {
            this.verifyFieldFormat("actrecamtvc", head.get("actrecamtvc"), "bigdecimla");
        }
        info.setActPayAmtVc(BillProertiesConvertor.getBigDecimal((String)head.get("actrecamtvc")));
        if (!this.isNull(head.get("actreclocamt"))) {
            this.verifyFieldFormat("actreclocamt", head.get("actreclocamt"), "bigdecimla");
        }
        info.setActPayLocAmt(BillProertiesConvertor.getBigDecimal((String)head.get("actreclocamt")));
        if (!this.isNull(head.get("actreclocamtvc"))) {
            this.verifyFieldFormat("actreclocamtvc", head.get("actreclocamtvc"), "bigdecimla");
        }
        info.setActPayAmtVc(BillProertiesConvertor.getBigDecimal((String)head.get("actreclocamtvc")));
        BankInfo payeeBank = (BankInfo)BillProertiesConvertor.getValueObject(head.get("payerbank"), BankInfo.class, this.cuFilter, ctx);
        info.setPayerBank(payeeBank);
        AccountBankInfo payeeaccountbank = (AccountBankInfo)BillProertiesConvertor.getValueObject(head.get("payeraccountbank"), AccountBankInfo.class, this.cuFilter, ctx);
        info.setPayerAccountBank(payeeaccountbank);
        AccountViewInfo payeeaccount = (AccountViewInfo)BillProertiesConvertor.getValueObject(head.get("payeeaccount"), AccountViewInfo.class, this.cuFilter, ctx);
        info.setPayerAccount(payeeaccount);
        this.verifyFieldNotNull("payertype", head.get("payertype"));
        AsstActTypeInfo payertype = (AsstActTypeInfo)BillProertiesConvertor.getValueObject(head.get("payertype"), AsstActTypeInfo.class, null, ctx);
        this.verifyFieldNotNull("payertype", payertype);
        info.setPayeeType(payertype);
        this.setAsstActor(ctx, info, head, payertype);
        info.setPayeeBank((String)head.get("payeebank"));
        info.setPayeeAccountBank((String)head.get("payeeaccountbank"));
        info.setPayDate(info.getBizDate());
        InnerAccountInfo oppinneracct = (InnerAccountInfo)BillProertiesConvertor.getValueObject(head.get("oppinneracct"), InnerAccountInfo.class, this.cuFilter, ctx);
        info.setOppInnerAcct(oppinneracct);
    }

    private void setAsstActor(Context ctx, PaymentBillInfo info, Map head, AsstActTypeInfo asstActTypeInfo) throws BOSException, WrongArgumentException {
        this.verifyFieldNotNull("payernumber", head.get("payernumber"));
        info.setPayeeNumber((String)head.get("payernumber"));
        EntityViewInfo evInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", head.get("payernumber"), CompareType.EQUALS));
        if (this.cuFilter != null) {
            filter.getFilterItems().add(this.cuFilter);
        }
        evInfo.setFilter(filter);
        if (asstActTypeInfo == null) {
            return;
        }
        String relationDataObject = asstActTypeInfo.getRealtionDataObject();
        BOSObjectType bosType = null;
        if (StringUtils.isEmpty((String)relationDataObject)) {
            return;
        }
        boolean fCust = relationDataObject.equalsIgnoreCase("T_BD_Customer");
        boolean fSupp = relationDataObject.equalsIgnoreCase("T_BD_Supplier");
        boolean fMaterial = relationDataObject.equalsIgnoreCase("T_BD_Material");
        if (relationDataObject.equalsIgnoreCase("T_BD_AccountBanks")) {
            bosType = new AccountBankInfo().getBOSType();
        } else if (fCust) {
            bosType = new CustomerInfo().getBOSType();
        } else if (fSupp) {
            bosType = new SupplierInfo().getBOSType();
        } else if (fMaterial) {
            bosType = new MaterialInfo().getBOSType();
        } else if (relationDataObject.equalsIgnoreCase("T_BD_Person")) {
            bosType = new PersonInfo().getBOSType();
        } else if (relationDataObject.equalsIgnoreCase("T_ORG_Company")) {
            bosType = new CompanyOrgUnitInfo().getBOSType();
        } else if (relationDataObject.equalsIgnoreCase("T_ORG_CostCenter")) {
            bosType = new CostCenterOrgUnitInfo().getBOSType();
        } else if (relationDataObject.equalsIgnoreCase("T_ORG_Admin")) {
            bosType = new AdminOrgUnitInfo().getBOSType();
        } else if (relationDataObject.equalsIgnoreCase("T_ORG_Purchase")) {
            bosType = new PurchaseOrgUnitInfo().getBOSType();
        } else if (relationDataObject.equalsIgnoreCase("T_ORG_Storage")) {
            bosType = new StorageOrgUnitInfo().getBOSType();
        } else if (relationDataObject.equalsIgnoreCase("T_ORG_Sale")) {
            bosType = new SaleOrgUnitInfo().getBOSType();
        } else if (relationDataObject.equalsIgnoreCase("T_ORG_ProfitCenter")) {
            bosType = new ProfitCenterOrgUnitInfo().getBOSType();
        } else if (relationDataObject.equalsIgnoreCase("T_BD_GeneralAsstActType")) {
            bosType = new GeneralAsstActTypeInfo().getBOSType();
        }
        try {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("name"));
            IObjectCollection objValCol = DynamicObjectFactory.getLocalInstance((Context)ctx).getCollection(bosType, evInfo);
            if (objValCol != null && objValCol.getObject(0) != null) {
                IObjectValue objVal = objValCol.getObject(0);
                info.setPayeeID(objVal.getString("id"));
                info.setPayeeName(objVal.getString("name"));
                info.setPayeeNumber(objVal.getString("number"));
            }
        }
        catch (BOSException e) {
            SysUtil.abort();
        }
    }

    private void setEntries(PaymentBillInfo info, List entries, Context ctx) throws BOSException, WrongArgumentException {
        PaymentBillEntryCollection entryCollection = info.getEntries();
        ListIterator it = entries.listIterator();
        while (it.hasNext()) {
            Map entry = (Map)it.next();
            PaymentBillEntryInfo entryInfo = this.getEntryInfo(entry, ctx);
            entryCollection.add(entryInfo);
        }
    }

    private PaymentBillEntryInfo getEntryInfo(Map entry, Context ctx) throws BOSException, WrongArgumentException {
        VcStatusEnum vcstatus;
        PaymentBillEntryInfo entryInfo = new PaymentBillEntryInfo();
        this.verifyFieldFormat("seq", entry.get("seq"), "int");
        entryInfo.setSeq(BillProertiesConvertor.getInt((String)entry.get("seq")));
        this.verifyFieldFormat("amount", entry.get("amount"), "bigdecimal");
        entryInfo.setAmount(BillProertiesConvertor.getBigDecimal((String)entry.get("amount")));
        if (!this.isNull(entry.get("amountvc"))) {
            this.verifyFieldFormat("amountvc", entry.get("amountvc"), "bigdecimal");
        }
        entryInfo.setAmountVc(BillProertiesConvertor.getBigDecimal((String)entry.get("amountvc")));
        this.verifyFieldFormat("localamt", entry.get("localamt"), "bigdecimal");
        entryInfo.setLocalAmt(BillProertiesConvertor.getBigDecimal((String)entry.get("localamt")));
        if (!this.isNull(entry.get("localamtvc"))) {
            this.verifyFieldFormat("localamtvc", entry.get("localamtvc"), "bigdecimal");
        }
        entryInfo.setLocalAmtVc(BillProertiesConvertor.getBigDecimal((String)entry.get("localamtvc")));
        if (!this.isNull(entry.get("unvcamount"))) {
            this.verifyFieldFormat("unvcamount", entry.get("unvcamount"), "bigdecimal");
        }
        entryInfo.setUnVcAmount(BillProertiesConvertor.getBigDecimal((String)entry.get("unvcamount")));
        if (!this.isNull(entry.get("unvclocamount"))) {
            this.verifyFieldFormat("unvclocamount", entry.get("unvclocamount"), "bigdecimal");
        }
        entryInfo.setHisUnVcLocAmount(BillProertiesConvertor.getBigDecimal((String)entry.get("unvclocamount")));
        if (!this.isNull(entry.get("unverifyexgrateloc"))) {
            this.verifyFieldFormat("unverifyexgrateloc", entry.get("unverifyexgrateloc"), "bigdecimal");
        }
        entryInfo.setUnVerifyExgRateLoc(BillProertiesConvertor.getBigDecimal((String)entry.get("unverifyexgrateloc")));
        if (!this.isNull(entry.get("rebate"))) {
            this.verifyFieldFormat("rebate", entry.get("rebate"), "bigdecimal");
        }
        entryInfo.setRebate(BillProertiesConvertor.getBigDecimal((String)entry.get("rebate")));
        if (!this.isNull(entry.get("rebateamtvc"))) {
            this.verifyFieldFormat("rebateamtvc", entry.get("rebateamtvc"), "bigdecimal");
        }
        entryInfo.setRebateAmtVc(BillProertiesConvertor.getBigDecimal((String)entry.get("rebateamtvc")));
        if (!this.isNull(entry.get("rebatelocamt"))) {
            this.verifyFieldFormat("rebatelocamt", entry.get("rebatelocamt"), "bigdecimal");
        }
        entryInfo.setRebateLocAmt(BillProertiesConvertor.getBigDecimal((String)entry.get("rebatelocamt")));
        if (!this.isNull(entry.get("rebatelocamtvc"))) {
            this.verifyFieldFormat("rebatelocamtvc", entry.get("rebatelocamtvc"), "bigdecimal");
        }
        entryInfo.setRebateLocAmtVc(BillProertiesConvertor.getBigDecimal((String)entry.get("rebatelocamtvc")));
        this.verifyFieldFormat("actualamt", entry.get("actualamt"), "bigdecimal");
        entryInfo.setActualAmt(BillProertiesConvertor.getBigDecimal((String)entry.get("actualamt")));
        if (!this.isNull(entry.get("actualamtvc"))) {
            this.verifyFieldFormat("actualamtvc", entry.get("actualamtvc"), "bigdecimal");
        }
        entryInfo.setActualAmtVc(BillProertiesConvertor.getBigDecimal((String)entry.get("actualamtvc")));
        this.verifyFieldFormat("actuallocamt", entry.get("actuallocamt"), "bigdecimal");
        entryInfo.setActualLocAmt(BillProertiesConvertor.getBigDecimal((String)entry.get("actuallocamt")));
        if (!this.isNull(entry.get("actuallocamtvc"))) {
            this.verifyFieldFormat("actuallocamtvc", entry.get("actuallocamtvc"), "bigdecimal");
        }
        entryInfo.setActualLocAmtVc(BillProertiesConvertor.getBigDecimal((String)entry.get("actuallocamtvc")));
        entryInfo.setRemark((String)entry.get("remark"));
        if (!this.isNull(entry.get("lockamt"))) {
            this.verifyFieldFormat("lockamt", entry.get("lockamt"), "bigdecimal");
        }
        entryInfo.setLockAmt(BillProertiesConvertor.getBigDecimal((String)entry.get("lockamt")));
        if (!this.isNull(entry.get("locklocamt"))) {
            this.verifyFieldFormat("locklocamt", entry.get("locklocamt"), "bigdecimal");
        }
        entryInfo.setLockLocAmt(BillProertiesConvertor.getBigDecimal((String)entry.get("locklocamt")));
        if (!this.isNull(entry.get("unlockamt"))) {
            this.verifyFieldFormat("unlockamt", entry.get("unlockamt"), "bigdecimal");
        }
        entryInfo.setUnLockAmt(BillProertiesConvertor.getBigDecimal((String)entry.get("unlockamt")));
        if (!this.isNull(entry.get("unlocklocamt"))) {
            this.verifyFieldFormat("unlocklocamt", entry.get("unlocklocamt"), "bigdecimal");
        }
        entryInfo.setUnLockLocAmt(BillProertiesConvertor.getBigDecimal((String)entry.get("unlocklocamt")));
        entryInfo.setSourceBillId((String)entry.get("sourcebillid"));
        entryInfo.setSourceBillEntryId((String)entry.get("sourcebillentryid"));
        if (!this.isNull(entry.get("vcstatus"))) {
            this.verifyFieldFormat("vcstatus", entry.get("vcstatus"), "int");
        }
        if ((vcstatus = VcStatusEnum.getEnum(BillProertiesConvertor.getInt((String)entry.get("vcstatus")))) != null) {
            entryInfo.setVcStatus(vcstatus);
        }
        if (!this.isNull(entry.get("hisunvcamount"))) {
            this.verifyFieldFormat("hisunvcamount", entry.get("hisunvcamount"), "bigdecimal");
        }
        entryInfo.setHisUnVcAmount(BillProertiesConvertor.getBigDecimal((String)entry.get("hisunvcamount")));
        if (!this.isNull(entry.get("hisunvclocamount"))) {
            this.verifyFieldFormat("hisunvclocamount", entry.get("hisunvclocamount"), "bigdecimal");
        }
        entryInfo.setHisUnVcLocAmount(BillProertiesConvertor.getBigDecimal((String)entry.get("hisunvclocamount")));
        BillTypeInfo corebilltype = (BillTypeInfo)BillProertiesConvertor.getValueObject(entry.get("corebilltype"), BillTypeInfo.class, this.cuFilter, ctx);
        entryInfo.setCoreBillType(corebilltype);
        entryInfo.setCoreBillId((String)entry.get("corebillid"));
        entryInfo.setCoreBillEntryId((String)entry.get("corebillentryid"));
        entryInfo.setCoreBillNumber((String)entry.get("corebillnumber"));
        if (!this.isNull(entry.get("corebillentryseq"))) {
            this.verifyFieldFormat("corebillentryseq", entry.get("corebillentryseq"), "int");
        }
        entryInfo.setCoreBillEntrySeq(BillProertiesConvertor.getInt((String)entry.get("corebillentryseq")));
        entryInfo.setTrackNumbet((String)entry.get("tracknumbet"));
        CurrencyInfo currency = (CurrencyInfo)BillProertiesConvertor.getValueObject(entry.get("currency"), CurrencyInfo.class, this.cuFilter, ctx);
        entryInfo.setCurrency(currency);
        return entryInfo;
    }

    private void verifyFieldFormat(String name, Object value, String dataType) throws WrongArgumentException {
        if (dataType.equals("int")) {
            String intString = (String)value;
            if (!Pattern.matches("[+|-]?\\d+", intString)) {
                throw new WrongArgumentException(name, "1002");
            }
        } else if (dataType.equals("bigdecimal")) {
            String bigDecimalStirng = (String)value;
            if (!Pattern.matches("[-|+]?\\d+(.\\d+)?(e[-|+]\\d+)?", bigDecimalStirng)) {
                throw new WrongArgumentException(name, "1004");
            }
        } else if (dataType.equals("date")) {
            String dateString = (String)value;
            if (!Pattern.matches("\\d{4}\\-\\d{1,2}\\-\\d{1,2}\\s\\d{1,2}:\\d{1,2}:\\d{1,2}", dateString)) {
                throw new WrongArgumentException(name, "1001");
            }
        } else if (dataType.equals("bool") && !value.equals("true") && !value.equals("false")) {
            throw new WrongArgumentException(name, "1003");
        }
    }

    private void verifyFieldNotNull(String name, Object value) throws WrongArgumentException {
        if (this.isNull(value)) {
            throw new WrongArgumentException(name, "1005");
        }
    }

    private boolean isNull(Object o) {
        if (o == null) {
            return true;
        }
        if (o instanceof String) {
            return o.equals("");
        }
        return false;
    }
}

