/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.basedata.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.service.OrgCommonUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.basedata.app.AbstractCasUtilFacadeControllerBean;
import com.kingdee.eas.fi.cas.utils.CasBosUtils;
import com.kingdee.eas.fi.cas.utils.PerfLogRecorder;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class CasUtilFacadeControllerBean
extends AbstractCasUtilFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.cas.basedata.app.CasUtilFacadeControllerBean");

    @Override
    protected CompanyOrgUnitCollection _getAuthrizedCompanyOrg(Context ctx, String userID, String permItemName, boolean includeVirtual) throws BOSException, EASBizException {
        Set idSet;
        String pfLogId = PerfLogRecorder.startRecord(Thread.currentThread().getName(), "CasUtilFacadeControllerBean._getAuthrizedCompanyOrg");
        IPermission iPermission = null;
        iPermission = ctx != null ? PermissionFactory.getLocalInstance((Context)ctx) : PermissionFactory.getRemoteInstance();
        String orgTreeId = OrgCommonUtils.getOrgTreeId((OrgType)OrgType.Company);
        ObjectUuidPK orgTreePK = null;
        if (orgTreeId != null) {
            orgTreePK = new ObjectUuidPK(orgTreeId);
        }
        if (EmptyUtil.isEmpty((String)userID)) {
            userID = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser().getId().toString();
        }
        if ((idSet = iPermission.getAuthorizedOrgIds((IObjectPK)new ObjectUuidPK(userID), OrgType.Company, (IObjectPK)orgTreePK, permItemName)).size() == 0) {
            return new CompanyOrgUnitCollection();
        }
        CasBosUtils.EntityViewBuilder viewBuilder = CasBosUtils.entityViewBuilder();
        viewBuilder.select("id", "number", "name", "longNumber", "level", "isBizUnit", "accountTable.id").sort("longNumber", SortType.ASCEND).sort("number", SortType.ASCEND).filter("id", idSet, CompareType.INCLUDE);
        if (!includeVirtual) {
            viewBuilder.filter("isBizUnit", true, CompareType.EQUALS);
        }
        CompanyOrgUnitCollection coll = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(viewBuilder.build());
        PerfLogRecorder.endRecord(pfLogId);
        return coll;
    }

    @Override
    protected Map _batchCheckPermission(Context ctx, String orgID, String userID, String[] permItems) throws BOSException, EASBizException {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        for (int i = 0; i < permItems.length; ++i) {
            result.put(permItems[i], this._checkPermission(ctx, orgID, userID, permItems[i]));
        }
        return result;
    }

    @Override
    protected boolean _checkPermission(Context ctx, String orgID, String userID, String permItemName) throws BOSException, EASBizException {
        try {
            String sql = "SELECT FID FROM T_PM_PermItem WHERE FNAME = ? ";
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{permItemName});
            String permItemID = null;
            if (!rowSet.next()) {
                return true;
            }
            permItemID = rowSet.getString("FID");
            sql = "SELECT UserRoleOrg.FOrgID as FOrgID FROM T_PM_RolePerm RolePerm INNER JOIN  T_PM_UserRoleOrg UserRoleOrg ON UserRoleOrg.FRoleID = RolePerm.FRoleID INNER JOIN T_PM_PermItem PermItem ON PermItem.FID = RolePerm.FPermItemID WHERE UserRoleOrg.FUserID = ? AND RolePerm.FPermItemID= ? AND UserRoleOrg.FOrgID = ? UNION SELECT UserOrgPerm.FOrgID as FOrgID FROM T_PM_UserOrgPerm UserOrgPerm WHERE UserOrgPerm.FOwner = ? AND UserOrgPerm.FPermItemID = ? AND UserOrgPerm.FOrgID = ? ";
            rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{userID, permItemID, orgID, userID, permItemID, orgID});
            return rowSet.next();
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage());
        }
    }
}

