/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.formula;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.IMethodBatchQuery;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.ctrl.excel.model.util.SortedParameterArray;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.app.CasBankStateCaculaterStrategy;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.newrpt.formula.ICalculator;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.fm.common.FMHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class CasBankStateBatchCaculator
implements ICalculator,
IMethodBatchQuery {
    private static Logger logger = Logger.getLogger((String)CasBankStateBatchCaculator.class.getName());
    private ICalculateContextProvider context;
    private Context serverCtx = null;
    private String reportCompanyNumber = null;
    private String reportCurrencyNumber = null;
    private Date reportBeginDate = null;
    private Date reportEndDate = null;

    public BigDecimal CasBankStateExt(String companyNum, String bankNum, String bankAcctNum, String currencyNum, String queryDate) throws BOSException, EASBizException {
        return null;
    }

    public void initCalculateContext(ICalculateContextProvider context) {
        this.context = context;
        this.serverCtx = this.context.getServerContext();
    }

    public boolean batchQuery(Map methods) {
        String reportCompanyId = (String)this.context.getReportAdapter().getReportProperty("Company.ID");
        try {
            this.reportCompanyNumber = CompanyOrgUnitFactory.getLocalInstance((Context)this.serverCtx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(reportCompanyId)).getNumber();
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        this.reportCurrencyNumber = (String)this.context.getReportAdapter().getReportProperty("Currency.Number");
        this.reportBeginDate = (Date)this.context.getReportAdapter().getReportProperty("Report_StartDate");
        this.reportEndDate = (Date)this.context.getReportAdapter().getReportProperty("Report_EndDate");
        for (Map.Entry e : methods.entrySet()) {
            SortedParameterArray param = (SortedParameterArray)e.getValue();
            this.execute(param);
        }
        return true;
    }

    public void execute(SortedParameterArray params) {
        List param = this.convertToList(params);
        CasBankStateCaculaterStrategy.getInstance(this.serverCtx).doCash(param, this.context);
    }

    private List convertToList(SortedParameterArray params) {
        ArrayList<Parameter> singleType = new ArrayList<Parameter>();
        for (int i = 0; i < params.size(); ++i) {
            Parameter param = params.getParameter(i);
            this.getParams(param);
            singleType.add(param);
        }
        return singleType;
    }

    private Object[] getParams(Parameter param) {
        String queryDate;
        String currencyNumber;
        Object[] args = param.getArgs();
        String companyNumber = args[0].toString();
        if (FMHelper.isEmpty((String)companyNumber)) {
            companyNumber = this.reportCompanyNumber;
            args[0] = companyNumber;
        }
        if (FMHelper.isEmpty((String)(currencyNumber = args[3].toString()))) {
            currencyNumber = this.reportCurrencyNumber;
            args[3] = currencyNumber;
        }
        if (FMHelper.isEmpty((String)(queryDate = args[4].toString()))) {
            queryDate = FMConstants.FORMAT_DAY.format(this.reportEndDate);
            args[4] = queryDate;
        }
        return args;
    }
}

