/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.model;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelTool2007 {
    private XSSFWorkbook workbook = null;
    private XSSFSheet currentSheet = null;
    private static Map<Integer, HorizontalAlignment> alignmentMap = new HashMap<Integer, HorizontalAlignment>();
    private Map<String, XSSFCellStyle> styleMap = new HashMap<String, XSSFCellStyle>();

    public ExcelTool2007(String sheetName) {
        this.workbook = new XSSFWorkbook();
        this.currentSheet = this.workbook.createSheet(sheetName);
    }

    public XSSFSheet createSheet(String sheetName) {
        this.currentSheet = this.workbook.createSheet(sheetName);
        return this.currentSheet;
    }

    public XSSFSheet switch2Sheet(String sheetName) {
        this.currentSheet = this.workbook.getSheet(sheetName);
        return this.currentSheet;
    }

    public void setColumnWidth(int columnIndex, int width) {
        this.currentSheet.setColumnWidth(columnIndex, 335 * width);
    }

    public XSSFCell getCell(int rowIndex, int colIndex, XSSFCellStyle style) {
        XSSFCell cell;
        XSSFRow row = this.currentSheet.getRow(rowIndex);
        if (row == null) {
            row = this.currentSheet.createRow(rowIndex);
        }
        if ((cell = row.getCell(colIndex)) == null) {
            cell = row.createCell(colIndex);
        }
        if (style != null) {
            cell.setCellStyle((CellStyle)style);
        }
        return cell;
    }

    public byte[] getBytes() {
        try {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            this.workbook.write((OutputStream)bOut);
            return bOut.toByteArray();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public XSSFCellStyle getNormalStyle(int alignment) {
        String NORMAL = "NORMAL_" + alignment;
        XSSFCellStyle normalStyle = this.styleMap.get(NORMAL);
        if (alignmentMap.isEmpty()) {
            this.putAlignment();
        }
        if (normalStyle == null) {
            XSSFFont font = this.workbook.createFont();
            font.setFontName("Calibri");
            font.setFontHeightInPoints((short)12);
            normalStyle = this.workbook.createCellStyle();
            normalStyle.setFont((Font)font);
            normalStyle.setAlignment(alignmentMap.get(alignment));
            normalStyle.setBorderTop(BorderStyle.NONE);
            normalStyle.setBorderBottom(BorderStyle.DOTTED);
            normalStyle.setBorderLeft(BorderStyle.DOTTED);
            normalStyle.setBorderTop(BorderStyle.DOTTED);
            normalStyle.setBorderRight(BorderStyle.DOTTED);
            this.styleMap.put(NORMAL, normalStyle);
        }
        return normalStyle;
    }

    public XSSFCellStyle getSubtotalStyle(int alignment) {
        String SUBTOTAL = "SUBTOTAL_" + alignment;
        XSSFCellStyle style = this.styleMap.get(SUBTOTAL);
        if (alignmentMap.isEmpty()) {
            this.putAlignment();
        }
        if (style == null) {
            XSSFFont font = this.workbook.createFont();
            font.setFontName("Calibri");
            font.setFontHeightInPoints((short)12);
            style = this.workbook.createCellStyle();
            style.setFont((Font)font);
            style.setAlignment(alignmentMap.get(alignment));
            style.setBorderTop(BorderStyle.NONE);
            style.setBorderBottom(BorderStyle.DOTTED);
            style.setBorderLeft(BorderStyle.DOTTED);
            style.setBorderTop(BorderStyle.DOTTED);
            style.setBorderRight(BorderStyle.DOTTED);
            style.setFillForegroundColor(IndexedColors.YELLOW.index);
            style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            this.styleMap.put(SUBTOTAL, style);
        }
        return style;
    }

    public XSSFCellStyle getTotalStyle() {
        XSSFCellStyle style = this.styleMap.get("TOTAL");
        if (style == null) {
            XSSFFont font = this.workbook.createFont();
            font.setFontName("Calibri");
            font.setFontHeightInPoints((short)12);
            font.setBold(true);
            style = this.workbook.createCellStyle();
            style.setFont((Font)font);
            style.setAlignment(HorizontalAlignment.CENTER);
            style.setBorderTop(BorderStyle.NONE);
            style.setBorderBottom(BorderStyle.DOTTED);
            style.setBorderLeft(BorderStyle.DOTTED);
            style.setBorderTop(BorderStyle.DOTTED);
            style.setBorderRight(BorderStyle.DOTTED);
            style.setFillForegroundColor(IndexedColors.LIGHT_ORANGE.index);
            style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            this.styleMap.put("TOTAL", style);
        }
        return style;
    }

    public XSSFCellStyle getTitleStyle() {
        XSSFCellStyle style = this.styleMap.get("TITLE");
        if (style == null) {
            XSSFFont font = this.workbook.createFont();
            font.setFontName("Calibri");
            font.setFontHeightInPoints((short)12);
            style = this.workbook.createCellStyle();
            style.setFont((Font)font);
            style.setAlignment(HorizontalAlignment.CENTER);
            style.setBorderTop(BorderStyle.NONE);
            style.setBorderBottom(BorderStyle.DOTTED);
            style.setBorderLeft(BorderStyle.DOTTED);
            style.setBorderTop(BorderStyle.DOTTED);
            style.setBorderRight(BorderStyle.DOTTED);
            style.setFillForegroundColor(IndexedColors.LIGHT_YELLOW.index);
            style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            this.styleMap.put("TITLE", style);
        }
        return style;
    }

    public XSSFCellStyle getTemplateStyle() {
        XSSFCellStyle style = this.styleMap.get("TITLE");
        if (style == null) {
            XSSFFont font = this.workbook.createFont();
            font.setFontName("Calibri");
            font.setFontHeightInPoints((short)12);
            style = this.workbook.createCellStyle();
            style.setFont((Font)font);
            style.setAlignment(HorizontalAlignment.CENTER);
            style.setBorderTop(BorderStyle.NONE);
            style.setBorderBottom(BorderStyle.DOTTED);
            style.setBorderLeft(BorderStyle.DOTTED);
            style.setBorderTop(BorderStyle.DOTTED);
            style.setBorderRight(BorderStyle.DOTTED);
            style.setFillForegroundColor(IndexedColors.LIGHT_CORNFLOWER_BLUE.index);
            style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            this.styleMap.put("TITLE", style);
        }
        return style;
    }

    public XSSFCellStyle getQueryTitleStyle() {
        XSSFCellStyle style = this.styleMap.get("getQueryTitleStyle");
        if (style == null) {
            XSSFFont font = this.workbook.createFont();
            font.setFontName("Calibri");
            font.setFontHeightInPoints((short)12);
            font.setColor(IndexedColors.GREEN.index);
            style = this.workbook.createCellStyle();
            style.setFont((Font)font);
            style.setAlignment(HorizontalAlignment.CENTER);
            style.setBorderTop(BorderStyle.NONE);
            style.setBorderBottom(BorderStyle.DOTTED);
            style.setBorderLeft(BorderStyle.DOTTED);
            style.setBorderTop(BorderStyle.DOTTED);
            style.setBorderRight(BorderStyle.DOTTED);
            style.setFillForegroundColor(IndexedColors.LIGHT_YELLOW.index);
            style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            this.styleMap.put("getQueryTitleStyle", style);
        }
        return style;
    }

    public XSSFCellStyle getQueryTitleStyle(int alignment) {
        String GROUP = "getQueryTitleStyle_" + alignment;
        XSSFCellStyle style = this.styleMap.get(GROUP);
        if (alignmentMap.isEmpty()) {
            this.putAlignment();
        }
        if (style == null) {
            XSSFFont font = this.workbook.createFont();
            font.setFontName("Calibri");
            font.setFontHeightInPoints((short)12);
            font.setColor(IndexedColors.GREEN.index);
            style = this.workbook.createCellStyle();
            style.setFont((Font)font);
            style.setAlignment(alignmentMap.get(alignment));
            style.setBorderTop(BorderStyle.NONE);
            style.setBorderBottom(BorderStyle.DOTTED);
            style.setBorderLeft(BorderStyle.DOTTED);
            style.setBorderTop(BorderStyle.DOTTED);
            style.setBorderRight(BorderStyle.DOTTED);
            style.setFillForegroundColor(IndexedColors.LIGHT_YELLOW.index);
            style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            this.styleMap.put(GROUP, style);
        }
        return style;
    }

    public XSSFCellStyle getGroupStyle(int alignment) {
        String GROUP = "GROUP_" + alignment;
        XSSFCellStyle style = this.styleMap.get(GROUP);
        if (alignmentMap.isEmpty()) {
            this.putAlignment();
        }
        if (style == null) {
            XSSFFont font = this.workbook.createFont();
            font.setFontName("Calibri");
            font.setFontHeightInPoints((short)12);
            style = this.workbook.createCellStyle();
            style.setFont((Font)font);
            style.setAlignment(alignmentMap.get(alignment));
            style.setBorderBottom(BorderStyle.DOTTED);
            style.setBorderLeft(BorderStyle.DOTTED);
            style.setBorderTop(BorderStyle.DOTTED);
            style.setBorderRight(BorderStyle.DOTTED);
            style.setFillForegroundColor(IndexedColors.LIGHT_TURQUOISE.index);
            style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            this.styleMap.put(GROUP, style);
        }
        return style;
    }

    public XSSFCellStyle getHeadStyle() {
        XSSFCellStyle style = this.styleMap.get("HEAD");
        if (style == null) {
            XSSFFont font = this.workbook.createFont();
            font.setFontName("Calibri");
            font.setFontHeightInPoints((short)18);
            font.setColor(IndexedColors.GREEN.index);
            style = this.workbook.createCellStyle();
            style.setFont((Font)font);
            style.setAlignment(HorizontalAlignment.CENTER);
            style.setBorderBottom(BorderStyle.DOTTED);
            style.setBorderLeft(BorderStyle.DOTTED);
            style.setBorderTop(BorderStyle.DOTTED);
            style.setBorderRight(BorderStyle.DOTTED);
            style.setFillForegroundColor(IndexedColors.LIGHT_YELLOW.index);
            style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            this.styleMap.put("HEAD", style);
        }
        return style;
    }

    public XSSFWorkbook getWorkbook() {
        return this.workbook;
    }

    public XSSFSheet getSheet() {
        return this.currentSheet;
    }

    public void setCellStyle(int firstRow, int lastRow, int firstCol, int lastCol, XSSFCell cell, ExcelTool2007 excelTool) {
        XSSFCellStyle styleCenter = excelTool.getNormalStyle(1);
        for (int i = firstRow; i <= lastRow; ++i) {
            for (int j = firstCol; j <= lastCol; ++j) {
                cell = excelTool.getCell(i, j, styleCenter);
            }
        }
    }

    public CellRangeAddress getCellRangeAddress(int firstRow, int lastRow, int firstCol, int lastCol) {
        return new CellRangeAddress(firstRow, lastRow, firstCol, lastCol);
    }

    public void createTableHeader(String[] tableHeader, int row) {
        for (int i = 0; i < tableHeader.length; ++i) {
            if (tableHeader[i] == null) continue;
            XSSFCell cell = this.getCell(row, i, this.getTitleStyle());
            cell.setCellValue(tableHeader[i]);
        }
    }

    public void createTemplateTableHeader(String[] tableHeader, int row) {
        for (int i = 0; i < tableHeader.length; ++i) {
            if (tableHeader[i] == null) continue;
            XSSFCell cell = this.getCell(row, i, this.getTemplateStyle());
            cell.setCellValue(tableHeader[i]);
        }
    }

    public void putAlignment() {
        alignmentMap.put(0, HorizontalAlignment.LEFT);
        alignmentMap.put(1, HorizontalAlignment.CENTER);
        alignmentMap.put(2, HorizontalAlignment.RIGHT);
    }
}

