/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.subacct;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateFactory;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.IExchangeRate;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.cas.CasConstants;
import com.kingdee.eas.fi.cas.CashDataTypeEnum;
import com.kingdee.eas.fi.cas.client.PeriodHelper;
import com.kingdee.eas.fi.cas.subacct.SubAccountCollection;
import com.kingdee.eas.fi.cas.subacct.SubAccountFactory;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class SubAcctHelper {
    private static Logger logger = Logger.getLogger((String)SubAcctHelper.class.getName());
    private static String resourcePath = "com.kingdee.eas.fi.cas.CasResources";
    public static final int BOOK_BILL = 0;
    public static final int BOOK_VOUCHER = 1;
    public static final String IS_ONLINE_VC_CHEQUE_PARAM = "CS007";

    public static SubAccountCollection getSubAccountCollection(String companyID, boolean isIncludeClosed) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("*");
        selector.add("number");
        selector.add("name");
        FilterInfo fi = new FilterInfo();
        if (companyID != null) {
            fi.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyID));
        }
        fi.getFilterItems().add(new FilterItemInfo("isClosed", (Object)new Integer(0)));
        if (!isIncludeClosed) {
            // empty if block
        }
        evi.setFilter(fi);
        evi.getSelector().addObjectCollection((IObjectCollection)selector);
        evi.getSorter().add(new SorterItemInfo("accountNumber"));
        SubAccountCollection acctBankCol = SubAccountFactory.getRemoteInstance().getSubAccountCollection(evi);
        for (int i = 0; i < acctBankCol.size(); ++i) {
            acctBankCol.get(i).setDisplayFormat("$number$ - $name$");
        }
        return acctBankCol;
    }

    public static void initCombCurrency(KDComboBox cboCurrency, boolean hasAll) {
        cboCurrency.removeAllItems();
        try {
            ICurrency iCurrency = CurrencyFactory.getRemoteInstance();
            CurrencyCollection currencyCollection = iCurrency.getCurrencyCollection(true);
            cboCurrency.addItems(currencyCollection.toArray());
            if (hasAll) {
                CurrencyInfo allCurrencyInfo = new CurrencyInfo();
                allCurrencyInfo.setNumber("all");
                allCurrencyInfo.setName(EASResource.getString((String)resourcePath, (String)"all"));
                cboCurrency.addItem((Object)allCurrencyInfo);
            }
            CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
            FMClientHelper.setSelectObject((KDComboBox)cboCurrency, (Object)company.getBaseCurrency());
        }
        catch (BOSException e) {
            SysUtil.abort((Throwable)e);
        }
        catch (EASBizException e) {
            SysUtil.abort((Throwable)e);
        }
    }

    public static BigDecimal getYearStartAmount(String companyId, String accountId, String accountBankIds, String currencyId, CashDataTypeEnum dataType) throws EASBizException, BOSException, SQLException {
        CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
        company.setId(BOSUuid.read((String)companyId));
        PeriodInfo startPeriod = PeriodHelper.getCashStartPeriod((CompanyOrgUnitInfo)company);
        if (startPeriod == null) {
            return CasConstants.ZERO;
        }
        StringBuffer sql = new StringBuffer();
        if (dataType.equals((Object)CashDataTypeEnum.JF)) {
            sql.append("select FDebitStartAmt result from T_CAS_SubAccountBalance where ");
        } else if (dataType.equals((Object)CashDataTypeEnum.DF)) {
            sql.append("select FCreditStartAmt result from T_CAS_SubAccountBalance where ");
        } else {
            return SysConstant.BIGZERO;
        }
        sql.append("FCompanyId='").append(companyId).append("' and FCurrencyId ='").append(currencyId).append("' and FPeriodId='").append(startPeriod.getId().toString()).append("'");
        if (accountBankIds != null && accountBankIds.length() > 0) {
            sql.append(" and FSubacctID ='").append(accountBankIds + "'");
        }
        sql.append(" and FIsInit =1");
        ISQLExecutor executor = SQLExecutorFactory.getRemoteInstance((String)sql.toString());
        IRowSet rowSet = executor.executeSQL();
        BigDecimal result = SysConstant.BIGZERO;
        if (rowSet.next()) {
            result = rowSet.getBigDecimal("result");
        }
        return result;
    }

    public static BigDecimal getExchange(String companyId, String sourceCurrencyId, String desCurrencyId) throws EASBizException, BOSException {
        CompanyOrgUnitInfo company = SubAcctHelper.getCompanyInfo(BOSUuid.read((String)companyId));
        CurrencyInfo sourceCurrency = new CurrencyInfo();
        sourceCurrency.setId(BOSUuid.read((String)sourceCurrencyId));
        CurrencyInfo desCurrency = null;
        if (desCurrencyId != null) {
            desCurrency = new CurrencyInfo();
            desCurrency.setId(BOSUuid.read((String)desCurrencyId));
        }
        return SubAcctHelper.getExchange(company, sourceCurrency, desCurrency);
    }

    public static BigDecimal getExchange(CompanyOrgUnitInfo company, CurrencyInfo sourceCurrency, CurrencyInfo desCurrency) throws EASBizException, BOSException {
        IExchangeRate iexchangRate = null;
        ObjectUuidPK excTablepk = null;
        ObjectUuidPK sourceCurrpk = null;
        ObjectUuidPK destCurrpk = null;
        if (company == null) {
            company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        } else if (company.getBaseExchangeTable() == null || company.getBaseCurrency() == null) {
            company = SubAcctHelper.getCompanyInfo(company.getId());
        }
        if (sourceCurrency == null) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"221_CashHelper"));
            return null;
        }
        if (desCurrency == null) {
            desCurrency = company.getBaseCurrency();
        }
        if (company.getBaseExchangeTable() == null) {
            MsgBox.showWarning((String)EASResource.getString((String)resourcePath, (String)"NoExchangeTable"));
            return new BigDecimal("0");
        }
        excTablepk = new ObjectUuidPK(company.getBaseExchangeTable().getId());
        if (desCurrency == null) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"222_CashHelper"));
            return null;
        }
        if (desCurrency.getId().equals((Object)sourceCurrency.getId())) {
            return new BigDecimal("1").setScale(2, 4);
        }
        destCurrpk = new ObjectUuidPK(desCurrency.getId());
        iexchangRate = ExchangeRateFactory.getRemoteInstance();
        ExchangeRateInfo erInfo = iexchangRate.getExchangeRateConvertInfo((IObjectPK)excTablepk, (IObjectPK)(sourceCurrpk = new ObjectUuidPK(sourceCurrency.getId())), (IObjectPK)destCurrpk, Calendar.getInstance().getTime());
        if (erInfo == null) {
            MsgBox.showWarning((String)EASResource.getString((String)resourcePath, (String)"NoExchange"));
            return new BigDecimal("0");
        }
        return erInfo.getConvertRate();
    }

    public static int getExchangePre(String companyId, String sourceCurrencyId, String desCurrencyId) throws EASBizException, BOSException {
        CompanyOrgUnitInfo company = SubAcctHelper.getCompanyInfo(BOSUuid.read((String)companyId));
        CurrencyInfo sourceCurrency = new CurrencyInfo();
        sourceCurrency.setId(BOSUuid.read((String)sourceCurrencyId));
        CurrencyInfo desCurrency = null;
        if (desCurrencyId != null) {
            desCurrency = new CurrencyInfo();
            desCurrency.setId(BOSUuid.read((String)desCurrencyId));
        }
        IExchangeRate iexchangRate = null;
        ObjectUuidPK excTablepk = null;
        ObjectUuidPK sourceCurrpk = null;
        ObjectUuidPK destCurrpk = null;
        if (company == null) {
            company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        } else if (company.getBaseExchangeTable() == null || company.getBaseCurrency() == null) {
            company = SubAcctHelper.getCompanyInfo(company.getId());
        }
        if (sourceCurrency == null) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"221_CashHelper"));
            SysUtil.abort();
        }
        if (desCurrency == null) {
            desCurrency = company.getBaseCurrency();
        }
        if (company.getBaseExchangeTable() == null) {
            return 6;
        }
        excTablepk = new ObjectUuidPK(company.getBaseExchangeTable().getId());
        if (desCurrency == null) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"222_CashHelper"));
            SysUtil.abort();
        }
        destCurrpk = new ObjectUuidPK(desCurrency.getId());
        iexchangRate = ExchangeRateFactory.getRemoteInstance();
        ExchangeRateInfo erInfo = iexchangRate.getExchangeRateConvertInfo((IObjectPK)excTablepk, (IObjectPK)(sourceCurrpk = new ObjectUuidPK(sourceCurrency.getId())), (IObjectPK)destCurrpk, Calendar.getInstance().getTime());
        if (erInfo == null) {
            return 6;
        }
        return erInfo.getPrecision();
    }

    public static CompanyOrgUnitInfo getCompanyInfo(BOSUuid bosuuid) {
        ObjectUuidPK compk = new ObjectUuidPK(bosuuid);
        ICompanyOrgUnit comorg = null;
        CompanyOrgUnitInfo comorgInfo = null;
        try {
            comorg = CompanyOrgUnitFactory.getRemoteInstance();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("accountBank.id"));
            sic.add(new SelectorItemInfo("accountBank.name"));
            sic.add(new SelectorItemInfo("accountBank.number"));
            sic.add(new SelectorItemInfo("baseCurrency.id"));
            sic.add(new SelectorItemInfo("baseCurrency.name"));
            sic.add(new SelectorItemInfo("baseExchangeTable"));
            sic.add(new SelectorItemInfo("accountTable.id"));
            comorgInfo = comorg.getCompanyOrgUnitInfo((IObjectPK)compk, sic);
        }
        catch (Exception e) {
            MsgBox.showInfo((String)"get company fail");
            logger.error((Object)e);
        }
        return comorgInfo;
    }

    public static String getKeyString(IObjectValue iter, String[] keys) {
        return FMHelper.getKeyString((IObjectValue)iter, (String[])keys);
    }

    public static Set getSetByArray(String[] array) {
        HashSet<String> set = new HashSet<String>();
        if (array == null) {
            return set;
        }
        for (int i = 0; i < array.length; ++i) {
            set.add(array[i]);
        }
        return set;
    }

    public static boolean isShowLocalCurrency(String companyId) {
        return false;
    }
}

