/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.subacct.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.subacct.app.AbstractRptSubAcctFacadeControllerBean;
import com.kingdee.eas.fm.common.AmountUnitEnum;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMQuerySqlBuilder;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.bireport.util.SchemaSource;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.TypeConversionUtils;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class RptSubAcctFacadeControllerBean
extends AbstractRptSubAcctFacadeControllerBean {
    private CompanyOrgUnitInfo currentCompany = null;

    protected SchemaSource readySchemaSource(RptParams params, Context ctx) throws BOSException, EASBizException {
        this.currentCompany = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        SchemaSource ss = new SchemaSource();
        ss.setCaller(this.getClass());
        this.setMacroValue(ctx, ss);
        this.setDimensionDataItem(ctx, ss, params);
        String mdx = this.getMdx(ctx, params);
        ss.setMdx(mdx);
        ss.setFilename("RptSubAcct_unit_2.xml");
        return ss;
    }

    private String getMdx(Context ctx, RptParams params) {
        StringBuffer mdx = new StringBuffer();
        mdx.append(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"418_RptSubAcctFacadeControllerBean", (Locale)ctx.getLocale())).append(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"419_RptSubAcctFacadeControllerBean", (Locale)ctx.getLocale())).append(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"420_RptSubAcctFacadeControllerBean", (Locale)ctx.getLocale())).append(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"421_RptSubAcctFacadeControllerBean", (Locale)ctx.getLocale())).append("select {[Measures].FBeginBanalceEx,[Measures].FEndBanalceEx,[Measures].FDebitEx,[Measures].FCreditEx}  on columns,").append("  {[BankAccount].members } dimension properties BankAccount.RelatedCompany, BankAccount.number  ").append("  on rows ").append(" from fm");
        return mdx.toString();
    }

    private void setMacroValue(Context ctx, SchemaSource ss) {
        ss.setMacroValue("bankAccountCaption", ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"422_RptSubAcctFacadeControllerBean", (Locale)ctx.getLocale()));
        ss.setMacroValue("SubBankAccountNumCaption", ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"423_RptSubAcctFacadeControllerBean", (Locale)ctx.getLocale()));
        ss.setMacroValue("SubBankAccountCaption", ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"424_RptSubAcctFacadeControllerBean", (Locale)ctx.getLocale()));
        ss.setMacroValue("RelatedCompanyCaption", ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"425_RptSubAcctFacadeControllerBean", (Locale)ctx.getLocale()));
        ss.setMacroValue("BeginBanalceCaption", ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"360_JournalDataProvider", (Locale)ctx.getLocale()));
        ss.setMacroValue("EndBanalceCaption", ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"426_RptSubAcctFacadeControllerBean", (Locale)ctx.getLocale()));
        ss.setMacroValue("Debit", ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"427_RptSubAcctFacadeControllerBean", (Locale)ctx.getLocale()));
        ss.setMacroValue("Credit", ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"428_RptSubAcctFacadeControllerBean", (Locale)ctx.getLocale()));
    }

    private void setDimensionDataItem(Context ctx, SchemaSource ss, RptParams params) throws BOSException, EASBizException {
        Date fromDate = (Date)params.getObjectElement("dpStartDate.value");
        Date toDate = (Date)params.getObjectElement("dpEndDate.value");
        CurrencyInfo currency = (CurrencyInfo)params.getObjectElement("cboCurrency.value");
        String currencyID = currency.getId().toString();
        int amountUnit = ((AmountUnitEnum)params.getObjectElement("cboUnit.value")).getValue();
        HashSet<String> companySet = new HashSet<String>();
        companySet.add(this.currentCompany.getId().toString());
        ss.setDataItem("BankAccount", this.getBankAcctRowSet(ctx, params), null);
        PeriodInfo currentPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)this.currentCompany);
        PeriodInfo queryPeriod = PeriodUtils.getPeriodInfo((Context)ctx, (Date)fromDate, (CompanyOrgUnitInfo)this.currentCompany);
        if (queryPeriod == null) {
            return;
        }
        boolean isQueryBigThanCurrent = PeriodUtils.PeriodCompare((PeriodInfo)queryPeriod, (PeriodInfo)currentPeriod);
        PeriodInfo period = null;
        period = isQueryBigThanCurrent ? currentPeriod : queryPeriod;
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("curencyID", currencyID);
        paramMap.put("period", period);
        paramMap.put("queryStartDate", fromDate);
        paramMap.put("queryEndDate", toDate);
        paramMap.put("curencyID", currencyID);
        paramMap.put("amountUnit", new Integer(amountUnit));
        FMQuerySqlBuilder sb = this.getFactSQLByCurrentPeriod(ctx, paramMap);
        ss.setDataItem("Fact", sb.getSql(), sb.getSqlParams());
    }

    private FMQuerySqlBuilder getFactSQLByCurrentPeriod(Context ctx, Map paramMap) {
        int amountUnit = (Integer)paramMap.get("amountUnit");
        String currencyID = (String)paramMap.get("curencyID");
        PeriodInfo period = (PeriodInfo)paramMap.get("period");
        Date periodStartDate = period.getBeginDate();
        Date queryStartDate = (Date)paramMap.get("queryStartDate");
        Date queryEndDate = (Date)paramMap.get("queryEndDate");
        FMQuerySqlBuilder sb = new FMQuerySqlBuilder();
        sb.appendSql(" SELECT                                                                   ");
        sb.appendSql("        DETAIL.FSUBACCTID FSubBankAccountId,                              ");
        sb.appendSql("        sub.FRelationalUnitID FRelationalUnitID,                          ");
        sb.appendSql("        sub.FAccountBankID FAccountBankId ,                               ");
        sb.appendSql("        FPeriodStartBalance FBeginBanalce,                                ");
        sb.appendSql("        FDEBIT FDebitAmt,                                                           ");
        sb.appendSql("        FCREDIT FCreditAmt,                                                          ");
        sb.appendSql("        (FPeriodStartBalance + FDEBIT - FCREDIT ) FEndBanalce              ");
        sb.appendSql("   FROM (select fcompanyid,                                                ");
        sb.appendSql("                FCurrencyID,                                               ");
        sb.appendSql("                FSubacctID,                                                ");
        sb.appendSql("                isNull(FPeriodStartBalance,0)/" + amountUnit + " FPeriodStartBalance ,");
        sb.appendSql("                0 FDEBIT,                                                  ");
        sb.appendSql("                0 FCREDIT                                                  ");
        sb.appendSql("           FROM T_CAS_SubAccountBalance                                    ");
        sb.appendSql("           WHERE                                                           ");
        sb.appendParam(" FCOMPANYID", new Object[]{this.currentCompany.getId().toString()});
        sb.appendParam("and fcurrencyID", new Object[]{currencyID});
        sb.appendParam("and fperiodid", new Object[]{period.getId().toString()});
        sb.appendSql("                                                                           ");
        sb.appendSql("         UNION                                                             ");
        sb.appendSql("         SELECT FCOMPANYID,                                                ");
        sb.appendSql("                FCURRENCYID,                                               ");
        sb.appendSql("                FSUBACCTID,                                               ");
        sb.appendSql(" \t\t          isNull(SUM(FDEBITAMOUNT) - SUM(FCREDITAMOUNT),0)/" + amountUnit + " FPeriodStartBalance, ");
        sb.appendSql("                0 FDEBIT,                                                  ");
        sb.appendSql("                0 FCREDIT                                                  ");
        sb.appendSql("           FROM T_CAS_SubAcctJournal                                           ");
        sb.appendSql("          WHERE                                                            ");
        sb.appendParam("  FCOMPANYID", new Object[]{this.currentCompany.getId().toString()});
        sb.appendParam(" and fcurrencyID", new Object[]{currencyID});
        sb.appendSql(" and fbizDate>=");
        sb.appendSql("{" + TypeConversionUtils.objToDate((Object)periodStartDate).toString() + "}");
        sb.appendSql(" and fbizDate<");
        sb.appendSql("{" + TypeConversionUtils.objToDate((Object)queryStartDate).toString() + "}");
        sb.appendSql("          GROUP BY FCOMPANYID, FCURRENCYID, FSUBACCTID                     ");
        sb.appendSql("                                                                           ");
        sb.appendSql("         UNION                                                             ");
        sb.appendSql("                                                                           ");
        sb.appendSql("         SELECT FCOMPANYID,                                                ");
        sb.appendSql("                FCURRENCYID,                                               ");
        sb.appendSql("                FSUBACCTID,                                                ");
        sb.appendSql("                0 FPeriodStartBalance,                                     ");
        sb.appendSql("                isNull(FDEBITAMOUNT,0)/" + amountUnit + " FDEBIT ,");
        sb.appendSql("                isNull(FCREDITAMOUNT,0)/" + amountUnit + " FCREDIT  ");
        sb.appendSql("           FROM T_CAS_SubAcctJournal                                           ");
        sb.appendSql("          WHERE                                                            ");
        sb.appendParam("  FCOMPANYID", new Object[]{this.currentCompany.getId().toString()});
        sb.appendParam(" and fcurrencyID", new Object[]{currencyID});
        sb.appendSql(" and fbizDate>");
        sb.appendSql("{" + TypeConversionUtils.objToDate((Object)queryStartDate).toString() + "}");
        sb.appendSql(" and fbizDate<");
        sb.appendSql("{" + TypeConversionUtils.objToDate((Object)queryEndDate).toString() + "}");
        sb.appendSql(") DETAIL                                                    ");
        sb.appendSql("                                                                           ");
        sb.appendSql("  INNER JOIN T_CAS_SubAccount sub ON detail.FSUBACCTID = sub.fid           ");
        return sb;
    }

    public static String appUnit(String colName, String alia, int unit) {
        return colName + "/" + unit + " " + alia + ", ";
    }

    public String getCompanyRowSet(Context ctx, Set ids, int level) throws BOSException {
        String loc = RptSubAcctFacadeControllerBean.getLoc((Context)ctx);
        FMQuerySqlBuilder sb = new FMQuerySqlBuilder();
        sb.appendSql(" select A.FID, A.FNumber, A.FName_" + loc + " FName, A.FParentID from t_org_company  A where 1=1 ");
        if (!FMHelper.isEmpty((Collection)ids)) {
            sb.appendSql(" and ");
            sb.appendParam("A.fid", ids.toArray());
        }
        if (level > 0) {
            sb.appendSql(" and  A.FLevel<=");
            sb.appendParam((Object)new Integer(level));
        }
        return sb.getTestSql();
    }

    public String getSubAcctBankRowSet(Context ctx, Set ids, int level) throws BOSException {
        String loc = RptSubAcctFacadeControllerBean.getLoc((Context)ctx);
        FMQuerySqlBuilder sb = new FMQuerySqlBuilder();
        sb.appendSql(" select A.FID, A.FNumber, A.FName_" + loc + " FName from T_CAS_SubAccount  A where 1=1 ");
        if (!FMHelper.isEmpty((Collection)ids)) {
            sb.appendSql(" and ");
            sb.appendParam("A.fid", ids.toArray());
        } else {
            sb.appendSql(" and  A.fcompanyid='" + this.currentCompany.getId().toString() + "'");
            sb.appendSql(" and A.fisClosed=0");
        }
        return sb.getTestSql();
    }

    public String getRelationalUnit(Context ctx, RptParams params) throws BOSException {
        String loc = RptSubAcctFacadeControllerBean.getLoc((Context)ctx);
        FMQuerySqlBuilder sb = new FMQuerySqlBuilder();
        sb.appendSql(" select  c.fid  FID,c.Fname_" + loc + " Fname                 ");
        sb.appendSql(" from t_bd_accountbanks b                                  ");
        sb.appendSql(" inner join T_CAS_SubAccount s on s.FAccountBankID=b.fid   ");
        sb.appendSql(" inner join t_org_company c on c.fid=s.FRelationalUnitID   ");
        return sb.getTestSql();
    }

    public String getBankAcctRowSet(Context ctx, Set ids, int level) throws BOSException {
        String loc = RptSubAcctFacadeControllerBean.getLoc((Context)ctx);
        FMQuerySqlBuilder sb = new FMQuerySqlBuilder();
        sb.appendSql(" select A.FID, A.FNumber, A.FName_" + loc + "    fname from t_bd_accountbanks  A where 1=1 ");
        if (!FMHelper.isEmpty((Collection)ids)) {
            sb.appendSql(" and ");
            sb.appendParam("A.fid", ids.toArray());
        } else {
            sb.appendSql(" and A.fcompanyid='" + this.currentCompany.getId().toString() + "'");
            sb.appendSql(" and A.fisClosed=0");
            sb.appendSql(" and A.FIsMotherAccount=1");
        }
        return sb.getTestSql();
    }

    public String getBankAcctRowSet(Context ctx, RptParams params) throws BOSException {
        String loc = RptSubAcctFacadeControllerBean.getLoc((Context)ctx);
        FMQuerySqlBuilder sb = new FMQuerySqlBuilder();
        Set bankAcctIdSet = (Set)params.getObject("bankAcctIdSet");
        Set subBankAcctIdSet = (Set)params.getObject("subBankAcctIdSet");
        sb.appendSql("select  b.fid FBankAccount_ID,b.fname_" + loc + "  fname,");
        sb.appendSql("s.fid FSubBankAccountId,s.fnumber SubBankAccountNumber,s.fname_" + loc + " SubBankAccountName, ");
        sb.appendSql("c.fname_" + loc + "  RelatedCompanyName   ");
        sb.appendSql("from t_bd_accountbanks b                                ");
        sb.appendSql("inner join T_CAS_SubAccount s on s.FAccountBankID=b.fid ");
        sb.appendSql("inner join t_org_company c on c.fid=s.FRelationalUnitID ");
        sb.appendSql("where 1=1      ");
        if (!FMHelper.isEmpty((Collection)bankAcctIdSet)) {
            sb.appendSql(" and ");
            sb.appendParam("b.fid", bankAcctIdSet.toArray());
        }
        if (!FMHelper.isEmpty((Collection)subBankAcctIdSet)) {
            sb.appendSql(" and ");
            sb.appendParam("s.fid", subBankAcctIdSet.toArray());
        }
        sb.appendSql(" and s.fcompanyid='" + this.currentCompany.getId().toString() + "'");
        return sb.getTestSql();
    }
}

