/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.subacct.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BookNotifyException;
import com.kingdee.eas.fi.cas.CasConstants;
import com.kingdee.eas.fi.cas.CasException;
import com.kingdee.eas.fi.cas.subacct.ISubAcctJournal;
import com.kingdee.eas.fi.cas.subacct.SubAccountBookFactory;
import com.kingdee.eas.fi.cas.subacct.SubAcctJournalCollection;
import com.kingdee.eas.fi.cas.subacct.SubAcctJournalFactory;
import com.kingdee.eas.fi.cas.subacct.SubAcctJournalInfo;
import com.kingdee.eas.fi.cas.subacct.app.AbstractSubAccountBookFacadeControllerBean;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.FMVerifyHelper;
import com.kingdee.eas.fm.common.IContextHelper;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class SubAccountBookFacadeControllerBean
extends AbstractSubAccountBookFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.cas.subacct.app.SubAccountBookFacadeControllerBean");

    @Override
    protected void _book(Context ctx, String builderName, String billId) throws BOSException, EASBizException {
        PeriodInfo startPeriod = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany());
        if (startPeriod == null) {
            return;
        }
        SubAcctJournalCollection subAcctJournalCollection = (SubAcctJournalCollection)this.genSubJournalCollection(ctx, builderName, billId);
        this._bookBatch(ctx, (IObjectCollection)subAcctJournalCollection);
    }

    @Override
    protected void _antiBook(Context ctx, String billId) throws BOSException, EASBizException {
        this.checkStatus(ctx, billId);
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("billId", (Object)billId));
        ISubAcctJournal journal = SubAcctJournalFactory.getLocalInstance((Context)ctx);
        journal.delete(fi);
    }

    private void checkStatus(Context ctx, String voucherId) throws BOSException, EASBizException {
        PeriodInfo periodInfo;
        ResultSet rs;
        PreparedStatement pstmt;
        Connection conn;
        block6: {
            String sql = "SELECT FBookDate FROM T_CAS_SubAcctJournal WHERE FBillId = ?";
            conn = null;
            pstmt = null;
            rs = null;
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)1, (String)voucherId);
            rs = pstmt.executeQuery();
            CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
            periodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)companyInfo);
            if (periodInfo != null) break block6;
            SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
            return;
        }
        try {
            while (rs.next()) {
                Date bookDate = rs.getDate("FBookDate");
                if (!periodInfo.getBeginDate().after(bookDate)) continue;
                throw new BookNotifyException(BookNotifyException.ALREADY_FINAL);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
    }

    @Override
    protected void _bookBatch(Context ctx, IObjectCollection journalColl) throws BOSException, EASBizException {
        SubAcctJournalCollection journalC = (SubAcctJournalCollection)journalColl;
        if (journalC == null || journalC.size() == 0) {
            return;
        }
        this.checkCashSystemStatus(ctx);
        journalC = this.getCorrectSubAcctJournalCollection(ctx, journalC);
        SubAcctJournalCollection newjournalCollection = new SubAcctJournalCollection();
        int size = journalC.size();
        for (int i = 0; i < size; ++i) {
            SubAcctJournalInfo info = journalC.get(i);
            if (info.getDebitAmount() != null && info.getDebitAmount().signum() != 0) {
                newjournalCollection.add(info);
                continue;
            }
            if (info.getCreditAmount() == null || info.getCreditAmount().signum() == 0) continue;
            newjournalCollection.add(info);
        }
        ISubAcctJournal journal = SubAcctJournalFactory.getLocalInstance((Context)ctx);
        HashSet<String> billIds = new HashSet<String>();
        for (int i = 0; i < journalC.size(); ++i) {
            billIds.add(journalC.get(i).getBillId());
        }
        Iterator it = billIds.iterator();
        while (it.hasNext()) {
            this._antiBook(ctx, (String)it.next());
        }
        journal.addBatch(newjournalCollection);
    }

    private IObjectCollection genSubJournalCollection(Context ctx, String builderName, String billId) throws BOSException, EASBizException {
        return SubAccountBookFactory.getInstance(builderName).getSubJournalColl(ctx, billId);
    }

    private void checkCashSystemStatus(Context ctx) throws BOSException, EASBizException, CasException {
        PeriodInfo startPeriod = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany());
        if (startPeriod == null) {
            throw new CasException(CasException.STARTPERIODNULL);
        }
    }

    private SubAcctJournalCollection getCorrectSubAcctJournalCollection(Context ctx, SubAcctJournalCollection subAcctJournalCollection) throws EASBizException, BOSException {
        IContextHelper localInstance = ContextHelperFactory.getLocalInstance((Context)ctx);
        UserInfo user = localInstance.getCurrentUser();
        CompanyOrgUnitInfo currentCompany = localInstance.getCurrentCompany();
        PeriodInfo currenPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)currentCompany);
        SubAcctJournalInfo subAcctJournalInfo = null;
        int size = subAcctJournalCollection.size();
        for (int i = 0; i < size; ++i) {
            subAcctJournalInfo = (SubAcctJournalInfo)subAcctJournalCollection.getObject(i);
            subAcctJournalInfo.setCashier(user);
            FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)subAcctJournalInfo, (String)"company");
            FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)subAcctJournalInfo, (String)"billId");
            if (subAcctJournalInfo.getCreditAmount() == null) {
                subAcctJournalInfo.setCreditAmount(CasConstants.ZERO);
            }
            if (subAcctJournalInfo.getDebitAmount() == null) {
                subAcctJournalInfo.setDebitAmount(CasConstants.ZERO);
            }
            if (subAcctJournalInfo.getDebitAmount().signum() != 0) {
                subAcctJournalInfo.setIsDebit(true);
            } else {
                subAcctJournalInfo.setIsDebit(false);
            }
            if (currenPeriodInfo != null && subAcctJournalInfo.getBookDate() != null && currenPeriodInfo.getBeginDate().after(subAcctJournalInfo.getBookDate())) {
                subAcctJournalInfo.setBookDate(currenPeriodInfo.getBeginDate());
                subAcctJournalInfo.setPeriod(currenPeriodInfo);
            }
            if (subAcctJournalInfo.getPeriod() == null) {
                PeriodInfo period = PeriodUtils.getPeriodInfo((Context)ctx, (java.util.Date)subAcctJournalInfo.getBookDate(), (CompanyOrgUnitInfo)subAcctJournalInfo.getCompany());
                if (period == null || period.getId() == null) {
                    throw new CasException(CasException.PERIODISNULL);
                }
                subAcctJournalInfo.setPeriod(period);
            }
            if (!subAcctJournalInfo.getPeriod().isIsAdjustPeriod() && !currenPeriodInfo.isIsAdjustPeriod()) continue;
            throw new CasException(CasException.ADJUSTCANNOTBOOK);
        }
        return subAcctJournalCollection;
    }
}

