/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.subacct.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.fi.cas.CasException;
import com.kingdee.eas.fi.cas.JournalBalanceInfo;
import com.kingdee.eas.fi.cas.subacct.ISubAccountBalance;
import com.kingdee.eas.fi.cas.subacct.SubAccountBalanceCollection;
import com.kingdee.eas.fi.cas.subacct.SubAccountBalanceFactory;
import com.kingdee.eas.fi.cas.subacct.SubAccountBalanceInfo;
import com.kingdee.eas.fi.cas.subacct.app.AbstractSubAcctFinalCheckoutFacadeControllerBean;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class SubAcctFinalCheckoutFacadeControllerBean
extends AbstractSubAcctFinalCheckoutFacadeControllerBean {
    private static final long serialVersionUID = 8257077523937653738L;

    private Map checkBeforeCheckAccount(Context ctx, String companyId, Date beginDate, Date endDate, int param) throws EASBizException, BOSException {
        HashMap hashMap = new HashMap();
        return hashMap;
    }

    @Override
    protected IObjectValue _finalCheckAccount(Context ctx, String companyId) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
        company.setId(BOSUuid.read((String)companyId));
        PeriodInfo periodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)company);
        PeriodInfo nextPeriodInfo = PeriodUtils.getNextPeriodInfo((Context)ctx, (PeriodInfo)periodInfo);
        if (nextPeriodInfo == null || nextPeriodInfo.getPeriodYear() == 0) {
            throw new CasException(CasException.NOPERIODDEF);
        }
        boolean isYearCheck = false;
        if (periodInfo.getPeriodYear() != nextPeriodInfo.getPeriodYear()) {
            isYearCheck = true;
        }
        this.genCurrentPeriodDataBySQL(ctx, companyId, periodInfo.getId().toString(), nextPeriodInfo.getId().toString(), isYearCheck);
        this.deleteUnCheckDataBySQL(ctx, companyId, periodInfo.getId().toString());
        this.genNextPeriodDataBySQL(ctx, companyId, periodInfo.getId().toString(), nextPeriodInfo.getId().toString(), isYearCheck);
        return nextPeriodInfo;
    }

    private void genCurrentPeriodDataBySQL(Context ctx, String companyId, String currentPeriodId, String nextPeriodId, boolean isYearCheck) throws BOSException, EASBizException {
        StringBuffer strBuff = new StringBuffer();
        SubAccountBalanceInfo journalBalInfo = new SubAccountBalanceInfo();
        strBuff.append("insert into T_CAS_SubAccountBalance   \r\n").append("(  \r\n").append("FID,  \r\n").append("FCompanyId, \r\n").append("FCurrencyId,  \r\n").append("FSubacctID,  \r\n").append("FPeriodId,  \r\n").append("FPeriodDebitAmt,  \r\n").append("FPeriodCreditAmt,  \r\n").append("FPeriodStartBalance,  \r\n").append("FPeriodEndBalance,  \r\n").append("FYearStartBalance,  \r\n").append("FYearDebitAmt,  \r\n").append("FYearCreditAmt,  \r\n").append("FYearEndBalance,  \r\n").append("FDebitStartAmt,  \r\n").append("FCreditStartAmt,  \r\n").append("FIsInit, \r\n").append("FIsFinal  \r\n").append(")  \r\n").append("select  \r\n").append("dbo.newbosid('").append(journalBalInfo.getBOSType().toString()).append("')  as FID,  \r\n").append("FCompanyId,  \r\n").append("FCurrencyId,  \r\n").append("FSubacctID,  \r\n").append("FPeriodId,  \r\n").append("sum(ISNULL(FDebitAmount,0.00)) as FPeriodDebitAmt,  \r\n").append("sum(ISNULL(FCreditAmount,0.00)) as FPeriodCreditAmt,  \r\n");
        strBuff.append("sum(ISNULL(FPeriodStartBalance,0.00)) as FPeriodStartBalance,  \r\n").append("sum(ISNULL(FDebitAmount,0.00))-sum(ISNULL(FCreditAmount,0.00))+sum(ISNULL(FPeriodStartBalance,0.00)) as FPeriodEndBalance,  \r\n").append("sum(ISNULL(FYearStartBalance,0.00)) as FYearStartBalance,  \r\n").append("sum(ISNULL(FDebitAmount,0.00))+sum(ISNULL(FYearDebitAmt,0.00)) as FYearDebitAmt,  \r\n").append("sum(ISNULL(FCreditAmount,0.00))+sum(ISNULL(FYearCreditAmt,0.00)) as FYearCreditAmt,  \r\n").append("sum(ISNULL(FDebitAmount,0.00))-sum(ISNULL(FCreditAmount,0.00))+sum(ISNULL(FPeriodStartBalance,0.00)) as FYearEndBalance,  \r\n");
        strBuff.append("0 as FDebitStartAmt,  \r\n").append("0 as FCreditStartAmt,  \r\n").append("0 AS FIsInit,  \r\n").append("1 AS FIsFinal  \r\n").append("FROM (  \r\n").append("SELECT FSubacctID, fcurrencyid, fperiodid,fcompanyid,  \r\n").append("sum(ISNULL(FDebitAmount,0.00)) as FDebitAmount,  \r\n").append("sum(ISNULL(FCreditAmount,0.00)) as FCreditAmount,  \r\n").append("0 as FPeriodEndBalance,  \r\n").append("0 as FPeriodStartBalance,  \r\n").append("0 as FYearStartBalance,  \r\n").append("0 as FYearDebitAmt,  \r\n").append("0 as FYearCreditAmt,  \r\n").append("0 as FYearEndBalance  \r\n").append("from T_CAS_SubAcctJournal  \r\n").append("WHERE FCompanyId=?  \r\n").append("AND FPeriodId=?  \r\n").append("GROUP BY  FCompanyId, FPeriodId, FCurrencyId, FSubacctID  \r\n").append("union all  \r\n").append("select  FSubacctID, fcurrencyid, fperiodid,fcompanyid,0 as FDebitAmount,0 as FCreditAmount,  \r\n").append("FPeriodEndBalance,FPeriodStartBalance,FYearStartBalance, FYearDebitAmt,FYearCreditAmt,FYearEndBalance  \r\n").append("from T_CAS_SubAccountBalance  \r\n").append("WHERE FCompanyId=?  \r\n").append("AND FPeriodId=?  \r\n").append("AND FIsInit=0  \r\n").append(") summary group by   fcompanyid,fperiodid,fcurrencyid,FSubacctID  \r\n").append("  \r\n").append("  \r\n").append("  \r\n").append("  \r\n");
        String sql = strBuff.toString();
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = this.getConnection(ctx);
            ps = conn.prepareStatement(sql);
            ps.setString(1, companyId);
            ps.setString(2, currentPeriodId);
            ps.setString(3, companyId);
            ps.setString(4, currentPeriodId);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
    }

    private void deleteUnCheckDataBySQL(Context ctx, String strCompanyId, String strPeriodId) throws BOSException, EASBizException {
        String sql = "DELETE T_CAS_SubAccountBalance WHERE FCompanyId=? AND FPeriodId=? AND FIsInit != 1 AND FIsFinal!=1 ";
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = this.getConnection(ctx);
            ps = conn.prepareStatement(sql);
            ps.setString(1, strCompanyId);
            ps.setString(2, strPeriodId);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
    }

    private void genNextPeriodDataBySQL(Context ctx, String companyId, String currentPeriodId, String nextPeriodId, boolean isYearCheck) throws BOSException, EASBizException {
        StringBuffer strBuff = new StringBuffer();
        JournalBalanceInfo journalBalInfo = new JournalBalanceInfo();
        strBuff.append("insert into T_CAS_SubAccountBalance   \r\n").append("(  \r\n").append("FID,  \r\n").append("FCompanyId, \r\n").append("FCurrencyId,  \r\n").append("FSubacctID,  \r\n").append("FPeriodId,  \r\n").append("FPeriodDebitAmt,  \r\n").append("FPeriodCreditAmt,  \r\n").append("FPeriodStartBalance,  \r\n").append("FPeriodEndBalance,  \r\n").append("FYearStartBalance,  \r\n").append("FYearDebitAmt,  \r\n").append("FYearCreditAmt,  \r\n").append("FYearEndBalance,  \r\n").append("FDebitStartAmt,  \r\n").append("FCreditStartAmt,  \r\n").append("FIsInit,  \r\n").append("FIsFinal   \r\n").append(")  \r\n").append("select  \r\n").append("dbo.newbosID('").append(journalBalInfo.getBOSType().toString()).append("')  as FID,  \r\n").append("FCompanyId,  \r\n").append("FCurrencyId,  \r\n").append("FSubacctID,  \r\n").append("'").append(nextPeriodId).append("'  as FPeriodId,  \r\n").append("0 as FPeriodDebitAmt,  \r\n").append("0 as FPeriodCreditAmt,  \r\n");
        if (isYearCheck) {
            strBuff.append("ISNULL(FPeriodEndBalance,0.00) as  FPeriodStartBalance,  \r\n").append("ISNULL(FPeriodEndBalance,0.00) as FPeriodEndBalance,  \r\n").append("ISNULL(FPeriodEndBalance,0.00) as FYearStartBalance,  \r\n").append("0 as FYearDebitAmt,  \r\n").append("0 as FYearCreditAmt,  \r\n").append("ISNULL(FPeriodEndBalance,0.00) as FYearEndBalance,  \r\n");
        } else {
            strBuff.append("ISNULL(FPeriodEndBalance,0.00) as FPeriodStartBalance,  \r\n").append("ISNULL(FPeriodEndBalance,0.00) as FPeriodEndBalance,  \r\n").append("ISNULL(FYearStartBalance,0.00) as FYearStartBalance,  \r\n").append("FYearDebitAmt,  \r\n").append("FYearCreditAmt,  \r\n").append("ISNULL(FPeriodEndBalance,0.00) as FYearEndBalance,  \r\n");
        }
        strBuff.append("0 as FDebitStartAmt,  \r\n").append("0 as FCreditStartAmt,  \r\n").append("FIsInit,  \r\n").append("0 as FIsFinal  \r\n").append("from T_CAS_SubAccountBalance  \r\n").append("where FCompanyId =?  \r\n").append("and FPeriodId=?  \r\n").append("and FIsInit=0   \r\n").append("  \r\n");
        String sql = strBuff.toString();
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = this.getConnection(ctx);
            ps = conn.prepareStatement(sql);
            ps.setString(1, companyId);
            ps.setString(2, currentPeriodId);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
    }

    private BigDecimal getBigDecimal(BigDecimal big) {
        return big == null ? SysConstant.BIGZERO : big;
    }

    private void deleteOldJournalBalData(Context ctx, String strCompanyId, String strPeriodId) throws BOSException, EASBizException {
        String sql = "DELETE T_CAS_SubAccountBalance WHERE FCompanyId=? AND FPeriodId=?  AND FIsInit != 1 ";
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = this.getConnection(ctx);
            ps = conn.prepareStatement(sql);
            ps.setString(1, strCompanyId);
            ps.setString(2, strPeriodId);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
    }

    private EntityViewInfo getJournalBalanceEntityView(String companyId, String periodId) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        FilterItemCollection items = filterInfo.getFilterItems();
        if (companyId != null) {
            items.add(new FilterItemInfo("company.id", (Object)companyId));
        }
        if (periodId != null) {
            items.add(new FilterItemInfo("period.id", (Object)periodId));
        }
        items.add(new FilterItemInfo("isInit", (Object)FMConstants.FALSE));
        viewInfo.setFilter(filterInfo);
        return viewInfo;
    }

    private SubAccountBalanceCollection getJournalBalColl(Context ctx, EntityViewInfo viewInfo) throws BOSException {
        ISubAccountBalance iJournalBal = SubAccountBalanceFactory.getLocalInstance((Context)ctx);
        SubAccountBalanceCollection journalBalColl = iJournalBal.getSubAccountBalanceCollection(viewInfo);
        return journalBalColl;
    }

    @Override
    protected IObjectValue _deleteCheckAccount(Context ctx, String companyId) throws BOSException, EASBizException {
        CompanyOrgUnitInfo companyInfo = new CompanyOrgUnitInfo();
        companyInfo.setId(BOSUuid.read((String)companyId));
        PeriodInfo periodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)companyInfo);
        String periodId = periodInfo.getId().toString();
        PeriodInfo startPeriodInfo = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)companyInfo);
        if (startPeriodInfo.equals((Object)periodInfo) || !this.isAfterStartPeriod(startPeriodInfo, periodInfo)) {
            throw new CasException(CasException.CHECK_ANTICHECKOUT);
        }
        PeriodInfo prePeriodInfo = PeriodUtils.getPrePeriodInfo((Context)ctx, (PeriodInfo)periodInfo);
        this.deleteOldJournalBalData(ctx, companyId, periodId);
        this.updatePreJournalBalData(ctx, companyId, periodId, prePeriodInfo.getId().toString());
        return prePeriodInfo;
    }

    private boolean isAfterStartPeriod(PeriodInfo startPeriod, PeriodInfo periodInfo) {
        if (startPeriod.getPeriodYear() < periodInfo.getPeriodYear()) {
            return true;
        }
        return startPeriod.getPeriodYear() == periodInfo.getPeriodYear() && startPeriod.getPeriodNumber() <= periodInfo.getPeriodNumber();
    }

    private void updatePreJournalBalData(Context ctx, String companyId, String periodId, String prePeriodId) throws EASBizException, BOSException {
        EntityViewInfo viewInfo = this.getJournalBalanceEntityView(companyId, prePeriodId);
        SubAccountBalanceCollection journalBalColl = this.getJournalBalColl(ctx, viewInfo);
        ISubAccountBalance iJournalBal = SubAccountBalanceFactory.getLocalInstance((Context)ctx);
        int size = journalBalColl.size();
        for (int i = 0; i < size; ++i) {
            SubAccountBalanceInfo journalBalInfo = journalBalColl.get(i);
            BigDecimal debitAmt = this.getBigDecimal(journalBalInfo.getPeriodDebitAmt());
            BigDecimal creditAmt = this.getBigDecimal(journalBalInfo.getPeriodCreditAmt());
            BigDecimal periodEndBalance = this.getBigDecimal(journalBalInfo.getPeriodEndBalance());
            journalBalInfo.setPeriodEndBalance(periodEndBalance.subtract(debitAmt).add(creditAmt));
            journalBalInfo.setPeriodDebitAmt(SysConstant.BIGZERO);
            journalBalInfo.setPeriodCreditAmt(SysConstant.BIGZERO);
            BigDecimal yearDebitAmt = this.getBigDecimal(journalBalInfo.getYearDebitAmt());
            BigDecimal yearCreditAmt = this.getBigDecimal(journalBalInfo.getYearCreditAmt());
            journalBalInfo.setYearDebitAmt(yearDebitAmt.subtract(debitAmt));
            journalBalInfo.setYearCreditAmt(yearCreditAmt.subtract(creditAmt));
            journalBalInfo.setIsFinal(false);
            BigDecimal yearEndBalance = this.getBigDecimal(journalBalInfo.getYearEndBalance());
            journalBalInfo.setYearEndBalance(yearEndBalance.subtract(debitAmt).add(creditAmt));
            iJournalBal.update((IObjectPK)new ObjectUuidPK(journalBalInfo.getId()), (CoreBaseInfo)journalBalInfo);
        }
    }
}

