/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.subacct.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.fi.cas.CasDataException;
import com.kingdee.eas.fi.cas.CashDataTypeEnum;
import com.kingdee.eas.fi.cas.subacct.app.AbstractSubAcctManagementFacadeControllerBean;
import com.kingdee.eas.fm.common.DateHelper;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMVerifyHelper;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.TypeConversionUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;

public class SubAcctManagementFacadeControllerBean
extends AbstractSubAcctManagementFacadeControllerBean {
    private Logger logger = Logger.getLogger(this.getClass());

    @Override
    protected BigDecimal _cash(Context ctx, String companyNum, String bankAcctNum, String currencyNum, Date beginDate, Date endDate, CashDataTypeEnum dataType, boolean isIncludeUnsettled) throws BOSException, EASBizException {
        FMVerifyHelper.checkBlank((Object)((Object)dataType), (Object[])new Object[]{"dataType"});
        if (dataType.getValue() == 0 || dataType.getValue() == 1) {
            FMVerifyHelper.checkBlank((Object)endDate, (Object[])new Object[]{"endDate"});
            beginDate = null;
        } else {
            FMVerifyHelper.checkBlank((Object)beginDate, (Object[])new Object[]{"beginDate"});
            FMVerifyHelper.checkBlank((Object)endDate, (Object[])new Object[]{"endDate"});
        }
        Set companyIdSet = this.getCompanyIds(ctx, companyNum);
        if (companyIdSet == null) {
            throw new CasDataException(CasDataException.NULL_COMPANY);
        }
        Set bankAcctIdSet = this.getBankAcctIds(ctx, bankAcctNum);
        String currencyId = this.getCurrencyId(ctx, currencyNum);
        if (beginDate != null) {
            beginDate = DateTimeUtils.truncateDate((Date)beginDate);
        }
        endDate = DateTimeUtils.truncateDate((Date)endDate);
        String sql = null;
        sql = this.getSql(ctx, companyIdSet, bankAcctIdSet, currencyId, beginDate, endDate, dataType, isIncludeUnsettled);
        BigDecimal result = SysConstant.BIGZERO;
        if (sql != null) {
            result = this.exeQuerySql(ctx, sql.toString());
        }
        if (currencyId != null && result != null) {
            ICurrency currency = CurrencyFactory.getLocalInstance((Context)ctx);
            CurrencyInfo curInfo = currency.getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyId));
            result = result.setScale(curInfo.getPrecision(), 4);
        }
        return result;
    }

    private String getSql(Context ctx, Set companyIdSet, Set bankAcctIdSet, String currencyId, Date beginDate, Date endDate, CashDataTypeEnum dataType, boolean isIncludeUnsettled) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        ArrayList<StringBuffer> sqls = new ArrayList<StringBuffer>();
        for (String companyId : companyIdSet) {
            StringBuffer subSql = new StringBuffer();
            String querySql = null;
            querySql = dataType.getValue() == 0 || dataType.getValue() == 1 ? this.getBalanceSql(ctx, companyId, bankAcctIdSet, currencyId, beginDate, endDate, dataType, isIncludeUnsettled) : this.getSummarySql(ctx, companyId, bankAcctIdSet, currencyId, beginDate, endDate, dataType, isIncludeUnsettled);
            if (querySql == null) continue;
            subSql.append(" select sum(SubResult) Result from ( ");
            if (querySql == null) {
                querySql = " dual ";
            }
            subSql.append(querySql);
            subSql.append(") SubQuery");
            this.logger.debug((Object)("sql: " + subSql));
            sqls.add(subSql);
        }
        if (sqls.size() <= 0) {
            return null;
        }
        sql.append(sqls.get(0));
        for (int i = 1; i < sqls.size(); ++i) {
            sql.append(" union all ").append(sqls.get(i));
        }
        return sql.toString();
    }

    private String getSummarySql(Context ctx, String companyId, Set bankAcctIdSet, String currencyId, Date beginDate, Date endDate, CashDataTypeEnum dataType, boolean isIncludeUnsettled) throws EASBizException, BOSException {
        String bTypeSql = this.getRangeSql(companyId, bankAcctIdSet, currencyId, beginDate, endDate, dataType, new Boolean(isIncludeUnsettled));
        return bTypeSql;
    }

    private String getBalanceSql(Context ctx, String companyId, Set bankAcctIdSet, String currencyId, Date beginDate, Date endDate, CashDataTypeEnum dataType, boolean isIncludeUnsettled) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        String bBalanceSql = this.getJTypeBalanceSql(ctx, companyId, bankAcctIdSet, currencyId, beginDate, endDate, dataType, isIncludeUnsettled);
        sql.append(bBalanceSql);
        return sql.toString();
    }

    private String getJTypeBalanceSql(Context ctx, String companyId, Set bankAcctIdSet, String currencyId, Date beginDate, Date endDate, CashDataTypeEnum dataType, boolean isIncludeUnsettled) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
        company.setId(BOSUuid.read((String)companyId));
        PeriodInfo startPeriod = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)company);
        PeriodInfo currentPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)company);
        if (startPeriod == null || currentPeriod == null) {
            return null;
        }
        if (endDate.before(startPeriod.getBeginDate())) {
            return null;
        }
        PeriodInfo period = null;
        Date calculateBeginDate = null;
        Date calculateEndDate = null;
        calculateEndDate = dataType.getValue() == 0 ? DateHelper.getBeforeDay((Date)endDate) : endDate;
        period = calculateEndDate.before(startPeriod.getBeginDate()) ? startPeriod : (calculateEndDate.after(currentPeriod.getBeginDate()) ? currentPeriod : PeriodUtils.getPeriodInfo((Context)ctx, (Date)calculateEndDate, (CompanyOrgUnitInfo)company));
        calculateBeginDate = period.getBeginDate();
        sql.append(this.getPeriodStartSql(companyId, bankAcctIdSet, currencyId, period));
        sql.append(" union all ");
        sql.append(this.getRangeSql(companyId, bankAcctIdSet, currencyId, calculateBeginDate, calculateEndDate, dataType, new Boolean(isIncludeUnsettled)));
        return sql.toString();
    }

    private String getPeriodStartSql(String companyId, Set bankAcctIdSet, String currencyId, PeriodInfo period) {
        StringBuffer sql = new StringBuffer();
        String accountBankIds = this.composeParse(bankAcctIdSet);
        sql.append("select FPeriodStartBalance SubResult from T_CAS_SubAccountBalance where ");
        sql.append("FIsInit =0  and ");
        sql.append("FCompanyId='").append(companyId).append("' and FCurrencyId ='").append(currencyId).append("' and FPeriodId='").append(period.getId().toString()).append("'");
        if (accountBankIds != null && accountBankIds.length() > 0) {
            sql.append(" and FSubacctID in (").append(accountBankIds + ")");
        }
        return sql.toString();
    }

    private Set getBankAcctIds(Context ctx, String bankAcctNum) throws BOSException, EASBizException {
        if (FMHelper.isEmpty((String)bankAcctNum)) {
            return null;
        }
        StringBuffer sql = new StringBuffer(100);
        sql.append("select Fid from T_CAS_SubAccount where 1=1");
        if (!StringUtils.isEmpty((String)bankAcctNum)) {
            if (bankAcctNum.indexOf(";") > 0) {
                sql.append(" and FNumber in (");
                String[] nums = bankAcctNum.split(";");
                for (int i = 0; i < nums.length; ++i) {
                    if (i > 0) {
                        sql.append(",");
                    }
                    sql.append(" '").append(nums[i].trim()).append("'");
                }
                sql.append(")");
            } else {
                sql.append(" and FNumber = '").append(bankAcctNum.trim()).append("'");
            }
        }
        HashSet<String> bankAcctIdSet = new HashSet<String>();
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                if (rs.getString("FID") == null) continue;
                bankAcctIdSet.add(rs.getString("FID"));
            }
        }
        catch (SQLException ex) {
            this.logger.error((Object)ex);
            BOSException e = new BOSException();
            e.setStackTrace(ex.getStackTrace());
            throw e;
        }
        if (bankAcctIdSet.size() > 0) {
            return bankAcctIdSet;
        }
        throw new CasDataException(CasDataException.NULL_ACCOUNTBANK);
    }

    private BigDecimal exeQuerySql(Context ctx, String sql) throws SQLDataException, BOSException {
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        BigDecimal result = FMConstants.ZERO;
        try {
            con = this.getConnection(ctx);
            pstmt = con.prepareStatement(sql);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                BigDecimal value = rs.getBigDecimal("Result");
                if (value == null) continue;
                result = result.add(value);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)con);
        return result;
    }

    private Set getCompanyIds(Context ctx, String companyNum) throws BOSException {
        if (FMHelper.isEmpty((String)companyNum)) {
            return null;
        }
        StringBuffer sql = new StringBuffer(120);
        sql.append("select fid from t_org_company where (");
        if (companyNum.indexOf(";") > 0) {
            String[] nums = companyNum.split(";");
            for (int i = 0; i < nums.length; ++i) {
                if (i > 0) {
                    sql.append(" or ");
                }
                sql.append(" (FNumber = '").append(nums[i].trim()).append("'").append(" or FLongNumber like '").append(companyNum).append("!%' ").append(" or FLongNumber like '%!").append(companyNum).append("!%') ");
            }
        } else {
            sql.append(" FNumber = '").append(companyNum.trim()).append("'").append(" or FLongNumber like '").append(companyNum).append("!%' ").append(" or FLongNumber like '%!").append(companyNum).append("!%'");
        }
        sql.append(" ) and FIsOnlyUnion =0 ");
        sql.append(" order by FLongNumber asc");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            HashSet<String> idSet = new HashSet<String>();
            while (rs.next()) {
                idSet.add(rs.getString("fid"));
            }
            if (idSet.size() > 0) {
                return idSet;
            }
            return null;
        }
        catch (SQLException ex) {
            this.logger.error((Object)ex);
            BOSException e = new BOSException();
            e.setStackTrace(ex.getStackTrace());
            throw e;
        }
    }

    private String composeParse(Set idSet) {
        if (idSet == null || idSet.size() == 0) {
            return null;
        }
        StringBuffer sIds = new StringBuffer();
        Iterator it = idSet.iterator();
        while (it.hasNext()) {
            sIds.append("'").append(it.next()).append("',");
        }
        if (sIds.length() > 0) {
            sIds = sIds.deleteCharAt(sIds.length() - 1);
        }
        return sIds.toString();
    }

    private String getCurrencyId(Context ctx, String currencyNum) throws BOSException, CasDataException {
        ResultSet rs;
        PreparedStatement pstmt;
        Connection con;
        block5: {
            String string;
            if (FMHelper.isEmpty((String)currencyNum)) {
                return null;
            }
            StringBuffer sql = new StringBuffer(100);
            sql.append("select fid from t_bd_currency where FNumber = ?");
            con = null;
            pstmt = null;
            rs = null;
            try {
                con = this.getConnection(ctx);
                pstmt = con.prepareStatement(sql.toString());
                pstmt.setString(1, currencyNum);
                rs = pstmt.executeQuery();
                if (!rs.next()) break block5;
                string = rs.getString(1);
            }
            catch (SQLException ex) {
                try {
                    throw new BOSException((Throwable)ex);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, pstmt, (Connection)con);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)con);
            return string;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)con);
        throw new CasDataException(CasDataException.NULL_CURRENCY);
    }

    private String getRangeSql(String companyId, Set bankAcctIdSet, String currencyId, Date beginDate, Date endDate, CashDataTypeEnum dataType, Boolean isIncludeUnsettled) {
        String bankAcctIds = this.composeParse(bankAcctIdSet);
        String field = this.getJournalField(dataType);
        StringBuffer sql = new StringBuffer();
        sql.append("select ");
        sql.append(field);
        sql.append("  from T_CAS_SubAcctJournal where ");
        sql.append(" FSubacctID in (").append(bankAcctIds).append(")");
        sql.append(" AND FCurrencyId = '").append(currencyId).append("'");
        sql.append(" and FBookDate <= {").append(TypeConversionUtils.objToDate((Object)endDate)).append("} ");
        sql.append(" AND FBookDate >= {").append(TypeConversionUtils.objToDate((Object)beginDate)).append(" } ");
        return sql.toString();
    }

    private String getJournalField(CashDataTypeEnum dataType) {
        String field = null;
        switch (dataType.getValue()) {
            case 3: {
                field = "sum(FDebitAmount) SubResult ";
                break;
            }
            case 4: {
                field = "sum(FCreditAmount) SubResult ";
                break;
            }
            case 0: {
                field = "sum(FDebitAmount - FCreditAmount) SubResult  ";
                break;
            }
            case 1: {
                field = "sum(FDebitAmount - FCreditAmount) SubResult  ";
            }
        }
        return field;
    }
}

