/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.subacct.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.IPeriod;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.CasException;
import com.kingdee.eas.fi.cas.subacct.ISubAccountBalance;
import com.kingdee.eas.fi.cas.subacct.SubAccountBalanceCollection;
import com.kingdee.eas.fi.cas.subacct.SubAccountBalanceFactory;
import com.kingdee.eas.fi.cas.subacct.SubAccountBalanceInfo;
import com.kingdee.eas.fi.cas.subacct.SubAccountCollection;
import com.kingdee.eas.fi.cas.subacct.SubAccountFactory;
import com.kingdee.eas.fi.cas.subacct.SubAccountInfo;
import com.kingdee.eas.fi.cas.subacct.SubAcctCurrencyBalance;
import com.kingdee.eas.fi.cas.subacct.app.AbstractSubAcctMgtInitFacadeControllerBean;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import org.apache.log4j.Logger;

public class SubAcctMgtInitFacadeControllerBean
extends AbstractSubAcctMgtInitFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)SubAcctMgtInitFacadeControllerBean.class.getName());
    private static final String STRING_ZERO = "0";
    private static final String STRING_ONE = "1";
    private static final BigDecimal ZERO = new BigDecimal("0.00");
    private static final String[] strKeys = new String[]{"company", "currency", "period", "accountBank"};

    public BigDecimal getBigDecimal(BigDecimal big) {
        return big == null ? ZERO : big;
    }

    private SubAccountCollection getSubAccountCollection(Context ctx, String strCompanyId, String strCurrencyId) throws BOSException, EASBizException {
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("*");
        selector.add("relationalUnit.name");
        FilterInfo fi = new FilterInfo();
        FilterItemCollection items = fi.getFilterItems();
        items.add(new FilterItemInfo("company.id", (Object)strCompanyId));
        evi.setFilter(fi);
        evi.getSelector().addObjectCollection((IObjectCollection)selector);
        evi.getSorter().add(new SorterItemInfo("number"));
        SubAccountCollection subAcctCol = SubAccountFactory.getLocalInstance((Context)ctx).getSubAccountCollection(evi);
        return subAcctCol;
    }

    private IObjectCollection createJournalBalCollBySubAcct(Context ctx, String strCompanyId, String strCurrencyId, String strPeriodId) throws BOSException, EASBizException {
        SubAccountBalanceCollection coll = new SubAccountBalanceCollection();
        SubAccountBalanceCollection journalBalColl = this.getSubAccountBalanceCollection(ctx, strCompanyId, strCurrencyId, strPeriodId);
        SubAccountCollection subAcctCol = this.getSubAccountCollection(ctx, strCompanyId, strCurrencyId);
        Hashtable<String, SubAccountBalanceInfo> htExistCollection = new Hashtable<String, SubAccountBalanceInfo>();
        if (journalBalColl != null && journalBalColl.size() != 0) {
            for (int i = 0; i < journalBalColl.size(); ++i) {
                SubAccountBalanceInfo journalBalInfo = journalBalColl.get(i);
                String subAcctId = journalBalInfo.getSubacct().getId().toString();
                htExistCollection.put(subAcctId, journalBalInfo);
            }
        }
        int intSubAcctColSize = 0;
        PeriodInfo periodInfo = null;
        CompanyOrgUnitInfo companyInfo = null;
        CurrencyInfo currencyInfo = null;
        if (subAcctCol != null) {
            intSubAcctColSize = subAcctCol.size();
            periodInfo = this.getPeriodById(ctx, strPeriodId);
            companyInfo = this.getCompanyById(ctx, strCompanyId);
            currencyInfo = this.getCurrencyById(ctx, strCurrencyId);
        }
        SubAccountInfo subAcct = null;
        String strAcctId = null;
        for (int i = 0; i < intSubAcctColSize; ++i) {
            subAcct = subAcctCol.get(i);
            strAcctId = subAcct.getId().toString();
            SubAccountBalanceInfo journalBalInfo = null;
            if (htExistCollection.containsKey(strAcctId)) {
                journalBalInfo = (SubAccountBalanceInfo)htExistCollection.get(strAcctId);
            } else {
                journalBalInfo = new SubAccountBalanceInfo();
                journalBalInfo.setSubacct(subAcct);
                journalBalInfo.setCompany(companyInfo);
                journalBalInfo.setCurrency(currencyInfo);
                journalBalInfo.setPeriod(periodInfo);
                journalBalInfo.setDebitStartAmt(ZERO);
                journalBalInfo.setCreditStartAmt(ZERO);
                journalBalInfo.setPeriodStartBalance(ZERO);
                journalBalInfo.setYearStartBalance(ZERO);
            }
            coll.add(journalBalInfo);
        }
        return coll;
    }

    private SubAccountBalanceCollection getSubAccountBalanceCollection(Context ctx, String strCompanyId, String strCurrencyId, String strPeriodId) throws BOSException {
        ISubAccountBalance iSubAccountBalance = SubAccountBalanceFactory.getLocalInstance((Context)ctx);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        viewInfo.setFilter(filterInfo);
        if (strCurrencyId != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("currency", (Object)strCurrencyId));
        }
        if (strCompanyId != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("company", (Object)strCompanyId));
        }
        if (strPeriodId != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("period", (Object)strPeriodId));
        }
        SelectorItemCollection sic = viewInfo.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("subacct.id"));
        sic.add(new SelectorItemInfo("subacct.number"));
        sic.add(new SelectorItemInfo("subacct.name"));
        sic.add(new SelectorItemInfo("subacct.accountNumber"));
        sic.add(new SelectorItemInfo("subacct.relationalUnit.name"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("currency.precision"));
        SubAccountBalanceCollection subAccountBalanceCollection = iSubAccountBalance.getSubAccountBalanceCollection(viewInfo);
        return subAccountBalanceCollection;
    }

    @Override
    protected void _save(Context ctx, IObjectCollection initInfoColl, IObjectValue paramInfo) throws BOSException, EASBizException {
        if (paramInfo == null) {
            return;
        }
        SubAccountBalanceInfo paramJournalBalInfo = (SubAccountBalanceInfo)paramInfo;
        this.deleteOldInitData(ctx, paramJournalBalInfo.getCompany().getId().toString(), paramJournalBalInfo.getCurrency().getId().toString(), paramJournalBalInfo.getPeriod().getId().toString());
        if (initInfoColl == null || initInfoColl.size() == 0) {
            return;
        }
        int size = initInfoColl.size();
        ISubAccountBalance iSubAccountBalance = SubAccountBalanceFactory.getLocalInstance((Context)ctx);
        for (int i = 0; i < size; ++i) {
            SubAccountBalanceInfo subAccountBalanceInfo = (SubAccountBalanceInfo)initInfoColl.getObject(i);
            if (subAccountBalanceInfo.getPeriodStartBalance().compareTo(FMConstants.ZERO) == 0 && subAccountBalanceInfo.getDebitStartAmt().compareTo(FMConstants.ZERO) == 0 && subAccountBalanceInfo.getCreditStartAmt().compareTo(FMConstants.ZERO) == 0) continue;
            subAccountBalanceInfo.setId(null);
            subAccountBalanceInfo.setIsInit(true);
            subAccountBalanceInfo.setPeriodEndBalance(this.getBigDecimal(subAccountBalanceInfo.getPeriodStartBalance()));
            BigDecimal yearStartBalance = ZERO;
            yearStartBalance = this.getBigDecimal(subAccountBalanceInfo.getPeriodStartBalance()).add(this.getBigDecimal(subAccountBalanceInfo.getCreditStartAmt())).subtract(this.getBigDecimal(subAccountBalanceInfo.getDebitStartAmt()));
            subAccountBalanceInfo.setYearStartBalance(yearStartBalance);
            subAccountBalanceInfo.setYearEndBalance(subAccountBalanceInfo.getPeriodStartBalance());
            subAccountBalanceInfo.setYearCreditAmt(this.getBigDecimal(subAccountBalanceInfo.getCreditStartAmt()));
            subAccountBalanceInfo.setYearDebitAmt(this.getBigDecimal(subAccountBalanceInfo.getDebitStartAmt()));
            iSubAccountBalance.addnew((CoreBaseInfo)subAccountBalanceInfo);
        }
    }

    private void deleteOldInitData(Context ctx, String companyId, String currencyId, String periodId) throws BOSException {
        String sqlStr = "DELETE T_CAS_SubAccountBalance WHERE  FCompanyId=? AND FCurrencyId=? AND FPeriodId=?";
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = this.getConnection(ctx);
            ps = conn.prepareStatement(sqlStr);
            ps.setString(1, companyId);
            ps.setString(2, currencyId);
            ps.setString(3, periodId);
            ps.execute();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
    }

    @Override
    protected IObjectCollection _getInitCollection(Context ctx, String strCompanyId, String strCurrencyId, String periodId) throws EASBizException, BOSException {
        IObjectCollection coll = null;
        coll = this.createJournalBalCollBySubAcct(ctx, strCompanyId, strCurrencyId, periodId);
        return coll;
    }

    @Override
    protected void _finishInit(Context ctx, String strCompanyId, String strPeriodId) throws BOSException, EASBizException {
        String sql = "DELETE FROM T_CAS_SubAccountBalance WHERE FCompanyId = ? AND FPeriodId <> ?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{strCompanyId, strPeriodId});
        SubAccountBalanceCollection journalBalColl = this.getSubAccountBalanceCollection(ctx, strCompanyId, null, strPeriodId);
        if (journalBalColl != null) {
            int size = journalBalColl.size();
            ISubAccountBalance iSubAccountBal = SubAccountBalanceFactory.getLocalInstance((Context)ctx);
            for (int i = 0; i < size; ++i) {
                SubAccountBalanceInfo journalBalInfo = journalBalColl.get(i);
                journalBalInfo.setIsInit(false);
                journalBalInfo.setId(null);
                iSubAccountBal.addnew((CoreBaseInfo)journalBalInfo);
            }
        }
    }

    @Override
    protected void _antiInit(Context ctx, String strCompanyId, String strPeriodId) throws BOSException, EASBizException {
        PeriodInfo periodInfo;
        CompanyOrgUnitInfo company = this.getCompanyById(ctx, strCompanyId);
        PeriodInfo startPeriodInfo = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)company);
        if (!startPeriodInfo.equals((Object)(periodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)company)))) {
            throw new CasException(CasException.CHECK_PERIOD);
        }
        this.deleteOldJournalBalData(ctx, strCompanyId, strPeriodId);
        ISystemStatusCtrol iSystemStatusCtrol = SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
        iSystemStatusCtrol.start(SystemEnum.CASHMANAGEMENT, company, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void deleteOldJournalBalData(Context ctx, String strCompanyId, String strPeriodId) throws BOSException, EASBizException {
        String sql = "DELETE T_CAS_SubAccountBalance WHERE FCompanyId=? AND FPeriodId=? AND FIsInit = 0 ";
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = this.getConnection(ctx);
            ps = conn.prepareStatement(sql);
            ps.setString(1, strCompanyId);
            ps.setString(2, strPeriodId);
            ps.executeUpdate();
        }
        catch (SQLException sQLException) {
            SQLUtils.cleanup(ps, (Connection)conn);
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
    }

    private SubAcctCurrencyBalance getPeriodStart(Context ctx, String subAcctId, String currencyId, String companyId, String periodId) throws BOSException {
        String innerSql_1 = "SELECT FId FROM T_BD_AccountBanks WHERE FSubAccountID = '" + subAcctId + "' and FIsClosed = " + 0;
        StringBuffer sql = new StringBuffer();
        sql.append("select isnull(sum(FMonthStartAmt),0),isnull(sum(FYearDebitAmt-FMonthDebitAmt),0) FYearDebitAmt ,isnull(sum(FYearCreditAmt-FMonthCreditAmt),0) FYearCreditAmt from T_CAS_JournalBalance where ");
        sql.append("  FType= 2");
        sql.append(" and FIsInit=1 ");
        sql.append(" and FPeriodId='").append(periodId).append("'");
        sql.append(" and FCurrencyId = '").append(currencyId).append("' ");
        sql.append(" and FAccountBankId in ( ");
        sql.append(innerSql_1);
        sql.append(" ) ");
        SubAcctCurrencyBalance destObj = new SubAcctCurrencyBalance();
        try {
            IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (set.next()) {
                BigDecimal balance = set.getBigDecimal(1);
                BigDecimal debitStartAmt = set.getBigDecimal(2);
                BigDecimal creditStartAmt = set.getBigDecimal(3);
                destObj.setSubAcctId(subAcctId);
                destObj.setCurrencyId(currencyId);
                destObj.setBalance(balance);
                destObj.setDebitStartAmt(debitStartAmt);
                destObj.setCreditStartAmt(creditStartAmt);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        return destObj;
    }

    private IObjectCollection createBankAccInitCollFrom(Context ctx, String strCompanyId, String strCurrencyId, String strPeriodId) throws BOSException, EASBizException {
        SubAccountBalanceCollection coll = new SubAccountBalanceCollection();
        SubAccountBalanceCollection journalBalColl = this.getSubAccountBalanceCollection(ctx, strCompanyId, strCurrencyId, strPeriodId);
        SubAccountCollection acctBankCol = this.getSubAccountCollection(ctx, strCompanyId, strCurrencyId);
        Hashtable<String, SubAccountBalanceInfo> htExistCollection = new Hashtable<String, SubAccountBalanceInfo>();
        if (journalBalColl != null && journalBalColl.size() != 0) {
            for (int i = 0; i < journalBalColl.size(); ++i) {
                SubAccountBalanceInfo journalBalInfo = journalBalColl.get(i);
                String accountBankId = journalBalInfo.getSubacct().getId().toString();
                htExistCollection.put(accountBankId, journalBalInfo);
            }
        }
        int intAcctBankColSize = 0;
        PeriodInfo periodInfo = this.getPeriodById(ctx, strPeriodId);
        if (acctBankCol != null) {
            intAcctBankColSize = acctBankCol.size();
        }
        SubAccountBalanceInfo journalBalInfo = null;
        SubAccountInfo acctBankInfo = null;
        String strAcctBankId = null;
        for (int i = 0; i < intAcctBankColSize; ++i) {
            SubAcctCurrencyBalance destObj;
            acctBankInfo = acctBankCol.get(i);
            strAcctBankId = acctBankInfo.getId().toString();
            if (htExistCollection.containsKey(strAcctBankId)) {
                journalBalInfo = (SubAccountBalanceInfo)htExistCollection.get(strAcctBankId);
                destObj = this.getPeriodStart(ctx, strAcctBankId, strCurrencyId, strCompanyId, strPeriodId);
                journalBalInfo.setPeriodStartBalance(destObj.getBalance());
                journalBalInfo.setDebitStartAmt(destObj.getDebitStartAmt());
                journalBalInfo.setCreditStartAmt(destObj.getCreditStartAmt());
            } else {
                journalBalInfo = new SubAccountBalanceInfo();
                journalBalInfo.setSubacct(acctBankInfo);
                journalBalInfo.setPeriod(periodInfo);
                journalBalInfo.setDebitStartAmt(ZERO);
                journalBalInfo.setCreditStartAmt(ZERO);
                journalBalInfo.setPeriodStartBalance(ZERO);
                journalBalInfo.setYearStartBalance(ZERO);
                destObj = this.getPeriodStart(ctx, strAcctBankId, strCurrencyId, strCompanyId, strPeriodId);
                journalBalInfo.setPeriodStartBalance(destObj.getBalance());
                journalBalInfo.setDebitStartAmt(destObj.getDebitStartAmt());
                journalBalInfo.setCreditStartAmt(destObj.getCreditStartAmt());
            }
            coll.add(journalBalInfo);
        }
        return coll;
    }

    @Override
    protected IObjectCollection _getInitCollectionFrom(Context ctx, String strCompanyId, String strCurrencyId, String periodId) throws EASBizException, BOSException {
        IObjectCollection coll = null;
        coll = this.createBankAccInitCollFrom(ctx, strCompanyId, strCurrencyId, periodId);
        return coll;
    }

    private CompanyOrgUnitInfo getCompanyById(Context ctx, String strId) throws EASBizException, BOSException {
        ICompanyOrgUnit iCompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitInfo company = iCompany.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(strId));
        return company;
    }

    private CurrencyInfo getCurrencyById(Context ctx, String strId) throws EASBizException, BOSException {
        ICurrency iCurrency = CurrencyFactory.getLocalInstance((Context)ctx);
        CurrencyInfo currency = iCurrency.getCurrencyInfo((IObjectPK)new ObjectUuidPK(strId));
        return currency;
    }

    private PeriodInfo getPeriodById(Context ctx, String strId) throws EASBizException, BOSException {
        IPeriod iPeriod = PeriodFactory.getLocalInstance((Context)ctx);
        PeriodInfo period = iPeriod.getPeriodInfo((IObjectPK)new ObjectUuidPK(strId));
        return period;
    }
}

