/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.backport.Arrays;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.vc.VerifyScopeEnum;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.IPeriod;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SharedAcctCollection;
import com.kingdee.eas.basedata.assistant.SharedAcctEntriesInfo;
import com.kingdee.eas.basedata.assistant.SharedAcctFactory;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountRefContrastCollection;
import com.kingdee.eas.basedata.master.account.AccountRefContrastFactory;
import com.kingdee.eas.basedata.master.account.AccountRefContrastInfo;
import com.kingdee.eas.basedata.master.account.AccountTableFactory;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.AccountTools;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.BalanceDirectionEnum;
import com.kingdee.eas.basedata.master.account.IAccountRefContrast;
import com.kingdee.eas.basedata.master.account.RefTypeEnum;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.fi.cas.BillTypeEnum;
import com.kingdee.eas.fi.cas.CasConstants;
import com.kingdee.eas.fi.cas.CashDataSourceEnum;
import com.kingdee.eas.fi.cas.CashDataTypeEnum;
import com.kingdee.eas.fi.cas.CashHelper;
import com.kingdee.eas.fi.cas.CashManagementCashMethod;
import com.kingdee.eas.fi.cas.CashManagementCashMethodParam;
import com.kingdee.eas.fi.cas.CashManagementFactory;
import com.kingdee.eas.fi.cas.DirectionEnum;
import com.kingdee.eas.fi.cas.ICashManagement;
import com.kingdee.eas.fi.cas.IInnerCashFacade;
import com.kingdee.eas.fi.cas.IJournal;
import com.kingdee.eas.fi.cas.InnerCashFacadeFactory;
import com.kingdee.eas.fi.cas.JournalFactory;
import com.kingdee.eas.fi.cas.JournalInfo;
import com.kingdee.eas.fi.cas.JournalSourceEnum;
import com.kingdee.eas.fi.cas.utils.CASWebUtil;
import com.kingdee.eas.fi.cas.utils.JournalWebUtil;
import com.kingdee.eas.fi.cas.web.param.BankJournalWebFilterParam;
import com.kingdee.eas.fi.cas.web.param.BsfBatchProcessResult;
import com.kingdee.eas.fi.cas.web.param.FetchAccTableParam;
import com.kingdee.eas.fi.cas.web.param.QueryTable;
import com.kingdee.eas.fi.cas.web.param.QueryTableRow;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.DateHelper;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

public class BankJournalWebUtil {
    private static final Logger logger = Logger.getLogger(BankJournalWebUtil.class);
    private static final Map periodCache = new ConcurrentHashMap();
    protected static final String COL_SETTNUMBER = "settlementNumber";
    protected static final String COL_SETTTYPE = "settlementType";
    protected static final String COL_DC = "dc";
    protected static final String COL_PERIOD = "period";
    protected static final String COL_YEAR = "year";
    protected static final String COL_SOURCE = "source";
    protected static final String COL_CASHIER = "cashier_name";
    protected static final String COL_BALANCE = "balance";
    protected static final String COL_CREDIT = "creditAmount";
    protected static final String COL_DEBIT = "debitAmount";
    protected static final String COL_DESCRIPTION = "description";
    protected static final String COL_BILLNUMBER = "billNumber";
    protected static final String COL_BILLTYPE = "billType";
    protected static final String COL_OPPACCOUNTNUMBER = "oppAccountNumber";
    protected static final String COL_VOUCHERNUMBER = "voucherNumber";
    protected static final String COL_VOUCHERTYPE = "voucherType";
    protected static final String COL_BIZDATE = "bizDate";
    protected static final String COL_ID = "id";
    protected static final String COL_COMPANY = "company_name";
    protected static final String COL_COMPANY_ID = "company_id";
    protected static final String CREDIT_AMOUNT = "creditAmount";
    protected static final String DEBIT_AMOUNT = "debitAmount";
    protected static final String PERIOD_NUMBER = "periodnumber";
    protected static final String PERIOD_YEAR = "periodyear";
    protected static final String COL_CREATE_DATE = "createDate";
    protected static final String COL_LOCAL_BALANCE = "localBalance";
    protected static final String COL_LOCAL_CREDIT = "localCredit";
    protected static final String COL_LOCAL_DEBIT = "localDebit";
    protected static final String COL_EXCHANGE = "exchange";
    private static final String resourcePath = "com.kingdee.eas.fi.cas.JournalResource";

    public static AccountRefContrastCollection getStrideAcctRefContrastColl(Context ctx, String companyId, Date beginDate, Date endDate) throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
        filter.getFilterItems().add(new FilterItemInfo("enabledPeriod.endDate", (Object)DateTimeUtils.truncateDate((Date)beginDate), CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("enabledPeriod.endDate", (Object)DateTimeUtils.truncateDate((Date)endDate), CompareType.LESS));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        IAccountRefContrast acctContrast = AccountRefContrastFactory.getLocalInstance((Context)ctx);
        AccountRefContrastCollection coll = acctContrast.getAccountRefContrastCollection(evi);
        return coll;
    }

    public static PeriodInfo getCurrentPeriod(Context ctx, SystemEnum SystemName, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        return SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemName, (CompanyOrgUnitInfo)company);
    }

    public static PeriodInfo getCurrentPeriod(Context ctx, SystemEnum SystemName, String companyId) throws BOSException, EASBizException {
        return SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemName, (IObjectPK)new ObjectUuidPK(companyId));
    }

    public static String getActualAcctTable(Context ctx, String companyId, Date beginDate, Date endDate) throws EASBizException, BOSException {
        CompanyOrgUnitInfo company = null;
        ICompanyOrgUnit iCompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        company = iCompany.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
        AccountRefContrastCollection coll = BankJournalWebUtil.getStrideAcctRefContrastColl(ctx, companyId, beginDate, endDate);
        if (coll == null || coll.isEmpty()) {
            PeriodInfo period = PeriodUtils.getPeriodInfo((Context)ctx, (Date)endDate, (CompanyOrgUnitInfo)company);
            if (period == null) {
                throw new BOSException(EASCommonResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"26_FMClientHelper", (Locale)ctx.getLocale()));
            }
            int yearNumber = period.getPeriodYear();
            int monthNumber = period.getPeriodNumber();
            AccountTableInfo tbl = company.getAccountTable();
            String currTableId = AccountTools.getCurrentAcctTable((Context)ctx, (String)companyId, (String)tbl.getId().toString(), (int)yearNumber, (int)monthNumber);
            return currTableId;
        }
        if (null != coll && coll.get(0).getRefType() == RefTypeEnum.BOOKS) {
            return coll.get(0).getEnabledAcctTable().getId().toString();
        }
        return null;
    }

    public static String getPeriodCollSQL(String periodTypeId, int beginYear, int beginMonth, int endYear, int endMonth) {
        StringBuffer sb = new StringBuffer();
        sb.append("select fid from t_bd_period A ");
        sb.append(" where A.FPERIODYEAR*100 + A.FPERIODNUMBER >=");
        sb.append(beginYear * 100 + beginMonth);
        sb.append(" and A.FPERIODYEAR*100 + A.FPERIODNUMBER  <=");
        sb.append(endYear * 100 + endMonth);
        sb.append(" and A.FTypeID='");
        sb.append(periodTypeId);
        sb.append("'");
        return sb.toString();
    }

    public static String getActualAcctTable(Context ctx, String companyId, int beginYear, int beginMonth, int endYear, int endMonth) throws EASBizException, BOSException {
        PeriodInfo beginPeriod = PeriodUtils.getPeriodInfo((Context)ctx, (int)beginYear, (int)beginMonth, (IObjectPK)new ObjectUuidPK(companyId));
        PeriodInfo endPeriod = PeriodUtils.getPeriodInfo((Context)ctx, (int)endYear, (int)endMonth, (IObjectPK)new ObjectUuidPK(companyId));
        return BankJournalWebUtil.getActualAcctTable(ctx, companyId, beginPeriod.getBeginDate(), endPeriod.getEndDate());
    }

    public static String getAcctTableID(Context ctx, BankJournalWebFilterParam param) throws EASBizException, BOSException {
        String acctTableId = null;
        if (param.isByDay()) {
            Date beginDate = param.getFromDate();
            Date endDate = param.getToDate();
            acctTableId = BankJournalWebUtil.getActualAcctTable(ctx, param.getCompanyId(), beginDate, endDate);
        } else {
            int beginYear = param.getBeginYear();
            int beginMonth = param.getBeginMonth();
            int endYear = param.getEndYear();
            int endMonth = param.getEndMonth();
            acctTableId = BankJournalWebUtil.getActualAcctTable(ctx, param.getCompanyId(), beginYear, beginMonth, endYear, endMonth);
        }
        return acctTableId;
    }

    public static PeriodInfo getStartPeriod(Context ctx, SystemEnum SystemName, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        return SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)company);
    }

    public static PeriodCollection getPeriodc(Context ctx, CompanyOrgUnitInfo companyInfo) throws BOSException, EASBizException {
        if (companyInfo.getAccountPeriodType() == null || companyInfo.getAccountPeriodType().getId() == null) {
            ICompanyOrgUnit iCompanyOrgUnit = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
            companyInfo = iCompanyOrgUnit.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyInfo.getId()));
        }
        IPeriod iPeriod = PeriodFactory.getLocalInstance((Context)ctx);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)companyInfo.getAccountPeriodType().getId().toString(), CompareType.EQUALS));
        evi.getSorter().add(new SorterItemInfo("periodYear"));
        evi.getSorter().add(new SorterItemInfo("periodNumber"));
        evi.setFilter(filter);
        PeriodCollection periodc = iPeriod.getPeriodCollection(evi);
        if (periodc == null || periodc.size() == 0) {
            return null;
        }
        if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)companyInfo)) {
            return periodc;
        }
        PeriodInfo startPeriod = BankJournalWebUtil.getStartPeriodInfo(ctx, companyInfo);
        PeriodCollection rsltCols = new PeriodCollection();
        int n = periodc.size();
        for (int i = 0; i < n; ++i) {
            PeriodInfo periodInfo = periodc.get(i);
            if (!BankJournalWebUtil.isAfterStartPeriod(startPeriod, periodInfo)) continue;
            periodInfo.toString();
            rsltCols.add(periodInfo);
        }
        return rsltCols;
    }

    public static boolean isAfterStartPeriod(PeriodInfo startPeriod, PeriodInfo periodInfo) {
        if (startPeriod == null || periodInfo == null) {
            return false;
        }
        if (startPeriod.getPeriodYear() < periodInfo.getPeriodYear()) {
            return true;
        }
        return startPeriod.getPeriodYear() == periodInfo.getPeriodYear() && startPeriod.getPeriodNumber() <= periodInfo.getPeriodNumber();
    }

    public static PeriodInfo getStartPeriodInfo(Context ctx, CompanyOrgUnitInfo companyInfo) throws EASBizException, BOSException {
        PeriodInfo startPeriod = null;
        startPeriod = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)companyInfo);
        return startPeriod;
    }

    public static TreeMap getYearPeriod(Context ctx, CompanyOrgUnitInfo companyInfo) throws EASBizException, BOSException {
        TreeMap<Integer, PeriodCollection> result = new TreeMap<Integer, PeriodCollection>();
        PeriodCollection pc = BankJournalWebUtil.getPeriodc(ctx, companyInfo);
        for (PeriodInfo pi : pc) {
            PeriodCollection tmpPc;
            Integer year = new Integer(pi.getPeriodYear());
            if (!result.containsKey(year)) {
                tmpPc = new PeriodCollection();
                tmpPc.add(pi);
                result.put(year, tmpPc);
                continue;
            }
            tmpPc = (PeriodCollection)result.get(year);
            tmpPc.add(pi);
        }
        return result;
    }

    public static PeriodInfo getPeriodInfo(Context ctx, Date date, CompanyOrgUnitInfo companyInfo) throws EASBizException, BOSException {
        TreeMap yearMap;
        PeriodCollection pc;
        Calendar cal = Calendar.getInstance();
        Date sourceDate = DateTimeUtils.truncateDate((Date)date);
        cal.setTime(date);
        int year = cal.get(1);
        ObjectUuidPK companyPK = new ObjectUuidPK(companyInfo.getId());
        if (periodCache == null || !periodCache.containsKey(companyPK)) {
            BankJournalWebUtil.cachePeriod(ctx, companyInfo);
        }
        if ((pc = (PeriodCollection)(yearMap = (TreeMap)periodCache.get(companyPK)).get(new Integer(year))) == null) {
            return null;
        }
        PeriodInfo periodInfo = null;
        for (int i = 0; i < pc.size(); ++i) {
            periodInfo = pc.get(i);
            Date beginDate = periodInfo.getBeginDate();
            Date endDate = DateTimeUtils.truncateDate((Date)periodInfo.getEndDate());
            if ((!beginDate.before(sourceDate) || !endDate.after(sourceDate)) && !beginDate.equals(sourceDate) && !endDate.equals(sourceDate)) continue;
            return periodInfo;
        }
        return null;
    }

    public static PeriodInfo getLastPeriodInfo(Context ctx, CompanyOrgUnitInfo companyInfo) throws EASBizException, BOSException {
        int end;
        TreeMap yearMap;
        PeriodCollection pc;
        ObjectUuidPK companyPK = new ObjectUuidPK(companyInfo.getId());
        if (periodCache == null || !periodCache.containsKey(companyPK)) {
            BankJournalWebUtil.cachePeriod(ctx, companyInfo);
        }
        if ((pc = (PeriodCollection)(yearMap = (TreeMap)periodCache.get(companyPK)).get(new Integer(end = ((Integer)yearMap.lastKey()).intValue()))) == null) {
            return null;
        }
        return pc.get(pc.size() - 1);
    }

    public static BigDecimal getCashMonthStartAmt(Context ctx, String acctTableNum, String companyId, String accountNum, String currencyNum, String periodId) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("select FMonthStartAmt SubResult from T_CAS_JournalBalance where ");
        sql.append("FIsInit =0  and ");
        sql.append("FCompanyId='").append(companyId).append("' and FCurrencyId in(").append("select fid from t_bd_currency where FNumber = '").append(currencyNum).append("') and FPeriodId='").append(periodId).append("'");
        sql.append(" and FType= 1");
        if (accountNum != null && accountNum.length() > 0) {
            sql.append(" and FAccountViewId in (").append("select fid from t_bd_accountview where FIsLeaf = 1 and FIsCash = 1 and FCompanyID='").append(companyId).append("' and FNumber = '").append(accountNum.trim()).append("' and FAccountTableID in(select fid from t_bd_accountTable where FNumber = '").append(acctTableNum).append("'))");
        }
        ISQLExecutor exec = SQLExecutorFactory.getLocalInstance((Context)ctx, (String)sql.toString());
        IRowSet rs = null;
        rs = exec.executeSQL();
        try {
            if (rs != null && rs.next()) {
                return rs.getBigDecimal("SubResult");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return Constants.ZERO;
    }

    public static BigDecimal getBankMonthStartAmt(Context ctx, String acctTableNum, String companyId, String accountBankNum, String accountNum, String currencyNum, String periodId) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("select FMonthStartAmt SubResult from T_CAS_JournalBalance where ");
        sql.append("FIsInit =0  and ");
        sql.append("FCompanyId='").append(companyId).append("' and FCurrencyId in(").append("select fid from t_bd_currency where FNumber = '").append(currencyNum).append("') and FPeriodId='").append(periodId).append("'");
        sql.append(" and FAccountBankId in(").append("select fid from t_bd_accountbanks where fnumber='").append(accountBankNum).append("'").append(" and fcompanyid='").append(companyId).append("')");
        sql.append(" and FType= 2");
        if (accountNum != null && accountNum.length() > 0) {
            sql.append(" and FAccountViewId in (").append("select fid from t_bd_accountview where FIsLeaf = 1 and FIsBank = 1 and FCompanyID='").append(companyId).append("' and FNumber = '").append(accountNum.trim()).append("' and FAccountTableID in(select fid from t_bd_accountTable where FNumber = '").append(acctTableNum).append("'))");
        }
        ISQLExecutor exec = SQLExecutorFactory.getLocalInstance((Context)ctx, (String)sql.toString());
        IRowSet rs = null;
        boolean result = false;
        try {
            rs = exec.executeSQL();
            if (rs != null && rs.next()) {
                return rs.getBigDecimal("SubResult");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return FMConstants.ZERO;
    }

    public static BigDecimal getBeginBalance(Context ctx, CompanyOrgUnitInfo companyInfo, String accountTableNumber, String currencyNumber, String accountNumber, String accountBankNumber, Date beginDate, CashDataSourceEnum dateType, boolean isAdjustPeriod, boolean isMulUnionQuery) throws EASBizException, BOSException {
        String lastDayAcctTableNumber;
        Date previousDate = beginDate;
        PeriodInfo previousPeriod = PeriodUtils.getPeriodInfo((Context)ctx, (Date)previousDate, (CompanyOrgUnitInfo)companyInfo);
        if (!isAdjustPeriod) {
            previousDate = DateHelper.getBeforeDay((Date)previousDate);
            previousPeriod = PeriodUtils.getPeriodInfo((Context)ctx, (Date)previousDate, (CompanyOrgUnitInfo)companyInfo);
        }
        if (previousPeriod == null) {
            PeriodInfo period = PeriodUtils.getPeriodInfo((Context)ctx, (Date)beginDate, (CompanyOrgUnitInfo)companyInfo);
            if (accountBankNumber == null) {
                return BankJournalWebUtil.getCashMonthStartAmt(ctx, accountTableNumber, companyInfo.getId().toString(), accountNumber, currencyNumber, period.getId().toString());
            }
            return BankJournalWebUtil.getBankMonthStartAmt(ctx, accountTableNumber, companyInfo.getId().toString(), accountBankNumber, accountNumber, currencyNumber, period.getId().toString());
        }
        IInnerCashFacade innerCashFacade = InnerCashFacadeFactory.getLocalInstance(ctx);
        String lastDayAcctTableid = innerCashFacade.getActualAcctTableID(companyInfo.getId().toString(), previousDate, previousDate);
        if (lastDayAcctTableid != null && !(lastDayAcctTableNumber = AccountTableFactory.getLocalInstance((Context)ctx).getAccountTableInfo((IObjectPK)new ObjectUuidPK(lastDayAcctTableid)).getNumber()).equals(accountTableNumber)) {
            PeriodInfo period = PeriodUtils.getPeriodInfo((Context)ctx, (Date)beginDate, (CompanyOrgUnitInfo)companyInfo);
            if (accountBankNumber == null) {
                return BankJournalWebUtil.getCashMonthStartAmt(ctx, accountTableNumber, companyInfo.getId().toString(), accountNumber, currencyNumber, period.getId().toString());
            }
            return BankJournalWebUtil.getBankMonthStartAmt(ctx, accountTableNumber, companyInfo.getId().toString(), accountBankNumber, accountNumber, currencyNumber, period.getId().toString());
        }
        ICashManagement cashInacct = CashManagementFactory.getLocalInstance(ctx);
        BigDecimal balance = null;
        balance = cashInacct.cash(companyInfo.getNumber(), dateType, accountTableNumber, accountNumber, accountBankNumber, currencyNumber, beginDate, beginDate, CashDataTypeEnum.C, false, isAdjustPeriod, isMulUnionQuery);
        return balance;
    }

    public static BigDecimal getBeginBalance(Context ctx, CompanyOrgUnitInfo companyInfo, String accountTableNumber, String currencyNumber, String accountNumber, String accountBankNumber, PeriodInfo period, CashDataSourceEnum dateType, boolean isMulUnionQuery) throws EASBizException, BOSException {
        if (period.isIsAdjustPeriod()) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyInfo.getId()));
            filter.getFilterItems().add(new FilterItemInfo("enabledPeriod.id", (Object)period.getId()));
            filter.getFilterItems().add(new FilterItemInfo("enabledAcctTable.number", (Object)accountTableNumber));
            IAccountRefContrast acctContrast = AccountRefContrastFactory.getLocalInstance((Context)ctx);
            if (acctContrast.exists(filter)) {
                return new BigDecimal("0");
            }
        }
        return BankJournalWebUtil.getBeginBalance(ctx, companyInfo, accountTableNumber, currencyNumber, accountNumber, accountBankNumber, period.getBeginDate(), dateType, period.isIsAdjustPeriod(), isMulUnionQuery);
    }

    public static void cachePeriod(Context ctx, CompanyOrgUnitInfo companyInfo) throws EASBizException, BOSException {
        TreeMap<Integer, PeriodCollection> result = new TreeMap<Integer, PeriodCollection>();
        PeriodCollection pc = BankJournalWebUtil.getPeriodc(ctx, companyInfo);
        for (PeriodInfo pi : pc) {
            PeriodCollection tmpPc;
            Integer year = new Integer(pi.getPeriodYear());
            if (!result.containsKey(year)) {
                tmpPc = new PeriodCollection();
                tmpPc.add(pi);
                result.put(year, tmpPc);
                continue;
            }
            tmpPc = (PeriodCollection)result.get(year);
            tmpPc.add(pi);
        }
        periodCache.put(new ObjectUuidPK(companyInfo.getId()), result);
    }

    public static PeriodInfo getPrePeriodInfo(Context ctx, CompanyOrgUnitInfo companyInfo, PeriodInfo period) throws EASBizException, BOSException {
        ObjectUuidPK companyPK = new ObjectUuidPK(companyInfo.getId());
        if (periodCache == null || !periodCache.containsKey(companyPK)) {
            BankJournalWebUtil.cachePeriod(ctx, companyInfo);
        }
        TreeMap yearMap = (TreeMap)periodCache.get(companyPK);
        PeriodCollection pc = null;
        if (period.getPeriodNumber() == 1) {
            pc = (PeriodCollection)yearMap.get(new Integer(period.getPeriodYear() - 1));
            if (pc != null && pc.size() > 0) {
                return pc.get(pc.size() - 1);
            }
        } else {
            pc = (PeriodCollection)yearMap.get(new Integer(period.getPeriodYear()));
        }
        if (pc == null) {
            return null;
        }
        PeriodInfo periodInfo = null;
        for (int i = 0; i < pc.size(); ++i) {
            periodInfo = pc.get(i);
            if (periodInfo.getPeriodYear() != period.getPeriodYear() || periodInfo.getPeriodNumber() != period.getPeriodNumber()) continue;
            if (i == 0) {
                return null;
            }
            return pc.get(i - 1);
        }
        return null;
    }

    public static BigDecimal getYearTotal(Context ctx, CompanyOrgUnitInfo companyInfo, String accountTableNumber, String currencyNumber, String accountNumber, String accountBankNumber, int year, int periodNumber, CashDataSourceEnum dateType, CashDataTypeEnum type, boolean isMulUnionQuery) throws EASBizException, BOSException {
        ICashManagement cashInacct = CashManagementFactory.getLocalInstance(ctx);
        BigDecimal result = null;
        GregorianCalendar begincal = new GregorianCalendar(year, 0, 1);
        PeriodInfo endPeriod = BankJournalWebUtil.getPeriodInfo(ctx, year, periodNumber, companyInfo);
        if (endPeriod == null) {
            return CasConstants.ZERO;
        }
        if (endPeriod.isIsAdjustPeriod()) {
            AccountRefContrastInfo info;
            if (companyInfo.getAccountTable() == null) {
                companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyInfo.getId()));
            }
            if ((info = AccountRefContrastFactory.getLocalInstance((Context)ctx).getLastAcctInfo(companyInfo.getId().toString(), companyInfo.getAccountTable().getId().toString(), year, periodNumber)).getEnabledPeriod() != null && info.getEnabledPeriod().getId().equals((Object)endPeriod.getId()) && accountTableNumber.equals(info.getEnabledAcctTable().getNumber())) {
                return CasConstants.ZERO;
            }
        }
        if ((endPeriod = BankJournalWebUtil.getPrePeriodInfo(ctx, companyInfo, endPeriod)) == null || endPeriod.getPeriodYear() != year) {
            return CasConstants.ZERO;
        }
        result = cashInacct.cash(companyInfo.getNumber(), dateType, accountTableNumber, accountNumber, accountBankNumber, currencyNumber, begincal.getTime(), endPeriod.getEndDate(), type, isMulUnionQuery);
        return result;
    }

    public static void fillBalance(Context ctx, QueryTableRow row, BigDecimal exchange, BigDecimal balance, boolean isCurEqualsBasecur, String description, Date beginDate, ConvertModeEnum convertMode, BalanceDirectionEnum dc, boolean glDc) {
        BigDecimal localBalance = isCurEqualsBasecur ? balance : (convertMode.equals((Object)ConvertModeEnum.DIRECTEXCHANGERATE) ? balance.multiply(exchange) : balance.divide(exchange, 4));
        DirectionEnum direction = balance.compareTo(CasConstants.ZERO) == 0 ? DirectionEnum.Balance : (balance.compareTo(CasConstants.ZERO) > 0 ? DirectionEnum.Debit : DirectionEnum.Credit);
        row.addCell(COL_DC, (Object)direction);
        row.addCell(COL_DESCRIPTION, description);
        if (!glDc) {
            row.addCell(COL_LOCAL_BALANCE, localBalance.abs());
            row.addCell(COL_BALANCE, balance.abs());
        } else {
            if (dc != null && !dc.getAlias().equals(direction.getAlias()) && !direction.equals((Object)DirectionEnum.Balance)) {
                row.addCell(COL_DC).setValue(dc);
            }
            row.addCell(COL_LOCAL_BALANCE).setValue(localBalance);
            row.addCell(COL_BALANCE).setValue(balance);
        }
        row.addCell(COL_CREATE_DATE).setValue(Constants.FORMAT_DAY.format(beginDate));
    }

    public static void fillBalance(Context ctx, CompanyOrgUnitInfo companyInfo, int year, int periodNumber, QueryTableRow tableRow, BigDecimal exchange, BigDecimal balance, boolean isCurEqualsBasecur, String description, ConvertModeEnum convertMode, BalanceDirectionEnum dc, boolean glDc) throws EASBizException, BOSException {
        PeriodInfo period = BankJournalWebUtil.getPeriodInfo(ctx, year, periodNumber, companyInfo);
        Date beginDate = null;
        if (period != null) {
            beginDate = period.getBeginDate();
        }
        BankJournalWebUtil.fillBalance(ctx, tableRow, exchange, balance, isCurEqualsBasecur, description, beginDate, convertMode, dc, glDc);
    }

    public static void fillAdjustRow_NewDay(Context ctx, BigDecimal monthDebitAmt, BigDecimal monthCreditAmt, BigDecimal yearDebitAmt, BigDecimal yearCreditAmt, QueryTable queryTable, boolean isShowBeginBalance, boolean isShowPeriodTotal, boolean isShowYearTotal, CompanyOrgUnitInfo companyInfo, boolean isCurEqualsBasecur, BigDecimal balance, PeriodInfo beginPeriodInfo, PeriodInfo endPeriodInfo, ConvertModeEnum convertMode, Date beginDay, Date endDay, CurrencyInfo sourceCurrency, BalanceDirectionEnum dc, boolean glDc) throws BOSException, EASBizException {
        PeriodInfo temPeriodInfo = beginPeriodInfo;
        String DAY_BALANCE = EASCommonResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"BankStmt_DayStart", (Locale)ctx.getLocale());
        String PERIOD_TOTAL = EASCommonResource.getString((String)resourcePath, (String)"MonthTotal", (Locale)ctx.getLocale());
        String YEAR_TOTAL = EASCommonResource.getString((String)resourcePath, (String)"YearTotal", (Locale)ctx.getLocale());
        String YEAR_BALANCE = EASCommonResource.getString((String)resourcePath, (String)"YearBalance", (Locale)ctx.getLocale());
        if (beginPeriodInfo == null || endPeriodInfo == null) {
            return;
        }
        boolean first = true;
        while (temPeriodInfo.getPeriodYear() < endPeriodInfo.getPeriodYear() || temPeriodInfo.getPeriodYear() == endPeriodInfo.getPeriodYear() && endPeriodInfo.getPeriodNumber() >= temPeriodInfo.getPeriodNumber()) {
            PeriodInfo temNextPeriodInfo;
            BigDecimal exchange;
            Date tempDate;
            QueryTableRow tableRow;
            if (isShowBeginBalance) {
                tableRow = queryTable.addRow();
                PeriodInfo period = BankJournalWebUtil.getPeriodInfo(ctx, temPeriodInfo.getPeriodYear(), temPeriodInfo.getPeriodNumber(), companyInfo);
                Timestamp tempDate2 = period.getEndDate();
                BigDecimal exchange2 = JournalWebUtil.getExchange(ctx, companyInfo, sourceCurrency, null, tempDate2);
                if (first) {
                    BankJournalWebUtil.fillBalance(ctx, tableRow, exchange2, balance, isCurEqualsBasecur, DAY_BALANCE, beginDay, convertMode, dc, glDc);
                } else {
                    BankJournalWebUtil.fillBalance(ctx, companyInfo, temPeriodInfo.getPeriodYear(), temPeriodInfo.getPeriodNumber(), tableRow, exchange2, balance, isCurEqualsBasecur, DAY_BALANCE, convertMode, dc, glDc);
                }
                first = false;
            }
            if (isShowPeriodTotal) {
                tableRow = queryTable.addRow();
                tempDate = temPeriodInfo.getEndDate();
                exchange = JournalWebUtil.getExchange(ctx, companyInfo, sourceCurrency, null, tempDate);
                if (temPeriodInfo.getEndDate().compareTo(new Timestamp(endDay.getTime())) < 0) {
                    BankJournalWebUtil.fillTotal(ctx, companyInfo, temPeriodInfo.getPeriodYear(), temPeriodInfo.getPeriodNumber(), temPeriodInfo.getEndDate(), tableRow, exchange, monthDebitAmt, monthCreditAmt, balance, isCurEqualsBasecur, PERIOD_TOTAL, convertMode, dc, glDc);
                } else {
                    BankJournalWebUtil.fillTotal(ctx, companyInfo, temPeriodInfo.getPeriodYear(), temPeriodInfo.getPeriodNumber(), endDay, tableRow, exchange, monthDebitAmt, monthCreditAmt, balance, isCurEqualsBasecur, PERIOD_TOTAL, convertMode, dc, glDc);
                }
                monthDebitAmt = Constants.ZERO;
                monthCreditAmt = Constants.ZERO;
            }
            if (isShowYearTotal) {
                tableRow = queryTable.addRow();
                tempDate = temPeriodInfo.getEndDate();
                exchange = JournalWebUtil.getExchange(ctx, companyInfo, sourceCurrency, null, tempDate);
                if (temPeriodInfo.getEndDate().compareTo(new Timestamp(endDay.getTime())) < 0) {
                    BankJournalWebUtil.fillTotal(ctx, companyInfo, temPeriodInfo.getPeriodYear(), temPeriodInfo.getPeriodNumber(), temPeriodInfo.getEndDate(), tableRow, exchange, yearDebitAmt, yearCreditAmt, balance, isCurEqualsBasecur, YEAR_TOTAL, convertMode, dc, glDc);
                } else {
                    BankJournalWebUtil.fillTotal(ctx, companyInfo, temPeriodInfo.getPeriodYear(), temPeriodInfo.getPeriodNumber(), endDay, tableRow, exchange, yearDebitAmt, yearCreditAmt, balance, isCurEqualsBasecur, YEAR_TOTAL, convertMode, dc, glDc);
                }
            }
            if ((temNextPeriodInfo = BankJournalWebUtil.getNextPeriodInfo(ctx, companyInfo, temPeriodInfo)) == null) {
                return;
            }
            if ((temNextPeriodInfo.getPeriodYear() < endPeriodInfo.getPeriodYear() || temNextPeriodInfo.getPeriodYear() == endPeriodInfo.getPeriodYear() && endPeriodInfo.getPeriodNumber() >= temNextPeriodInfo.getPeriodNumber()) && temPeriodInfo.getPeriodYear() < temNextPeriodInfo.getPeriodYear()) {
                tableRow = queryTable.addRow();
                tempDate = temNextPeriodInfo.getBeginDate();
                exchange = JournalWebUtil.getExchange(ctx, companyInfo, sourceCurrency, null, DateUtil.getBeforeDay((Date)tempDate));
                BankJournalWebUtil.fillBalance(ctx, companyInfo, temNextPeriodInfo.getPeriodYear(), temNextPeriodInfo.getPeriodNumber(), tableRow, exchange, balance, isCurEqualsBasecur, YEAR_BALANCE, convertMode, dc, glDc);
                yearDebitAmt = CasConstants.ZERO;
                yearCreditAmt = CasConstants.ZERO;
            }
            temPeriodInfo = temNextPeriodInfo;
        }
    }

    public static CompanyOrgUnitInfo getCompanyInfo(Context ctx, BOSUuid bosuuid) throws BOSException, EASBizException {
        ObjectUuidPK compk = new ObjectUuidPK(bosuuid);
        ICompanyOrgUnit comorg = null;
        CompanyOrgUnitInfo comorgInfo = null;
        comorg = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("accountBank.id"));
        sic.add(new SelectorItemInfo("accountBank.name"));
        sic.add(new SelectorItemInfo("accountBank.number"));
        sic.add(new SelectorItemInfo("baseCurrency.id"));
        sic.add(new SelectorItemInfo("baseCurrency.name"));
        sic.add(new SelectorItemInfo("baseExchangeTable"));
        sic.add(new SelectorItemInfo("accountTable.id"));
        comorgInfo = comorg.getCompanyOrgUnitInfo((IObjectPK)compk, sic);
        return comorgInfo;
    }

    public static void fillAdjustRow_New(Context ctx, BigDecimal monthDebitAmt, BigDecimal monthCreditAmt, BigDecimal yearDebitAmt, BigDecimal yearCreditAmt, QueryTable queryTable, boolean isShowBeginBalance, boolean isShowPeriodTotal, boolean isShowYearTotal, CompanyOrgUnitInfo companyInfo, boolean isCurEqualsBasecur, BigDecimal balance, PeriodInfo beginPeriodInfo, PeriodInfo endPeriodInfo, ConvertModeEnum convertMode, CurrencyInfo sourceCurrency, BalanceDirectionEnum dc, boolean glDc) throws BOSException, EASBizException {
        PeriodInfo temPeriodInfo = beginPeriodInfo;
        String BEGIN_BALANCE = EASCommonResource.getString((String)resourcePath, (String)"BeginBalance", (Locale)ctx.getLocale());
        String YEAR_TOTAL = EASCommonResource.getString((String)resourcePath, (String)"YearTotal", (Locale)ctx.getLocale());
        String PERIOD_TOTAL = EASCommonResource.getString((String)resourcePath, (String)"MonthTotal", (Locale)ctx.getLocale());
        String YEAR_BALANCE = EASCommonResource.getString((String)resourcePath, (String)"YearBalance", (Locale)ctx.getLocale());
        if (beginPeriodInfo == null || endPeriodInfo == null) {
            return;
        }
        while (temPeriodInfo.getPeriodYear() < endPeriodInfo.getPeriodYear() || temPeriodInfo.getPeriodYear() == endPeriodInfo.getPeriodYear() && endPeriodInfo.getPeriodNumber() >= temPeriodInfo.getPeriodNumber()) {
            PeriodInfo temNextPeriodInfo;
            BigDecimal exchange;
            Timestamp tempDate;
            BigDecimal exchange2;
            Timestamp tempDate2;
            PeriodInfo period;
            QueryTableRow tableRow;
            if (isShowBeginBalance) {
                tableRow = queryTable.addRow();
                period = BankJournalWebUtil.getPeriodInfo(ctx, temPeriodInfo.getPeriodYear(), temPeriodInfo.getPeriodNumber(), companyInfo);
                tempDate2 = period.getEndDate();
                exchange2 = JournalWebUtil.getExchange(ctx, companyInfo, sourceCurrency, null, DateUtil.getBeforeDay((Date)tempDate2));
                BankJournalWebUtil.fillBalance(ctx, companyInfo, temPeriodInfo.getPeriodYear(), temPeriodInfo.getPeriodNumber(), tableRow, exchange2, balance, isCurEqualsBasecur, BEGIN_BALANCE, convertMode, dc, glDc);
            }
            if (isShowPeriodTotal) {
                tableRow = queryTable.addRow();
                tempDate = temPeriodInfo.getEndDate();
                exchange = JournalWebUtil.getExchange(ctx, companyInfo, sourceCurrency, null, tempDate);
                BankJournalWebUtil.fillTotal(ctx, companyInfo, temPeriodInfo.getPeriodYear(), temPeriodInfo.getPeriodNumber(), temPeriodInfo.getEndDate(), tableRow, exchange, monthDebitAmt, monthCreditAmt, balance, isCurEqualsBasecur, PERIOD_TOTAL, convertMode, dc, glDc);
                monthDebitAmt = Constants.ZERO;
                monthCreditAmt = Constants.ZERO;
            }
            if (isShowYearTotal) {
                tableRow = queryTable.addRow();
                tempDate = temPeriodInfo.getEndDate();
                exchange = JournalWebUtil.getExchange(ctx, companyInfo, sourceCurrency, null, tempDate);
                BankJournalWebUtil.fillTotal(ctx, companyInfo, temPeriodInfo.getPeriodYear(), temPeriodInfo.getPeriodNumber(), temPeriodInfo.getEndDate(), tableRow, exchange, yearDebitAmt, yearCreditAmt, balance, isCurEqualsBasecur, YEAR_TOTAL, convertMode, dc, glDc);
            }
            if ((temNextPeriodInfo = BankJournalWebUtil.getNextPeriodInfo(ctx, companyInfo, temPeriodInfo)) == null) {
                return;
            }
            if ((temNextPeriodInfo.getPeriodYear() < endPeriodInfo.getPeriodYear() || temNextPeriodInfo.getPeriodYear() == endPeriodInfo.getPeriodYear() && endPeriodInfo.getPeriodNumber() >= temNextPeriodInfo.getPeriodNumber()) && temPeriodInfo.getPeriodYear() < temNextPeriodInfo.getPeriodYear()) {
                tableRow = queryTable.addRow();
                period = BankJournalWebUtil.getPeriodInfo(ctx, temNextPeriodInfo.getPeriodYear(), temNextPeriodInfo.getPeriodNumber(), companyInfo);
                tempDate2 = period.getEndDate();
                exchange2 = JournalWebUtil.getExchange(ctx, companyInfo, sourceCurrency, null, DateUtil.getBeforeDay((Date)tempDate2));
                BankJournalWebUtil.fillBalance(ctx, companyInfo, temNextPeriodInfo.getPeriodYear(), temNextPeriodInfo.getPeriodNumber(), tableRow, exchange2, balance, isCurEqualsBasecur, YEAR_BALANCE, convertMode, dc, glDc);
                yearDebitAmt = CasConstants.ZERO;
                yearCreditAmt = CasConstants.ZERO;
            }
            temPeriodInfo = temNextPeriodInfo;
        }
    }

    public static void fillLocalCurrencyDataForTotal(Context ctx, QueryTableRow tableRow, BigDecimal exchange, BigDecimal debitAmt, BigDecimal creditAmt, BigDecimal balance, boolean isCurEqualsBasecur, ConvertModeEnum convertMode, BalanceDirectionEnum dc, boolean glDc) {
        BigDecimal localBalance;
        BigDecimal localCreditAmt;
        BigDecimal localDebitAmt;
        if (isCurEqualsBasecur) {
            localDebitAmt = debitAmt;
            localCreditAmt = creditAmt;
            localBalance = balance;
        } else if (convertMode.equals((Object)ConvertModeEnum.DIRECTEXCHANGERATE)) {
            localDebitAmt = debitAmt.multiply(exchange);
            localCreditAmt = creditAmt.multiply(exchange);
            localBalance = balance.multiply(exchange);
        } else {
            localDebitAmt = debitAmt.divide(exchange, 20, 4);
            localCreditAmt = creditAmt.divide(exchange, 20, 4);
            localBalance = balance.divide(exchange, 20, 4);
        }
        DirectionEnum direction = balance.compareTo(CasConstants.ZERO) == 0 ? DirectionEnum.Balance : (balance.compareTo(CasConstants.ZERO) > 0 ? DirectionEnum.Debit : DirectionEnum.Credit);
        tableRow.addCell(COL_DC).setValue((Object)direction);
        tableRow.addCell(COL_LOCAL_DEBIT).setValue(localDebitAmt);
        tableRow.addCell(COL_LOCAL_CREDIT).setValue(localCreditAmt);
        if (!glDc) {
            tableRow.addCell(COL_LOCAL_BALANCE).setValue(localBalance.abs());
            tableRow.addCell(COL_BALANCE).setValue(balance.abs());
        } else {
            if (dc != null && !dc.getAlias().equals(direction.getAlias()) && !direction.equals((Object)DirectionEnum.Balance)) {
                tableRow.addCell(COL_DC).setValue(dc);
            }
            tableRow.addCell(COL_LOCAL_BALANCE).setValue(localBalance);
            tableRow.addCell(COL_BALANCE).setValue(balance);
        }
    }

    public static void fillTotal(Context ctx, CompanyOrgUnitInfo companyInfo, int year, int periodNumber, Date date, QueryTableRow tableRow, BigDecimal exchange, BigDecimal debitAmt, BigDecimal creditAmt, BigDecimal balance, boolean isCurEqualsBasecur, String description, ConvertModeEnum convertMode, BalanceDirectionEnum dc, boolean glDc) throws EASBizException, BOSException {
        tableRow.addCell(COL_DESCRIPTION).setValue(description);
        tableRow.addCell("debitAmount").setValue(debitAmt);
        tableRow.addCell("creditAmount").setValue(creditAmt);
        if (date == null) {
            PeriodInfo endPeriod = BankJournalWebUtil.getPeriodInfo(ctx, year, periodNumber, companyInfo);
            tableRow.addCell(COL_CREATE_DATE).setValue(Constants.FORMAT_DAY.format(endPeriod.getEndDate()));
        } else {
            tableRow.addCell(COL_CREATE_DATE).setValue(Constants.FORMAT_DAY.format(date));
        }
        BankJournalWebUtil.fillLocalCurrencyDataForTotal(ctx, tableRow, exchange, debitAmt, creditAmt, balance, isCurEqualsBasecur, convertMode, dc, glDc);
    }

    private static Set getSharedAcctSet(Context ctx, boolean chkMulUnionQuery, AccountBankInfo accountBank) throws BOSException {
        HashSet<String> idSet = new HashSet<String>();
        if (chkMulUnionQuery) {
            String id;
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            if (2 == accountBank.getShareType().getValue()) {
                id = accountBank.getShareAcct().getId().toString();
                filter.getFilterItems().add(new FilterItemInfo(COL_ID, (Object)id));
            } else if (1 == accountBank.getShareType().getValue()) {
                id = accountBank.getId().toString();
                filter.getFilterItems().add(new FilterItemInfo("bankAccount.id", (Object)id));
            }
            SharedAcctCollection colls = SharedAcctFactory.getLocalInstance((Context)ctx).getSharedAcctCollection(view);
            idSet.add(colls.get(0).getBankAccount().getId().toString());
            for (int index = 0; index < colls.get(0).getEntries().size(); ++index) {
                SharedAcctEntriesInfo info = colls.get(0).getEntries().get(index);
                idSet.add(info.getAccountBank().getId().toString());
            }
        } else {
            idSet.add(accountBank.getId().toString());
        }
        return idSet;
    }

    private static Set getAccountSet(Context ctx, boolean chkMulUnionQuery, Set accountBankSet, AccountViewInfo account, String acctTableId) throws BOSException {
        HashSet<String> acctSet = new HashSet<String>();
        if (chkMulUnionQuery && accountBankSet.size() > 1) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo(COL_ID, (Object)accountBankSet, CompareType.INCLUDE));
            AccountBankCollection acctBankColl = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankCollection(view);
            acctBankColl = FMHelper.getJouranlBalanceAcctBank(null, (AccountBankCollection)acctBankColl, null, (String)acctTableId);
            for (int index = 0; index < acctBankColl.size(); ++index) {
                acctSet.add(acctBankColl.get(index).getAccount().getId().toString());
            }
        } else {
            acctSet.add(account.getId().toString());
        }
        return acctSet;
    }

    public static IRowSet getRowset(Context ctx, IMetaDataPK mainQueryPK, BankJournalWebFilterParam param) throws BOSException, EASBizException {
        String sql;
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("type", (Object)new Integer(2), CompareType.EQUALS));
        if (param.isByDay()) {
            if (param.getToDate() != null) {
                filterInfo.getFilterItems().add(new FilterItemInfo(COL_CREATE_DATE, (Object)DateTimeUtils.truncateDate((Date)param.getToDate()), CompareType.LESS_EQUALS));
            }
            if (param.getFromDate() != null) {
                filterInfo.getFilterItems().add(new FilterItemInfo(COL_CREATE_DATE, (Object)DateTimeUtils.truncateDate((Date)param.getFromDate()), CompareType.GREATER_EQUALS));
            }
        } else {
            CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(param.getCompanyId()));
            String periodTypeId = companyInfo.getAccountPeriodType().getId().toString();
            sql = BankJournalWebUtil.getPeriodCollSQL(periodTypeId, param.getBeginYear(), param.getBeginMonth(), param.getEndYear(), param.getEndMonth());
            filterInfo.getFilterItems().add(new FilterItemInfo("period.id", (Object)sql, CompareType.INNER));
        }
        EntityViewInfo mainQuery = new EntityViewInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("currency.id", (Object)param.getCurrencyId()));
        filterInfo.getFilterItems().add(new FilterItemInfo("accountBank.id", param.getAccountBankIds(), CompareType.INCLUDE));
        if (param.getAccountViewIds() != null && param.getAccountViewIds().size() > 0) {
            filterInfo.getFilterItems().add(new FilterItemInfo("accountView.id", param.getAccountViewIds(), CompareType.INCLUDE));
        }
        if (param.getCashierIds() != null && param.getCashierIds().length != 0) {
            filterInfo.getFilterItems().add(new FilterItemInfo("cashier.id", new HashSet(Arrays.asList((Object[])param.getCashierIds())), CompareType.INCLUDE));
        }
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)mainQueryPK);
        mainQuery.getSorter().add(new SorterItemInfo("createTime"));
        mainQuery.getSorter().add(new SorterItemInfo("lineNo"));
        mainQuery.setFilter(filterInfo);
        exec.setObjectView(mainQuery);
        sql = exec.getSQL();
        IRowSet rs = exec.executeQuery();
        return rs;
    }

    public static PeriodInfo getPeriodInfo(Context ctx, int year, int periodNumber, CompanyOrgUnitInfo companyInfo) throws EASBizException, BOSException {
        TreeMap yearMap;
        PeriodCollection pc;
        ObjectUuidPK companyPK = new ObjectUuidPK(companyInfo.getId());
        if (periodCache == null || !periodCache.containsKey(companyPK)) {
            BankJournalWebUtil.cachePeriod(ctx, companyInfo);
        }
        if ((pc = (PeriodCollection)(yearMap = (TreeMap)periodCache.get(companyPK)).get(new Integer(year))) == null) {
            return null;
        }
        if (pc.get(periodNumber - 1) != null && pc.get(periodNumber - 1).getPeriodNumber() == periodNumber) {
            return pc.get(periodNumber - 1);
        }
        PeriodInfo info = null;
        for (int i = 0; i < pc.size(); ++i) {
            info = pc.get(i);
            if (info.getPeriodNumber() != periodNumber) continue;
            return info;
        }
        return null;
    }

    public static PeriodInfo getNextPeriodInfo(Context ctx, CompanyOrgUnitInfo companyInfo, PeriodInfo period) throws EASBizException, BOSException {
        TreeMap yearMap;
        PeriodCollection pc;
        if (period == null) {
            return null;
        }
        ObjectUuidPK companyPK = new ObjectUuidPK(companyInfo.getId());
        if (periodCache == null || !periodCache.containsKey(companyPK)) {
            BankJournalWebUtil.cachePeriod(ctx, companyInfo);
        }
        if ((pc = (PeriodCollection)(yearMap = (TreeMap)periodCache.get(companyPK)).get(new Integer(period.getPeriodYear()))) == null) {
            return null;
        }
        PeriodInfo periodInfo = null;
        for (int i = 0; i < pc.size(); ++i) {
            periodInfo = pc.get(i);
            if (periodInfo.getPeriodYear() != period.getPeriodYear() || periodInfo.getPeriodNumber() != period.getPeriodNumber()) continue;
            if (i == pc.size() - 1) {
                pc = (PeriodCollection)yearMap.get(new Integer(period.getPeriodYear() + 1));
                if (pc == null) {
                    return null;
                }
                return pc.get(0);
            }
            return pc.get(i + 1);
        }
        return null;
    }

    public static void setLocalColumnHided(QueryTable queryTable, boolean isHide) {
        if (isHide) {
            queryTable.getHidenColumns().add(COL_EXCHANGE);
            queryTable.getHidenColumns().add(COL_LOCAL_DEBIT);
            queryTable.getHidenColumns().add(COL_LOCAL_CREDIT);
            queryTable.getHidenColumns().add(COL_LOCAL_BALANCE);
        }
    }

    public static BigDecimal getYearStartAmount(Context ctx, CashDataSourceEnum dataSource, String companyId, String accountId, String accountBankIds, String currencyId, CashDataTypeEnum dataType) throws EASBizException, BOSException, SQLException {
        CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
        company.setId(BOSUuid.read((String)companyId));
        PeriodInfo startPeriod = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)company);
        if (startPeriod == null) {
            return CasConstants.ZERO;
        }
        StringBuffer sql = new StringBuffer();
        if (dataType.equals((Object)CashDataTypeEnum.JF)) {
            sql.append("select FDebitStartAmt result from T_CAS_JournalBalance where ");
        } else if (dataType.equals((Object)CashDataTypeEnum.DF)) {
            sql.append("select FCreditStartAmt result from T_CAS_JournalBalance where ");
        } else {
            return SysConstant.BIGZERO;
        }
        sql.append("FCompanyId='").append(companyId).append("' and FCurrencyId ='").append(currencyId).append("' and FPeriodId='").append(startPeriod.getId().toString()).append("'");
        if (dataSource.getValue() == 3) {
            sql.append("and FType= 3");
        } else if (dataSource.getValue() == 1) {
            sql.append("and FType= 2");
        } else {
            sql.append("and FType= 1");
        }
        if (!dataSource.equals((Object)CashDataSourceEnum.C) && !dataSource.equals((Object)CashDataSourceEnum.S) && accountBankIds != null && accountBankIds.length() > 0) {
            sql.append(" and FAccountBankID ='").append(accountBankIds + "'");
        }
        if (accountId != null) {
            sql.append(" and FAccountViewId ='").append(accountId).append("'");
        }
        sql.append(" and FIsInit =1");
        ISQLExecutor executor = SQLExecutorFactory.getLocalInstance((Context)ctx, (String)sql.toString());
        IRowSet rowSet = executor.executeSQL();
        BigDecimal result = SysConstant.BIGZERO;
        if (rowSet.next()) {
            result = rowSet.getBigDecimal("result");
        }
        return result;
    }

    public static void fetchJournalData(Context ctx, BankJournalWebFilterParam para, QueryTable queryTable) throws SQLException, EASBizException, BOSException {
        PeriodInfo cPeriod;
        PeriodInfo temNextPeriodInfo;
        BigDecimal exchange;
        Timestamp tempDate;
        PeriodInfo period;
        BigDecimal exchange2;
        PeriodInfo Period;
        QueryTableRow tableRow;
        BigDecimal exchange3;
        Timestamp tempDate2;
        PeriodInfo period2;
        int endPeriod;
        int endYear;
        int beginPeriod;
        int beginYear;
        Date beginDate;
        String DAY_TOTAL = EASCommonResource.getString((String)resourcePath, (String)"DayTotal", (Locale)ctx.getLocale());
        String YEAR_TOTAL = EASCommonResource.getString((String)resourcePath, (String)"YearTotal", (Locale)ctx.getLocale());
        String PERIOD_TOTAL = EASCommonResource.getString((String)resourcePath, (String)"MonthTotal", (Locale)ctx.getLocale());
        String YEAR_BALANCE = EASCommonResource.getString((String)resourcePath, (String)"YearBalance", (Locale)ctx.getLocale());
        String BEGIN_BALANCE = EASCommonResource.getString((String)resourcePath, (String)"BeginBalance", (Locale)ctx.getLocale());
        BOSLocaleUtil.setDefaultLocale((Locale)ctx.getLocale());
        CurrencyInfo sourceCurrency = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(para.getCurrencyId()));
        String accountBankNumber = para.getAccountBankNumber();
        String accountBankId = para.getAccountBankId();
        String accountNumber = para.getAccountNumber();
        CashDataSourceEnum dataSourceType = para.getDataSourceType();
        AccountBankInfo accountBank = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankInfo((IObjectPK)new ObjectUuidPK(para.getAccountBankId()));
        Set cashierIDSet = FMHelper.Array2Set((String[])para.getCashierIds());
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("accountBank.id"));
        sic.add(new SelectorItemInfo("accountBank.name"));
        sic.add(new SelectorItemInfo("accountBank.number"));
        sic.add(new SelectorItemInfo("baseCurrency.id"));
        sic.add(new SelectorItemInfo("baseCurrency.name"));
        sic.add(new SelectorItemInfo("baseCurrency.precision"));
        sic.add(new SelectorItemInfo("baseExchangeTable"));
        sic.add(new SelectorItemInfo("accountTable.id"));
        CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(para.getCompanyId()), sic);
        BigDecimal rate = JournalWebUtil.getExchange(ctx, companyInfo, sourceCurrency, null, para.getToDate());
        if (EmptyUtil.isEmpty((Object)rate)) {
            throw new BOSException(CASWebUtil.getResource(ctx, "com.kingdee.eas.fi.cas.CasResources", "NoExchange"));
        }
        long beginDateLong = para.getFromDate() == null ? -1L : para.getFromDate().getTime();
        long endDateLong = para.getToDate() == null ? -1L : para.getToDate().getTime();
        FetchAccTableParam accTableParam = new FetchAccTableParam(para.getCompanyId(), para.getBeginYear(), para.getBeginMonth(), para.getEndYear(), para.getEndMonth(), beginDateLong, endDateLong, para.isByDay());
        String acctTableId = JournalWebUtil.getDisplayAcctTable(ctx, accTableParam);
        para.setAcctTableId(acctTableId);
        AccountBankCollection acctBankColl = new AccountBankCollection();
        acctBankColl.add(accountBank);
        acctBankColl = FMHelper.getJouranlBalanceAcctBank((Context)ctx, (AccountBankCollection)acctBankColl, null, (String)para.getAcctTableId());
        accountBank = acctBankColl.get(0);
        accountBank = JournalWebUtil.getJouranlBalanceAcctBank(ctx, accountBank, null, acctTableId);
        BalanceDirectionEnum dc = null;
        AccountViewInfo account = null;
        if (accountBank.getAccount() != null) {
            account = new AccountViewInfo();
            account = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewInfo((IObjectPK)new ObjectUuidPK(accountBank.getAccount().getId().toString()));
            dc = account.getDC();
        }
        boolean glDc = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("GL_005", (IObjectPK)new ObjectUuidPK(companyInfo.getId()));
        Set accountBankSet = BankJournalWebUtil.getSharedAcctSet(ctx, para.isChkMulUnionQuery(), accountBank);
        para.setAccountBankIds(accountBankSet);
        Set accountSet = BankJournalWebUtil.getAccountSet(ctx, para.isChkMulUnionQuery(), accountBankSet, account, para.getAcctTableId());
        para.setAccountViewIds(accountSet);
        MetaDataPK mainQueryPk = new MetaDataPK("com.kingdee.eas.fi.cas", "BankJournalWebQuery");
        IRowSet rs = BankJournalWebUtil.getRowset(ctx, (IMetaDataPK)mainQueryPk, para);
        boolean isShowBeginBalance = para.isShowBeginBalance();
        boolean isShowDayTotal = para.isShowDayTotal();
        boolean isShowPeriodTotal = para.isShowMonthTotal();
        boolean isShowYearTotal = para.isShowYearTotal();
        PeriodInfo beginPeriodInfo = null;
        PeriodInfo endPeriodInfo = null;
        String currencyNumber = sourceCurrency.getNumber();
        boolean isStart = SystemStatusCtrolUtils.isStart((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)companyInfo);
        PeriodInfo startPeriod = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)companyInfo);
        int startPeriodYear = startPeriod.getPeriodYear();
        boolean isByDay = para.isByDay();
        if (isByDay) {
            if (para.getFromDate().before(startPeriod.getBeginDate())) {
                beginPeriodInfo = startPeriod;
                beginDate = beginPeriodInfo.getBeginDate();
            } else {
                beginPeriodInfo = BankJournalWebUtil.getPeriodInfo(ctx, para.getFromDate(), companyInfo);
                beginDate = para.getFromDate();
            }
            if (para.getToDate().before(startPeriod.getBeginDate())) {
                return;
            }
            endPeriodInfo = BankJournalWebUtil.getPeriodInfo(ctx, para.getToDate(), companyInfo);
            if (endPeriodInfo == null) {
                endPeriodInfo = BankJournalWebUtil.getLastPeriodInfo(ctx, companyInfo);
            }
            beginYear = beginPeriodInfo.getPeriodYear();
            beginPeriod = beginPeriodInfo.getPeriodNumber();
            endYear = endPeriodInfo.getPeriodYear();
            endPeriod = endPeriodInfo.getPeriodNumber();
        } else {
            beginYear = para.getBeginYear();
            beginPeriod = para.getBeginMonth();
            endYear = para.getEndYear();
            endPeriod = para.getEndMonth();
            beginPeriodInfo = BankJournalWebUtil.getPeriodInfo(ctx, beginYear, beginPeriod, companyInfo);
            endPeriodInfo = BankJournalWebUtil.getPeriodInfo(ctx, endYear, endPeriod, companyInfo);
            beginDate = beginPeriodInfo.getBeginDate();
        }
        AccountTableInfo accountTable = AccountTableFactory.getLocalInstance((Context)ctx).getAccountTableInfo((IObjectPK)new ObjectUuidPK(para.getAcctTableId()));
        String acctTableNumber = accountTable.getNumber();
        ConvertModeEnum convertMode = JournalWebUtil.getExchangeConvertMode(ctx, companyInfo, sourceCurrency, null);
        boolean isCurEqualsBasecur = sourceCurrency.getId().equals((Object)companyInfo.getBaseCurrency().getId());
        boolean isShowLocalCurrency = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("CS003", (IObjectPK)new ObjectUuidPK(companyInfo.getId().toString()));
        BigDecimal exchange1 = JournalWebUtil.getExchange(ctx, companyInfo, sourceCurrency, null, null);
        boolean isHide = true;
        isHide = isCurEqualsBasecur || !isShowLocalCurrency || !isCurEqualsBasecur && exchange1.compareTo(Constants.ONE) == 0;
        if (!isHide) {
            queryTable.setBaseCurrPrecision(companyInfo.getBaseCurrency().getPrecision());
        }
        queryTable.setSrcCurrPrecision(sourceCurrency.getPrecision());
        BankJournalWebUtil.setLocalColumnHided(queryTable, isHide);
        BigDecimal debitAmt = null;
        BigDecimal creditAmt = null;
        BigDecimal balance = null;
        BigDecimal tmpDayDebitTotal = CasConstants.ZERO;
        BigDecimal tmpDayCreditTotal = CasConstants.ZERO;
        BigDecimal tmpMonthDebitTotal = CasConstants.ZERO;
        BigDecimal tmpMonthCreditTotal = CasConstants.ZERO;
        BigDecimal tmpYearDebitTotal = CasConstants.ZERO;
        BigDecimal tmpYearCreditTotal = CasConstants.ZERO;
        BigDecimal yearDebitAmt = CasConstants.ZERO;
        BigDecimal yearCreditAmt = CasConstants.ZERO;
        if (isStart && beginYear == startPeriodYear) {
            yearDebitAmt = BankJournalWebUtil.getYearStartAmount(ctx, dataSourceType, companyInfo.getId().toString(), null, accountBankId, sourceCurrency.getId().toString(), CashDataTypeEnum.JF);
            yearCreditAmt = BankJournalWebUtil.getYearStartAmount(ctx, dataSourceType, companyInfo.getId().toString(), null, accountBankId, sourceCurrency.getId().toString(), CashDataTypeEnum.DF);
        }
        CashManagementCashMethod cm = new CashManagementCashMethod();
        CashManagementCashMethodParam pm6 = new CashManagementCashMethodParam(companyInfo.getNumber(), dataSourceType, acctTableNumber, null, accountBankNumber, currencyNumber, beginDate, beginDate, CashDataTypeEnum.C, false, para.isChkMulUnionQuery());
        CashManagementCashMethodParam pm7 = new CashManagementCashMethodParam(companyInfo.getNumber(), dataSourceType, acctTableNumber, null, accountBankNumber, currencyNumber, startPeriod.getBeginDate(), startPeriod.getBeginDate(), CashDataTypeEnum.C, false, para.isChkMulUnionQuery());
        CashManagementCashMethodParam pm8 = new CashManagementCashMethodParam(companyInfo.getNumber(), dataSourceType, acctTableNumber, null, accountBankNumber, currencyNumber, beginDate, beginDate, CashDataTypeEnum.C, false, para.isChkMulUnionQuery());
        cm.addParam(pm6);
        cm.addParam(pm7);
        cm.addParam(pm8);
        CashManagementCashMethodParam pm1 = new CashManagementCashMethodParam(companyInfo.getNumber(), CashDataSourceEnum.B, acctTableNumber, null, accountBankNumber, currencyNumber, beginPeriodInfo.getBeginDate(), DateHelper.getBeforeDay((Date)para.getFromDate()), CashDataTypeEnum.JF, false, para.isChkMulUnionQuery());
        CashManagementCashMethodParam pm2 = new CashManagementCashMethodParam(companyInfo.getNumber(), CashDataSourceEnum.B, acctTableNumber, null, accountBankNumber, currencyNumber, beginPeriodInfo.getBeginDate(), DateHelper.getBeforeDay((Date)para.getFromDate()), CashDataTypeEnum.DF, false, para.isChkMulUnionQuery());
        cm.addParam(pm1);
        cm.addParam(pm2);
        cm.fetchAllData(ctx);
        balance = isByDay ? cm.getValue(pm6) : BankJournalWebUtil.getBeginBalance(ctx, companyInfo, acctTableNumber, currencyNumber, accountNumber, accountBankNumber, beginPeriodInfo, dataSourceType, para.isChkMulUnionQuery());
        BigDecimal beginYearDebitTotal = BankJournalWebUtil.getYearTotal(ctx, companyInfo, acctTableNumber, currencyNumber, accountNumber, accountBankNumber, beginYear, beginPeriod, dataSourceType, CashDataTypeEnum.JF, para.isChkMulUnionQuery());
        BigDecimal beginYearCreditTotal = BankJournalWebUtil.getYearTotal(ctx, companyInfo, acctTableNumber, currencyNumber, accountNumber, accountBankNumber, beginYear, beginPeriod, dataSourceType, CashDataTypeEnum.DF, para.isChkMulUnionQuery());
        BigDecimal adebitTotal = FMConstants.ZERO;
        BigDecimal acreditTotal = FMConstants.ZERO;
        if (isByDay && para.getFromDate().compareTo(beginPeriodInfo.getBeginDate()) > 0) {
            adebitTotal = cm.getValue(pm1);
            acreditTotal = cm.getValue(pm2);
            if (cashierIDSet == null) {
                tmpMonthDebitTotal = adebitTotal;
                tmpMonthCreditTotal = acreditTotal;
            }
        }
        if (beginYear == startPeriod.getPeriodYear() && beginPeriod == startPeriod.getPeriodNumber()) {
            QueryTableRow tableRow2 = queryTable.addRow();
            BigDecimal yearBeginBalance = CasConstants.ZERO;
            if (isStart) {
                if (isByDay) {
                    BigDecimal b = cm.getValue(pm7);
                    if (b == null) {
                        b = CasConstants.ZERO;
                    }
                    yearBeginBalance = b.add(yearCreditAmt).subtract(yearDebitAmt);
                } else {
                    yearBeginBalance = balance.add(yearCreditAmt).subtract(yearDebitAmt);
                }
            }
            PeriodInfo period3 = BankJournalWebUtil.getPeriodInfo(ctx, beginYear, beginPeriod, companyInfo);
            Timestamp tempDate3 = period3.getEndDate();
            BigDecimal exchange4 = JournalWebUtil.getExchange(ctx, companyInfo, sourceCurrency, null, DateUtil.getBeforeDay((Date)tempDate3));
            BankJournalWebUtil.fillBalance(ctx, companyInfo, beginYear, beginPeriod, tableRow2, exchange4, yearBeginBalance, isCurEqualsBasecur, YEAR_BALANCE, convertMode, dc, glDc);
        }
        if (rs == null || rs.size() == 0) {
            adebitTotal = CasConstants.ZERO;
            acreditTotal = CasConstants.ZERO;
            if (beginYear == startPeriodYear) {
                tmpYearDebitTotal = beginYearDebitTotal.add(yearDebitAmt);
                tmpYearCreditTotal = beginYearCreditTotal.add(yearCreditAmt);
            } else {
                tmpYearDebitTotal = beginYearDebitTotal;
                tmpYearCreditTotal = beginYearCreditTotal;
            }
            if (isByDay && para.getFromDate().compareTo(beginPeriodInfo.getBeginDate()) > 0) {
                tmpYearDebitTotal = tmpYearDebitTotal.add(adebitTotal);
                tmpYearCreditTotal = tmpYearCreditTotal.add(acreditTotal);
            }
            if (isByDay) {
                BankJournalWebUtil.fillAdjustRow_NewDay(ctx, adebitTotal, acreditTotal, tmpYearDebitTotal, tmpYearCreditTotal, queryTable, isShowBeginBalance, isShowPeriodTotal, isShowYearTotal, companyInfo, isCurEqualsBasecur, balance, beginPeriodInfo, endPeriodInfo, convertMode, para.getFromDate(), para.getToDate(), sourceCurrency, dc, glDc);
            } else {
                BankJournalWebUtil.fillAdjustRow_New(ctx, adebitTotal, acreditTotal, tmpYearDebitTotal, tmpYearCreditTotal, queryTable, isShowBeginBalance, isShowPeriodTotal, isShowYearTotal, companyInfo, isCurEqualsBasecur, balance, beginPeriodInfo, endPeriodInfo, convertMode, sourceCurrency, dc, glDc);
            }
            return;
        }
        java.sql.Date date = null;
        int year = beginYear;
        int periodNumber = beginPeriod;
        int tmpYear = beginYear;
        int tmpPeriodNumber = beginPeriod;
        Date tmpdate = null;
        if (rs.next()) {
            date = rs.getDate(COL_CREATE_DATE);
            year = rs.getInt(PERIOD_YEAR);
            periodNumber = rs.getInt(PERIOD_NUMBER);
            tmpYear = rs.getInt(PERIOD_YEAR);
            tmpPeriodNumber = rs.getInt(PERIOD_NUMBER);
            tmpdate = rs.getDate(COL_CREATE_DATE);
            rs.beforeFirst();
        }
        if (beginYear < year || beginYear == year && beginPeriod < periodNumber) {
            endPeriodInfo = BankJournalWebUtil.getPeriodInfo(ctx, year, periodNumber, companyInfo);
            endPeriodInfo = BankJournalWebUtil.getPrePeriodInfo(ctx, companyInfo, endPeriodInfo);
            if (beginYear == startPeriodYear) {
                tmpYearDebitTotal = beginYearDebitTotal.add(yearDebitAmt);
                tmpYearCreditTotal = beginYearCreditTotal.add(yearCreditAmt);
            } else {
                tmpYearDebitTotal = beginYearDebitTotal;
                tmpYearCreditTotal = beginYearCreditTotal;
            }
            BankJournalWebUtil.fillAdjustRow_New(ctx, CasConstants.ZERO, CasConstants.ZERO, tmpYearDebitTotal, tmpYearCreditTotal, queryTable, isShowBeginBalance, isShowPeriodTotal, isShowYearTotal, companyInfo, isCurEqualsBasecur, balance, beginPeriodInfo, endPeriodInfo, convertMode, sourceCurrency, dc, glDc);
        }
        if (isShowBeginBalance) {
            QueryTableRow tableRow3 = queryTable.addRow();
            period2 = BankJournalWebUtil.getPeriodInfo(ctx, year, periodNumber, companyInfo);
            tempDate2 = period2.getEndDate();
            exchange3 = JournalWebUtil.getExchange(ctx, companyInfo, sourceCurrency, null, DateUtil.getBeforeDay((Date)tempDate2));
            BankJournalWebUtil.fillBalance(ctx, companyInfo, year, periodNumber, tableRow3, exchange3, balance, isCurEqualsBasecur, BEGIN_BALANCE, convertMode, dc, glDc);
        }
        BigDecimal dayBalance = balance;
        if (isByDay && rs != null && rs.size() != 0) {
            dayBalance = balance = cm.getValue(pm8);
        }
        if (year == startPeriodYear) {
            tmpYearDebitTotal = beginYearDebitTotal.add(yearDebitAmt);
            tmpYearCreditTotal = beginYearCreditTotal.add(yearCreditAmt);
        } else {
            tmpYearDebitTotal = beginYearDebitTotal;
            tmpYearCreditTotal = beginYearCreditTotal;
        }
        tmpYear = beginYear;
        while (rs.next()) {
            QueryTableRow tableRow4;
            year = rs.getInt(PERIOD_YEAR);
            periodNumber = rs.getInt(PERIOD_NUMBER);
            date = rs.getDate(COL_CREATE_DATE);
            debitAmt = rs.getBigDecimal("debitAmount");
            creditAmt = rs.getBigDecimal("creditAmount");
            if (debitAmt == null) {
                debitAmt = CasConstants.ZERO;
            }
            if (creditAmt == null) {
                creditAmt = CasConstants.ZERO;
            }
            if (date.compareTo(tmpdate) == 0) {
                tmpDayDebitTotal = tmpDayDebitTotal.add(debitAmt);
                tmpDayCreditTotal = tmpDayCreditTotal.add(creditAmt);
            }
            if (date.compareTo(tmpdate) != 0) {
                if (isShowDayTotal) {
                    tableRow = queryTable.addRow();
                    if (tmpdate == null) {
                        Period = BankJournalWebUtil.getPeriodInfo(ctx, tmpYear, tmpPeriodNumber, companyInfo);
                        tmpdate = Period.getEndDate();
                    }
                    exchange2 = JournalWebUtil.getExchange(ctx, companyInfo, sourceCurrency, null, tmpdate);
                    BankJournalWebUtil.fillTotal(ctx, companyInfo, tmpYear, tmpPeriodNumber, tmpdate, tableRow, exchange2, tmpDayDebitTotal, tmpDayCreditTotal, balance, isCurEqualsBasecur, DAY_TOTAL, convertMode, dc, glDc);
                }
                tmpMonthDebitTotal = tmpMonthDebitTotal.add(tmpDayDebitTotal);
                tmpMonthCreditTotal = tmpMonthCreditTotal.add(tmpDayCreditTotal);
                tmpDayDebitTotal = debitAmt;
                tmpDayCreditTotal = creditAmt;
            }
            if (tmpPeriodNumber != periodNumber) {
                if (isShowPeriodTotal) {
                    tableRow = queryTable.addRow();
                    period = BankJournalWebUtil.getPeriodInfo(ctx, tmpYear, tmpPeriodNumber, companyInfo);
                    tempDate = period.getEndDate();
                    exchange = JournalWebUtil.getExchange(ctx, companyInfo, sourceCurrency, null, tempDate);
                    if (cashierIDSet == null) {
                        BankJournalWebUtil.fillTotal(ctx, companyInfo, tmpYear, tmpPeriodNumber, null, tableRow, exchange, tmpMonthDebitTotal.subtract(adebitTotal), tmpMonthCreditTotal.subtract(acreditTotal), balance, isCurEqualsBasecur, PERIOD_TOTAL, convertMode, dc, glDc);
                        tmpYearDebitTotal = tmpYearDebitTotal.add(tmpMonthDebitTotal).subtract(adebitTotal);
                        tmpYearCreditTotal = tmpYearCreditTotal.add(tmpMonthCreditTotal).subtract(acreditTotal);
                    } else {
                        BankJournalWebUtil.fillTotal(ctx, companyInfo, tmpYear, tmpPeriodNumber, null, tableRow, exchange, tmpMonthDebitTotal, tmpMonthCreditTotal, balance, isCurEqualsBasecur, PERIOD_TOTAL, convertMode, dc, glDc);
                        tmpYearDebitTotal = tmpYearDebitTotal.add(tmpMonthDebitTotal);
                        tmpYearCreditTotal = tmpYearCreditTotal.add(tmpMonthCreditTotal);
                    }
                }
                if (isShowYearTotal) {
                    tableRow = queryTable.addRow();
                    period = BankJournalWebUtil.getPeriodInfo(ctx, tmpYear, tmpPeriodNumber, companyInfo);
                    tempDate = period.getEndDate();
                    exchange = JournalWebUtil.getExchange(ctx, companyInfo, sourceCurrency, null, tempDate);
                    BankJournalWebUtil.fillTotal(ctx, companyInfo, tmpYear, tmpPeriodNumber, null, tableRow, exchange, tmpYearDebitTotal, tmpYearCreditTotal, balance, isCurEqualsBasecur, YEAR_TOTAL, convertMode, dc, glDc);
                    if (tmpYear < endYear || tmpYear == endYear && tmpPeriodNumber < endPeriod) {
                        beginPeriodInfo = BankJournalWebUtil.getPeriodInfo(ctx, tmpYear, tmpPeriodNumber, companyInfo);
                        temNextPeriodInfo = BankJournalWebUtil.getNextPeriodInfo(ctx, companyInfo, beginPeriodInfo);
                        if (temNextPeriodInfo == null) {
                            return;
                        }
                        if ((temNextPeriodInfo.getPeriodYear() < endPeriodInfo.getPeriodYear() || temNextPeriodInfo.getPeriodYear() == endPeriodInfo.getPeriodYear() && endPeriodInfo.getPeriodNumber() >= temNextPeriodInfo.getPeriodNumber()) && beginPeriodInfo.getPeriodYear() < temNextPeriodInfo.getPeriodYear()) {
                            tableRow = queryTable.addRow();
                            PeriodInfo period22 = BankJournalWebUtil.getPeriodInfo(ctx, temNextPeriodInfo.getPeriodYear(), temNextPeriodInfo.getPeriodNumber(), companyInfo);
                            Timestamp tempDate22 = period22.getEndDate();
                            BigDecimal exchange22 = JournalWebUtil.getExchange(ctx, companyInfo, sourceCurrency, null, DateUtil.getBeforeDay((Date)tempDate22));
                            BankJournalWebUtil.fillBalance(ctx, companyInfo, temNextPeriodInfo.getPeriodYear(), temNextPeriodInfo.getPeriodNumber(), tableRow, exchange22, balance, isCurEqualsBasecur, YEAR_BALANCE, convertMode, dc, glDc);
                            tmpYearDebitTotal = CasConstants.ZERO;
                            tmpYearCreditTotal = CasConstants.ZERO;
                        }
                    }
                }
                beginPeriodInfo = BankJournalWebUtil.getPeriodInfo(ctx, tmpYear, tmpPeriodNumber, companyInfo);
                beginPeriodInfo = BankJournalWebUtil.getNextPeriodInfo(ctx, companyInfo, beginPeriodInfo);
                endPeriodInfo = BankJournalWebUtil.getPeriodInfo(ctx, year, periodNumber, companyInfo);
                if ((endPeriodInfo = BankJournalWebUtil.getPrePeriodInfo(ctx, companyInfo, endPeriodInfo)) == null) {
                    endPeriodInfo = BankJournalWebUtil.getPeriodInfo(ctx, year, periodNumber, companyInfo);
                }
                BankJournalWebUtil.fillAdjustRow_New(ctx, CasConstants.ZERO, CasConstants.ZERO, tmpYearDebitTotal, tmpYearCreditTotal, queryTable, isShowBeginBalance, isShowPeriodTotal, isShowYearTotal, companyInfo, isCurEqualsBasecur, balance, beginPeriodInfo, endPeriodInfo, convertMode, sourceCurrency, dc, glDc);
                tmpMonthDebitTotal = CasConstants.ZERO;
                tmpMonthCreditTotal = CasConstants.ZERO;
            }
            if (tmpYear != year) {
                tmpYearDebitTotal = CasConstants.ZERO;
                tmpYearCreditTotal = CasConstants.ZERO;
            }
            period2 = BankJournalWebUtil.getPeriodInfo(ctx, year, periodNumber, companyInfo);
            tempDate2 = period2.getEndDate();
            exchange3 = JournalWebUtil.getExchange(ctx, companyInfo, sourceCurrency, null, DateUtil.getBeforeDay((Date)tempDate2));
            if (tmpYear != year) {
                tableRow4 = queryTable.addRow();
                BankJournalWebUtil.fillBalance(ctx, companyInfo, year, periodNumber, tableRow4, exchange3, balance, isCurEqualsBasecur, YEAR_BALANCE, convertMode, dc, glDc);
            }
            if (tmpPeriodNumber != periodNumber && isShowBeginBalance) {
                tableRow4 = queryTable.addRow();
                BankJournalWebUtil.fillBalance(ctx, companyInfo, year, periodNumber, tableRow4, exchange3, balance, isCurEqualsBasecur, BEGIN_BALANCE, convertMode, dc, glDc);
            }
            balance = balance.add(debitAmt).subtract(creditAmt);
            BigDecimal exchange23 = JournalWebUtil.getExchange(ctx, companyInfo, sourceCurrency, null, new Date(rs.getDate(COL_BIZDATE).getTime()));
            BankJournalWebUtil.fillOneJournalRow(ctx, queryTable, rs, exchange23, isCurEqualsBasecur, debitAmt, creditAmt, balance, convertMode, dc, glDc);
            tmpdate = date;
            tmpYear = year;
            tmpPeriodNumber = periodNumber;
        }
        if (isShowDayTotal) {
            tableRow = queryTable.addRow();
            if (tmpdate == null) {
                Period = BankJournalWebUtil.getPeriodInfo(ctx, tmpYear, tmpPeriodNumber, companyInfo);
                tmpdate = Period.getEndDate();
            }
            exchange2 = JournalWebUtil.getExchange(ctx, companyInfo, sourceCurrency, null, tmpdate);
            BankJournalWebUtil.fillTotal(ctx, companyInfo, tmpYear, tmpPeriodNumber, date, tableRow, exchange2, tmpDayDebitTotal, tmpDayCreditTotal, balance, isCurEqualsBasecur, DAY_TOTAL, convertMode, dc, glDc);
        }
        if (isByDay) {
            period2 = BankJournalWebUtil.getPeriodInfo(ctx, year, periodNumber, companyInfo);
            Date endDate = new Date(period2.getEndDate().getTime());
            if (endDate.after(para.getToDate())) {
                endDate = para.getToDate();
            }
            CashManagementCashMethodParam pm3 = new CashManagementCashMethodParam(companyInfo.getNumber(), dataSourceType, acctTableNumber, null, accountBankNumber, currencyNumber, period2.getBeginDate(), endDate, CashDataTypeEnum.Y, false, para.isChkMulUnionQuery());
            CashManagementCashMethodParam pm4 = new CashManagementCashMethodParam(companyInfo.getNumber(), dataSourceType, acctTableNumber, null, accountBankNumber, currencyNumber, period2.getBeginDate(), endDate, CashDataTypeEnum.JF, false, para.isChkMulUnionQuery());
            CashManagementCashMethodParam pm5 = new CashManagementCashMethodParam(companyInfo.getNumber(), dataSourceType, acctTableNumber, null, accountBankNumber, currencyNumber, period2.getBeginDate(), endDate, CashDataTypeEnum.DF, false, para.isChkMulUnionQuery());
            cm.addParam(pm3);
            cm.addParam(pm4);
            cm.addParam(pm5);
            cm.fetchAllData(ctx);
            tmpMonthDebitTotal = tmpMonthDebitTotal.add(tmpDayDebitTotal);
            tmpMonthCreditTotal = tmpMonthCreditTotal.add(tmpDayCreditTotal);
            if (CashHelper.isTheSameMonth(para.getFromDate(), para.getToDate())) {
                tmpYearDebitTotal = tmpYearDebitTotal.add(tmpMonthDebitTotal).subtract(adebitTotal);
                tmpYearCreditTotal = tmpYearCreditTotal.add(tmpMonthCreditTotal).subtract(acreditTotal);
            }
        } else {
            tmpMonthDebitTotal = tmpMonthDebitTotal.add(tmpDayDebitTotal);
            tmpMonthCreditTotal = tmpMonthCreditTotal.add(tmpDayCreditTotal);
            if (isByDay || !beginPeriodInfo.isIsAdjustPeriod() || !isByDay && beginPeriodInfo.isIsAdjustPeriod() && !endPeriodInfo.equals((Object)beginPeriodInfo)) {
                tmpYearDebitTotal = tmpYearDebitTotal.add(tmpMonthDebitTotal);
                tmpYearCreditTotal = tmpYearCreditTotal.add(tmpMonthCreditTotal);
            }
        }
        if (isShowPeriodTotal) {
            tableRow = queryTable.addRow();
            period = BankJournalWebUtil.getPeriodInfo(ctx, tmpYear, tmpPeriodNumber, companyInfo);
            tempDate = period.getEndDate();
            exchange = JournalWebUtil.getExchange(ctx, companyInfo, sourceCurrency, null, tempDate);
            if (isByDay) {
                cPeriod = BankJournalWebUtil.getPeriodInfo(ctx, tmpYear, tmpPeriodNumber, companyInfo);
                if (cPeriod.getEndDate().compareTo(new Timestamp(para.getToDate().getTime())) > 0) {
                    if (CashHelper.isTheSameMonth(para.getFromDate(), para.getToDate())) {
                        BankJournalWebUtil.fillTotal(ctx, companyInfo, tmpYear, tmpPeriodNumber, para.getToDate(), tableRow, exchange, tmpMonthDebitTotal, tmpMonthCreditTotal, balance, isCurEqualsBasecur, PERIOD_TOTAL, convertMode, dc, glDc);
                    } else {
                        BankJournalWebUtil.fillTotal(ctx, companyInfo, tmpYear, tmpPeriodNumber, para.getToDate(), tableRow, exchange, tmpMonthDebitTotal, tmpMonthCreditTotal, balance, isCurEqualsBasecur, PERIOD_TOTAL, convertMode, dc, glDc);
                    }
                } else if (CashHelper.isTheSameMonth(para.getFromDate(), para.getToDate())) {
                    BankJournalWebUtil.fillTotal(ctx, companyInfo, tmpYear, tmpPeriodNumber, para.getToDate(), tableRow, exchange, tmpMonthDebitTotal.subtract(adebitTotal), tmpMonthCreditTotal.subtract(acreditTotal), balance, isCurEqualsBasecur, PERIOD_TOTAL, convertMode, dc, glDc);
                } else {
                    BankJournalWebUtil.fillTotal(ctx, companyInfo, tmpYear, tmpPeriodNumber, null, tableRow, exchange, tmpMonthDebitTotal, tmpMonthCreditTotal, balance, isCurEqualsBasecur, PERIOD_TOTAL, convertMode, dc, glDc);
                }
            } else {
                BankJournalWebUtil.fillTotal(ctx, companyInfo, tmpYear, tmpPeriodNumber, null, tableRow, exchange, tmpMonthDebitTotal, tmpMonthCreditTotal, balance, isCurEqualsBasecur, PERIOD_TOTAL, convertMode, dc, glDc);
                if (year < endYear || year == endYear && periodNumber < endPeriod) {
                    beginPeriodInfo = BankJournalWebUtil.getPeriodInfo(ctx, year, periodNumber, companyInfo);
                    temNextPeriodInfo = BankJournalWebUtil.getNextPeriodInfo(ctx, companyInfo, beginPeriodInfo);
                    if (temNextPeriodInfo == null) {
                        return;
                    }
                    if ((temNextPeriodInfo.getPeriodYear() < endPeriodInfo.getPeriodYear() || temNextPeriodInfo.getPeriodYear() == endPeriodInfo.getPeriodYear() && endPeriodInfo.getPeriodNumber() >= temNextPeriodInfo.getPeriodNumber()) && beginPeriodInfo.getPeriodYear() < temNextPeriodInfo.getPeriodYear()) {
                        tableRow = queryTable.addRow();
                        BankJournalWebUtil.fillBalance(ctx, companyInfo, temNextPeriodInfo.getPeriodYear(), temNextPeriodInfo.getPeriodNumber(), tableRow, exchange, balance, isCurEqualsBasecur, YEAR_BALANCE, convertMode, dc, glDc);
                        tmpYearDebitTotal = CasConstants.ZERO;
                        tmpYearCreditTotal = CasConstants.ZERO;
                    }
                }
            }
        }
        if (isShowYearTotal) {
            tableRow = queryTable.addRow();
            period = BankJournalWebUtil.getPeriodInfo(ctx, tmpYear, tmpPeriodNumber, companyInfo);
            tempDate = period.getEndDate();
            exchange = JournalWebUtil.getExchange(ctx, companyInfo, sourceCurrency, null, tempDate);
            if (isByDay) {
                cPeriod = BankJournalWebUtil.getPeriodInfo(ctx, tmpYear, tmpPeriodNumber, companyInfo);
                if (cPeriod.getEndDate().compareTo(new Timestamp(para.getToDate().getTime())) > 0) {
                    BankJournalWebUtil.fillTotal(ctx, companyInfo, tmpYear, tmpPeriodNumber, para.getToDate(), tableRow, exchange, tmpYearDebitTotal, tmpYearCreditTotal, balance, isCurEqualsBasecur, YEAR_TOTAL, convertMode, dc, glDc);
                } else {
                    BankJournalWebUtil.fillTotal(ctx, companyInfo, tmpYear, tmpPeriodNumber, null, tableRow, exchange, tmpYearDebitTotal, tmpYearCreditTotal, balance, isCurEqualsBasecur, YEAR_TOTAL, convertMode, dc, glDc);
                }
            } else {
                BankJournalWebUtil.fillTotal(ctx, companyInfo, tmpYear, tmpPeriodNumber, null, tableRow, exchange, tmpYearDebitTotal, tmpYearCreditTotal, balance, isCurEqualsBasecur, YEAR_TOTAL, convertMode, dc, glDc);
            }
        }
        if (year < endYear || year == endYear && periodNumber < endPeriod) {
            beginPeriodInfo = BankJournalWebUtil.getPeriodInfo(ctx, year, periodNumber, companyInfo);
            beginPeriodInfo = BankJournalWebUtil.getNextPeriodInfo(ctx, companyInfo, beginPeriodInfo);
            endPeriodInfo = BankJournalWebUtil.getPeriodInfo(ctx, endYear, endPeriod, companyInfo);
            if (isByDay && !para.getToDate().equals(endPeriodInfo.getEndDate())) {
                endPeriodInfo = BankJournalWebUtil.getPrePeriodInfo(ctx, companyInfo, endPeriodInfo);
            }
            BankJournalWebUtil.fillAdjustRow_New(ctx, CasConstants.ZERO, CasConstants.ZERO, tmpYearDebitTotal, tmpYearCreditTotal, queryTable, isShowBeginBalance, isShowPeriodTotal, isShowYearTotal, companyInfo, isCurEqualsBasecur, balance, beginPeriodInfo, endPeriodInfo, convertMode, sourceCurrency, dc, glDc);
        }
        BigDecimal exchange5 = JournalWebUtil.getExchange(ctx, companyInfo, sourceCurrency, null, beginDate);
        BankJournalWebUtil.setBeginBalanceRowDisc(ctx, queryTable, beginDate, isByDay, exchange5, isCurEqualsBasecur, dayBalance, convertMode, dc, glDc);
    }

    public static void fillLocalCurrencyData(Context ctx, QueryTableRow tableRow, BigDecimal exchange, BigDecimal debitAmt, BigDecimal creditAmt, BigDecimal balance, boolean isCurEqualsBasecur, ConvertModeEnum convertMode, BalanceDirectionEnum dc, boolean glDc) {
        BigDecimal localBalance;
        BigDecimal localCreditAmt;
        BigDecimal localDebitAmt;
        if (isCurEqualsBasecur) {
            localDebitAmt = debitAmt;
            localCreditAmt = creditAmt;
            localBalance = balance;
        } else if (convertMode.equals((Object)ConvertModeEnum.DIRECTEXCHANGERATE)) {
            localDebitAmt = debitAmt.multiply(exchange);
            localCreditAmt = creditAmt.multiply(exchange);
            localBalance = balance.multiply(exchange);
        } else {
            localDebitAmt = debitAmt.divide(exchange, 20, 4);
            localCreditAmt = creditAmt.divide(exchange, 20, 4);
            localBalance = balance.divide(exchange, 20, 4);
        }
        DirectionEnum direction = balance.compareTo(CasConstants.ZERO) == 0 ? DirectionEnum.Balance : (balance.compareTo(CasConstants.ZERO) > 0 ? DirectionEnum.Debit : DirectionEnum.Credit);
        tableRow.addCell(COL_DC).setValue((Object)direction);
        if (localDebitAmt.compareTo(CasConstants.ZERO) != 0) {
            tableRow.addCell(COL_LOCAL_DEBIT).setValue(localDebitAmt);
        }
        if (localCreditAmt.compareTo(CasConstants.ZERO) != 0) {
            tableRow.addCell(COL_LOCAL_CREDIT).setValue(localCreditAmt);
        }
        if (!glDc) {
            tableRow.addCell(COL_LOCAL_BALANCE).setValue(localBalance.abs());
            tableRow.addCell(COL_BALANCE).setValue(balance.abs());
        } else {
            if (dc != null && !dc.getAlias().equals(direction.getAlias()) && !direction.equals((Object)DirectionEnum.Balance)) {
                tableRow.addCell(COL_DC).setValue(dc);
            }
            tableRow.addCell(COL_LOCAL_BALANCE).setValue(localBalance);
            tableRow.addCell(COL_BALANCE).setValue(balance);
        }
    }

    public static void fillOneJournalRow(Context ctx, QueryTable queryTable, IRowSet rs, BigDecimal exchange, boolean isCurEqualsBasecur, BigDecimal debitAmt, BigDecimal creditAmt, BigDecimal balance, ConvertModeEnum convertMode, BalanceDirectionEnum dc, boolean glDc) throws SQLException {
        QueryTableRow tableRow = queryTable.addRow();
        tableRow.addCell(COL_ID).setValue(rs.getString("ID"));
        tableRow.addCell(COL_COMPANY).setValue(rs.getString("company.name"));
        tableRow.addCell(COL_COMPANY_ID).setValue(rs.getString("company.id"));
        tableRow.addCell(COL_BIZDATE).setValue(Constants.FORMAT_DAY.format(rs.getDate(COL_BIZDATE)));
        tableRow.addCell(COL_CREATE_DATE).setValue(Constants.FORMAT_DAY.format(rs.getDate(COL_CREATE_DATE)));
        tableRow.addCell(COL_VOUCHERTYPE).setValue(rs.getString(COL_VOUCHERTYPE));
        tableRow.addCell(COL_VOUCHERNUMBER).setValue(rs.getString(COL_VOUCHERNUMBER));
        tableRow.addCell("bankCheckFlag").setValue(rs.getString("bankCheckFlag"));
        String oppAccount = rs.getString("oppAccountViewNumber");
        if (oppAccount != null) {
            oppAccount = oppAccount + " " + rs.getString("oppAccountViewName");
        }
        tableRow.addCell(COL_OPPACCOUNTNUMBER).setValue(oppAccount);
        tableRow.addCell(COL_BILLTYPE).setValue((Object)BillTypeEnum.getEnum(rs.getInt(COL_BILLTYPE)));
        tableRow.addCell(COL_BILLNUMBER).setValue(rs.getString(COL_BILLNUMBER));
        tableRow.addCell(COL_DESCRIPTION).setValue(rs.getString(COL_DESCRIPTION));
        tableRow.addCell(COL_SETTTYPE).setValue(rs.getString(COL_SETTTYPE));
        tableRow.addCell(COL_SETTNUMBER).setValue(rs.getString(COL_SETTNUMBER));
        if (debitAmt.compareTo(CasConstants.ZERO) != 0) {
            tableRow.addCell("debitAmount").setValue(debitAmt);
        }
        if (creditAmt.compareTo(CasConstants.ZERO) != 0) {
            tableRow.addCell("creditAmount").setValue(creditAmt);
        }
        tableRow.addCell(COL_BALANCE).setValue(balance.abs());
        tableRow.addCell(COL_EXCHANGE).setValue(exchange);
        tableRow.addCell(COL_SOURCE).setValue(JournalSourceEnum.getEnum((int)rs.getInt(COL_SOURCE)));
        tableRow.addCell("periodYear").setValue(rs.getObject("periodYear"));
        tableRow.addCell("periodNumber").setValue(rs.getObject("periodNumber"));
        tableRow.addCell(COL_CASHIER).setValue(rs.getString("cashier"));
        tableRow.addCell("oppUnit").setValue(rs.getString("oppUnit"));
        tableRow.addCell("oppAcctNumber").setValue(rs.getString("oppAcctNumber"));
        tableRow.addCell("oppBank").setValue(rs.getString("oppBank"));
        VerifyScopeEnum verifyScope = VerifyScopeEnum.getEnum((int)rs.getInt("verifyStatus"));
        if (verifyScope.equals((Object)VerifyScopeEnum.NOVA)) {
            tableRow.addCell("verifyStatus").setValue(Boolean.FALSE);
        } else {
            tableRow.addCell("verifyStatus").setValue(Boolean.TRUE);
        }
        BankJournalWebUtil.fillLocalCurrencyData(ctx, tableRow, exchange, debitAmt, creditAmt, balance, isCurEqualsBasecur, convertMode, dc, glDc);
    }

    public static void setBeginBalanceRowDisc(Context ctx, QueryTable queryTable, Date beginDate, boolean isByDay, BigDecimal exchange, boolean isCurEqualsBasecur, BigDecimal dayBalance, ConvertModeEnum convertMode, BalanceDirectionEnum dc, boolean glDc) {
        QueryTableRow tableRow = null;
        String DAY_BALANCE = EASCommonResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"BankStmt_DayStart", (Locale)ctx.getLocale());
        String BEGIN_BALANCE = EASCommonResource.getString((String)resourcePath, (String)"BeginBalance", (Locale)ctx.getLocale());
        if (isByDay) {
            String desc = null;
            int size = queryTable.getRowCount() >= 2 ? 2 : queryTable.getRowCount();
            for (int i = 1; i <= size; ++i) {
                tableRow = queryTable.getRow(i);
                desc = (String)tableRow.addCell(COL_DESCRIPTION).getValue();
                if (desc == null || !desc.equals(BEGIN_BALANCE)) continue;
                desc = DAY_BALANCE;
                BankJournalWebUtil.fillBalance(ctx, tableRow, exchange, dayBalance, isCurEqualsBasecur, desc, beginDate, convertMode, dc, glDc);
                break;
            }
        }
    }

    public static int registerVoucherBatch(Context ctx, JournalInfo journalInfo, Set idSet, int count, BsfBatchProcessResult result) throws BOSException, EASBizException {
        ArrayList<String> array = new ArrayList<String>();
        StringBuffer sb1 = new StringBuffer();
        VoucherInfo voucherInfo = null;
        String billId = "";
        List idList = FMHelper.set2List((Set)idSet);
        int batchSucCount = 0;
        for (int i = 0; i < idList.size(); ++i) {
            billId = idList.get(i).toString();
            voucherInfo = JournalWebUtil.getVoucherInfo(ctx, billId);
            if (voucherInfo == null || voucherInfo.getBizStatus().getValue() == 0 || array.contains(voucherInfo.getNumber())) continue;
            journalInfo.setVoucherType(voucherInfo.getVoucherType());
            array.add(voucherInfo.getNumber());
            sb1.append(voucherInfo.getNumber() + ";");
            ++batchSucCount;
            ++count;
        }
        String tempString = "";
        if (sb1.length() > 0) {
            tempString = sb1.substring(0, sb1.length() - 1);
        }
        array.clear();
        journalInfo.setVoucherNumber(tempString);
        if (count > 1) {
            journalInfo.setVoucherType(null);
        }
        if (batchSucCount == 0) {
            result.setProcessResult(false);
            journalInfo.setVoucherId(null);
            journalInfo.setVoucherNumber(null);
            journalInfo.setVoucherType(null);
            journalInfo.setOppAccountView(null);
        } else {
            result.setProcessResult(true);
        }
        IJournal iEntry = JournalFactory.getLocalInstance(ctx);
        iEntry.registerVoucher((IObjectPK)new ObjectUuidPK(journalInfo.getId()), journalInfo);
        return count;
    }

    public static boolean canRegisterVoucher(Context ctx, String companyId) throws BOSException, EASBizException {
        boolean flag = false;
        IParamControl iParamControl = ParamControlFactory.getLocalInstance((Context)ctx);
        String strValue = iParamControl.getParamValue((IObjectPK)new ObjectUuidPK(companyId), "CS001");
        if (strValue != null && Integer.parseInt(strValue) == 0) {
            flag = true;
        }
        return flag;
    }
}

