/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.utils;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.fi.cas.utils.CASWebHelper;
import com.kingdee.eas.fi.cas.utils.CasWorkPlatfromCashJournalUtil;
import com.kingdee.eas.fi.cas.utils.CasWorkPlatfromHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.TimerTask;
import org.apache.log4j.Logger;

public class CasWorkPlatfromCashFlowTimerTask
extends TimerTask {
    private Context context = null;
    private Logger logger = Logger.getLogger(CasWorkPlatfromCashFlowTimerTask.class);
    private static final int TaskPeriod_Hours = 3;
    private static final int TaskPeriod_Minutes = 30;
    private String companyID_Prior = null;

    public void setCompanyID_Prior(String companyID) {
        this.companyID_Prior = companyID;
    }

    public void setContext(Context ctx) {
        this.context = ctx;
    }

    public CasWorkPlatfromCashFlowTimerTask(Context ctx) {
        this.context = ctx;
    }

    @Override
    public void run() {
        if (this.context == null) {
            return;
        }
        try {
            CasWorkPlatfromHelper casWorkPlatfromHelper = CasWorkPlatfromHelper.getInstance(this.context);
            ICompanyOrgUnit iCompanyOrgUnit = CompanyOrgUnitFactory.getLocalInstance((Context)this.context);
            Set<String> authorOrgSets = CASWebHelper.getAuthorizedOrg(this.context, null, false);
            ArrayList<String> companyOrgIDLists = new ArrayList<String>();
            if (!StringUtil.isEmptyString((String)this.companyID_Prior)) {
                companyOrgIDLists.add(this.companyID_Prior);
            }
            companyOrgIDLists.addAll(authorOrgSets);
            for (String curCompanyID : companyOrgIDLists) {
                int diffMinutes = casWorkPlatfromHelper.getCashFlowFinishMinute(curCompanyID);
                if (diffMinutes > 0 && diffMinutes < 30) continue;
                try {
                    Map<String, BigDecimal[]> cashFlowSubMap;
                    ObjectUuidPK curCompanyPK = new ObjectUuidPK(curCompanyID);
                    if (!iCompanyOrgUnit.exists((IObjectPK)curCompanyPK)) continue;
                    CompanyOrgUnitInfo company = iCompanyOrgUnit.getCompanyOrgUnitInfo((IObjectPK)curCompanyPK);
                    PeriodInfo curPeriod = CASWebHelper.getCurrentPeriod(this.context, company);
                    if (curPeriod == null) {
                        curPeriod = CasWorkPlatfromCashJournalUtil.getPeriodInfo(this.context, new Date(), company);
                    }
                    if (curPeriod == null || (cashFlowSubMap = casWorkPlatfromHelper.welcomePage_CashFlowChartData(company, curPeriod)) == null) continue;
                    casWorkPlatfromHelper.setCashFlowDataMap(curCompanyID, cashFlowSubMap);
                    casWorkPlatfromHelper.setCashFlowFinishDateMap(curCompanyID, new Date());
                }
                catch (Exception e1) {
                    this.logger.debug((Object)(e1.getMessage() + " " + e1.toString()));
                }
            }
            this.logger.debug((Object)("CasWorkPlatfromCashFlowTimerTask Run complete ... " + new Date().toString()));
        }
        catch (Exception e) {
            this.logger.debug((Object)(e.getMessage() + " " + e.toString()));
        }
    }
}

