/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.BalanceDirectionEnum;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.fi.cas.CashDataSourceEnum;
import com.kingdee.eas.fi.cas.DirectionEnum;
import com.kingdee.eas.fi.cas.utils.CASWebHelper;
import com.kingdee.eas.fi.cas.utils.CasWorkPlatfromBankJournalUtil;
import com.kingdee.eas.fi.cas.utils.CasWorkPlatfromCashJournalUtil;
import com.kingdee.eas.fi.cas.utils.JournalWebUtil;
import com.kingdee.eas.fi.cas.vo.WelcomePageBankVO;
import com.kingdee.eas.fi.cas.web.param.CasWorkPlatfromBCJournalParam;
import com.kingdee.eas.fi.cas.web.param.QueryTable;
import com.kingdee.eas.fi.cas.web.param.QueryTableRow;
import com.kingdee.eas.fi.cas.web.param.QueryTableRowCell;
import com.kingdee.eas.util.EASCommonResource;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

public class CasWorkPlatfromHelper {
    private Context ctx = null;
    private Logger logger = Logger.getLogger(CasWorkPlatfromHelper.class);
    public static final String WelcomePage_UIPK = "com.kingdee.eas.dynamic.web.FI_CAS_WorkPlatform_Welcome";
    public static final String WelcomePage_Name = "hello";
    public static final String WP_Split_FenHao = ";";
    public static final String WP_Split_DouHao = ",";
    public static final String WP_Split_DenHao = "=";
    public static final int AryKey_Income_0 = 0;
    public static final int AryKey_Expend_1 = 1;
    public static final int AryKey_Balance_2 = 2;
    public static final String MAPKEY_CUR_MONTH_BEGIN = "xxxx-xx-00";
    public static final SimpleDateFormat DATE_FM_KEY = new SimpleDateFormat("yyyy-M-d");
    public static final long OneHourVal = 3600000L;
    public static final long OneMinuteVal = 60000L;
    private static Timer casWorkPlatfromTimer = null;
    public static long timer_firstTime = 500L;
    private static Map<String, Map<String, BigDecimal[]>> CashFlowDataMap = new ConcurrentHashMap<String, Map<String, BigDecimal[]>>();
    private static Map<String, Date> CashFlowFinishDateMap = new ConcurrentHashMap<String, Date>();
    private static Map<String, List<WelcomePageBankVO>> BankJournalDataMap = new ConcurrentHashMap<String, List<WelcomePageBankVO>>();
    private static Map<String, Date> BankJournalFinishDateMap = new ConcurrentHashMap<String, Date>();

    public CasWorkPlatfromHelper(Context ctx) {
        this.ctx = ctx;
    }

    public static CasWorkPlatfromHelper getInstance(Context ctx) {
        return new CasWorkPlatfromHelper(ctx);
    }

    public static Timer getCasWorkPlatfromTimer() {
        if (casWorkPlatfromTimer == null) {
            casWorkPlatfromTimer = new Timer();
        }
        return casWorkPlatfromTimer;
    }

    public Map<String, Map<String, BigDecimal[]>> getCashFlowDataMap() {
        return CashFlowDataMap;
    }

    public Map<String, BigDecimal[]> getCashFlowDataMap(String companyID) {
        return CashFlowDataMap.get(companyID);
    }

    public void setCashFlowDataMap(String companyID, Map<String, BigDecimal[]> cashFlowSubMap) {
        CashFlowDataMap.put(companyID, cashFlowSubMap);
    }

    public Date getCashFlowFinishDateMap(String companyID) {
        return CashFlowFinishDateMap.get(companyID);
    }

    public int getCashFlowFinishMinute(String companyID) {
        Date finishDate = CashFlowFinishDateMap.get(companyID);
        int myMinutes = 0;
        if (finishDate == null) {
            return myMinutes;
        }
        long diffTime = new Date().getTime() - finishDate.getTime();
        myMinutes = diffTime <= 60000L ? 1 : new Long(diffTime / 60000L).intValue();
        return myMinutes;
    }

    public void setCashFlowFinishDateMap(String companyID, Date curDate) {
        CashFlowFinishDateMap.put(companyID, curDate);
    }

    public Map<String, BigDecimal[]> welcomePage_CashFlowChartData(CompanyOrgUnitInfo company, PeriodInfo curPeriod) throws BOSException, EASBizException, SQLException {
        if (company == null || company.getId() == null) {
            return null;
        }
        String curCompanyID = company.getId().toString();
        ConcurrentHashMap<String, BigDecimal[]> cashFlowMap = new ConcurrentHashMap<String, BigDecimal[]>();
        if (curPeriod == null && (curPeriod = CASWebHelper.getCurrentPeriod(this.ctx, company)) == null) {
            curPeriod = CasWorkPlatfromCashJournalUtil.getPeriodInfo(this.ctx, new Date(), company);
        }
        if (curPeriod == null) {
            return null;
        }
        String acctTableId = CasWorkPlatfromCashJournalUtil.getActualAcctTable(this.ctx, curCompanyID, curPeriod.getPeriodYear(), curPeriod.getPeriodNumber(), curPeriod.getPeriodYear(), curPeriod.getPeriodNumber());
        AccountViewCollection accViewColl = JournalWebUtil.getAccountViewList(this.ctx, curCompanyID, acctTableId, true);
        if (accViewColl != null) {
            AccountViewInfo accViewInfo = null;
            CurrencyInfo currencyInfo = null;
            for (int idx = 0; idx < accViewColl.size(); ++idx) {
                accViewInfo = accViewColl.get(idx);
                if (accViewInfo == null || accViewInfo.getId() == null) continue;
                if (accViewInfo.getAccountCurrency().size() == 0) {
                    currencyInfo = company.getBaseCurrency();
                    this._welcomePage_doMakeCashFlowChartData_CashJournal(cashFlowMap, accViewInfo, currencyInfo, company, curPeriod);
                    continue;
                }
                for (int min = 0; min < accViewInfo.getAccountCurrency().size(); ++min) {
                    currencyInfo = accViewInfo.getAccountCurrency().get(min).getCurrency();
                    this._welcomePage_doMakeCashFlowChartData_CashJournal(cashFlowMap, accViewInfo, currencyInfo, company, curPeriod);
                }
            }
        }
        CurrencyCollection currencyColl = CASWebHelper.getCurrencyValidColl(this.ctx, company);
        AccountBankCollection acctBankColls = CASWebHelper.getAccountBankCollection(this.ctx, curCompanyID, true);
        AccountBankInfo accBankInfo = null;
        CurrencyInfo currencyInfo = null;
        for (int idx = 0; idx < acctBankColls.size(); ++idx) {
            accBankInfo = acctBankColls.get(idx);
            if (accBankInfo == null || accBankInfo.getId() == null) continue;
            if (accBankInfo.isIsByCurrency()) {
                currencyInfo = accBankInfo.getCurrency();
                this._welcomePage_doMakeCashFlowChartData_BankJournal(cashFlowMap, accBankInfo, currencyInfo, company, curPeriod);
                continue;
            }
            for (int p = 0; p < currencyColl.size(); ++p) {
                if (!currencyColl.get(p).getId().equals((Object)company.getBaseCurrency().getId())) continue;
                this._welcomePage_doMakeCashFlowChartData_BankJournal(cashFlowMap, accBankInfo, currencyColl.get(p), company, curPeriod);
            }
        }
        return cashFlowMap;
    }

    private void _welcomePage_doMakeCashFlowChartData_CashJournal(Map<String, BigDecimal[]> cashFlowMap, AccountViewInfo accViewInfo, CurrencyInfo currencyInfo, CompanyOrgUnitInfo company, PeriodInfo curPeriod) throws EASBizException, BOSException, SQLException {
        if (company == null || company.getId() == null) {
            return;
        }
        String curCompanyID = company.getId().toString();
        if (accViewInfo.getId() != null && accViewInfo.getNumber() == null) {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("id"));
            selector.add(new SelectorItemInfo("number"));
            selector.add(new SelectorItemInfo("name"));
            selector.add(new SelectorItemInfo("DC"));
            selector.add(new SelectorItemInfo("accountTableID.id"));
            selector.add(new SelectorItemInfo("accountTableID.number"));
            selector.add(new SelectorItemInfo("accountTableID.name"));
            selector.add(new SelectorItemInfo("accountCurrency.currency.id"));
            selector.add(new SelectorItemInfo("accountCurrency.currency.number"));
            selector.add(new SelectorItemInfo("accountCurrency.currency.name"));
            accViewInfo = AccountViewFactory.getLocalInstance((Context)this.ctx).getAccountViewInfo((IObjectPK)new ObjectUuidPK(accViewInfo.getId()), selector);
        }
        CasWorkPlatfromBCJournalParam bcParam = new CasWorkPlatfromBCJournalParam();
        bcParam.setCompanyId(curCompanyID);
        bcParam.setFromDate(curPeriod.getBeginDate());
        bcParam.setToDate(curPeriod.getEndDate());
        bcParam.setShowDayTotal(true);
        bcParam.setShowBeginBalance(true);
        bcParam.setShowMonthTotal(true);
        bcParam.setShowYearTotal(true);
        bcParam.setCurrencyId(currencyInfo.getId().toString());
        bcParam.setAcctTableId(accViewInfo.getAccountTableID().getId().toString());
        bcParam.setAccountViewId(accViewInfo.getId().toString());
        bcParam.setAccountViewNumber(accViewInfo.getNumber());
        bcParam.setDataSourceType(CashDataSourceEnum.C);
        QueryTable queryCashTable = new QueryTable();
        try {
            CasWorkPlatfromCashJournalUtil.fetchJournalData(this.ctx, bcParam, queryCashTable);
        }
        catch (Exception e) {
            this.logger.debug((Object)e.getMessage());
        }
        this._welcomePage_DoQueryOfInterface(cashFlowMap, queryCashTable, curCompanyID, accViewInfo.getDC());
    }

    private void _welcomePage_DoQueryOfInterface(Map<String, BigDecimal[]> cashFlowMap, QueryTable queryTable, String curCompanyID, BalanceDirectionEnum dc) {
        String DAY_BALANCE = EASCommonResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"BankStmt_DayStart", (Locale)this.ctx.getLocale());
        String BEGIN_BALANCE = EASCommonResource.getString((String)"com.kingdee.eas.fi.cas.JournalResource", (String)"BeginBalance", (Locale)this.ctx.getLocale());
        String DAY_TOTAL = EASCommonResource.getString((String)"com.kingdee.eas.fi.cas.JournalResource", (String)"DayTotal", (Locale)this.ctx.getLocale());
        HashMap<String, BigDecimal[]> cashFlowSubMap = new HashMap<String, BigDecimal[]>();
        for (int idx = 1; idx <= queryTable.getRowCount(); ++idx) {
            QueryTableRow tblRow = queryTable.getRow(idx);
            if (tblRow == null) continue;
            QueryTableRowCell descriptionCell = tblRow.getCell("description");
            if (descriptionCell != null && descriptionCell.getValue() != null && (StringUtil.equals((String)descriptionCell.getValue().toString(), (String)DAY_BALANCE) || StringUtil.equals((String)descriptionCell.getValue().toString(), (String)BEGIN_BALANCE))) {
                this._welcomePage_DoArrangeChartDate(cashFlowSubMap, tblRow, MAPKEY_CUR_MONTH_BEGIN, dc);
            }
            if (descriptionCell == null || descriptionCell.getValue() == null || !StringUtil.equals((String)descriptionCell.getValue().toString(), (String)DAY_TOTAL)) continue;
            this._welcomePage_DoArrangeChartDate(cashFlowSubMap, tblRow, null, dc);
        }
        this._welcomePage_DoArrangeMap(cashFlowMap, cashFlowSubMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _welcomePage_DoArrangeMap(Map<String, BigDecimal[]> cashFlowMap, Map<String, BigDecimal[]> cashFlowSubMap) {
        if (cashFlowMap == null || cashFlowSubMap == null || cashFlowSubMap.size() == 0) {
            return;
        }
        ArrayList<String> keyLists = new ArrayList<String>();
        keyLists.addAll(cashFlowSubMap.keySet());
        keyLists.remove(MAPKEY_CUR_MONTH_BEGIN);
        Collections.sort(keyLists, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                try {
                    Date date1 = DATE_FM_KEY.parse(o1);
                    Date date2 = DATE_FM_KEY.parse(o2);
                    long diffVal = date1.getTime() - date2.getTime();
                    return diffVal > 0L ? 1 : -1;
                }
                catch (Exception e) {
                    CasWorkPlatfromHelper.this.logger.debug((Object)e);
                    return o1.compareTo(o2);
                }
            }
        });
        BigDecimal preDayBalance = SysConstant.BIGZERO;
        BigDecimal[] beginVals = cashFlowSubMap.get(MAPKEY_CUR_MONTH_BEGIN);
        if (beginVals != null) {
            preDayBalance = beginVals[2];
        }
        Date preDayKeyDate = null;
        for (int idx = 0; idx < keyLists.size(); ++idx) {
            String curKeyStr = (String)keyLists.get(idx);
            Date curDate = null;
            try {
                curDate = DATE_FM_KEY.parse(curKeyStr);
                Date fristDay = DateUtil.getFirstDayOfMonth((Date)curDate);
                String fristKeyStr = DATE_FM_KEY.format(fristDay);
                Date date = preDayKeyDate = preDayKeyDate == null ? DateUtil.getBeforeDay((Date)fristDay) : preDayKeyDate;
                if (curKeyStr.equals(fristKeyStr)) continue;
                boolean isDoPrevious = true;
                Date curProcesesDate = curDate;
                while (isDoPrevious) {
                    Date previousDay = DateUtil.getBeforeDay((Date)curProcesesDate);
                    String preKeyStr = DATE_FM_KEY.format(previousDay);
                    if (previousDay.getTime() > preDayKeyDate.getTime()) {
                        BigDecimal[] preDayVals = new BigDecimal[]{SysConstant.BIGZERO, SysConstant.BIGZERO, preDayBalance};
                        cashFlowSubMap.put(preKeyStr, preDayVals);
                        curProcesesDate = previousDay;
                        continue;
                    }
                    isDoPrevious = false;
                }
                continue;
            }
            catch (Exception e) {
                this.logger.debug((Object)e);
                continue;
            }
            finally {
                BigDecimal[] curDayVals = cashFlowSubMap.get(curKeyStr);
                if (curDayVals != null) {
                    preDayBalance = curDayVals[2];
                }
                if (curDate != null) {
                    preDayKeyDate = curDate;
                }
            }
        }
        Set<String> subMapKeys = cashFlowSubMap.keySet();
        for (String subMapKey : subMapKeys) {
            BigDecimal balanceVal;
            BigDecimal expendVal;
            BigDecimal incomeVal;
            BigDecimal[] curKeySubVals = cashFlowSubMap.get(subMapKey);
            if (cashFlowMap.get(subMapKey) == null) {
                BigDecimal[] newKeyVals = new BigDecimal[]{curKeySubVals[0], curKeySubVals[1], curKeySubVals[2]};
                cashFlowMap.put(subMapKey, newKeyVals);
                continue;
            }
            BigDecimal[] curKeyMainVals = cashFlowMap.get(subMapKey);
            curKeyMainVals[0] = incomeVal = curKeyMainVals[0].add(curKeySubVals[0]);
            curKeyMainVals[1] = expendVal = curKeyMainVals[1].add(curKeySubVals[1]);
            curKeyMainVals[2] = balanceVal = curKeyMainVals[2].add(curKeySubVals[2]);
            cashFlowMap.put(subMapKey, curKeyMainVals);
        }
    }

    private void _welcomePage_doMakeCashFlowChartData_BankJournal(Map<String, BigDecimal[]> cashFlowMap, AccountBankInfo accBankInfo, CurrencyInfo currencyInfo, CompanyOrgUnitInfo company, PeriodInfo curPeriod) throws EASBizException, BOSException, SQLException {
        if (company == null || company.getId() == null) {
            return;
        }
        String curCompanyID = company.getId().toString();
        if (accBankInfo.getAccount() == null || accBankInfo.getAccount().getAccountTableID() == null) {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("id"));
            selector.add(new SelectorItemInfo("number"));
            selector.add(new SelectorItemInfo("name"));
            selector.add(new SelectorItemInfo("bankAccountNumber"));
            selector.add(new SelectorItemInfo("account.id"));
            selector.add(new SelectorItemInfo("account.number"));
            selector.add(new SelectorItemInfo("account.name"));
            selector.add(new SelectorItemInfo("account.DC"));
            selector.add(new SelectorItemInfo("bank.id"));
            selector.add(new SelectorItemInfo("bank.number"));
            selector.add(new SelectorItemInfo("bank.name"));
            selector.add(new SelectorItemInfo("account.accountTableID.id"));
            selector.add(new SelectorItemInfo("account.accountTableID.number"));
            selector.add(new SelectorItemInfo("account.accountTableID.name"));
            accBankInfo = AccountBankFactory.getLocalInstance((Context)this.ctx).getAccountBankInfo((IObjectPK)new ObjectUuidPK(accBankInfo.getId()), selector);
        }
        CasWorkPlatfromBCJournalParam bcParam = new CasWorkPlatfromBCJournalParam();
        bcParam.setCompanyId(curCompanyID);
        bcParam.setFromDate(curPeriod.getBeginDate());
        bcParam.setToDate(curPeriod.getEndDate());
        bcParam.setShowDayTotal(true);
        bcParam.setShowBeginBalance(true);
        bcParam.setShowMonthTotal(true);
        bcParam.setShowYearTotal(true);
        bcParam.setCurrencyId(currencyInfo.getId().toString());
        bcParam.setAcctTableId(accBankInfo.getAccount().getAccountTableID().getId().toString());
        bcParam.setAccountViewId(accBankInfo.getAccount().getId().toString());
        bcParam.setAccountViewNumber(accBankInfo.getAccount().getNumber());
        bcParam.setAccountBankId(accBankInfo.getId().toString());
        bcParam.setAccountBankNumber(accBankInfo.getNumber());
        bcParam.setDataSourceType(CashDataSourceEnum.B);
        QueryTable queryBankTable = new QueryTable();
        try {
            CasWorkPlatfromBankJournalUtil.fetchJournalData(this.ctx, bcParam, queryBankTable);
        }
        catch (Exception e) {
            this.logger.debug((Object)e.getMessage());
        }
        BalanceDirectionEnum bankJournalDC = BalanceDirectionEnum.DEBIT;
        this._welcomePage_DoQueryOfInterface(cashFlowMap, queryBankTable, curCompanyID, bankJournalDC);
    }

    private void _welcomePage_DoArrangeChartDate(Map<String, BigDecimal[]> cashChartSubMap, QueryTableRow tblRow, String keyStr, BalanceDirectionEnum dc) {
        QueryTableRowCell bizDateCell = tblRow.getCell("createDate");
        QueryTableRowCell localDebitCell = tblRow.getCell("localDebit");
        QueryTableRowCell debitCell = tblRow.getCell("debitAmount");
        QueryTableRowCell localCreditCell = tblRow.getCell("localCredit");
        QueryTableRowCell creditCell = tblRow.getCell("creditAmount");
        QueryTableRowCell localBalanceCell = tblRow.getCell("localBalance");
        QueryTableRowCell balanceCell = tblRow.getCell("balance");
        QueryTableRowCell DCCell = tblRow.getCell("dc");
        String bizDateStr = bizDateCell == null ? null : (String)bizDateCell.getValue();
        String string = keyStr = keyStr == null ? bizDateStr : keyStr;
        if (keyStr == null) {
            return;
        }
        BigDecimal localDebit = this._W_GetVal(localDebitCell, debitCell);
        BigDecimal localCredit = this._W_GetVal(localCreditCell, creditCell);
        BigDecimal localBalance = this._W_GetVal(localBalanceCell, balanceCell);
        DirectionEnum blanceDC = (DirectionEnum)((Object)DCCell.getValue());
        BigDecimal[] localVals = cashChartSubMap.get(keyStr);
        if (localVals == null) {
            localVals = new BigDecimal[3];
            for (int idx = 0; idx < localVals.length; ++idx) {
                localVals[idx] = SysConstant.BIGZERO;
            }
            cashChartSubMap.put(keyStr, localVals);
        }
        BigDecimal accViewDCVal = new BigDecimal("1.0");
        BigDecimal balanceDCVal = new BigDecimal("1.0");
        if (blanceDC != null && blanceDC.getValue() == DirectionEnum.Credit.getValue()) {
            balanceDCVal = new BigDecimal("-1.0");
        }
        localVals[0] = localVals[0].add(localDebit.multiply(accViewDCVal));
        localVals[1] = localVals[1].add(localCredit.multiply(accViewDCVal));
        localVals[2] = localVals[2].add(localBalance.multiply(accViewDCVal).multiply(balanceDCVal));
    }

    private BigDecimal _W_GetVal(QueryTableRowCell firstCell, QueryTableRowCell secondCell) {
        if (firstCell == null) {
            return secondCell == null ? SysConstant.BIGZERO : this._W_GetVal(secondCell);
        }
        return this._W_GetVal(firstCell);
    }

    private BigDecimal _W_GetVal(QueryTableRowCell cell) {
        if (cell == null) {
            return SysConstant.BIGZERO;
        }
        double val = ((BigDecimal)cell.getValue()).doubleValue();
        return new BigDecimal(val);
    }

    public Map<String, List<WelcomePageBankVO>> getBankJournalDataList() {
        return BankJournalDataMap;
    }

    public List<WelcomePageBankVO> getBankJournalDataList(String companyID) {
        return BankJournalDataMap.get(companyID);
    }

    public void setBankJournalDataList(String companyID, List<WelcomePageBankVO> bankSubList) {
        BankJournalDataMap.put(companyID, bankSubList);
    }

    public Date getBankJournalFinishDateMap(String companyID) {
        return BankJournalFinishDateMap.get(companyID);
    }

    public int getBankJournalFinishMinute(String companyID) {
        Date finishDate = BankJournalFinishDateMap.get(companyID);
        int myMinutes = 0;
        if (finishDate == null) {
            return myMinutes;
        }
        long diffTime = new Date().getTime() - finishDate.getTime();
        myMinutes = diffTime <= 60000L ? 1 : new Long(diffTime / 60000L).intValue();
        return myMinutes;
    }

    public void setBankJournalFinishDateMap(String companyID, Date curDate) {
        BankJournalFinishDateMap.put(companyID, curDate);
    }

    public List<WelcomePageBankVO> welcomePage_BankJouranlData(CompanyOrgUnitInfo company) throws BOSException, EASBizException, SQLException {
        if (company == null || company.getId() == null) {
            return null;
        }
        CurrencyCollection currencyColl = CASWebHelper.getCurrencyValidColl(this.ctx, company);
        ArrayList<WelcomePageBankVO> bankDataList = new ArrayList<WelcomePageBankVO>();
        AccountBankCollection acctBankColls = CASWebHelper.getAccountBankCollection(this.ctx, company.getId().toString(), true);
        AccountBankInfo accBankInfo = null;
        CurrencyInfo currencyInfo = null;
        for (int idx = 0; idx < acctBankColls.size(); ++idx) {
            accBankInfo = acctBankColls.get(idx);
            if (accBankInfo == null || accBankInfo.getId() == null) continue;
            if (accBankInfo.isIsByCurrency()) {
                currencyInfo = accBankInfo.getCurrency();
                this._welcomePage_doMakeBankJouranlData(bankDataList, accBankInfo, currencyInfo, company);
                continue;
            }
            for (int p = 0; p < currencyColl.size(); ++p) {
                if (!currencyColl.get(p).getId().equals((Object)company.getBaseCurrency().getId())) continue;
                this._welcomePage_doMakeBankJouranlData(bankDataList, accBankInfo, currencyColl.get(p), company);
            }
        }
        return bankDataList;
    }

    private void _welcomePage_doMakeBankJouranlData(List<WelcomePageBankVO> bankDataList, AccountBankInfo accBankInfo, CurrencyInfo currencyInfo, CompanyOrgUnitInfo company) throws EASBizException, BOSException, SQLException {
        CasWorkPlatfromBCJournalParam param = new CasWorkPlatfromBCJournalParam();
        param.setCompanyId(company.getId().toString());
        Date curDate = new Date();
        param.setFromDate(curDate);
        param.setToDate(curDate);
        param.setShowDayTotal(true);
        param.setShowBeginBalance(true);
        param.setAccountBankId(accBankInfo.getId().toString());
        param.setAccountBankNumber(accBankInfo.getNumber());
        param.setCurrencyId(currencyInfo.getId().toString());
        if (accBankInfo.getAccount() == null || accBankInfo.getAccount().getAccountTableID() == null) {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("id"));
            selector.add(new SelectorItemInfo("number"));
            selector.add(new SelectorItemInfo("name"));
            selector.add(new SelectorItemInfo("bankAccountNumber"));
            selector.add(new SelectorItemInfo("account.id"));
            selector.add(new SelectorItemInfo("account.number"));
            selector.add(new SelectorItemInfo("account.name"));
            selector.add(new SelectorItemInfo("bank.id"));
            selector.add(new SelectorItemInfo("bank.number"));
            selector.add(new SelectorItemInfo("bank.name"));
            selector.add(new SelectorItemInfo("account.accountTableID.id"));
            selector.add(new SelectorItemInfo("account.accountTableID.number"));
            selector.add(new SelectorItemInfo("account.accountTableID.name"));
            accBankInfo = AccountBankFactory.getLocalInstance((Context)this.ctx).getAccountBankInfo((IObjectPK)new ObjectUuidPK(accBankInfo.getId()), selector);
        }
        param.setAcctTableId(accBankInfo.getAccount().getAccountTableID().getId().toString());
        param.setAccountViewNumber(accBankInfo.getAccount().getNumber());
        param.setDataSourceType(CashDataSourceEnum.B);
        String accBankID = accBankInfo.getId().toString();
        WelcomePageBankVO curBankDataVO = null;
        for (WelcomePageBankVO bankDataVO : bankDataList) {
            String curAccBankID;
            if (bankDataVO == null || !StringUtil.equals((String)accBankID, (String)(curAccBankID = bankDataVO.getAccountBankId()))) continue;
            curBankDataVO = bankDataVO;
        }
        if (curBankDataVO == null) {
            curBankDataVO = new WelcomePageBankVO();
            curBankDataVO.setId(accBankID);
            curBankDataVO.setAccountBankId(accBankID);
            curBankDataVO.setAccountBankColumn(accBankInfo.getBank().getName() + "  " + accBankInfo.getBankAccountNumber());
            curBankDataVO.setCurDayBalanceColumn(SysConstant.BIGZERO);
            curBankDataVO.setIsTotal(Boolean.FALSE);
            bankDataList.add(curBankDataVO);
        }
        QueryTable queryTable = new QueryTable();
        try {
            CasWorkPlatfromBankJournalUtil.fetchJournalData(this.ctx, param, queryTable);
        }
        catch (Exception e) {
            this.logger.debug((Object)e.getMessage());
            return;
        }
        boolean isNotHaveDayTotal = true;
        String DAY_TOTAL = EASCommonResource.getString((String)"com.kingdee.eas.fi.cas.JournalResource", (String)"DayTotal", (Locale)this.ctx.getLocale());
        for (int idx = 1; idx <= queryTable.getRowCount(); ++idx) {
            QueryTableRow tblRow = queryTable.getRow(idx);
            if (tblRow == null) continue;
            QueryTableRowCell descriptionCell = tblRow.getCell("description");
            QueryTableRowCell localBalanceCell = tblRow.getCell("localBalance");
            if (descriptionCell == null || localBalanceCell == null || descriptionCell.getValue() == null || !StringUtil.equals((String)descriptionCell.getValue().toString(), (String)DAY_TOTAL)) continue;
            BigDecimal localBalance = (BigDecimal)localBalanceCell.getValue();
            localBalance = localBalance.add(curBankDataVO.getCurDayBalanceColumn());
            curBankDataVO.setCurDayBalanceColumn(localBalance);
            isNotHaveDayTotal = false;
        }
        if (isNotHaveDayTotal) {
            String DAY_BALANCE = EASCommonResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"BankStmt_DayStart", (Locale)this.ctx.getLocale());
            String BEGINBALANCE = EASCommonResource.getString((String)"com.kingdee.eas.fi.cas.JournalResource", (String)"BeginBalance", (Locale)this.ctx.getLocale());
            for (int idx = 1; idx <= queryTable.getRowCount(); ++idx) {
                QueryTableRow tblRow = queryTable.getRow(idx);
                if (tblRow == null) continue;
                QueryTableRowCell descriptionCell = tblRow.getCell("description");
                QueryTableRowCell localBalanceCell = tblRow.getCell("localBalance");
                if (descriptionCell == null || localBalanceCell == null || descriptionCell.getValue() == null || !StringUtil.equals((String)descriptionCell.getValue().toString(), (String)DAY_BALANCE) && !StringUtil.equals((String)descriptionCell.getValue().toString(), (String)BEGINBALANCE)) continue;
                BigDecimal localBalance = (BigDecimal)localBalanceCell.getValue();
                localBalance = localBalance.add(curBankDataVO.getCurDayBalanceColumn());
                curBankDataVO.setCurDayBalanceColumn(localBalance);
            }
        }
    }
}

