/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.framework.session.LoginType;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.openapi.util.json.JSONUtils;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.EJBAccessFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.cas.AgentPayBillCollection;
import com.kingdee.eas.fi.cas.AgentPayBillFactory;
import com.kingdee.eas.fi.cas.BillStatusEnum;
import com.kingdee.eas.fi.cas.IPayAntiGravityLog;
import com.kingdee.eas.fi.cas.LogCategoryEnum;
import com.kingdee.eas.fi.cas.PayAdmitSchemeCollection;
import com.kingdee.eas.fi.cas.PayAdmitSchemeFactory;
import com.kingdee.eas.fi.cas.PayAdmitSchemeInfo;
import com.kingdee.eas.fi.cas.PayAntiGravityLogFactory;
import com.kingdee.eas.fi.cas.PayAntiGravityLogInfo;
import com.kingdee.eas.fi.cas.PayAntiRepeatCollection;
import com.kingdee.eas.fi.cas.PayAntiRepeatFactory;
import com.kingdee.eas.fi.cas.PayAntiRepeatInfo;
import com.kingdee.eas.fi.cas.PaymentBillCollection;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public class PayAdmitUtils {
    private static final String payAdmitResource = "com.kingdee.eas.fi.cas.PayAdmitResource";
    private static final String PAY = "FKZR";
    private static final String AGENT = "DFZR";
    private static final String ONLYKEY = "\u552f\u4e00\u4e3b\u952e";
    private static String schemeNumber = "";
    private static Logger logger = Logger.getLogger((String)PayAdmitUtils.class.getName());

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void verifyPayadmit(Context ctx, CoreBaseInfo info, boolean isAddnew) throws BOSException, EASBizException {
        schemeNumber = info instanceof PaymentBillInfo ? PAY : AGENT;
        boolean inWorkFlow = false;
        if (!isAddnew) {
            inWorkFlow = FMHelper.isInWorkFlow((Context)ctx, (String)info.getId().toString());
        } else {
            String sourceBillId = PayAdmitUtils.getSourceBillID(info);
            if (!EmptyUtil.isEmpty((String)sourceBillId)) {
                inWorkFlow = FMHelper.isInWorkFlow((Context)ctx, (String)sourceBillId);
            }
        }
        if (LoginType.GUI.equals(ctx.get((Object)"LOGIN_TYPE")) || LoginType.PORTAL.equals(ctx.get((Object)"LOGIN_TYPE")) || ctx.get((Object)"jobInstId") != null || inWorkFlow) {
            if (!isAddnew) return;
            PayAdmitUtils.verifyEasBill(ctx, info, schemeNumber);
            return;
        } else {
            if (!isAddnew) {
                if (info.get("billStatus") == null) return;
                Integer billStatus = null;
                if (info.get("billStatus") instanceof BillStatusEnum) {
                    billStatus = ((BillStatusEnum)((Object)info.get("billStatus"))).getValue();
                } else if (info.get("billStatus") instanceof Integer) {
                    billStatus = (Integer)info.get("billStatus");
                }
                if (billStatus != null && billStatus != 10 && billStatus == 11) return;
            }
            PayAdmitUtils.verifyOutSysBill(ctx, info, schemeNumber);
        }
    }

    private static String getSourceBillID(CoreBaseInfo info) {
        String sourceBillId = "";
        try {
            if (!EmptyUtil.isEmpty((String)info.getExtendedProperty("botRelationSrcObjectId"))) {
                String botRelationSrcObjectId = info.getExtendedProperty("botRelationSrcObjectId");
                List srcObjectIdList = new ArrayList();
                if ((srcObjectIdList = (List)JSONUtils.convertJsonToObject((String)botRelationSrcObjectId, srcObjectIdList.getClass())).size() > 0) {
                    sourceBillId = (String)srcObjectIdList.get(0);
                }
            } else if (!EmptyUtil.isEmpty((String)info.getString("sourceBillId"))) {
                sourceBillId = info.getString("sourceBillId");
            } else if (!EmptyUtil.isEmpty((Object)info.get("relationcoll"))) {
                BOTRelationCollection relationColl = new BOTRelationCollection();
                relationColl = info.get("relationcoll") instanceof String ? (BOTRelationCollection)JSONUtils.convertJsonToObject((String)((String)info.get("relationcoll")), BOTRelationCollection.class) : (BOTRelationCollection)info.get("relationcoll");
                if (relationColl.size() > 0) {
                    sourceBillId = relationColl.get(0).getSrcObjectID();
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("EAS\u5355\u636e\u8f6c\u6362\u4ed8\u6b3e\u5355\u51fa\u73b0\u5f02\u5e38:" + info.get("relationcoll")), (Throwable)e);
        }
        return sourceBillId;
    }

    public static void verifyOutSysBill(Context ctx, CoreBaseInfo info, String schemeNumber) throws BOSException, EASBizException {
        if (info != null) {
            PayAdmitUtils.verifyScheme(ctx, info, info.getString("outSysBillTag"), schemeNumber);
        }
    }

    public static void verifyEasBill(Context ctx, CoreBaseInfo info, String schemeNumber) throws BOSException, EASBizException {
        if (info == null) {
            return;
        }
        int destBill = info instanceof PaymentBillInfo ? 1 : 2;
        String sourceBillId = PayAdmitUtils.getSourceBillID(info);
        if (!EmptyUtil.isEmpty((String)sourceBillId)) {
            PayAdmitUtils.verifyBySourceBillId(ctx, info, destBill, schemeNumber, sourceBillId);
        }
    }

    private static void verifyBySourceBillId(Context ctx, CoreBaseInfo info, int destBill, String schemeNumber, String sourceBillId) throws BOSException, EASBizException, FMException {
        if (EmptyUtil.isEmpty((String)sourceBillId)) {
            return;
        }
        BOSObjectType bosType = BOSUuid.read((String)sourceBillId).getType();
        EntityObjectInfo eoi = EJBAccessFactory.createLocalInstance((Context)ctx).getEntityInfo(bosType);
        String sourceBillName = eoi.getAlias();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("sourceBillBosType", (Object)bosType.toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("destbill", (Object)destBill, CompareType.EQUALS));
        view.setFilter(filter);
        PayAdmitSchemeCollection collection = PayAdmitSchemeFactory.getLocalInstance(ctx).getPayAdmitSchemeCollection(view);
        PayAdmitSchemeInfo schemeInfo = null;
        if (EmptyUtil.isEmpty((AbstractObjectCollection)collection)) {
            EntityViewInfo viewNew = new EntityViewInfo();
            FilterInfo filterNew = new FilterInfo();
            filterNew.getFilterItems().add(new FilterItemInfo("number", (Object)schemeNumber, CompareType.EQUALS));
            filterNew.getFilterItems().add(new FilterItemInfo("isEnable", (Object)1, CompareType.EQUALS));
            filterNew.getFilterItems().add(new FilterItemInfo("destbill", (Object)destBill, CompareType.EQUALS));
            viewNew.setFilter(filterNew);
            PayAdmitSchemeCollection collNew = PayAdmitSchemeFactory.getLocalInstance(ctx).getPayAdmitSchemeCollection(viewNew);
            if (!EmptyUtil.isEmpty((AbstractObjectCollection)collNew)) {
                PayAdmitUtils.verifyAntiRepeat(ctx, info, destBill, sourceBillName, collNew.get(0), true);
            }
        } else {
            schemeInfo = collection.get(0);
            if (schemeInfo.isIsPreset() && !schemeInfo.isIsEnable()) {
                return;
            }
            if (!schemeInfo.isIsPreset() && !schemeInfo.isIsEnable()) {
                if (destBill == 1) {
                    String errorMsg = ResourceBase.getString((String)payAdmitResource, (String)"27_PayAdmitVerify", (Locale)ctx.getLocale(), (Object[])new Object[]{sourceBillName});
                    PayAdmitUtils.recordAntiGravityLog(ctx, null, LogCategoryEnum.PayAnti, null, null, errorMsg);
                    throw new FMException(FMException.COMMMONEXCEPTION, (Object[])new String[]{errorMsg});
                }
                if (destBill == 2) {
                    String errorMsg = ResourceBase.getString((String)payAdmitResource, (String)"28_AgentAdmitVerify", (Locale)ctx.getLocale(), (Object[])new Object[]{sourceBillName});
                    PayAdmitUtils.recordAntiGravityLog(ctx, null, LogCategoryEnum.PayAnti, null, null, errorMsg);
                    throw new FMException(FMException.COMMMONEXCEPTION, (Object[])new String[]{errorMsg});
                }
            }
            EntityViewInfo viewNew = new EntityViewInfo();
            FilterInfo filterNew = new FilterInfo();
            filterNew.getFilterItems().add(new FilterItemInfo("payAdmitScheme.id", (Object)schemeInfo.getId().toString(), CompareType.EQUALS));
            filterNew.getFilterItems().add(new FilterItemInfo("isEnable", (Object)1, CompareType.EQUALS));
            viewNew.setFilter(filterNew);
            PayAntiRepeatCollection antiRepeatColl = PayAntiRepeatFactory.getLocalInstance(ctx).getPayAntiRepeatCollection(viewNew);
            if (EmptyUtil.isEmpty((AbstractObjectCollection)antiRepeatColl)) {
                if (destBill == 1) {
                    String errorMsg = ResourceBase.getString((String)payAdmitResource, (String)"21_PayAntiVerify", (Locale)ctx.getLocale(), (Object[])new Object[]{sourceBillName});
                    PayAdmitUtils.recordAntiGravityLog(ctx, (CoreBaseInfo)schemeInfo, LogCategoryEnum.PayAnti, null, null, errorMsg);
                    throw new FMException(FMException.COMMMONEXCEPTION, (Object[])new String[]{errorMsg});
                }
                if (destBill == 2) {
                    String errorMsg = ResourceBase.getString((String)payAdmitResource, (String)"22_AgentAntiVerify", (Locale)ctx.getLocale(), (Object[])new Object[]{sourceBillName});
                    PayAdmitUtils.recordAntiGravityLog(ctx, (CoreBaseInfo)schemeInfo, LogCategoryEnum.PayAnti, null, null, errorMsg);
                    throw new FMException(FMException.COMMMONEXCEPTION, (Object[])new String[]{errorMsg});
                }
            } else {
                PayAdmitUtils.recordLogAndVerifyExist(ctx, destBill, antiRepeatColl.get(0), "sourceBillId", sourceBillId);
            }
        }
    }

    private static void verifyScheme(Context ctx, CoreBaseInfo info, String sourceBillName, String schemeNumber) throws BOSException, EASBizException {
        int destBill;
        int n = destBill = info instanceof PaymentBillInfo ? 1 : 2;
        if (EmptyUtil.isEmpty((String)sourceBillName)) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)schemeNumber, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("isEnable", (Object)1, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("destbill", (Object)destBill, CompareType.EQUALS));
            view.setFilter(filter);
            PayAdmitSchemeCollection admitColl = PayAdmitSchemeFactory.getLocalInstance(ctx).getPayAdmitSchemeCollection(view);
            if (!EmptyUtil.isEmpty((AbstractObjectCollection)admitColl)) {
                PayAdmitUtils.verifyAntiRepeat(ctx, info, destBill, sourceBillName, admitColl.get(0), false);
            }
        } else {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("customEntity", (Object)sourceBillName, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("isEnable", (Object)1, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("destbill", (Object)destBill, CompareType.EQUALS));
            view.setFilter(filter);
            PayAdmitSchemeCollection admitColl = PayAdmitSchemeFactory.getLocalInstance(ctx).getPayAdmitSchemeCollection(view);
            if (EmptyUtil.isEmpty((AbstractObjectCollection)admitColl)) {
                if (destBill == 1) {
                    String errorMsg = ResourceBase.getString((String)payAdmitResource, (String)"23_PayAdmitVerify", (Locale)ctx.getLocale(), (Object[])new Object[]{sourceBillName});
                    PayAdmitUtils.recordAntiGravityLog(ctx, null, LogCategoryEnum.PayAnti, null, null, errorMsg);
                    throw new FMException(FMException.COMMMONEXCEPTION, (Object[])new String[]{errorMsg});
                }
                if (destBill == 2) {
                    String errorMsg = ResourceBase.getString((String)payAdmitResource, (String)"24_AgentAdmitVerify", (Locale)ctx.getLocale(), (Object[])new Object[]{sourceBillName});
                    PayAdmitUtils.recordAntiGravityLog(ctx, null, LogCategoryEnum.PayAnti, null, null, errorMsg);
                    throw new FMException(FMException.COMMMONEXCEPTION, (Object[])new String[]{errorMsg});
                }
            } else {
                PayAdmitUtils.verifyAntiRepeat(ctx, info, destBill, sourceBillName, admitColl.get(0), false);
            }
        }
    }

    private static void verifyAntiRepeat(Context ctx, CoreBaseInfo info, int destBill, String sourceBillName, PayAdmitSchemeInfo schemeInfo, boolean fromEas) throws EASBizException, BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("payAdmitScheme.id", (Object)schemeInfo.getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isEnable", (Object)1, CompareType.EQUALS));
        view.setFilter(filter);
        PayAntiRepeatCollection antiRepeatColl = PayAntiRepeatFactory.getLocalInstance(ctx).getPayAntiRepeatCollection(view);
        if (EmptyUtil.isEmpty((AbstractObjectCollection)antiRepeatColl)) {
            if (destBill == 1) {
                String errorMsg = "";
                errorMsg = fromEas ? ResourceBase.getString((String)payAdmitResource, (String)"21_PayAntiVerify", (Locale)ctx.getLocale(), (Object[])new Object[]{sourceBillName}) : ResourceBase.getString((String)payAdmitResource, (String)"25_OutPayAntiVerify", (Locale)ctx.getLocale(), (Object[])new Object[]{sourceBillName});
                PayAdmitUtils.recordAntiGravityLog(ctx, (CoreBaseInfo)schemeInfo, LogCategoryEnum.PayAnti, null, null, errorMsg);
                throw new FMException(FMException.COMMMONEXCEPTION, (Object[])new String[]{errorMsg});
            }
            if (destBill == 2) {
                String errorMsg = "";
                errorMsg = fromEas ? ResourceBase.getString((String)payAdmitResource, (String)"22_AgentAntiVerify", (Locale)ctx.getLocale(), (Object[])new Object[]{sourceBillName}) : ResourceBase.getString((String)payAdmitResource, (String)"26_OutAgentAntiVerify", (Locale)ctx.getLocale(), (Object[])new Object[]{sourceBillName});
                PayAdmitUtils.recordAntiGravityLog(ctx, (CoreBaseInfo)schemeInfo, LogCategoryEnum.PayAnti, null, null, errorMsg);
                throw new FMException(FMException.COMMMONEXCEPTION, (Object[])new String[]{errorMsg});
            }
        } else {
            PayAntiRepeatInfo antiInfo = antiRepeatColl.get(0);
            if (EmptyUtil.isEmpty((String)info.getString("sourceFunction"))) {
                String onlyKey = antiInfo.getOnlyKey();
                String[] onlyKeys = onlyKey.split(",");
                String flag = "";
                for (int i = 0; i < onlyKeys.length; ++i) {
                    if (EmptyUtil.isEmpty((Object)info.get(onlyKeys[i]))) continue;
                    flag = info.get(onlyKeys[i]) instanceof CoreBaseInfo ? flag + ((CoreBaseInfo)info.get(onlyKeys[i])).get("id") + "_" : flag + info.get(onlyKeys[i]) + "_";
                }
                if (EmptyUtil.isEmpty((String)flag)) {
                    PayAdmitUtils.recordAntiGravityLog(ctx, (CoreBaseInfo)antiInfo, LogCategoryEnum.PayAnti, null, null, ResourceBase.getString((String)payAdmitResource, (String)"31_OnlyValueNotNull", (Locale)ctx.getLocale()));
                    throw new FMException(FMException.COMMMONEXCEPTION, (Object[])new String[]{ResourceBase.getString((String)payAdmitResource, (String)"31_OnlyValueNotNull", (Locale)ctx.getLocale())});
                }
                if (!EmptyUtil.isEmpty((String)sourceBillName)) {
                    flag = flag + sourceBillName;
                }
                if (flag.length() > 500) {
                    flag = flag.substring(0, 500);
                }
                PayAdmitUtils.recordLogAndVerifyExist(ctx, destBill, antiInfo, "sourceFunction", flag);
                info.setString("sourceFunction", flag);
            } else {
                PayAdmitUtils.recordLogAndVerifyExist(ctx, destBill, antiInfo, "sourceFunction", info.getString("sourceFunction"));
            }
        }
    }

    private static void recordLogAndVerifyExist(Context ctx, int destBill, PayAntiRepeatInfo antiInfo, String key, String value) throws BOSException, EASBizException, FMException {
        if (destBill == 1) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo(key, (Object)value, CompareType.EQUALS));
            view.setFilter(filter);
            PaymentBillCollection collection = PaymentBillFactory.getLocalInstance(ctx).getPaymentBillCollection(view);
            if (collection.size() == 0 && "sourceBillId".equals(key)) {
                EntityViewInfo botView = new EntityViewInfo();
                FilterInfo botFilter = new FilterInfo();
                botFilter.getFilterItems().add(new FilterItemInfo("srcObjectID", (Object)value, CompareType.EQUALS));
                botFilter.getFilterItems().add(new FilterItemInfo("destEntityID", (Object)"40284E81", CompareType.EQUALS));
                botView.setFilter(botFilter);
                BOTRelationCollection relationColl = BOTRelationFactory.getLocalInstance((Context)ctx).getCollection(botView);
                if (relationColl.size() > 0) {
                    EntityViewInfo viewNew = new EntityViewInfo();
                    FilterInfo filterNew = new FilterInfo();
                    filterNew.getFilterItems().add(new FilterItemInfo("id", (Object)relationColl.get(0).getDestObjectID(), CompareType.EQUALS));
                    viewNew.setFilter(filterNew);
                    collection = PaymentBillFactory.getLocalInstance(ctx).getPaymentBillCollection(viewNew);
                }
            }
            if (collection != null && collection.size() > 0) {
                String errorMsg = antiInfo.getErrorMsg() + ResourceBase.getString((String)payAdmitResource, (String)"39_hasChongFuBill", (Locale)ctx.getLocale(), (Object[])new Object[]{collection.get(0).getNumber()});
                PayAdmitUtils.recordAntiGravityLog(ctx, (CoreBaseInfo)antiInfo, LogCategoryEnum.PayAnti, null, null, errorMsg);
                throw new FMException(FMException.COMMMONEXCEPTION, (Object[])new String[]{errorMsg});
            }
            PayAdmitUtils.recordAntiGravityLog(ctx, (CoreBaseInfo)antiInfo, LogCategoryEnum.PayAnti, null, null, ResourceBase.getString((String)payAdmitResource, (String)"30_Normal", (Locale)ctx.getLocale()));
        } else if (destBill == 2) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo(key, (Object)value, CompareType.EQUALS));
            view.setFilter(filter);
            AgentPayBillCollection collection = AgentPayBillFactory.getLocalInstance(ctx).getAgentPayBillCollection(view);
            if (collection.size() == 0 && "sourceBillId".equals(key)) {
                EntityViewInfo botView = new EntityViewInfo();
                FilterInfo botFilter = new FilterInfo();
                botFilter.getFilterItems().add(new FilterItemInfo("srcObjectID", (Object)value, CompareType.EQUALS));
                botFilter.getFilterItems().add(new FilterItemInfo("destEntityID", (Object)"131C7D36", CompareType.EQUALS));
                botView.setFilter(botFilter);
                BOTRelationCollection relationColl = BOTRelationFactory.getLocalInstance((Context)ctx).getCollection(botView);
                if (relationColl.size() > 0) {
                    EntityViewInfo viewNew = new EntityViewInfo();
                    FilterInfo filterNew = new FilterInfo();
                    filterNew.getFilterItems().add(new FilterItemInfo("id", (Object)relationColl.get(0).getDestObjectID(), CompareType.EQUALS));
                    viewNew.setFilter(filterNew);
                    collection = AgentPayBillFactory.getLocalInstance(ctx).getAgentPayBillCollection(viewNew);
                }
            }
            if (collection != null && collection.size() > 0) {
                String errorMsg = antiInfo.getErrorMsg() + ResourceBase.getString((String)payAdmitResource, (String)"39_hasChongFuBill", (Locale)ctx.getLocale(), (Object[])new Object[]{collection.get(0).getNumber()});
                PayAdmitUtils.recordAntiGravityLog(ctx, (CoreBaseInfo)antiInfo, LogCategoryEnum.PayAnti, null, null, errorMsg);
                throw new FMException(FMException.COMMMONEXCEPTION, (Object[])new String[]{errorMsg});
            }
            PayAdmitUtils.recordAntiGravityLog(ctx, (CoreBaseInfo)antiInfo, LogCategoryEnum.PayAnti, null, null, ResourceBase.getString((String)payAdmitResource, (String)"30_Normal", (Locale)ctx.getLocale()));
        }
    }

    public static void recordAntiGravityLog(Context ctx, CoreBaseInfo info, LogCategoryEnum logType, String before, String after, String errorMsg) {
        try {
            IContextHelper localInstance = null;
            IPayAntiGravityLog iPayAntiLog = null;
            if (ctx != null) {
                localInstance = ContextHelperFactory.getLocalInstance((Context)ctx);
                iPayAntiLog = PayAntiGravityLogFactory.getLocalInstance(ctx);
            } else {
                localInstance = ContextHelperFactory.getRemoteInstance();
                iPayAntiLog = PayAntiGravityLogFactory.getRemoteInstance();
            }
            UserInfo userInfo = localInstance.getCurrentUser();
            PayAntiGravityLogInfo logInfo = new PayAntiGravityLogInfo();
            logInfo.setCreator(userInfo);
            logInfo.setUserName(userInfo.getName());
            logInfo.setUserNumber(userInfo.getNumber());
            logInfo.setOperateTime(new Timestamp(System.currentTimeMillis()));
            logInfo.setLogCategory(logType);
            if (ctx != null) {
                logInfo.setIP(ctx.getClientHostIP());
            } else {
                logInfo.setIP(SysContext.getSysContext().getClientIP());
            }
            logInfo.setUpdateBefore(before);
            logInfo.setUpdateAfter(after);
            logInfo.setErrorMsg(errorMsg);
            if (info != null) {
                logInfo.setSourceBill(info.getString("sourceBill"));
                logInfo.setCustomEntity(info.getString("customEntity"));
            }
            if (LogCategoryEnum.AntiSchemeEdit.equals((Object)logType)) {
                logInfo.setUpdateColumn(ONLYKEY);
            }
            if (info instanceof PayAdmitSchemeInfo) {
                PayAdmitSchemeInfo admitInfo = (PayAdmitSchemeInfo)info;
                logInfo.setAccessSolution(admitInfo);
                logInfo.setDestBill(admitInfo.getDestBill().getAlias());
            } else if (info instanceof PayAntiRepeatInfo) {
                PayAntiRepeatInfo antiInfo = (PayAntiRepeatInfo)info;
                logInfo.setAntiSolution(antiInfo);
                logInfo.setDestBill(antiInfo.getDestBill());
                logInfo.setUniqueKey(antiInfo.getOnlyKey());
                logInfo.setAccessSolution(antiInfo.getPayAdmitScheme());
            }
            iPayAntiLog.addnew(logInfo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

