/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.IPeriod;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.CasWebException;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class PeriodHelper {
    private static Map periodCache;
    private static Map startPeriodMap;

    public static boolean isAfterStartPeriod(PeriodInfo startPeriod, PeriodInfo periodInfo) {
        if (startPeriod == null || periodInfo == null) {
            return false;
        }
        if (startPeriod.getPeriodYear() < periodInfo.getPeriodYear()) {
            return true;
        }
        return startPeriod.getPeriodYear() == periodInfo.getPeriodYear() && startPeriod.getPeriodNumber() <= periodInfo.getPeriodNumber();
    }

    public static boolean isAdjustPeriod(Context ctx, String companyId) throws EASBizException, BOSException {
        CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
        company.setId(BOSUuid.read((String)companyId));
        PeriodInfo periodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)company);
        return periodInfo != null && periodInfo.isIsAdjustPeriod();
    }

    public static PeriodInfo getNextPeriodInfo(CompanyOrgUnitInfo companyInfo, PeriodInfo period) throws EASBizException, BOSException {
        TreeMap yearMap;
        PeriodCollection pc;
        if (period == null) {
            return null;
        }
        ObjectUuidPK companyPK = new ObjectUuidPK(companyInfo.getId());
        if (periodCache == null || !periodCache.containsKey(companyPK)) {
            PeriodHelper.cachePeriod(companyInfo);
        }
        if ((pc = (PeriodCollection)(yearMap = (TreeMap)periodCache.get(companyPK)).get(new Integer(period.getPeriodYear()))) == null) {
            return null;
        }
        PeriodInfo periodInfo = null;
        for (int i = 0; i < pc.size(); ++i) {
            periodInfo = pc.get(i);
            if (periodInfo.getPeriodYear() != period.getPeriodYear() || periodInfo.getPeriodNumber() != period.getPeriodNumber()) continue;
            if (i == pc.size() - 1) {
                pc = (PeriodCollection)yearMap.get(new Integer(period.getPeriodYear() + 1));
                if (pc == null) {
                    return null;
                }
                return pc.get(0);
            }
            return pc.get(i + 1);
        }
        return null;
    }

    public static PeriodInfo getPeriodInfo(Date date, CompanyOrgUnitInfo companyInfo) throws EASBizException, BOSException {
        TreeMap yearMap;
        PeriodCollection pc;
        Calendar cal = Calendar.getInstance();
        Date sourceDate = DateTimeUtils.truncateDate((Date)date);
        cal.setTime(date);
        int year = cal.get(1);
        ObjectUuidPK companyPK = new ObjectUuidPK(companyInfo.getId());
        if (periodCache == null || !periodCache.containsKey(companyPK)) {
            PeriodHelper.cachePeriod(companyInfo);
        }
        if ((pc = (PeriodCollection)(yearMap = (TreeMap)periodCache.get(companyPK)).get(new Integer(year))) == null) {
            return null;
        }
        PeriodInfo periodInfo = null;
        for (int i = 0; i < pc.size(); ++i) {
            periodInfo = pc.get(i);
            Date beginDate = periodInfo.getBeginDate();
            Date endDate = DateTimeUtils.truncateDate((Date)periodInfo.getEndDate());
            if ((!beginDate.before(sourceDate) || !endDate.after(sourceDate)) && !beginDate.equals(sourceDate) && !endDate.equals(sourceDate)) continue;
            return periodInfo;
        }
        return null;
    }

    private static void cachePeriod(CompanyOrgUnitInfo companyInfo) throws EASBizException, BOSException {
        if (periodCache == null) {
            periodCache = new HashMap();
        }
        TreeMap<Integer, PeriodCollection> result = new TreeMap<Integer, PeriodCollection>();
        PeriodCollection pc = PeriodHelper.getPeriodc(companyInfo);
        for (PeriodInfo pi : pc) {
            PeriodCollection tmpPc;
            Integer year = new Integer(pi.getPeriodYear());
            if (!result.containsKey(year)) {
                tmpPc = new PeriodCollection();
                tmpPc.add(pi);
                result.put(year, tmpPc);
                continue;
            }
            tmpPc = (PeriodCollection)result.get(year);
            tmpPc.add(pi);
        }
        periodCache.put(new ObjectUuidPK(companyInfo.getId()), result);
    }

    private static PeriodCollection getPeriodc(CompanyOrgUnitInfo companyInfo) throws BOSException, EASBizException {
        if (companyInfo.getAccountPeriodType() == null || companyInfo.getAccountPeriodType().getId() == null) {
            ICompanyOrgUnit iCompanyOrgUnit = CompanyOrgUnitFactory.getRemoteInstance();
            companyInfo = iCompanyOrgUnit.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyInfo.getId()));
        }
        IPeriod iPeriod = PeriodFactory.getRemoteInstance();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)companyInfo.getAccountPeriodType().getId().toString(), CompareType.EQUALS));
        evi.getSorter().add(new SorterItemInfo("periodYear"));
        evi.getSorter().add(new SorterItemInfo("periodNumber"));
        evi.setFilter(filter);
        PeriodCollection periodc = iPeriod.getPeriodCollection(evi);
        if (periodc == null || periodc.size() == 0) {
            return null;
        }
        if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)companyInfo)) {
            return periodc;
        }
        PeriodInfo startPeriod = PeriodHelper.getStartPeriodInfo(null, companyInfo);
        PeriodCollection rsltCols = new PeriodCollection();
        int n = periodc.size();
        for (int i = 0; i < n; ++i) {
            PeriodInfo periodInfo = periodc.get(i);
            if (!PeriodHelper.isAfterStartPeriod(startPeriod, periodInfo)) continue;
            rsltCols.add(periodInfo);
        }
        return rsltCols;
    }

    public static PeriodInfo getStartPeriodInfo(Component comp, CompanyOrgUnitInfo companyInfo) throws EASBizException, BOSException {
        PeriodInfo startPeriod = null;
        startPeriod = SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)companyInfo);
        if (startPeriod == null) {
            throw new CasWebException(CasWebException.STARTPERIOD_IS_NULL);
        }
        return startPeriod;
    }
}

